package software.amazon.awscdk.services.ec2;

/**
 * This represents an EC2 LaunchTemplate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * SecurityGroup sg1 = SecurityGroup.Builder.create(this, "sg1")
 *         .vpc(vpc)
 *         .build();
 * SecurityGroup sg2 = SecurityGroup.Builder.create(this, "sg2")
 *         .vpc(vpc)
 *         .build();
 * LaunchTemplate launchTemplate = LaunchTemplate.Builder.create(this, "LaunchTemplate")
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .securityGroup(sg1)
 *         .build();
 * launchTemplate.addSecurityGroup(sg2);
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:13.276Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.LaunchTemplate")
public class LaunchTemplate extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.ILaunchTemplate, software.amazon.awscdk.services.iam.IGrantable, software.amazon.awscdk.services.ec2.IConnectable {

    protected LaunchTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LaunchTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LaunchTemplate.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LaunchTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.LaunchTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LaunchTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing LaunchTemplate.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ILaunchTemplate fromLaunchTemplateAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.LaunchTemplateAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.LaunchTemplate.class, "fromLaunchTemplateAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ILaunchTemplate.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add the security group to the instance.
     * <p>
     * @param securityGroup : The security group to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        software.amazon.jsii.Kernel.call(this, "addSecurityGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * Allows specifying security group connections for the instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The default version for the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDefaultVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "defaultVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * The latest version of the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLatestVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "latestVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * TagManager for tagging support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The version number of this launch template to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "versionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AMI ID of the image to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getImageId() {
        return software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Type of instance to launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
    }

    /**
     * The identifier of the Launch Template.
     * <p>
     * Exactly one of <code>launchTemplateId</code> and <code>launchTemplateName</code> will be set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Launch Template.
     * <p>
     * Exactly one of <code>launchTemplateId</code> and <code>launchTemplateName</code> will be set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of OS the instance is running.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
        return software.amazon.jsii.Kernel.get(this, "osType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.OperatingSystemType.class));
    }

    /**
     * IAM Role assumed by instances that are launched from this template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * UserData executed by instances that are launched from this template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData getUserData() {
        return software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.LaunchTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.LaunchTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.LaunchTemplateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Whether instances should have a public IP addresses associated with them.
         * <p>
         * Default: - Use subnet settings
         * <p>
         * @return {@code this}
         * @param associatePublicIpAddress Whether instances should have a public IP addresses associated with them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(final java.lang.Boolean associatePublicIpAddress) {
            this.props().associatePublicIpAddress(associatePublicIpAddress);
            return this;
        }

        /**
         * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         * <p>
         * Each instance that is launched has an associated root device volume,
         * either an Amazon EBS volume or an instance store volume.
         * You can use block device mappings to specify additional EBS volumes or
         * instance store volumes to attach to an instance when it is launched.
         * <p>
         * Default: - Uses the block device mapping of the AMI
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html</a>
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDevices(final java.util.List<? extends software.amazon.awscdk.services.ec2.BlockDevice> blockDevices) {
            this.props().blockDevices(blockDevices);
            return this;
        }

        /**
         * CPU credit type for burstable EC2 instance types.
         * <p>
         * Default: - No credit type is specified in the Launch Template.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html</a>
         * @param cpuCredits CPU credit type for burstable EC2 instance types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuCredits(final software.amazon.awscdk.services.ec2.CpuCredits cpuCredits) {
            this.props().cpuCredits(cpuCredits);
            return this;
        }

        /**
         * If set to true, then detailed monitoring will be enabled on instances created with this launch template.
         * <p>
         * Default: False - Detailed monitoring is disabled.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html</a>
         * @param detailedMonitoring If set to true, then detailed monitoring will be enabled on instances created with this launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailedMonitoring(final java.lang.Boolean detailedMonitoring) {
            this.props().detailedMonitoring(detailedMonitoring);
            return this;
        }

        /**
         * If you set this parameter to true, you cannot terminate the instances launched with this launch template using the Amazon EC2 console, CLI, or API;
         * <p>
         * otherwise, you can.
         * <p>
         * Default: - The API termination setting is not specified in the Launch Template.
         * <p>
         * @return {@code this}
         * @param disableApiTermination If you set this parameter to true, you cannot terminate the instances launched with this launch template using the Amazon EC2 console, CLI, or API;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableApiTermination(final java.lang.Boolean disableApiTermination) {
            this.props().disableApiTermination(disableApiTermination);
            return this;
        }

        /**
         * Indicates whether the instances are optimized for Amazon EBS I/O.
         * <p>
         * This optimization provides dedicated throughput
         * to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization
         * isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * <p>
         * Default: - EBS optimization is not specified in the launch template.
         * <p>
         * @return {@code this}
         * @param ebsOptimized Indicates whether the instances are optimized for Amazon EBS I/O. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(final java.lang.Boolean ebsOptimized) {
            this.props().ebsOptimized(ebsOptimized);
            return this;
        }

        /**
         * If you set this parameter to true, the instance is enabled for hibernation.
         * <p>
         * Default: - Hibernation configuration is not specified in the launch template; defaulting to false.
         * <p>
         * @return {@code this}
         * @param hibernationConfigured If you set this parameter to true, the instance is enabled for hibernation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hibernationConfigured(final java.lang.Boolean hibernationConfigured) {
            this.props().hibernationConfigured(hibernationConfigured);
            return this;
        }

        /**
         * Enables or disables the HTTP metadata endpoint on your instances.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpendpoint">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpendpoint</a>
         * @param httpEndpoint Enables or disables the HTTP metadata endpoint on your instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpEndpoint(final java.lang.Boolean httpEndpoint) {
            this.props().httpEndpoint(httpEndpoint);
            return this;
        }

        /**
         * Enables or disables the IPv6 endpoint for the instance metadata service.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpprotocolipv6">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpprotocolipv6</a>
         * @param httpProtocolIpv6 Enables or disables the IPv6 endpoint for the instance metadata service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpProtocolIpv6(final java.lang.Boolean httpProtocolIpv6) {
            this.props().httpProtocolIpv6(httpProtocolIpv6);
            return this;
        }

        /**
         * The desired HTTP PUT response hop limit for instance metadata requests.
         * <p>
         * The larger the number, the further instance metadata requests can travel.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpputresponsehoplimit">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpputresponsehoplimit</a>
         * @param httpPutResponseHopLimit The desired HTTP PUT response hop limit for instance metadata requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpPutResponseHopLimit(final java.lang.Number httpPutResponseHopLimit) {
            this.props().httpPutResponseHopLimit(httpPutResponseHopLimit);
            return this;
        }

        /**
         * The state of token usage for your instance metadata requests.
         * <p>
         * The default state is <code>optional</code> if not specified. However,
         * if requireImdsv2 is true, the state must be <code>required</code>.
         * <p>
         * Default: LaunchTemplateHttpTokens.OPTIONAL
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httptokens">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httptokens</a>
         * @param httpTokens The state of token usage for your instance metadata requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpTokens(final software.amazon.awscdk.services.ec2.LaunchTemplateHttpTokens httpTokens) {
            this.props().httpTokens(httpTokens);
            return this;
        }

        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         * <p>
         * Default: - Shutdown behavior is not specified in the launch template; defaults to STOP.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior</a>
         * @param instanceInitiatedShutdownBehavior Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceInitiatedShutdownBehavior(final software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.props().instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
            return this;
        }

        /**
         * Set to enabled to allow access to instance tags from the instance metadata.
         * <p>
         * Set to disabled to turn off access to instance tags from the instance metadata.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-instancemetadatatags">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-instancemetadatatags</a>
         * @param instanceMetadataTags Set to enabled to allow access to instance tags from the instance metadata. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMetadataTags(final java.lang.Boolean instanceMetadataTags) {
            this.props().instanceMetadataTags(instanceMetadataTags);
            return this;
        }

        /**
         * The instance profile used to pass role information to EC2 instances.
         * <p>
         * Note: You can provide an instanceProfile or a role, but not both.
         * <p>
         * Default: - No instance profile
         * <p>
         * @return {@code this}
         * @param instanceProfile The instance profile used to pass role information to EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfile(final software.amazon.awscdk.services.iam.IInstanceProfile instanceProfile) {
            this.props().instanceProfile(instanceProfile);
            return this;
        }

        /**
         * Type of instance to launch.
         * <p>
         * Default: - This Launch Template does not specify a default Instance Type.
         * <p>
         * @return {@code this}
         * @param instanceType Type of instance to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props().instanceType(instanceType);
            return this;
        }

        /**
         * (deprecated) Name of SSH keypair to grant access to instance.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @deprecated <ul>
         * <li>Use <code>keyPair</code> instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair</li>
         * </ul>
         * @param keyName Name of SSH keypair to grant access to instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder keyName(final java.lang.String keyName) {
            this.props().keyName(keyName);
            return this;
        }

        /**
         * The SSH keypair to grant access to the instance.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @param keyPair The SSH keypair to grant access to the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(final software.amazon.awscdk.services.ec2.IKeyPair keyPair) {
            this.props().keyPair(keyPair);
            return this;
        }

        /**
         * Name for this launch template.
         * <p>
         * Default: Automatically generated name
         * <p>
         * @return {@code this}
         * @param launchTemplateName Name for this launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateName(final java.lang.String launchTemplateName) {
            this.props().launchTemplateName(launchTemplateName);
            return this;
        }

        /**
         * The AMI that will be used by instances.
         * <p>
         * Default: - This Launch Template does not specify a default AMI.
         * <p>
         * @return {@code this}
         * @param machineImage The AMI that will be used by instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.props().machineImage(machineImage);
            return this;
        }

        /**
         * If this parameter is set to true, the instance is enabled for AWS Nitro Enclaves;
         * <p>
         * otherwise, it is not enabled for AWS Nitro Enclaves.
         * <p>
         * Default: - Enablement of Nitro enclaves is not specified in the launch template; defaulting to false.
         * <p>
         * @return {@code this}
         * @param nitroEnclaveEnabled If this parameter is set to true, the instance is enabled for AWS Nitro Enclaves;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nitroEnclaveEnabled(final java.lang.Boolean nitroEnclaveEnabled) {
            this.props().nitroEnclaveEnabled(nitroEnclaveEnabled);
            return this;
        }

        /**
         * The placement group that you want to launch the instance into.
         * <p>
         * Default: - no placement group will be used for this launch template.
         * <p>
         * @return {@code this}
         * @param placementGroup The placement group that you want to launch the instance into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroup(final software.amazon.awscdk.services.ec2.IPlacementGroup placementGroup) {
            this.props().placementGroup(placementGroup);
            return this;
        }

        /**
         * Whether IMDSv2 should be required on launched instances.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param requireImdsv2 Whether IMDSv2 should be required on launched instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireImdsv2(final java.lang.Boolean requireImdsv2) {
            this.props().requireImdsv2(requireImdsv2);
            return this;
        }

        /**
         * An IAM role to associate with the instance profile that is used by instances.
         * <p>
         * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>.
         * Note: You can provide an instanceProfile or a role, but not both.
         * <p>
         * Default: - No new role is created.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * Role role = Role.Builder.create(this, "MyRole")
         *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
         *         .build();
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param role An IAM role to associate with the instance profile that is used by instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * Security group to assign to instances created with the launch template.
         * <p>
         * Default: No security group is assigned.
         * <p>
         * @return {@code this}
         * @param securityGroup Security group to assign to instances created with the launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props().securityGroup(securityGroup);
            return this;
        }

        /**
         * If this property is defined, then the Launch Template's InstanceMarketOptions will be set to use Spot instances, and the options for the Spot instances will be as defined.
         * <p>
         * Default: - Instance launched with this template will not be spot instances.
         * <p>
         * @return {@code this}
         * @param spotOptions If this property is defined, then the Launch Template's InstanceMarketOptions will be set to use Spot instances, and the options for the Spot instances will be as defined. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(final software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions spotOptions) {
            this.props().spotOptions(spotOptions);
            return this;
        }

        /**
         * The user data to make available to the instance.
         * <p>
         * Default: - This Launch Template creates a UserData based on the type of provided
         * machineImage; no UserData is created if a machineImage is not provided
         * <p>
         * @return {@code this}
         * @param userData The user data to make available to the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * A description for the first version of the launch template.
         * <p>
         * The version description must be maximum 255 characters long.
         * <p>
         * Default: - No description
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-versiondescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-versiondescription</a>
         * @param versionDescription A description for the first version of the launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(final java.lang.String versionDescription) {
            this.props().versionDescription(versionDescription);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.LaunchTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.LaunchTemplate build() {
            return new software.amazon.awscdk.services.ec2.LaunchTemplate(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.LaunchTemplateProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.LaunchTemplateProps.Builder();
            }
            return this.props;
        }
    }
}
