package software.amazon.awscdk.services.ecr;

/**
 * Properties for defining a <code>CfnRepository</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecr.*;
 * Object repositoryPolicyText;
 * CfnRepositoryProps cfnRepositoryProps = CfnRepositoryProps.builder()
 *         .emptyOnDelete(false)
 *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                 .encryptionType("encryptionType")
 *                 // the properties below are optional
 *                 .kmsKey("kmsKey")
 *                 .build())
 *         .imageScanningConfiguration(ImageScanningConfigurationProperty.builder()
 *                 .scanOnPush(false)
 *                 .build())
 *         .imageTagMutability("imageTagMutability")
 *         .lifecyclePolicy(LifecyclePolicyProperty.builder()
 *                 .lifecyclePolicyText("lifecyclePolicyText")
 *                 .registryId("registryId")
 *                 .build())
 *         .repositoryName("repositoryName")
 *         .repositoryPolicyText(repositoryPolicyText)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:13.416Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr.CfnRepositoryProps")
@software.amazon.jsii.Jsii.Proxy(CfnRepositoryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRepositoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * If true, deleting the repository force deletes the contents of the repository.
     * <p>
     * If false, the repository must be empty before attempting to delete it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-emptyondelete">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-emptyondelete</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEmptyOnDelete() {
        return null;
    }

    /**
     * The encryption configuration for the repository.
     * <p>
     * This determines how the contents of your repository are encrypted at rest.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-encryptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
        return null;
    }

    /**
     * The image scanning configuration for the repository.
     * <p>
     * This determines whether images are scanned for known vulnerabilities after being pushed to the repository.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-imagescanningconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-imagescanningconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getImageScanningConfiguration() {
        return null;
    }

    /**
     * The tag mutability setting for the repository.
     * <p>
     * If this parameter is omitted, the default setting of <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-imagetagmutability">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-imagetagmutability</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageTagMutability() {
        return null;
    }

    /**
     * Creates or updates a lifecycle policy.
     * <p>
     * For information about lifecycle policy syntax, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html">Lifecycle policy template</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-lifecyclepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-lifecyclepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLifecyclePolicy() {
        return null;
    }

    /**
     * The name to use for the repository.
     * <p>
     * The repository name may be specified on its own (such as <code>nginx-web-app</code> ) or it can be prepended with a namespace to group the repository into a category (such as <code>project-a/nginx-web-app</code> ). If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the repository name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
     * <p>
     * The repository name must start with a letter and can only contain lowercase letters, numbers, hyphens, underscores, and forward slashes.
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-repositoryname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-repositoryname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryName() {
        return null;
    }

    /**
     * The JSON repository policy text to apply to the repository.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository policies</a> in the <em>Amazon Elastic Container Registry User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-repositorypolicytext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-repositorypolicytext</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRepositoryPolicyText() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRepositoryProps> {
        java.lang.Object emptyOnDelete;
        java.lang.Object encryptionConfiguration;
        java.lang.Object imageScanningConfiguration;
        java.lang.String imageTagMutability;
        java.lang.Object lifecyclePolicy;
        java.lang.String repositoryName;
        java.lang.Object repositoryPolicyText;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRepositoryProps#getEmptyOnDelete}
         * @param emptyOnDelete If true, deleting the repository force deletes the contents of the repository.
         *                      If false, the repository must be empty before attempting to delete it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emptyOnDelete(java.lang.Boolean emptyOnDelete) {
            this.emptyOnDelete = emptyOnDelete;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getEmptyOnDelete}
         * @param emptyOnDelete If true, deleting the repository force deletes the contents of the repository.
         *                      If false, the repository must be empty before attempting to delete it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emptyOnDelete(software.amazon.awscdk.IResolvable emptyOnDelete) {
            this.emptyOnDelete = emptyOnDelete;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getEncryptionConfiguration}
         * @param encryptionConfiguration The encryption configuration for the repository.
         *                                This determines how the contents of your repository are encrypted at rest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getEncryptionConfiguration}
         * @param encryptionConfiguration The encryption configuration for the repository.
         *                                This determines how the contents of your repository are encrypted at rest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.services.ecr.CfnRepository.EncryptionConfigurationProperty encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getImageScanningConfiguration}
         * @param imageScanningConfiguration The image scanning configuration for the repository.
         *                                   This determines whether images are scanned for known vulnerabilities after being pushed to the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageScanningConfiguration(software.amazon.awscdk.IResolvable imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getImageScanningConfiguration}
         * @param imageScanningConfiguration The image scanning configuration for the repository.
         *                                   This determines whether images are scanned for known vulnerabilities after being pushed to the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageScanningConfiguration(software.amazon.awscdk.services.ecr.CfnRepository.ImageScanningConfigurationProperty imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getImageTagMutability}
         * @param imageTagMutability The tag mutability setting for the repository.
         *                           If this parameter is omitted, the default setting of <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTagMutability(java.lang.String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getLifecyclePolicy}
         * @param lifecyclePolicy Creates or updates a lifecycle policy.
         *                        For information about lifecycle policy syntax, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html">Lifecycle policy template</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicy(software.amazon.awscdk.IResolvable lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getLifecyclePolicy}
         * @param lifecyclePolicy Creates or updates a lifecycle policy.
         *                        For information about lifecycle policy syntax, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html">Lifecycle policy template</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicy(software.amazon.awscdk.services.ecr.CfnRepository.LifecyclePolicyProperty lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getRepositoryName}
         * @param repositoryName The name to use for the repository.
         *                       The repository name may be specified on its own (such as <code>nginx-web-app</code> ) or it can be prepended with a namespace to group the repository into a category (such as <code>project-a/nginx-web-app</code> ). If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the repository name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
         *                       <p>
         *                       The repository name must start with a letter and can only contain lowercase letters, numbers, hyphens, underscores, and forward slashes.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getRepositoryPolicyText}
         * @param repositoryPolicyText The JSON repository policy text to apply to the repository.
         *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository policies</a> in the <em>Amazon Elastic Container Registry User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryPolicyText(java.lang.Object repositoryPolicyText) {
            this.repositoryPolicyText = repositoryPolicyText;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRepositoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRepositoryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRepositoryProps {
        private final java.lang.Object emptyOnDelete;
        private final java.lang.Object encryptionConfiguration;
        private final java.lang.Object imageScanningConfiguration;
        private final java.lang.String imageTagMutability;
        private final java.lang.Object lifecyclePolicy;
        private final java.lang.String repositoryName;
        private final java.lang.Object repositoryPolicyText;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.emptyOnDelete = software.amazon.jsii.Kernel.get(this, "emptyOnDelete", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.imageScanningConfiguration = software.amazon.jsii.Kernel.get(this, "imageScanningConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.imageTagMutability = software.amazon.jsii.Kernel.get(this, "imageTagMutability", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lifecyclePolicy = software.amazon.jsii.Kernel.get(this, "lifecyclePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryPolicyText = software.amazon.jsii.Kernel.get(this, "repositoryPolicyText", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.emptyOnDelete = builder.emptyOnDelete;
            this.encryptionConfiguration = builder.encryptionConfiguration;
            this.imageScanningConfiguration = builder.imageScanningConfiguration;
            this.imageTagMutability = builder.imageTagMutability;
            this.lifecyclePolicy = builder.lifecyclePolicy;
            this.repositoryName = builder.repositoryName;
            this.repositoryPolicyText = builder.repositoryPolicyText;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getEmptyOnDelete() {
            return this.emptyOnDelete;
        }

        @Override
        public final java.lang.Object getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        public final java.lang.Object getImageScanningConfiguration() {
            return this.imageScanningConfiguration;
        }

        @Override
        public final java.lang.String getImageTagMutability() {
            return this.imageTagMutability;
        }

        @Override
        public final java.lang.Object getLifecyclePolicy() {
            return this.lifecyclePolicy;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.lang.Object getRepositoryPolicyText() {
            return this.repositoryPolicyText;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEmptyOnDelete() != null) {
                data.set("emptyOnDelete", om.valueToTree(this.getEmptyOnDelete()));
            }
            if (this.getEncryptionConfiguration() != null) {
                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
            }
            if (this.getImageScanningConfiguration() != null) {
                data.set("imageScanningConfiguration", om.valueToTree(this.getImageScanningConfiguration()));
            }
            if (this.getImageTagMutability() != null) {
                data.set("imageTagMutability", om.valueToTree(this.getImageTagMutability()));
            }
            if (this.getLifecyclePolicy() != null) {
                data.set("lifecyclePolicy", om.valueToTree(this.getLifecyclePolicy()));
            }
            if (this.getRepositoryName() != null) {
                data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            }
            if (this.getRepositoryPolicyText() != null) {
                data.set("repositoryPolicyText", om.valueToTree(this.getRepositoryPolicyText()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecr.CfnRepositoryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRepositoryProps.Jsii$Proxy that = (CfnRepositoryProps.Jsii$Proxy) o;

            if (this.emptyOnDelete != null ? !this.emptyOnDelete.equals(that.emptyOnDelete) : that.emptyOnDelete != null) return false;
            if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
            if (this.imageScanningConfiguration != null ? !this.imageScanningConfiguration.equals(that.imageScanningConfiguration) : that.imageScanningConfiguration != null) return false;
            if (this.imageTagMutability != null ? !this.imageTagMutability.equals(that.imageTagMutability) : that.imageTagMutability != null) return false;
            if (this.lifecyclePolicy != null ? !this.lifecyclePolicy.equals(that.lifecyclePolicy) : that.lifecyclePolicy != null) return false;
            if (this.repositoryName != null ? !this.repositoryName.equals(that.repositoryName) : that.repositoryName != null) return false;
            if (this.repositoryPolicyText != null ? !this.repositoryPolicyText.equals(that.repositoryPolicyText) : that.repositoryPolicyText != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.emptyOnDelete != null ? this.emptyOnDelete.hashCode() : 0;
            result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
            result = 31 * result + (this.imageScanningConfiguration != null ? this.imageScanningConfiguration.hashCode() : 0);
            result = 31 * result + (this.imageTagMutability != null ? this.imageTagMutability.hashCode() : 0);
            result = 31 * result + (this.lifecyclePolicy != null ? this.lifecyclePolicy.hashCode() : 0);
            result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
            result = 31 * result + (this.repositoryPolicyText != null ? this.repositoryPolicyText.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
