package software.amazon.awscdk.services.ecr.assets;

/**
 * networking mode on build time supported by docker.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.assets.DockerImageAsset;
 * import software.amazon.awscdk.services.ecr.assets.NetworkMode;
 * DockerImageAsset asset = DockerImageAsset.Builder.create(this, "MyBuildImage")
 *         .directory(join(__dirname, "my-image"))
 *         .networkMode(NetworkMode.HOST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:13.448Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr_assets.NetworkMode")
public class NetworkMode extends software.amazon.jsii.JsiiObject {

    protected NetworkMode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkMode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecr.assets.NetworkMode.class, "DEFAULT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.NetworkMode.class));
        HOST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecr.assets.NetworkMode.class, "HOST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.NetworkMode.class));
        NONE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecr.assets.NetworkMode.class, "NONE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.NetworkMode.class));
    }

    /**
     * Used to specify a custom networking mode Use this if the networking mode name is not yet supported by the CDK.
     * <p>
     * @param mode The networking mode to use for docker build. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.NetworkMode custom(final @org.jetbrains.annotations.NotNull java.lang.String mode) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecr.assets.NetworkMode.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.NetworkMode.class), new Object[] { java.util.Objects.requireNonNull(mode, "mode is required") });
    }

    /**
     * Reuse another container's network stack.
     * <p>
     * @param containerId The target container's id or name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.NetworkMode fromContainer(final @org.jetbrains.annotations.NotNull java.lang.String containerId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecr.assets.NetworkMode.class, "fromContainer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.NetworkMode.class), new Object[] { java.util.Objects.requireNonNull(containerId, "containerId is required") });
    }

    /**
     * The default networking mode if omitted, create a network stack on the default Docker bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecr.assets.NetworkMode DEFAULT;

    /**
     * Use the Docker host network stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecr.assets.NetworkMode HOST;

    /**
     * Disable the network stack, only the loopback device will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecr.assets.NetworkMode NONE;

    /**
     * The networking mode to use for docker build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMode() {
        return software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
