package software.amazon.awscdk.services.ecs;

/**
 * The options for creating an AWS Cloud Map namespace.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * ContainerDefinitionOptions containerOptions;
 * ContainerDefinition container = taskDefinition.addContainer("MyContainer", containerOptions);
 * container.addPortMappings(PortMapping.builder()
 *         .name("api")
 *         .containerPort(8080)
 *         .build());
 * cluster.addDefaultCloudMapNamespace(CloudMapNamespaceOptions.builder()
 *         .name("local")
 *         .build());
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .serviceConnectConfiguration(ServiceConnectProps.builder()
 *                 .services(List.of(ServiceConnectService.builder()
 *                         .portMappingName("api")
 *                         .dnsName("http-api")
 *                         .port(80)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:13.653Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CloudMapNamespaceOptions")
@software.amazon.jsii.Jsii.Proxy(CloudMapNamespaceOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudMapNamespaceOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the namespace, such as example.com.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The type of CloudMap Namespace to create.
     * <p>
     * Default: PrivateDns
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.NamespaceType getType() {
        return null;
    }

    /**
     * This property specifies whether to set the provided namespace as the service connect default in the cluster properties.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseForServiceConnect() {
        return null;
    }

    /**
     * The VPC to associate the namespace with.
     * <p>
     * This property is required for private DNS namespaces.
     * <p>
     * Default: VPC of the cluster for Private DNS Namespace, otherwise none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudMapNamespaceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudMapNamespaceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudMapNamespaceOptions> {
        java.lang.String name;
        software.amazon.awscdk.services.servicediscovery.NamespaceType type;
        java.lang.Boolean useForServiceConnect;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link CloudMapNamespaceOptions#getName}
         * @param name The name of the namespace, such as example.com. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CloudMapNamespaceOptions#getType}
         * @param type The type of CloudMap Namespace to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.servicediscovery.NamespaceType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CloudMapNamespaceOptions#getUseForServiceConnect}
         * @param useForServiceConnect This property specifies whether to set the provided namespace as the service connect default in the cluster properties.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useForServiceConnect(java.lang.Boolean useForServiceConnect) {
            this.useForServiceConnect = useForServiceConnect;
            return this;
        }

        /**
         * Sets the value of {@link CloudMapNamespaceOptions#getVpc}
         * @param vpc The VPC to associate the namespace with.
         *            This property is required for private DNS namespaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudMapNamespaceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudMapNamespaceOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudMapNamespaceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudMapNamespaceOptions {
        private final java.lang.String name;
        private final software.amazon.awscdk.services.servicediscovery.NamespaceType type;
        private final java.lang.Boolean useForServiceConnect;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.NamespaceType.class));
            this.useForServiceConnect = software.amazon.jsii.Kernel.get(this, "useForServiceConnect", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.type = builder.type;
            this.useForServiceConnect = builder.useForServiceConnect;
            this.vpc = builder.vpc;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.NamespaceType getType() {
            return this.type;
        }

        @Override
        public final java.lang.Boolean getUseForServiceConnect() {
            return this.useForServiceConnect;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getUseForServiceConnect() != null) {
                data.set("useForServiceConnect", om.valueToTree(this.getUseForServiceConnect()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CloudMapNamespaceOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudMapNamespaceOptions.Jsii$Proxy that = (CloudMapNamespaceOptions.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            if (this.useForServiceConnect != null ? !this.useForServiceConnect.equals(that.useForServiceConnect) : that.useForServiceConnect != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.useForServiceConnect != null ? this.useForServiceConnect.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
