package software.amazon.awscdk.services.ecs;

/**
 * Kms Keys for encryption ECS managed storage.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Key key;
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .managedStorageConfiguration(ManagedStorageConfiguration.builder()
 *                 .fargateEphemeralStorageKmsKey(key)
 *                 .kmsKey(key)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:13.755Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ManagedStorageConfiguration")
@software.amazon.jsii.Jsii.Proxy(ManagedStorageConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ManagedStorageConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * Customer KMS Key used to encrypt ECS Fargate ephemeral Storage.
     * <p>
     * The configured KMS Key's policy will be modified to allow ECS to use the Key to encrypt the ephemeral Storage for this cluster.
     * <p>
     * Default: - Encrypted using AWS-managed key
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-storage-encryption.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-storage-encryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getFargateEphemeralStorageKmsKey() {
        return null;
    }

    /**
     * Customer KMS Key used to encrypt ECS managed Storage.
     * <p>
     * Default: - Encrypted using AWS-managed key
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-managedstorageconfiguration.html#cfn-ecs-cluster-managedstorageconfiguration-kmskeyid">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-managedstorageconfiguration.html#cfn-ecs-cluster-managedstorageconfiguration-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ManagedStorageConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ManagedStorageConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ManagedStorageConfiguration> {
        software.amazon.awscdk.services.kms.IKey fargateEphemeralStorageKmsKey;
        software.amazon.awscdk.services.kms.IKey kmsKey;

        /**
         * Sets the value of {@link ManagedStorageConfiguration#getFargateEphemeralStorageKmsKey}
         * @param fargateEphemeralStorageKmsKey Customer KMS Key used to encrypt ECS Fargate ephemeral Storage.
         *                                      The configured KMS Key's policy will be modified to allow ECS to use the Key to encrypt the ephemeral Storage for this cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fargateEphemeralStorageKmsKey(software.amazon.awscdk.services.kms.IKey fargateEphemeralStorageKmsKey) {
            this.fargateEphemeralStorageKmsKey = fargateEphemeralStorageKmsKey;
            return this;
        }

        /**
         * Sets the value of {@link ManagedStorageConfiguration#getKmsKey}
         * @param kmsKey Customer KMS Key used to encrypt ECS managed Storage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ManagedStorageConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ManagedStorageConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ManagedStorageConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedStorageConfiguration {
        private final software.amazon.awscdk.services.kms.IKey fargateEphemeralStorageKmsKey;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fargateEphemeralStorageKmsKey = software.amazon.jsii.Kernel.get(this, "fargateEphemeralStorageKmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fargateEphemeralStorageKmsKey = builder.fargateEphemeralStorageKmsKey;
            this.kmsKey = builder.kmsKey;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getFargateEphemeralStorageKmsKey() {
            return this.fargateEphemeralStorageKmsKey;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFargateEphemeralStorageKmsKey() != null) {
                data.set("fargateEphemeralStorageKmsKey", om.valueToTree(this.getFargateEphemeralStorageKmsKey()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.ManagedStorageConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ManagedStorageConfiguration.Jsii$Proxy that = (ManagedStorageConfiguration.Jsii$Proxy) o;

            if (this.fargateEphemeralStorageKmsKey != null ? !this.fargateEphemeralStorageKmsKey.equals(that.fargateEphemeralStorageKmsKey) : that.fargateEphemeralStorageKmsKey != null) return false;
            return this.kmsKey != null ? this.kmsKey.equals(that.kmsKey) : that.kmsKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fargateEphemeralStorageKmsKey != null ? this.fargateEphemeralStorageKmsKey.hashCode() : 0;
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            return result;
        }
    }
}
