package software.amazon.awscdk.services.ecs.patterns;

/**
 * A scheduled Fargate task that will be initiated off of CloudWatch Events.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = Vpc.Builder.create(this, "Vpc").maxAzs(1).build();
 * Cluster cluster = Cluster.Builder.create(this, "EcsCluster").vpc(vpc).build();
 * ScheduledFargateTask scheduledFargateTask = ScheduledFargateTask.Builder.create(this, "ScheduledFargateTask")
 *         .cluster(cluster)
 *         .scheduledFargateTaskImageOptions(ScheduledFargateTaskImageOptions.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .memoryLimitMiB(512)
 *                 .build())
 *         .schedule(Schedule.expression("rate(1 minute)"))
 *         .tags(List.of(Tag.builder()
 *                 .key("my-tag")
 *                 .value("my-tag-value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:13.910Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ScheduledFargateTask")
public class ScheduledFargateTask extends software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBase {

    protected ScheduledFargateTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduledFargateTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the ScheduledFargateTask class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ScheduledFargateTask(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The ECS task in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.targets.EcsTask getTask() {
        return software.amazon.jsii.Kernel.get(this, "task", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.targets.EcsTask.class));
    }

    /**
     * The Fargate task definition in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargateTaskDefinition.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTask> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskProps.Builder();
        }

        /**
         * The schedule or rate (frequency) that determines when CloudWatch Events runs the rule.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expression Syntax for Rules</a>
         * in the Amazon CloudWatch User Guide.
         * <p>
         * @return {@code this}
         * @param schedule The schedule or rate (frequency) that determines when CloudWatch Events runs the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.applicationautoscaling.Schedule schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The name of the cluster that hosts the service.
         * <p>
         * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * <p>
         * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
         * <p>
         * @return {@code this}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * The desired number of instantiations of the task definition to keep running on the service.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param desiredTaskCount The desired number of instantiations of the task definition to keep running on the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredTaskCount(final java.lang.Number desiredTaskCount) {
            this.props.desiredTaskCount(desiredTaskCount);
            return this;
        }

        /**
         * Indicates whether the rule is enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Indicates whether the rule is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the task definition to the task.
         * <p>
         * If no value is specified, the tags are not propagated.
         * <p>
         * Default: - Tags will not be propagated
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the task definition to the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        /**
         * A name for the rule.
         * <p>
         * Default: - AWS CloudFormation generates a unique physical ID and uses that ID
         * for the rule name. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
         * <p>
         * @return {@code this}
         * @param ruleName A name for the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(final java.lang.String ruleName) {
            this.props.ruleName(ruleName);
            return this;
        }

        /**
         * Existing security groups to use for your service.
         * <p>
         * Default: - a new security group will be created.
         * <p>
         * @return {@code this}
         * @param securityGroups Existing security groups to use for your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * In what subnets to place the task's ENIs.
         * <p>
         * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * <p>
         * Default: Private subnets
         * <p>
         * @return {@code this}
         * @param subnetSelection In what subnets to place the task's ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * The metadata that you apply to the task to help you categorize and organize them.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define.
         * <p>
         * Default: - No tags are applied to the task
         * <p>
         * @return {@code this}
         * @param tags The metadata that you apply to the task to help you categorize and organize them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.services.events.targets.Tag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         * <p>
         * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * <p>
         * Default: - uses the VPC defined in the cluster or creates a new VPC.
         * <p>
         * @return {@code this}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * The number of cpu units used by the task.
         * <p>
         * Valid values, which determines your range of valid values for the memory parameter:
         * <p>
         * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
         * <p>
         * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
         * <p>
         * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
         * <p>
         * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
         * <p>
         * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
         * <p>
         * 8192 (8 vCPU) - Available memory values: Between 16GB and 60GB in 4GB increments
         * <p>
         * 16384 (16 vCPU) - Available memory values: Between 32GB and 120GB in 8GB increments
         * <p>
         * This default is set in the underlying FargateTaskDefinition construct.
         * <p>
         * Default: 256
         * <p>
         * @return {@code this}
         * @param cpu The number of cpu units used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        /**
         * The amount (in GiB) of ephemeral storage to be allocated to the task.
         * <p>
         * The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
         * <p>
         * Only supported in Fargate platform version 1.4.0 or later.
         * <p>
         * Default: Undefined, in which case, the task will receive 20GiB ephemeral storage.
         * <p>
         * @return {@code this}
         * @param ephemeralStorageGiB The amount (in GiB) of ephemeral storage to be allocated to the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageGiB(final java.lang.Number ephemeralStorageGiB) {
            this.props.ephemeralStorageGiB(ephemeralStorageGiB);
            return this;
        }

        /**
         * The amount (in MiB) of memory used by the task.
         * <p>
         * This field is required and you must use one of the following values, which determines your range of valid values
         * for the cpu parameter:
         * <p>
         * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         * <p>
         * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         * <p>
         * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         * <p>
         * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         * <p>
         * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         * <p>
         * Between 16384 (16 GB) and 61440 (60 GB) in increments of 4096 (4 GB) - Available cpu values: 8192 (8 vCPU)
         * <p>
         * Between 32768 (32 GB) and 122880 (120 GB) in increments of 8192 (8 GB) - Available cpu values: 16384 (16 vCPU)
         * <p>
         * This default is set in the underlying FargateTaskDefinition construct.
         * <p>
         * Default: 512
         * <p>
         * @return {@code this}
         * @param memoryLimitMiB The amount (in MiB) of memory used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(final java.lang.Number memoryLimitMiB) {
            this.props.memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        /**
         * The platform version on which to run your service.
         * <p>
         * If one is not specified, the LATEST platform version is used by default. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a>
         * in the Amazon Elastic Container Service Developer Guide.
         * <p>
         * Default: Latest
         * <p>
         * @return {@code this}
         * @param platformVersion The platform version on which to run your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.props.platformVersion(platformVersion);
            return this;
        }

        /**
         * The runtime platform of the task definition.
         * <p>
         * Default: - If the property is undefined, `operatingSystemFamily` is LINUX and `cpuArchitecture` is X86_64
         * <p>
         * @return {@code this}
         * @param runtimePlatform The runtime platform of the task definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(final software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform) {
            this.props.runtimePlatform(runtimePlatform);
            return this;
        }

        /**
         * The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param taskDefinition The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        /**
         * The properties to define if using an existing TaskDefinition in this construct.
         * <p>
         * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param scheduledFargateTaskDefinitionOptions The properties to define if using an existing TaskDefinition in this construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledFargateTaskDefinitionOptions(final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions scheduledFargateTaskDefinitionOptions) {
            this.props.scheduledFargateTaskDefinitionOptions(scheduledFargateTaskDefinitionOptions);
            return this;
        }

        /**
         * The properties to define if the construct is to create a TaskDefinition.
         * <p>
         * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param scheduledFargateTaskImageOptions The properties to define if the construct is to create a TaskDefinition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledFargateTaskImageOptions(final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions scheduledFargateTaskImageOptions) {
            this.props.scheduledFargateTaskImageOptions(scheduledFargateTaskImageOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTask build() {
            return new software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTask(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
