package software.amazon.awscdk.services.eks;

/**
 * Represents an access entry in an Amazon EKS cluster.
 * <p>
 * An access entry defines the permissions and scope for a user or role to access an Amazon EKS cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * AccessPolicy accessPolicy;
 * Cluster cluster;
 * AccessEntry accessEntry = AccessEntry.Builder.create(this, "MyAccessEntry")
 *         .accessPolicies(List.of(accessPolicy))
 *         .cluster(cluster)
 *         .principal("principal")
 *         // the properties below are optional
 *         .accessEntryName("accessEntryName")
 *         .accessEntryType(AccessEntryType.STANDARD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:13.994Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AccessEntry")
public class AccessEntry extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.eks.IAccessEntry {

    protected AccessEntry(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessEntry(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AccessEntry.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AccessEntry(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AccessEntryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports an <code>AccessEntry</code> from its attributes.
     * <p>
     * @return The imported access entry.
     * @param scope <ul><li>The parent construct.</li></ul> This parameter is required.
     * @param id <ul><li>The ID of the imported construct.</li></ul> This parameter is required.
     * @param attrs <ul><li>The attributes of the access entry to import.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.IAccessEntry fromAccessEntryAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AccessEntryAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.AccessEntry.class, "fromAccessEntryAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IAccessEntry.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add the access policies for this entry.
     * <p>
     * @param newAccessPolicies <ul><li>The new access policies to add.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAccessPolicies(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.eks.IAccessPolicy> newAccessPolicies) {
        software.amazon.jsii.Kernel.call(this, "addAccessPolicies", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(newAccessPolicies, "newAccessPolicies is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The Amazon Resource Name (ARN) of the access entry.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessEntryArn() {
        return software.amazon.jsii.Kernel.get(this, "accessEntryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the access entry.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessEntryName() {
        return software.amazon.jsii.Kernel.get(this, "accessEntryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.AccessEntry}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.AccessEntry> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.AccessEntryProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.AccessEntryProps.Builder();
        }

        /**
         * The access policies that define the permissions and scope for the access entry.
         * <p>
         * @return {@code this}
         * @param accessPolicies The access policies that define the permissions and scope for the access entry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicies(final java.util.List<? extends software.amazon.awscdk.services.eks.IAccessPolicy> accessPolicies) {
            this.props.accessPolicies(accessPolicies);
            return this;
        }

        /**
         * The Amazon EKS cluster to which the access entry applies.
         * <p>
         * @return {@code this}
         * @param cluster The Amazon EKS cluster to which the access entry applies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.eks.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the principal (user or role) to associate the access entry with.
         * <p>
         * @return {@code this}
         * @param principal The Amazon Resource Name (ARN) of the principal (user or role) to associate the access entry with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(final java.lang.String principal) {
            this.props.principal(principal);
            return this;
        }

        /**
         * The name of the AccessEntry.
         * <p>
         * Default: - No access entry name is provided
         * <p>
         * @return {@code this}
         * @param accessEntryName The name of the AccessEntry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessEntryName(final java.lang.String accessEntryName) {
            this.props.accessEntryName(accessEntryName);
            return this;
        }

        /**
         * The type of the AccessEntry.
         * <p>
         * Default: STANDARD
         * <p>
         * @return {@code this}
         * @param accessEntryType The type of the AccessEntry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessEntryType(final software.amazon.awscdk.services.eks.AccessEntryType accessEntryType) {
            this.props.accessEntryType(accessEntryType);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.AccessEntry}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.AccessEntry build() {
            return new software.amazon.awscdk.services.eks.AccessEntry(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
