package software.amazon.awscdk.services.eks;

/**
 * Construct for installing the AWS ALB Contoller on EKS clusters.
 * <p>
 * Use the factory functions <code>get</code> and <code>getOrCreate</code> to obtain/create instances of this controller.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * AlbControllerVersion albControllerVersion;
 * Cluster cluster;
 * Object policy;
 * AlbController albController = AlbController.Builder.create(this, "MyAlbController")
 *         .cluster(cluster)
 *         .version(albControllerVersion)
 *         // the properties below are optional
 *         .additionalHelmChartValues(AlbControllerHelmChartOptions.builder()
 *                 .enableWaf(false)
 *                 .enableWafv2(false)
 *                 .build())
 *         .policy(policy)
 *         .repository("repository")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://kubernetes-sigs.github.io/aws-load-balancer-controller">https://kubernetes-sigs.github.io/aws-load-balancer-controller</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:14.011Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AlbController")
public class AlbController extends software.constructs.Construct {

    protected AlbController(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AlbController(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AlbController(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AlbControllerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Create the controller construct associated with this cluster and scope.
     * <p>
     * Singleton per stack/cluster.
     * <p>
     * @param scope This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AlbController create(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AlbControllerProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.AlbController.class, "create", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbController.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.AlbController}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.AlbController> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.AlbControllerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.AlbControllerProps.Builder();
        }

        /**
         * Version of the controller.
         * <p>
         * @return {@code this}
         * @param version Version of the controller. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final software.amazon.awscdk.services.eks.AlbControllerVersion version) {
            this.props.version(version);
            return this;
        }

        /**
         * Additional helm chart values for ALB controller.
         * <p>
         * Default: - no additional helm chart values
         * <p>
         * @return {@code this}
         * @param additionalHelmChartValues Additional helm chart values for ALB controller. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalHelmChartValues(final software.amazon.awscdk.services.eks.AlbControllerHelmChartOptions additionalHelmChartValues) {
            this.props.additionalHelmChartValues(additionalHelmChartValues);
            return this;
        }

        /**
         * The IAM policy to apply to the service account.
         * <p>
         * If you're using one of the built-in versions, this is not required since
         * CDK ships with the appropriate policies for those versions.
         * <p>
         * However, if you are using a custom version, this is required (and validated).
         * <p>
         * Default: - Corresponds to the predefined version.
         * <p>
         * @return {@code this}
         * @param policy The IAM policy to apply to the service account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final java.lang.Object policy) {
            this.props.policy(policy);
            return this;
        }

        /**
         * The repository to pull the controller image from.
         * <p>
         * Note that the default repository works for most regions, but not all.
         * If the repository is not applicable to your region, use a custom repository
         * according to the information here: https://github.com/kubernetes-sigs/aws-load-balancer-controller/releases.
         * <p>
         * Default: '602401143452.dkr.ecr.us-west-2.amazonaws.com/amazon/aws-load-balancer-controller'
         * <p>
         * @return {@code this}
         * @param repository The repository to pull the controller image from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(final java.lang.String repository) {
            this.props.repository(repository);
            return this;
        }

        /**
         * [disable-awslint:ref-via-interface] Cluster to install the controller onto.
         * <p>
         * @return {@code this}
         * @param cluster [disable-awslint:ref-via-interface] Cluster to install the controller onto. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.eks.Cluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.AlbController}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.AlbController build() {
            return new software.amazon.awscdk.services.eks.AlbController(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
