package software.amazon.awscdk.services.events;

/**
 * Properties for <code>Authorization.oauth()</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.events.*;
 * HttpParameter httpParameter;
 * SecretValue secretValue;
 * OAuthAuthorizationProps oAuthAuthorizationProps = OAuthAuthorizationProps.builder()
 *         .authorizationEndpoint("authorizationEndpoint")
 *         .clientId("clientId")
 *         .clientSecret(secretValue)
 *         .httpMethod(HttpMethod.POST)
 *         // the properties below are optional
 *         .bodyParameters(Map.of(
 *                 "bodyParametersKey", httpParameter))
 *         .headerParameters(Map.of(
 *                 "headerParametersKey", httpParameter))
 *         .queryStringParameters(Map.of(
 *                 "queryStringParametersKey", httpParameter))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:14.711Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.OAuthAuthorizationProps")
@software.amazon.jsii.Jsii.Proxy(OAuthAuthorizationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OAuthAuthorizationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The URL to the authorization endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationEndpoint();

    /**
     * The client ID to use for OAuth authorization for the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientId();

    /**
     * The client secret associated with the client ID to use for OAuth authorization for the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue getClientSecret();

    /**
     * The method to use for the authorization request.
     * <p>
     * (Can only choose POST, GET or PUT).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.HttpMethod getHttpMethod();

    /**
     * Additional string parameters to add to the OAuth request body.
     * <p>
     * Default: - No additional parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getBodyParameters() {
        return null;
    }

    /**
     * Additional string parameters to add to the OAuth request header.
     * <p>
     * Default: - No additional parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getHeaderParameters() {
        return null;
    }

    /**
     * Additional string parameters to add to the OAuth request query string.
     * <p>
     * Default: - No additional parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getQueryStringParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OAuthAuthorizationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OAuthAuthorizationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OAuthAuthorizationProps> {
        java.lang.String authorizationEndpoint;
        java.lang.String clientId;
        software.amazon.awscdk.SecretValue clientSecret;
        software.amazon.awscdk.services.events.HttpMethod httpMethod;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> bodyParameters;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> headerParameters;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> queryStringParameters;

        /**
         * Sets the value of {@link OAuthAuthorizationProps#getAuthorizationEndpoint}
         * @param authorizationEndpoint The URL to the authorization endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationEndpoint(java.lang.String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link OAuthAuthorizationProps#getClientId}
         * @param clientId The client ID to use for OAuth authorization for the connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link OAuthAuthorizationProps#getClientSecret}
         * @param clientSecret The client secret associated with the client ID to use for OAuth authorization for the connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSecret(software.amazon.awscdk.SecretValue clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        /**
         * Sets the value of {@link OAuthAuthorizationProps#getHttpMethod}
         * @param httpMethod The method to use for the authorization request. This parameter is required.
         *                   (Can only choose POST, GET or PUT).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(software.amazon.awscdk.services.events.HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        /**
         * Sets the value of {@link OAuthAuthorizationProps#getBodyParameters}
         * @param bodyParameters Additional string parameters to add to the OAuth request body.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder bodyParameters(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.events.HttpParameter> bodyParameters) {
            this.bodyParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)bodyParameters;
            return this;
        }

        /**
         * Sets the value of {@link OAuthAuthorizationProps#getHeaderParameters}
         * @param headerParameters Additional string parameters to add to the OAuth request header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder headerParameters(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.events.HttpParameter> headerParameters) {
            this.headerParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)headerParameters;
            return this;
        }

        /**
         * Sets the value of {@link OAuthAuthorizationProps#getQueryStringParameters}
         * @param queryStringParameters Additional string parameters to add to the OAuth request query string.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder queryStringParameters(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.events.HttpParameter> queryStringParameters) {
            this.queryStringParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)queryStringParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OAuthAuthorizationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OAuthAuthorizationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OAuthAuthorizationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuthAuthorizationProps {
        private final java.lang.String authorizationEndpoint;
        private final java.lang.String clientId;
        private final software.amazon.awscdk.SecretValue clientSecret;
        private final software.amazon.awscdk.services.events.HttpMethod httpMethod;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> bodyParameters;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> headerParameters;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> queryStringParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizationEndpoint = software.amazon.jsii.Kernel.get(this, "authorizationEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
            this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.HttpMethod.class));
            this.bodyParameters = software.amazon.jsii.Kernel.get(this, "bodyParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.HttpParameter.class)));
            this.headerParameters = software.amazon.jsii.Kernel.get(this, "headerParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.HttpParameter.class)));
            this.queryStringParameters = software.amazon.jsii.Kernel.get(this, "queryStringParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.HttpParameter.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizationEndpoint = java.util.Objects.requireNonNull(builder.authorizationEndpoint, "authorizationEndpoint is required");
            this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
            this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
            this.httpMethod = java.util.Objects.requireNonNull(builder.httpMethod, "httpMethod is required");
            this.bodyParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)builder.bodyParameters;
            this.headerParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)builder.headerParameters;
            this.queryStringParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)builder.queryStringParameters;
        }

        @Override
        public final java.lang.String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        @Override
        public final java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public final software.amazon.awscdk.SecretValue getClientSecret() {
            return this.clientSecret;
        }

        @Override
        public final software.amazon.awscdk.services.events.HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getBodyParameters() {
            return this.bodyParameters;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getHeaderParameters() {
            return this.headerParameters;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getQueryStringParameters() {
            return this.queryStringParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authorizationEndpoint", om.valueToTree(this.getAuthorizationEndpoint()));
            data.set("clientId", om.valueToTree(this.getClientId()));
            data.set("clientSecret", om.valueToTree(this.getClientSecret()));
            data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
            if (this.getBodyParameters() != null) {
                data.set("bodyParameters", om.valueToTree(this.getBodyParameters()));
            }
            if (this.getHeaderParameters() != null) {
                data.set("headerParameters", om.valueToTree(this.getHeaderParameters()));
            }
            if (this.getQueryStringParameters() != null) {
                data.set("queryStringParameters", om.valueToTree(this.getQueryStringParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.OAuthAuthorizationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OAuthAuthorizationProps.Jsii$Proxy that = (OAuthAuthorizationProps.Jsii$Proxy) o;

            if (!authorizationEndpoint.equals(that.authorizationEndpoint)) return false;
            if (!clientId.equals(that.clientId)) return false;
            if (!clientSecret.equals(that.clientSecret)) return false;
            if (!httpMethod.equals(that.httpMethod)) return false;
            if (this.bodyParameters != null ? !this.bodyParameters.equals(that.bodyParameters) : that.bodyParameters != null) return false;
            if (this.headerParameters != null ? !this.headerParameters.equals(that.headerParameters) : that.headerParameters != null) return false;
            return this.queryStringParameters != null ? this.queryStringParameters.equals(that.queryStringParameters) : that.queryStringParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizationEndpoint.hashCode();
            result = 31 * result + (this.clientId.hashCode());
            result = 31 * result + (this.clientSecret.hashCode());
            result = 31 * result + (this.httpMethod.hashCode());
            result = 31 * result + (this.bodyParameters != null ? this.bodyParameters.hashCode() : 0);
            result = 31 * result + (this.headerParameters != null ? this.headerParameters.hashCode() : 0);
            result = 31 * result + (this.queryStringParameters != null ? this.queryStringParameters.hashCode() : 0);
            return result;
        }
    }
}
