package software.amazon.awscdk.services.events.targets;

/**
 * Use an API Gateway V2 HTTP APIs as a target for Amazon EventBridge rules.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * HttpApi httpApi;
 * Rule rule;
 * rule.addTarget(new ApiGatewayV2(httpApi));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:14.728Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.ApiGatewayV2")
public class ApiGatewayV2 extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected ApiGatewayV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiGatewayV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param httpApi <ul><li>IHttpApi implementation to use as event target.</li></ul> This parameter is required.
     * @param props <ul><li>Properties to configure the APIGateway target.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApiGatewayV2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.ApiGatewayProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(httpApi, "httpApi is required"), props });
    }

    /**
     * @param httpApi <ul><li>IHttpApi implementation to use as event target.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApiGatewayV2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(httpApi, "httpApi is required") });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this API Gateway HTTP APIs as a result from an EventBridge event.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-use-resource-based.html#eb-api-gateway-permissions">https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-use-resource-based.html#eb-api-gateway-permissions</a>
     * @param rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required"), _id });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this API Gateway HTTP APIs as a result from an EventBridge event.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-use-resource-based.html#eb-api-gateway-permissions">https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-use-resource-based.html#eb-api-gateway-permissions</a>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * Returns the target IHttpApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IHttpApi getIHttpApi() {
        return software.amazon.jsii.Kernel.get(this, "iHttpApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpApi.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.ApiGatewayV2}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.ApiGatewayV2> {
        /**
         * @return a new instance of {@link Builder}.
         * @param httpApi <ul><li>IHttpApi implementation to use as event target.</li></ul> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi) {
            return new Builder(httpApi);
        }

        private final software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi;
        private software.amazon.awscdk.services.events.targets.ApiGatewayProps.Builder props;

        private Builder(final software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi) {
            this.httpApi = httpApi;
        }

        /**
         * The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>.
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        /**
         * The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered.
         * <p>
         * Default: - a new role will be created
         * <p>
         * @return {@code this}
         * @param eventRole The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRole(final software.amazon.awscdk.services.iam.IRole eventRole) {
            this.props().eventRole(eventRole);
            return this;
        }

        /**
         * The headers to be set when requesting API.
         * <p>
         * Default: no header parameters
         * <p>
         * @return {@code this}
         * @param headerParameters The headers to be set when requesting API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerParameters(final java.util.Map<java.lang.String, java.lang.String> headerParameters) {
            this.props().headerParameters(headerParameters);
            return this;
        }

        /**
         * The method for api resource invoked by the rule.
         * <p>
         * Default: '*' that treated as ANY
         * <p>
         * @return {@code this}
         * @param method The method for api resource invoked by the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(final java.lang.String method) {
            this.props().method(method);
            return this;
        }

        /**
         * The api resource invoked by the rule.
         * <p>
         * We can use wildcards('*') to specify the path. In that case,
         * an equal number of real values must be specified for pathParameterValues.
         * <p>
         * Default: '/'
         * <p>
         * @return {@code this}
         * @param path The api resource invoked by the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props().path(path);
            return this;
        }

        /**
         * The path parameter values to be used to populate to wildcards("*") of requesting api path.
         * <p>
         * Default: no path parameters
         * <p>
         * @return {@code this}
         * @param pathParameterValues The path parameter values to be used to populate to wildcards("*") of requesting api path. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathParameterValues(final java.util.List<java.lang.String> pathParameterValues) {
            this.props().pathParameterValues(pathParameterValues);
            return this;
        }

        /**
         * This will be the post request body send to the API.
         * <p>
         * Default: the entire EventBridge event
         * <p>
         * @return {@code this}
         * @param postBody This will be the post request body send to the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postBody(final software.amazon.awscdk.services.events.RuleTargetInput postBody) {
            this.props().postBody(postBody);
            return this;
        }

        /**
         * The query parameters to be set when requesting API.
         * <p>
         * Default: no querystring parameters
         * <p>
         * @return {@code this}
         * @param queryStringParameters The query parameters to be set when requesting API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryStringParameters(final java.util.Map<java.lang.String, java.lang.String> queryStringParameters) {
            this.props().queryStringParameters(queryStringParameters);
            return this;
        }

        /**
         * The deploy stage of api gateway invoked by the rule.
         * <p>
         * Default: the value of deploymentStage.stageName of target api gateway.
         * <p>
         * @return {@code this}
         * @param stage The deploy stage of api gateway invoked by the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(final java.lang.String stage) {
            this.props().stage(stage);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.targets.ApiGatewayV2}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.ApiGatewayV2 build() {
            return new software.amazon.awscdk.services.events.targets.ApiGatewayV2(
                this.httpApi,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.ApiGatewayProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.ApiGatewayProps.Builder();
            }
            return this.props;
        }
    }
}
