package software.amazon.awscdk.services.evidently;

/**
 * Creates or updates an Evidently <em>feature</em> that you want to launch or test.
 * <p>
 * You can define up to five variations of a feature, and use these variations in your launches and experiments. A feature must be created in a project. For information about creating a project, see <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html">CreateProject</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.evidently.*;
 * CfnFeature cfnFeature = CfnFeature.Builder.create(this, "MyCfnFeature")
 *         .name("name")
 *         .project("project")
 *         .variations(List.of(VariationObjectProperty.builder()
 *                 .variationName("variationName")
 *                 // the properties below are optional
 *                 .booleanValue(false)
 *                 .doubleValue(123)
 *                 .longValue(123)
 *                 .stringValue("stringValue")
 *                 .build()))
 *         // the properties below are optional
 *         .defaultVariation("defaultVariation")
 *         .description("description")
 *         .entityOverrides(List.of(EntityOverrideProperty.builder()
 *                 .entityId("entityId")
 *                 .variation("variation")
 *                 .build()))
 *         .evaluationStrategy("evaluationStrategy")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:14.782Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnFeature")
public class CfnFeature extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnFeature(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFeature(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.evidently.CfnFeature.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFeature(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.evidently.CfnFeatureProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the feature.
     * <p>
     * For example, <code>arn:aws:evidently:us-west-2:0123455678912:project/myProject/feature/myFeature</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name for the feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The name or ARN of the project that is to contain the new feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProject() {
        return software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name or ARN of the project that is to contain the new feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProject(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "project", java.util.Objects.requireNonNull(value, "project is required"));
    }

    /**
     * An array of structures that contain the configuration of the feature's different variations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getVariations() {
        return software.amazon.jsii.Kernel.get(this, "variations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of structures that contain the configuration of the feature's different variations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVariations(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "variations", java.util.Objects.requireNonNull(value, "variations is required"));
    }

    /**
     * An array of structures that contain the configuration of the feature's different variations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVariations(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.evidently.CfnFeature.VariationObjectProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.evidently.CfnFeature.VariationObjectProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "variations", java.util.Objects.requireNonNull(value, "variations is required"));
    }

    /**
     * The name of the variation to use as the default variation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultVariation() {
        return software.amazon.jsii.Kernel.get(this, "defaultVariation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the variation to use as the default variation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultVariation(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultVariation", value);
    }

    /**
     * An optional description of the feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional description of the feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specify users that should always be served a specific variation of a feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEntityOverrides() {
        return software.amazon.jsii.Kernel.get(this, "entityOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specify users that should always be served a specific variation of a feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntityOverrides(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "entityOverrides", value);
    }

    /**
     * Specify users that should always be served a specific variation of a feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntityOverrides(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.evidently.CfnFeature.EntityOverrideProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.evidently.CfnFeature.EntityOverrideProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "entityOverrides", value);
    }

    /**
     * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEvaluationStrategy() {
        return software.amazon.jsii.Kernel.get(this, "evaluationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvaluationStrategy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "evaluationStrategy", value);
    }

    /**
     * Assigns one or more tags (key-value pairs) to the feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Assigns one or more tags (key-value pairs) to the feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A set of key-value pairs that specify users who should always be served a specific variation of a feature.
     * <p>
     * Each key specifies a user using their user ID, account ID, or some other identifier. The value specifies the name of the variation that the user is to be served.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * EntityOverrideProperty entityOverrideProperty = EntityOverrideProperty.builder()
     *         .entityId("entityId")
     *         .variation("variation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-entityoverride.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-entityoverride.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnFeature.EntityOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(EntityOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EntityOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The entity ID to be served the variation specified in <code>Variation</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-entityoverride.html#cfn-evidently-feature-entityoverride-entityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-entityoverride.html#cfn-evidently-feature-entityoverride-entityid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntityId() {
            return null;
        }

        /**
         * The name of the variation to serve to the user session that matches the <code>EntityId</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-entityoverride.html#cfn-evidently-feature-entityoverride-variation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-entityoverride.html#cfn-evidently-feature-entityoverride-variation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVariation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EntityOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EntityOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EntityOverrideProperty> {
            java.lang.String entityId;
            java.lang.String variation;

            /**
             * Sets the value of {@link EntityOverrideProperty#getEntityId}
             * @param entityId The entity ID to be served the variation specified in <code>Variation</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityId(java.lang.String entityId) {
                this.entityId = entityId;
                return this;
            }

            /**
             * Sets the value of {@link EntityOverrideProperty#getVariation}
             * @param variation The name of the variation to serve to the user session that matches the <code>EntityId</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variation(java.lang.String variation) {
                this.variation = variation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EntityOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EntityOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EntityOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EntityOverrideProperty {
            private final java.lang.String entityId;
            private final java.lang.String variation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityId = software.amazon.jsii.Kernel.get(this, "entityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.variation = software.amazon.jsii.Kernel.get(this, "variation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityId = builder.entityId;
                this.variation = builder.variation;
            }

            @Override
            public final java.lang.String getEntityId() {
                return this.entityId;
            }

            @Override
            public final java.lang.String getVariation() {
                return this.variation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEntityId() != null) {
                    data.set("entityId", om.valueToTree(this.getEntityId()));
                }
                if (this.getVariation() != null) {
                    data.set("variation", om.valueToTree(this.getVariation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnFeature.EntityOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EntityOverrideProperty.Jsii$Proxy that = (EntityOverrideProperty.Jsii$Proxy) o;

                if (this.entityId != null ? !this.entityId.equals(that.entityId) : that.entityId != null) return false;
                return this.variation != null ? this.variation.equals(that.variation) : that.variation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.entityId != null ? this.entityId.hashCode() : 0;
                result = 31 * result + (this.variation != null ? this.variation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure contains the name and variation value of one variation of a feature.
     * <p>
     * It can contain only one of the following parameters: <code>BooleanValue</code> , <code>DoubleValue</code> , <code>LongValue</code> or <code>StringValue</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * VariationObjectProperty variationObjectProperty = VariationObjectProperty.builder()
     *         .variationName("variationName")
     *         // the properties below are optional
     *         .booleanValue(false)
     *         .doubleValue(123)
     *         .longValue(123)
     *         .stringValue("stringValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnFeature.VariationObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(VariationObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VariationObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the variation.
         * <p>
         * It can include up to 127 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html#cfn-evidently-feature-variationobject-variationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html#cfn-evidently-feature-variationobject-variationname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVariationName();

        /**
         * The value assigned to this variation, if the variation type is boolean.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html#cfn-evidently-feature-variationobject-booleanvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html#cfn-evidently-feature-variationobject-booleanvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBooleanValue() {
            return null;
        }

        /**
         * The value assigned to this variation, if the variation type is a double.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html#cfn-evidently-feature-variationobject-doublevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html#cfn-evidently-feature-variationobject-doublevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDoubleValue() {
            return null;
        }

        /**
         * The value assigned to this variation, if the variation type is a long.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html#cfn-evidently-feature-variationobject-longvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html#cfn-evidently-feature-variationobject-longvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLongValue() {
            return null;
        }

        /**
         * The value assigned to this variation, if the variation type is a string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html#cfn-evidently-feature-variationobject-stringvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-feature-variationobject.html#cfn-evidently-feature-variationobject-stringvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStringValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VariationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VariationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VariationObjectProperty> {
            java.lang.String variationName;
            java.lang.Object booleanValue;
            java.lang.Number doubleValue;
            java.lang.Number longValue;
            java.lang.String stringValue;

            /**
             * Sets the value of {@link VariationObjectProperty#getVariationName}
             * @param variationName A name for the variation. This parameter is required.
             *                      It can include up to 127 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variationName(java.lang.String variationName) {
                this.variationName = variationName;
                return this;
            }

            /**
             * Sets the value of {@link VariationObjectProperty#getBooleanValue}
             * @param booleanValue The value assigned to this variation, if the variation type is boolean.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(java.lang.Boolean booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link VariationObjectProperty#getBooleanValue}
             * @param booleanValue The value assigned to this variation, if the variation type is boolean.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(software.amazon.awscdk.IResolvable booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link VariationObjectProperty#getDoubleValue}
             * @param doubleValue The value assigned to this variation, if the variation type is a double.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder doubleValue(java.lang.Number doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            /**
             * Sets the value of {@link VariationObjectProperty#getLongValue}
             * @param longValue The value assigned to this variation, if the variation type is a long.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder longValue(java.lang.Number longValue) {
                this.longValue = longValue;
                return this;
            }

            /**
             * Sets the value of {@link VariationObjectProperty#getStringValue}
             * @param stringValue The value assigned to this variation, if the variation type is a string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringValue(java.lang.String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VariationObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VariationObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VariationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VariationObjectProperty {
            private final java.lang.String variationName;
            private final java.lang.Object booleanValue;
            private final java.lang.Number doubleValue;
            private final java.lang.Number longValue;
            private final java.lang.String stringValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.variationName = software.amazon.jsii.Kernel.get(this, "variationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.booleanValue = software.amazon.jsii.Kernel.get(this, "booleanValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.doubleValue = software.amazon.jsii.Kernel.get(this, "doubleValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.longValue = software.amazon.jsii.Kernel.get(this, "longValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.variationName = java.util.Objects.requireNonNull(builder.variationName, "variationName is required");
                this.booleanValue = builder.booleanValue;
                this.doubleValue = builder.doubleValue;
                this.longValue = builder.longValue;
                this.stringValue = builder.stringValue;
            }

            @Override
            public final java.lang.String getVariationName() {
                return this.variationName;
            }

            @Override
            public final java.lang.Object getBooleanValue() {
                return this.booleanValue;
            }

            @Override
            public final java.lang.Number getDoubleValue() {
                return this.doubleValue;
            }

            @Override
            public final java.lang.Number getLongValue() {
                return this.longValue;
            }

            @Override
            public final java.lang.String getStringValue() {
                return this.stringValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("variationName", om.valueToTree(this.getVariationName()));
                if (this.getBooleanValue() != null) {
                    data.set("booleanValue", om.valueToTree(this.getBooleanValue()));
                }
                if (this.getDoubleValue() != null) {
                    data.set("doubleValue", om.valueToTree(this.getDoubleValue()));
                }
                if (this.getLongValue() != null) {
                    data.set("longValue", om.valueToTree(this.getLongValue()));
                }
                if (this.getStringValue() != null) {
                    data.set("stringValue", om.valueToTree(this.getStringValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnFeature.VariationObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VariationObjectProperty.Jsii$Proxy that = (VariationObjectProperty.Jsii$Proxy) o;

                if (!variationName.equals(that.variationName)) return false;
                if (this.booleanValue != null ? !this.booleanValue.equals(that.booleanValue) : that.booleanValue != null) return false;
                if (this.doubleValue != null ? !this.doubleValue.equals(that.doubleValue) : that.doubleValue != null) return false;
                if (this.longValue != null ? !this.longValue.equals(that.longValue) : that.longValue != null) return false;
                return this.stringValue != null ? this.stringValue.equals(that.stringValue) : that.stringValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.variationName.hashCode();
                result = 31 * result + (this.booleanValue != null ? this.booleanValue.hashCode() : 0);
                result = 31 * result + (this.doubleValue != null ? this.doubleValue.hashCode() : 0);
                result = 31 * result + (this.longValue != null ? this.longValue.hashCode() : 0);
                result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.evidently.CfnFeature}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.evidently.CfnFeature> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.evidently.CfnFeatureProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.evidently.CfnFeatureProps.Builder();
        }

        /**
         * The name for the feature.
         * <p>
         * It can include up to 127 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-name</a>
         * @param name The name for the feature. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The name or ARN of the project that is to contain the new feature.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-project">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-project</a>
         * @param project The name or ARN of the project that is to contain the new feature. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(final java.lang.String project) {
            this.props.project(project);
            return this;
        }

        /**
         * An array of structures that contain the configuration of the feature's different variations.
         * <p>
         * Each <code>VariationObject</code> in the <code>Variations</code> array for a feature must have the same type of value ( <code>BooleanValue</code> , <code>DoubleValue</code> , <code>LongValue</code> or <code>StringValue</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-variations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-variations</a>
         * @param variations An array of structures that contain the configuration of the feature's different variations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variations(final software.amazon.awscdk.IResolvable variations) {
            this.props.variations(variations);
            return this;
        }
        /**
         * An array of structures that contain the configuration of the feature's different variations.
         * <p>
         * Each <code>VariationObject</code> in the <code>Variations</code> array for a feature must have the same type of value ( <code>BooleanValue</code> , <code>DoubleValue</code> , <code>LongValue</code> or <code>StringValue</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-variations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-variations</a>
         * @param variations An array of structures that contain the configuration of the feature's different variations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variations(final java.util.List<? extends java.lang.Object> variations) {
            this.props.variations(variations);
            return this;
        }

        /**
         * The name of the variation to use as the default variation.
         * <p>
         * The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.
         * <p>
         * This variation must also be listed in the <code>Variations</code> structure.
         * <p>
         * If you omit <code>DefaultVariation</code> , the first variation listed in the <code>Variations</code> structure is used as the default variation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-defaultvariation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-defaultvariation</a>
         * @param defaultVariation The name of the variation to use as the default variation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultVariation(final java.lang.String defaultVariation) {
            this.props.defaultVariation(defaultVariation);
            return this;
        }

        /**
         * An optional description of the feature.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-description</a>
         * @param description An optional description of the feature. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specify users that should always be served a specific variation of a feature.
         * <p>
         * Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-entityoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-entityoverrides</a>
         * @param entityOverrides Specify users that should always be served a specific variation of a feature. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityOverrides(final software.amazon.awscdk.IResolvable entityOverrides) {
            this.props.entityOverrides(entityOverrides);
            return this;
        }
        /**
         * Specify users that should always be served a specific variation of a feature.
         * <p>
         * Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-entityoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-entityoverrides</a>
         * @param entityOverrides Specify users that should always be served a specific variation of a feature. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityOverrides(final java.util.List<? extends java.lang.Object> entityOverrides) {
            this.props.entityOverrides(entityOverrides);
            return this;
        }

        /**
         * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments.
         * <p>
         * Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-evaluationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-evaluationstrategy</a>
         * @param evaluationStrategy Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationStrategy(final java.lang.String evaluationStrategy) {
            this.props.evaluationStrategy(evaluationStrategy);
            return this;
        }

        /**
         * Assigns one or more tags (key-value pairs) to the feature.
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         * <p>
         * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
         * <p>
         * You can associate as many as 50 tags with a feature.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-tags</a>
         * @param tags Assigns one or more tags (key-value pairs) to the feature. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.evidently.CfnFeature}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.evidently.CfnFeature build() {
            return new software.amazon.awscdk.services.evidently.CfnFeature(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
