package software.amazon.awscdk.services.fsx;

/**
 * The storage type for the file system.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LustreFileSystem fileSystem = LustreFileSystem.Builder.create(this, "FsxLustreFileSystem")
 *         .lustreConfiguration(LustreConfiguration.builder().deploymentType(LustreDeploymentType.PERSISTENT_1).build())
 *         .storageCapacityGiB(1200)
 *         .vpc(vpc)
 *         .vpcSubnet(vpc.getPrivateSubnets()[0])
 *         .storageType(StorageType.HDD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:14.989Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.StorageType")
public enum StorageType {
    /**
     * Solid State Drive storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SSD,
    /**
     * Hard Disk Drive storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HDD,
    /**
     * Intelligent Tiering storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INTELLIGENT_TIERING,
}
