package software.amazon.awscdk.services.gamelift;

/**
 * The properties that describe a container group resource.
 * <p>
 * You can update all properties of a container group definition properties. Updates to a container group definition are saved as new versions.
 * <p>
 * <em>Used with:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html">CreateContainerGroupDefinition</a>
 * <p>
 * <em>Returned by:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeContainerGroupDefinition.html">DescribeContainerGroupDefinition</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListContainerGroupDefinitions.html">ListContainerGroupDefinitions</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html">UpdateContainerGroupDefinition</a>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnContainerGroupDefinition cfnContainerGroupDefinition = CfnContainerGroupDefinition.Builder.create(this, "MyCfnContainerGroupDefinition")
 *         .name("name")
 *         .operatingSystem("operatingSystem")
 *         .totalMemoryLimitMebibytes(123)
 *         .totalVcpuLimit(123)
 *         // the properties below are optional
 *         .containerGroupType("containerGroupType")
 *         .gameServerContainerDefinition(GameServerContainerDefinitionProperty.builder()
 *                 .containerName("containerName")
 *                 .imageUri("imageUri")
 *                 .serverSdkVersion("serverSdkVersion")
 *                 // the properties below are optional
 *                 .dependsOn(List.of(ContainerDependencyProperty.builder()
 *                         .condition("condition")
 *                         .containerName("containerName")
 *                         .build()))
 *                 .environmentOverride(List.of(ContainerEnvironmentProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .mountPoints(List.of(ContainerMountPointProperty.builder()
 *                         .instancePath("instancePath")
 *                         // the properties below are optional
 *                         .accessLevel("accessLevel")
 *                         .containerPath("containerPath")
 *                         .build()))
 *                 .portConfiguration(PortConfigurationProperty.builder()
 *                         .containerPortRanges(List.of(ContainerPortRangeProperty.builder()
 *                                 .fromPort(123)
 *                                 .protocol("protocol")
 *                                 .toPort(123)
 *                                 .build()))
 *                         .build())
 *                 .resolvedImageDigest("resolvedImageDigest")
 *                 .build())
 *         .sourceVersionNumber(123)
 *         .supportContainerDefinitions(List.of(SupportContainerDefinitionProperty.builder()
 *                 .containerName("containerName")
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .dependsOn(List.of(ContainerDependencyProperty.builder()
 *                         .condition("condition")
 *                         .containerName("containerName")
 *                         .build()))
 *                 .environmentOverride(List.of(ContainerEnvironmentProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .essential(false)
 *                 .healthCheck(ContainerHealthCheckProperty.builder()
 *                         .command(List.of("command"))
 *                         // the properties below are optional
 *                         .interval(123)
 *                         .retries(123)
 *                         .startPeriod(123)
 *                         .timeout(123)
 *                         .build())
 *                 .memoryHardLimitMebibytes(123)
 *                 .mountPoints(List.of(ContainerMountPointProperty.builder()
 *                         .instancePath("instancePath")
 *                         // the properties below are optional
 *                         .accessLevel("accessLevel")
 *                         .containerPath("containerPath")
 *                         .build()))
 *                 .portConfiguration(PortConfigurationProperty.builder()
 *                         .containerPortRanges(List.of(ContainerPortRangeProperty.builder()
 *                                 .fromPort(123)
 *                                 .protocol("protocol")
 *                                 .toPort(123)
 *                                 .build()))
 *                         .build())
 *                 .resolvedImageDigest("resolvedImageDigest")
 *                 .vcpu(123)
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .versionDescription("versionDescription")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:15.017Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition")
public class CfnContainerGroupDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnContainerGroupDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnContainerGroupDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnContainerGroupDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name ( <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a> ) that is assigned to an Amazon GameLift Servers <code>ContainerGroupDefinition</code> resource. It uniquely identifies the resource across all AWS Regions. Format is <code>arn:aws:gamelift:[region]::containergroupdefinition/[container group definition name]:[version]</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrContainerGroupDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrContainerGroupDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A time stamp indicating when this data object was created.
     * <p>
     * Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Current status of the container group definition resource. Values include:.
     * <p>
     * <ul>
     * <li><code>COPYING</code> -- Amazon GameLift Servers is in the process of making copies of all container images that are defined in the group. While in this state, the resource can't be used to create a container fleet.</li>
     * <li><code>READY</code> -- Amazon GameLift Servers has copied the registry images for all containers that are defined in the group. You can use a container group definition in this status to create a container fleet.</li>
     * <li><code>FAILED</code> -- Amazon GameLift Servers failed to create a valid container group definition resource. For more details on the cause of the failure, see <code>StatusReason</code> . A container group definition resource in failed status will be deleted within a few minutes.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Additional information about a container group definition that's in <code>FAILED</code> status. Possible reasons include:.
     * <p>
     * <ul>
     * <li>An internal issue prevented Amazon GameLift Servers from creating the container group definition resource. Delete the failed resource and call <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html">CreateContainerGroupDefinition</a> again.</li>
     * <li>An access-denied message means that you don't have permissions to access the container image on ECR. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-iam-policy-examples.html.html">IAM permission examples</a> for help setting up required IAM permissions for Amazon GameLift Servers.</li>
     * <li>The <code>ImageUri</code> value for at least one of the containers in the container group definition was invalid or not found in the current AWS account.</li>
     * <li>At least one of the container images referenced in the container group definition exceeds the allowed size. For size limits, see <a href="https://docs.aws.amazon.com/general/latest/gr/gamelift.html">Amazon GameLift Servers endpoints and quotas</a> .</li>
     * <li>At least one of the container images referenced in the container group definition uses a different operating system than the one defined for the container group.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusReason() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates the version of a particular container group definition.
     * <p>
     * This number is incremented automatically when you update a container group definition. You can view, update, or delete individual versions or the entire container group definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A descriptive identifier for the container group definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A descriptive identifier for the container group definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The platform that all containers in the container group definition run on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOperatingSystem() {
        return software.amazon.jsii.Kernel.get(this, "operatingSystem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The platform that all containers in the container group definition run on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOperatingSystem(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "operatingSystem", java.util.Objects.requireNonNull(value, "operatingSystem is required"));
    }

    /**
     * The amount of memory (in MiB) on a fleet instance to allocate for the container group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getTotalMemoryLimitMebibytes() {
        return software.amazon.jsii.Kernel.get(this, "totalMemoryLimitMebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of memory (in MiB) on a fleet instance to allocate for the container group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTotalMemoryLimitMebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "totalMemoryLimitMebibytes", java.util.Objects.requireNonNull(value, "totalMemoryLimitMebibytes is required"));
    }

    /**
     * The amount of vCPU units on a fleet instance to allocate for the container group (1 vCPU is equal to 1024 CPU units).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getTotalVcpuLimit() {
        return software.amazon.jsii.Kernel.get(this, "totalVcpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of vCPU units on a fleet instance to allocate for the container group (1 vCPU is equal to 1024 CPU units).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTotalVcpuLimit(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "totalVcpuLimit", java.util.Objects.requireNonNull(value, "totalVcpuLimit is required"));
    }

    /**
     * The type of container group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getContainerGroupType() {
        return software.amazon.jsii.Kernel.get(this, "containerGroupType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of container group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerGroupType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "containerGroupType", value);
    }

    /**
     * The definition for the game server container in this group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGameServerContainerDefinition() {
        return software.amazon.jsii.Kernel.get(this, "gameServerContainerDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The definition for the game server container in this group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGameServerContainerDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "gameServerContainerDefinition", value);
    }

    /**
     * The definition for the game server container in this group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGameServerContainerDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.GameServerContainerDefinitionProperty value) {
        software.amazon.jsii.Kernel.set(this, "gameServerContainerDefinition", value);
    }

    /**
     * A specific ContainerGroupDefinition version to be updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSourceVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "sourceVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A specific ContainerGroupDefinition version to be updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceVersionNumber(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "sourceVersionNumber", value);
    }

    /**
     * The set of definitions for support containers in this group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSupportContainerDefinitions() {
        return software.amazon.jsii.Kernel.get(this, "supportContainerDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The set of definitions for support containers in this group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSupportContainerDefinitions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "supportContainerDefinitions", value);
    }

    /**
     * The set of definitions for support containers in this group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSupportContainerDefinitions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.SupportContainerDefinitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.SupportContainerDefinitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "supportContainerDefinitions", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * An optional description that was provided for a container group definition update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional description that was provided for a container group definition update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersionDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "versionDescription", value);
    }
    /**
     * A container's dependency on another container in the same container group.
     * <p>
     * The dependency impacts how the dependent container is able to start or shut down based the status of the other container.
     * <p>
     * For example, <em>ContainerA</em> is configured with the following dependency: a <code>START</code> dependency on <em>ContainerB</em> . This means that <em>ContainerA</em> can't start until <em>ContainerB</em> has started. It also means that <em>ContainerA</em> must shut down before <em>ContainerB</em> .
     * <p>
     * <em>Part of:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinition.html">GameServerContainerDefinition</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput.html">GameServerContainerDefinitionInput</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinition.html">SupportContainerDefinition</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html">SupportContainerDefinitionInput</a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ContainerDependencyProperty containerDependencyProperty = ContainerDependencyProperty.builder()
     *         .condition("condition")
     *         .containerName("containerName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerDependencyProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerDependencyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerDependencyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition that the dependency container must reach before the dependent container can start. Valid conditions include:.
         * <p>
         * <ul>
         * <li>START - The dependency container must have started.</li>
         * <li>COMPLETE - The dependency container has run to completion (exits). Use this condition with nonessential containers, such as those that run a script and then exit. The dependency container can't be an essential container.</li>
         * <li>SUCCESS - The dependency container has run to completion and exited with a zero status. The dependency container can't be an essential container.</li>
         * <li>HEALTHY - The dependency container has passed its Docker health check. Use this condition with dependency containers that have health checks configured. This condition is confirmed at container group startup only.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html#cfn-gamelift-containergroupdefinition-containerdependency-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html#cfn-gamelift-containergroupdefinition-containerdependency-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCondition();

        /**
         * A descriptive label for the container definition that this container depends on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html#cfn-gamelift-containergroupdefinition-containerdependency-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html#cfn-gamelift-containergroupdefinition-containerdependency-containername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContainerName();

        /**
         * @return a {@link Builder} of {@link ContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerDependencyProperty> {
            java.lang.String condition;
            java.lang.String containerName;

            /**
             * Sets the value of {@link ContainerDependencyProperty#getCondition}
             * @param condition The condition that the dependency container must reach before the dependent container can start. Valid conditions include:. This parameter is required.
             *                  <ul>
             *                  <li>START - The dependency container must have started.</li>
             *                  <li>COMPLETE - The dependency container has run to completion (exits). Use this condition with nonessential containers, such as those that run a script and then exit. The dependency container can't be an essential container.</li>
             *                  <li>SUCCESS - The dependency container has run to completion and exited with a zero status. The dependency container can't be an essential container.</li>
             *                  <li>HEALTHY - The dependency container has passed its Docker health check. Use this condition with dependency containers that have health checks configured. This condition is confirmed at container group startup only.</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDependencyProperty#getContainerName}
             * @param containerName A descriptive label for the container definition that this container depends on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerDependencyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerDependencyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerDependencyProperty {
            private final java.lang.String condition;
            private final java.lang.String containerName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
                this.containerName = java.util.Objects.requireNonNull(builder.containerName, "containerName is required");
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("condition", om.valueToTree(this.getCondition()));
                data.set("containerName", om.valueToTree(this.getContainerName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerDependencyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerDependencyProperty.Jsii$Proxy that = (ContainerDependencyProperty.Jsii$Proxy) o;

                if (!condition.equals(that.condition)) return false;
                return this.containerName.equals(that.containerName);
            }

            @Override
            public final int hashCode() {
                int result = this.condition.hashCode();
                result = 31 * result + (this.containerName.hashCode());
                return result;
            }
        }
    }
    /**
     * An environment variable to set inside a container, in the form of a key-value pair.
     * <p>
     * <em>Part of:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinition.html">GameServerContainerDefinition</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput.html">GameServerContainerDefinitionInput</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinition.html">SupportContainerDefinition</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html">SupportContainerDefinitionInput</a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ContainerEnvironmentProperty containerEnvironmentProperty = ContainerEnvironmentProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerEnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerEnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerEnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The environment variable name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html#cfn-gamelift-containergroupdefinition-containerenvironment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html#cfn-gamelift-containergroupdefinition-containerenvironment-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The environment variable value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html#cfn-gamelift-containergroupdefinition-containerenvironment-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html#cfn-gamelift-containergroupdefinition-containerenvironment-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ContainerEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerEnvironmentProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link ContainerEnvironmentProperty#getName}
             * @param name The environment variable name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ContainerEnvironmentProperty#getValue}
             * @param value The environment variable value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerEnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerEnvironmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerEnvironmentProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerEnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerEnvironmentProperty.Jsii$Proxy that = (ContainerEnvironmentProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Instructions on when and how to check the health of a support container in a container fleet.
     * <p>
     * These properties override any Docker health checks that are set in the container image. For more information on container health checks, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html#ECS-Type-HealthCheck-command">HealthCheck command</a> in the <em>Amazon Elastic Container Service API</em> . Game server containers don't have a health check parameter; Amazon GameLift Servers automatically handles health checks for these containers.
     * <p>
     * The following example instructs the container to initiate a health check command every 60 seconds and wait 10 seconds for it to succeed. If it fails, retry the command 3 times before flagging the container as unhealthy. It also tells the container to wait 100 seconds after launch before counting failed health checks.
     * <p>
     * <code>{"Command": [ "CMD-SHELL", "ps cax | grep "processmanager" || exit 1" ], "Interval": 60, "Timeout": 10, "Retries": 3, "StartPeriod": 100 }</code>
     * <p>
     * <em>Part of:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinition.html">SupportContainerDefinition</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html">SupportContainerDefinitionInput</a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ContainerHealthCheckProperty containerHealthCheckProperty = ContainerHealthCheckProperty.builder()
     *         .command(List.of("command"))
     *         // the properties below are optional
     *         .interval(123)
     *         .retries(123)
     *         .startPeriod(123)
     *         .timeout(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerHealthCheckProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerHealthCheckProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerHealthCheckProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A string array that specifies the command that the container runs to determine if it's healthy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-command">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-command</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCommand();

        /**
         * The time period (in seconds) between each health check.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The number of times to retry a failed health check before flagging the container unhealthy.
         * <p>
         * The first run of the command does not count as a retry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-retries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-retries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetries() {
            return null;
        }

        /**
         * The optional grace period (in seconds) to give a container time to bootstrap before the first failed health check counts toward the number of retries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-startperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-startperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartPeriod() {
            return null;
        }

        /**
         * The time period (in seconds) to wait for a health check to succeed before counting a failed health check.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-timeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerHealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerHealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerHealthCheckProperty> {
            java.util.List<java.lang.String> command;
            java.lang.Number interval;
            java.lang.Number retries;
            java.lang.Number startPeriod;
            java.lang.Number timeout;

            /**
             * Sets the value of {@link ContainerHealthCheckProperty#getCommand}
             * @param command A string array that specifies the command that the container runs to determine if it's healthy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link ContainerHealthCheckProperty#getInterval}
             * @param interval The time period (in seconds) between each health check.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link ContainerHealthCheckProperty#getRetries}
             * @param retries The number of times to retry a failed health check before flagging the container unhealthy.
             *                The first run of the command does not count as a retry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retries(java.lang.Number retries) {
                this.retries = retries;
                return this;
            }

            /**
             * Sets the value of {@link ContainerHealthCheckProperty#getStartPeriod}
             * @param startPeriod The optional grace period (in seconds) to give a container time to bootstrap before the first failed health check counts toward the number of retries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startPeriod(java.lang.Number startPeriod) {
                this.startPeriod = startPeriod;
                return this;
            }

            /**
             * Sets the value of {@link ContainerHealthCheckProperty#getTimeout}
             * @param timeout The time period (in seconds) to wait for a health check to succeed before counting a failed health check.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(java.lang.Number timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerHealthCheckProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerHealthCheckProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerHealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerHealthCheckProperty {
            private final java.util.List<java.lang.String> command;
            private final java.lang.Number interval;
            private final java.lang.Number retries;
            private final java.lang.Number startPeriod;
            private final java.lang.Number timeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.retries = software.amazon.jsii.Kernel.get(this, "retries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startPeriod = software.amazon.jsii.Kernel.get(this, "startPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.command = java.util.Objects.requireNonNull(builder.command, "command is required");
                this.interval = builder.interval;
                this.retries = builder.retries;
                this.startPeriod = builder.startPeriod;
                this.timeout = builder.timeout;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.Number getRetries() {
                return this.retries;
            }

            @Override
            public final java.lang.Number getStartPeriod() {
                return this.startPeriod;
            }

            @Override
            public final java.lang.Number getTimeout() {
                return this.timeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("command", om.valueToTree(this.getCommand()));
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getRetries() != null) {
                    data.set("retries", om.valueToTree(this.getRetries()));
                }
                if (this.getStartPeriod() != null) {
                    data.set("startPeriod", om.valueToTree(this.getStartPeriod()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerHealthCheckProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerHealthCheckProperty.Jsii$Proxy that = (ContainerHealthCheckProperty.Jsii$Proxy) o;

                if (!command.equals(that.command)) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                if (this.retries != null ? !this.retries.equals(that.retries) : that.retries != null) return false;
                if (this.startPeriod != null ? !this.startPeriod.equals(that.startPeriod) : that.startPeriod != null) return false;
                return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.command.hashCode();
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.retries != null ? this.retries.hashCode() : 0);
                result = 31 * result + (this.startPeriod != null ? this.startPeriod.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A mount point that binds a container to a file or directory on the host system.
     * <p>
     * <em>Part of:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinition.html">GameServerContainerDefinition</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput.html"></a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinition.html">SupportContainerDefinition</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html"></a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ContainerMountPointProperty containerMountPointProperty = ContainerMountPointProperty.builder()
     *         .instancePath("instancePath")
     *         // the properties below are optional
     *         .accessLevel("accessLevel")
     *         .containerPath("containerPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containermountpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containermountpoint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerMountPointProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerMountPointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerMountPointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path to the source file or directory.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containermountpoint.html#cfn-gamelift-containergroupdefinition-containermountpoint-instancepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containermountpoint.html#cfn-gamelift-containergroupdefinition-containermountpoint-instancepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstancePath();

        /**
         * The type of access for the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containermountpoint.html#cfn-gamelift-containergroupdefinition-containermountpoint-accesslevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containermountpoint.html#cfn-gamelift-containergroupdefinition-containermountpoint-accesslevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessLevel() {
            return null;
        }

        /**
         * The mount path on the container.
         * <p>
         * If this property isn't set, the instance path is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containermountpoint.html#cfn-gamelift-containergroupdefinition-containermountpoint-containerpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containermountpoint.html#cfn-gamelift-containergroupdefinition-containermountpoint-containerpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerMountPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerMountPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerMountPointProperty> {
            java.lang.String instancePath;
            java.lang.String accessLevel;
            java.lang.String containerPath;

            /**
             * Sets the value of {@link ContainerMountPointProperty#getInstancePath}
             * @param instancePath The path to the source file or directory. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancePath(java.lang.String instancePath) {
                this.instancePath = instancePath;
                return this;
            }

            /**
             * Sets the value of {@link ContainerMountPointProperty#getAccessLevel}
             * @param accessLevel The type of access for the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessLevel(java.lang.String accessLevel) {
                this.accessLevel = accessLevel;
                return this;
            }

            /**
             * Sets the value of {@link ContainerMountPointProperty#getContainerPath}
             * @param containerPath The mount path on the container.
             *                      If this property isn't set, the instance path is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerMountPointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerMountPointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerMountPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerMountPointProperty {
            private final java.lang.String instancePath;
            private final java.lang.String accessLevel;
            private final java.lang.String containerPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instancePath = software.amazon.jsii.Kernel.get(this, "instancePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessLevel = software.amazon.jsii.Kernel.get(this, "accessLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instancePath = java.util.Objects.requireNonNull(builder.instancePath, "instancePath is required");
                this.accessLevel = builder.accessLevel;
                this.containerPath = builder.containerPath;
            }

            @Override
            public final java.lang.String getInstancePath() {
                return this.instancePath;
            }

            @Override
            public final java.lang.String getAccessLevel() {
                return this.accessLevel;
            }

            @Override
            public final java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instancePath", om.valueToTree(this.getInstancePath()));
                if (this.getAccessLevel() != null) {
                    data.set("accessLevel", om.valueToTree(this.getAccessLevel()));
                }
                if (this.getContainerPath() != null) {
                    data.set("containerPath", om.valueToTree(this.getContainerPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerMountPointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerMountPointProperty.Jsii$Proxy that = (ContainerMountPointProperty.Jsii$Proxy) o;

                if (!instancePath.equals(that.instancePath)) return false;
                if (this.accessLevel != null ? !this.accessLevel.equals(that.accessLevel) : that.accessLevel != null) return false;
                return this.containerPath != null ? this.containerPath.equals(that.containerPath) : that.containerPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instancePath.hashCode();
                result = 31 * result + (this.accessLevel != null ? this.accessLevel.hashCode() : 0);
                result = 31 * result + (this.containerPath != null ? this.containerPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A set of one or more port numbers that can be opened on the container, and the supported network protocol.
     * <p>
     * <em>Part of:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerPortConfiguration.html">ContainerPortConfiguration</a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ContainerPortRangeProperty containerPortRangeProperty = ContainerPortRangeProperty.builder()
     *         .fromPort(123)
     *         .protocol("protocol")
     *         .toPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerPortRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerPortRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerPortRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A starting value for the range of allowed port numbers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-fromport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-fromport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFromPort();

        /**
         * The network protocol that these ports support.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * An ending value for the range of allowed port numbers.
         * <p>
         * Port numbers are end-inclusive. This value must be equal to or greater than <code>FromPort</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-toport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-toport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getToPort();

        /**
         * @return a {@link Builder} of {@link ContainerPortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerPortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerPortRangeProperty> {
            java.lang.Number fromPort;
            java.lang.String protocol;
            java.lang.Number toPort;

            /**
             * Sets the value of {@link ContainerPortRangeProperty#getFromPort}
             * @param fromPort A starting value for the range of allowed port numbers. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPortRangeProperty#getProtocol}
             * @param protocol The network protocol that these ports support. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPortRangeProperty#getToPort}
             * @param toPort An ending value for the range of allowed port numbers. This parameter is required.
             *               Port numbers are end-inclusive. This value must be equal to or greater than <code>FromPort</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerPortRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerPortRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerPortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerPortRangeProperty {
            private final java.lang.Number fromPort;
            private final java.lang.String protocol;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fromPort = java.util.Objects.requireNonNull(builder.fromPort, "fromPort is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
                this.toPort = java.util.Objects.requireNonNull(builder.toPort, "toPort is required");
            }

            @Override
            public final java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fromPort", om.valueToTree(this.getFromPort()));
                data.set("protocol", om.valueToTree(this.getProtocol()));
                data.set("toPort", om.valueToTree(this.getToPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerPortRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerPortRangeProperty.Jsii$Proxy that = (ContainerPortRangeProperty.Jsii$Proxy) o;

                if (!fromPort.equals(that.fromPort)) return false;
                if (!protocol.equals(that.protocol)) return false;
                return this.toPort.equals(that.toPort);
            }

            @Override
            public final int hashCode() {
                int result = this.fromPort.hashCode();
                result = 31 * result + (this.protocol.hashCode());
                result = 31 * result + (this.toPort.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes the game server container in an existing game server container group.
     * <p>
     * A game server container identifies a container image with your game server build. A game server container is automatically considered essential; if an essential container fails, the entire container group restarts.
     * <p>
     * You can update a container definition and deploy the updates to an existing fleet. When creating or updating a game server container group definition, use the property <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput"></a> .
     * <p>
     * <em>Part of:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html">ContainerGroupDefinition</a>
     * <p>
     * <em>Returned by:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeContainerGroupDefinition.html">DescribeContainerGroupDefinition</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListContainerGroupDefinitions.html">ListContainerGroupDefinitions</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html">UpdateContainerGroupDefinition</a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * GameServerContainerDefinitionProperty gameServerContainerDefinitionProperty = GameServerContainerDefinitionProperty.builder()
     *         .containerName("containerName")
     *         .imageUri("imageUri")
     *         .serverSdkVersion("serverSdkVersion")
     *         // the properties below are optional
     *         .dependsOn(List.of(ContainerDependencyProperty.builder()
     *                 .condition("condition")
     *                 .containerName("containerName")
     *                 .build()))
     *         .environmentOverride(List.of(ContainerEnvironmentProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .mountPoints(List.of(ContainerMountPointProperty.builder()
     *                 .instancePath("instancePath")
     *                 // the properties below are optional
     *                 .accessLevel("accessLevel")
     *                 .containerPath("containerPath")
     *                 .build()))
     *         .portConfiguration(PortConfigurationProperty.builder()
     *                 .containerPortRanges(List.of(ContainerPortRangeProperty.builder()
     *                         .fromPort(123)
     *                         .protocol("protocol")
     *                         .toPort(123)
     *                         .build()))
     *                 .build())
     *         .resolvedImageDigest("resolvedImageDigest")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.GameServerContainerDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(GameServerContainerDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GameServerContainerDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The container definition identifier.
         * <p>
         * Container names are unique within a container group definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-containername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContainerName();

        /**
         * The URI to the image that Amazon GameLift Servers uses when deploying this container to a container fleet.
         * <p>
         * For a more specific identifier, see <code>ResolvedImageDigest</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-imageuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-imageuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageUri();

        /**
         * The Amazon GameLift Servers server SDK version that the game server is integrated with.
         * <p>
         * Only game servers using 5.2.0 or higher are compatible with container fleets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-serversdkversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-serversdkversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServerSdkVersion();

        /**
         * Indicates that the container relies on the status of other containers in the same container group during startup and shutdown sequences.
         * <p>
         * A container might have dependencies on multiple containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-dependson">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-dependson</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDependsOn() {
            return null;
        }

        /**
         * A set of environment variables that's passed to the container on startup.
         * <p>
         * See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-environment">ContainerDefinition::environment</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-environmentoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-environmentoverride</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentOverride() {
            return null;
        }

        /**
         * A mount point that binds a path inside the container to a file or directory on the host system and lets it access the file or directory.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-mountpoints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-mountpoints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMountPoints() {
            return null;
        }

        /**
         * The set of ports that are available to bind to processes in the container.
         * <p>
         * For example, a game server process requires a container port to allow game clients to connect to it. Container ports aren't directly accessed by inbound traffic. Amazon GameLift Servers maps these container ports to externally accessible connection ports, which are assigned as needed from the container fleet's <code>ConnectionPortRange</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-portconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-portconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPortConfiguration() {
            return null;
        }

        /**
         * A unique and immutable identifier for the container image.
         * <p>
         * The digest is a SHA 256 hash of the container image manifest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-resolvedimagedigest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-gameservercontainerdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition-resolvedimagedigest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResolvedImageDigest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GameServerContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GameServerContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GameServerContainerDefinitionProperty> {
            java.lang.String containerName;
            java.lang.String imageUri;
            java.lang.String serverSdkVersion;
            java.lang.Object dependsOn;
            java.lang.Object environmentOverride;
            java.lang.Object mountPoints;
            java.lang.Object portConfiguration;
            java.lang.String resolvedImageDigest;

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getContainerName}
             * @param containerName The container definition identifier. This parameter is required.
             *                      Container names are unique within a container group definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getImageUri}
             * @param imageUri The URI to the image that Amazon GameLift Servers uses when deploying this container to a container fleet. This parameter is required.
             *                 For a more specific identifier, see <code>ResolvedImageDigest</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUri(java.lang.String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getServerSdkVersion}
             * @param serverSdkVersion The Amazon GameLift Servers server SDK version that the game server is integrated with. This parameter is required.
             *                         Only game servers using 5.2.0 or higher are compatible with container fleets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSdkVersion(java.lang.String serverSdkVersion) {
                this.serverSdkVersion = serverSdkVersion;
                return this;
            }

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getDependsOn}
             * @param dependsOn Indicates that the container relies on the status of other containers in the same container group during startup and shutdown sequences.
             *                  A container might have dependencies on multiple containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(software.amazon.awscdk.IResolvable dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getDependsOn}
             * @param dependsOn Indicates that the container relies on the status of other containers in the same container group during startup and shutdown sequences.
             *                  A container might have dependencies on multiple containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(java.util.List<? extends java.lang.Object> dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getEnvironmentOverride}
             * @param environmentOverride A set of environment variables that's passed to the container on startup.
             *                            See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-environment">ContainerDefinition::environment</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentOverride(software.amazon.awscdk.IResolvable environmentOverride) {
                this.environmentOverride = environmentOverride;
                return this;
            }

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getEnvironmentOverride}
             * @param environmentOverride A set of environment variables that's passed to the container on startup.
             *                            See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-environment">ContainerDefinition::environment</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentOverride(java.util.List<? extends java.lang.Object> environmentOverride) {
                this.environmentOverride = environmentOverride;
                return this;
            }

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getMountPoints}
             * @param mountPoints A mount point that binds a path inside the container to a file or directory on the host system and lets it access the file or directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(software.amazon.awscdk.IResolvable mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getMountPoints}
             * @param mountPoints A mount point that binds a path inside the container to a file or directory on the host system and lets it access the file or directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(java.util.List<? extends java.lang.Object> mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getPortConfiguration}
             * @param portConfiguration The set of ports that are available to bind to processes in the container.
             *                          For example, a game server process requires a container port to allow game clients to connect to it. Container ports aren't directly accessed by inbound traffic. Amazon GameLift Servers maps these container ports to externally accessible connection ports, which are assigned as needed from the container fleet's <code>ConnectionPortRange</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portConfiguration(software.amazon.awscdk.IResolvable portConfiguration) {
                this.portConfiguration = portConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getPortConfiguration}
             * @param portConfiguration The set of ports that are available to bind to processes in the container.
             *                          For example, a game server process requires a container port to allow game clients to connect to it. Container ports aren't directly accessed by inbound traffic. Amazon GameLift Servers maps these container ports to externally accessible connection ports, which are assigned as needed from the container fleet's <code>ConnectionPortRange</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portConfiguration(software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.PortConfigurationProperty portConfiguration) {
                this.portConfiguration = portConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link GameServerContainerDefinitionProperty#getResolvedImageDigest}
             * @param resolvedImageDigest A unique and immutable identifier for the container image.
             *                            The digest is a SHA 256 hash of the container image manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resolvedImageDigest(java.lang.String resolvedImageDigest) {
                this.resolvedImageDigest = resolvedImageDigest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GameServerContainerDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GameServerContainerDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GameServerContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GameServerContainerDefinitionProperty {
            private final java.lang.String containerName;
            private final java.lang.String imageUri;
            private final java.lang.String serverSdkVersion;
            private final java.lang.Object dependsOn;
            private final java.lang.Object environmentOverride;
            private final java.lang.Object mountPoints;
            private final java.lang.Object portConfiguration;
            private final java.lang.String resolvedImageDigest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageUri = software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverSdkVersion = software.amazon.jsii.Kernel.get(this, "serverSdkVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environmentOverride = software.amazon.jsii.Kernel.get(this, "environmentOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mountPoints = software.amazon.jsii.Kernel.get(this, "mountPoints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.portConfiguration = software.amazon.jsii.Kernel.get(this, "portConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resolvedImageDigest = software.amazon.jsii.Kernel.get(this, "resolvedImageDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerName = java.util.Objects.requireNonNull(builder.containerName, "containerName is required");
                this.imageUri = java.util.Objects.requireNonNull(builder.imageUri, "imageUri is required");
                this.serverSdkVersion = java.util.Objects.requireNonNull(builder.serverSdkVersion, "serverSdkVersion is required");
                this.dependsOn = builder.dependsOn;
                this.environmentOverride = builder.environmentOverride;
                this.mountPoints = builder.mountPoints;
                this.portConfiguration = builder.portConfiguration;
                this.resolvedImageDigest = builder.resolvedImageDigest;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public final java.lang.String getImageUri() {
                return this.imageUri;
            }

            @Override
            public final java.lang.String getServerSdkVersion() {
                return this.serverSdkVersion;
            }

            @Override
            public final java.lang.Object getDependsOn() {
                return this.dependsOn;
            }

            @Override
            public final java.lang.Object getEnvironmentOverride() {
                return this.environmentOverride;
            }

            @Override
            public final java.lang.Object getMountPoints() {
                return this.mountPoints;
            }

            @Override
            public final java.lang.Object getPortConfiguration() {
                return this.portConfiguration;
            }

            @Override
            public final java.lang.String getResolvedImageDigest() {
                return this.resolvedImageDigest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containerName", om.valueToTree(this.getContainerName()));
                data.set("imageUri", om.valueToTree(this.getImageUri()));
                data.set("serverSdkVersion", om.valueToTree(this.getServerSdkVersion()));
                if (this.getDependsOn() != null) {
                    data.set("dependsOn", om.valueToTree(this.getDependsOn()));
                }
                if (this.getEnvironmentOverride() != null) {
                    data.set("environmentOverride", om.valueToTree(this.getEnvironmentOverride()));
                }
                if (this.getMountPoints() != null) {
                    data.set("mountPoints", om.valueToTree(this.getMountPoints()));
                }
                if (this.getPortConfiguration() != null) {
                    data.set("portConfiguration", om.valueToTree(this.getPortConfiguration()));
                }
                if (this.getResolvedImageDigest() != null) {
                    data.set("resolvedImageDigest", om.valueToTree(this.getResolvedImageDigest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.GameServerContainerDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GameServerContainerDefinitionProperty.Jsii$Proxy that = (GameServerContainerDefinitionProperty.Jsii$Proxy) o;

                if (!containerName.equals(that.containerName)) return false;
                if (!imageUri.equals(that.imageUri)) return false;
                if (!serverSdkVersion.equals(that.serverSdkVersion)) return false;
                if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
                if (this.environmentOverride != null ? !this.environmentOverride.equals(that.environmentOverride) : that.environmentOverride != null) return false;
                if (this.mountPoints != null ? !this.mountPoints.equals(that.mountPoints) : that.mountPoints != null) return false;
                if (this.portConfiguration != null ? !this.portConfiguration.equals(that.portConfiguration) : that.portConfiguration != null) return false;
                return this.resolvedImageDigest != null ? this.resolvedImageDigest.equals(that.resolvedImageDigest) : that.resolvedImageDigest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerName.hashCode();
                result = 31 * result + (this.imageUri.hashCode());
                result = 31 * result + (this.serverSdkVersion.hashCode());
                result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
                result = 31 * result + (this.environmentOverride != null ? this.environmentOverride.hashCode() : 0);
                result = 31 * result + (this.mountPoints != null ? this.mountPoints.hashCode() : 0);
                result = 31 * result + (this.portConfiguration != null ? this.portConfiguration.hashCode() : 0);
                result = 31 * result + (this.resolvedImageDigest != null ? this.resolvedImageDigest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the ports on a container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * PortConfigurationProperty portConfigurationProperty = PortConfigurationProperty.builder()
     *         .containerPortRanges(List.of(ContainerPortRangeProperty.builder()
     *                 .fromPort(123)
     *                 .protocol("protocol")
     *                 .toPort(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-portconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-portconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.PortConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PortConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PortConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies one or more ranges of ports on a container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-portconfiguration.html#cfn-gamelift-containergroupdefinition-portconfiguration-containerportranges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-portconfiguration.html#cfn-gamelift-containergroupdefinition-portconfiguration-containerportranges</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getContainerPortRanges();

        /**
         * @return a {@link Builder} of {@link PortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PortConfigurationProperty> {
            java.lang.Object containerPortRanges;

            /**
             * Sets the value of {@link PortConfigurationProperty#getContainerPortRanges}
             * @param containerPortRanges Specifies one or more ranges of ports on a container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPortRanges(software.amazon.awscdk.IResolvable containerPortRanges) {
                this.containerPortRanges = containerPortRanges;
                return this;
            }

            /**
             * Sets the value of {@link PortConfigurationProperty#getContainerPortRanges}
             * @param containerPortRanges Specifies one or more ranges of ports on a container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPortRanges(java.util.List<? extends java.lang.Object> containerPortRanges) {
                this.containerPortRanges = containerPortRanges;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PortConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortConfigurationProperty {
            private final java.lang.Object containerPortRanges;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPortRanges = software.amazon.jsii.Kernel.get(this, "containerPortRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPortRanges = java.util.Objects.requireNonNull(builder.containerPortRanges, "containerPortRanges is required");
            }

            @Override
            public final java.lang.Object getContainerPortRanges() {
                return this.containerPortRanges;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containerPortRanges", om.valueToTree(this.getContainerPortRanges()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.PortConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PortConfigurationProperty.Jsii$Proxy that = (PortConfigurationProperty.Jsii$Proxy) o;

                return this.containerPortRanges.equals(that.containerPortRanges);
            }

            @Override
            public final int hashCode() {
                int result = this.containerPortRanges.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes a support container in a container group.
     * <p>
     * A support container might be in a game server container group or a per-instance container group. Support containers don't run game server processes.
     * <p>
     * You can update a support container definition and deploy the updates to an existing fleet. When creating or updating a game server container group definition, use the property <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput.html">GameServerContainerDefinitionInput</a> .
     * <p>
     * <em>Part of:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html">ContainerGroupDefinition</a>
     * <p>
     * <em>Returned by:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeContainerGroupDefinition.html">DescribeContainerGroupDefinition</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListContainerGroupDefinitions.html">ListContainerGroupDefinitions</a> , <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html">UpdateContainerGroupDefinition</a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * SupportContainerDefinitionProperty supportContainerDefinitionProperty = SupportContainerDefinitionProperty.builder()
     *         .containerName("containerName")
     *         .imageUri("imageUri")
     *         // the properties below are optional
     *         .dependsOn(List.of(ContainerDependencyProperty.builder()
     *                 .condition("condition")
     *                 .containerName("containerName")
     *                 .build()))
     *         .environmentOverride(List.of(ContainerEnvironmentProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .essential(false)
     *         .healthCheck(ContainerHealthCheckProperty.builder()
     *                 .command(List.of("command"))
     *                 // the properties below are optional
     *                 .interval(123)
     *                 .retries(123)
     *                 .startPeriod(123)
     *                 .timeout(123)
     *                 .build())
     *         .memoryHardLimitMebibytes(123)
     *         .mountPoints(List.of(ContainerMountPointProperty.builder()
     *                 .instancePath("instancePath")
     *                 // the properties below are optional
     *                 .accessLevel("accessLevel")
     *                 .containerPath("containerPath")
     *                 .build()))
     *         .portConfiguration(PortConfigurationProperty.builder()
     *                 .containerPortRanges(List.of(ContainerPortRangeProperty.builder()
     *                         .fromPort(123)
     *                         .protocol("protocol")
     *                         .toPort(123)
     *                         .build()))
     *                 .build())
     *         .resolvedImageDigest("resolvedImageDigest")
     *         .vcpu(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.SupportContainerDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(SupportContainerDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SupportContainerDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The container definition identifier.
         * <p>
         * Container names are unique within a container group definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-containername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContainerName();

        /**
         * The URI to the image that Amazon GameLift Servers deploys to a container fleet.
         * <p>
         * For a more specific identifier, see <code>ResolvedImageDigest</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-imageuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-imageuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageUri();

        /**
         * Indicates that the container relies on the status of other containers in the same container group during its startup and shutdown sequences.
         * <p>
         * A container might have dependencies on multiple containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-dependson">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-dependson</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDependsOn() {
            return null;
        }

        /**
         * A set of environment variables that's passed to the container on startup.
         * <p>
         * See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-environment">ContainerDefinition::environment</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-environmentoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-environmentoverride</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentOverride() {
            return null;
        }

        /**
         * Indicates whether the container is vital to the container group.
         * <p>
         * If an essential container fails, the entire container group restarts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-essential">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-essential</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEssential() {
            return null;
        }

        /**
         * A configuration for a non-terminal health check.
         * <p>
         * A support container automatically restarts if it stops functioning or if it fails this health check.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-healthcheck">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-healthcheck</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheck() {
            return null;
        }

        /**
         * The amount of memory that Amazon GameLift Servers makes available to the container.
         * <p>
         * If memory limits aren't set for an individual container, the container shares the container group's total memory allocation.
         * <p>
         * <em>Related data type:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html">ContainerGroupDefinition TotalMemoryLimitMebibytes</a>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-memoryhardlimitmebibytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-memoryhardlimitmebibytes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryHardLimitMebibytes() {
            return null;
        }

        /**
         * A mount point that binds a path inside the container to a file or directory on the host system and lets it access the file or directory.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-mountpoints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-mountpoints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMountPoints() {
            return null;
        }

        /**
         * A set of ports that allow access to the container from external users.
         * <p>
         * Processes running in the container can bind to a one of these ports. Container ports aren't directly accessed by inbound traffic. Amazon GameLift Servers maps these container ports to externally accessible connection ports, which are assigned as needed from the container fleet's <code>ConnectionPortRange</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-portconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-portconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPortConfiguration() {
            return null;
        }

        /**
         * A unique and immutable identifier for the container image.
         * <p>
         * The digest is a SHA 256 hash of the container image manifest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-resolvedimagedigest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-resolvedimagedigest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResolvedImageDigest() {
            return null;
        }

        /**
         * The number of vCPU units that are reserved for the container.
         * <p>
         * If no resources are reserved, the container shares the total vCPU limit for the container group.
         * <p>
         * <em>Related data type:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html">ContainerGroupDefinition TotalVcpuLimit</a>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-vcpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-supportcontainerdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinition-vcpu</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVcpu() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SupportContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SupportContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SupportContainerDefinitionProperty> {
            java.lang.String containerName;
            java.lang.String imageUri;
            java.lang.Object dependsOn;
            java.lang.Object environmentOverride;
            java.lang.Object essential;
            java.lang.Object healthCheck;
            java.lang.Number memoryHardLimitMebibytes;
            java.lang.Object mountPoints;
            java.lang.Object portConfiguration;
            java.lang.String resolvedImageDigest;
            java.lang.Number vcpu;

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getContainerName}
             * @param containerName The container definition identifier. This parameter is required.
             *                      Container names are unique within a container group definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getImageUri}
             * @param imageUri The URI to the image that Amazon GameLift Servers deploys to a container fleet. This parameter is required.
             *                 For a more specific identifier, see <code>ResolvedImageDigest</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUri(java.lang.String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getDependsOn}
             * @param dependsOn Indicates that the container relies on the status of other containers in the same container group during its startup and shutdown sequences.
             *                  A container might have dependencies on multiple containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(software.amazon.awscdk.IResolvable dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getDependsOn}
             * @param dependsOn Indicates that the container relies on the status of other containers in the same container group during its startup and shutdown sequences.
             *                  A container might have dependencies on multiple containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(java.util.List<? extends java.lang.Object> dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getEnvironmentOverride}
             * @param environmentOverride A set of environment variables that's passed to the container on startup.
             *                            See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-environment">ContainerDefinition::environment</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentOverride(software.amazon.awscdk.IResolvable environmentOverride) {
                this.environmentOverride = environmentOverride;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getEnvironmentOverride}
             * @param environmentOverride A set of environment variables that's passed to the container on startup.
             *                            See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-environment">ContainerDefinition::environment</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentOverride(java.util.List<? extends java.lang.Object> environmentOverride) {
                this.environmentOverride = environmentOverride;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getEssential}
             * @param essential Indicates whether the container is vital to the container group.
             *                  If an essential container fails, the entire container group restarts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder essential(java.lang.Boolean essential) {
                this.essential = essential;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getEssential}
             * @param essential Indicates whether the container is vital to the container group.
             *                  If an essential container fails, the entire container group restarts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder essential(software.amazon.awscdk.IResolvable essential) {
                this.essential = essential;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getHealthCheck}
             * @param healthCheck A configuration for a non-terminal health check.
             *                    A support container automatically restarts if it stops functioning or if it fails this health check.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheck(software.amazon.awscdk.IResolvable healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getHealthCheck}
             * @param healthCheck A configuration for a non-terminal health check.
             *                    A support container automatically restarts if it stops functioning or if it fails this health check.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheck(software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.ContainerHealthCheckProperty healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getMemoryHardLimitMebibytes}
             * @param memoryHardLimitMebibytes The amount of memory that Amazon GameLift Servers makes available to the container.
             *                                 If memory limits aren't set for an individual container, the container shares the container group's total memory allocation.
             *                                 <p>
             *                                 <em>Related data type:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html">ContainerGroupDefinition TotalMemoryLimitMebibytes</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryHardLimitMebibytes(java.lang.Number memoryHardLimitMebibytes) {
                this.memoryHardLimitMebibytes = memoryHardLimitMebibytes;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getMountPoints}
             * @param mountPoints A mount point that binds a path inside the container to a file or directory on the host system and lets it access the file or directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(software.amazon.awscdk.IResolvable mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getMountPoints}
             * @param mountPoints A mount point that binds a path inside the container to a file or directory on the host system and lets it access the file or directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(java.util.List<? extends java.lang.Object> mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getPortConfiguration}
             * @param portConfiguration A set of ports that allow access to the container from external users.
             *                          Processes running in the container can bind to a one of these ports. Container ports aren't directly accessed by inbound traffic. Amazon GameLift Servers maps these container ports to externally accessible connection ports, which are assigned as needed from the container fleet's <code>ConnectionPortRange</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portConfiguration(software.amazon.awscdk.IResolvable portConfiguration) {
                this.portConfiguration = portConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getPortConfiguration}
             * @param portConfiguration A set of ports that allow access to the container from external users.
             *                          Processes running in the container can bind to a one of these ports. Container ports aren't directly accessed by inbound traffic. Amazon GameLift Servers maps these container ports to externally accessible connection ports, which are assigned as needed from the container fleet's <code>ConnectionPortRange</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portConfiguration(software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.PortConfigurationProperty portConfiguration) {
                this.portConfiguration = portConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getResolvedImageDigest}
             * @param resolvedImageDigest A unique and immutable identifier for the container image.
             *                            The digest is a SHA 256 hash of the container image manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resolvedImageDigest(java.lang.String resolvedImageDigest) {
                this.resolvedImageDigest = resolvedImageDigest;
                return this;
            }

            /**
             * Sets the value of {@link SupportContainerDefinitionProperty#getVcpu}
             * @param vcpu The number of vCPU units that are reserved for the container.
             *             If no resources are reserved, the container shares the total vCPU limit for the container group.
             *             <p>
             *             <em>Related data type:</em> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html">ContainerGroupDefinition TotalVcpuLimit</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vcpu(java.lang.Number vcpu) {
                this.vcpu = vcpu;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SupportContainerDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SupportContainerDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SupportContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SupportContainerDefinitionProperty {
            private final java.lang.String containerName;
            private final java.lang.String imageUri;
            private final java.lang.Object dependsOn;
            private final java.lang.Object environmentOverride;
            private final java.lang.Object essential;
            private final java.lang.Object healthCheck;
            private final java.lang.Number memoryHardLimitMebibytes;
            private final java.lang.Object mountPoints;
            private final java.lang.Object portConfiguration;
            private final java.lang.String resolvedImageDigest;
            private final java.lang.Number vcpu;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageUri = software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environmentOverride = software.amazon.jsii.Kernel.get(this, "environmentOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.essential = software.amazon.jsii.Kernel.get(this, "essential", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memoryHardLimitMebibytes = software.amazon.jsii.Kernel.get(this, "memoryHardLimitMebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mountPoints = software.amazon.jsii.Kernel.get(this, "mountPoints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.portConfiguration = software.amazon.jsii.Kernel.get(this, "portConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resolvedImageDigest = software.amazon.jsii.Kernel.get(this, "resolvedImageDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vcpu = software.amazon.jsii.Kernel.get(this, "vcpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerName = java.util.Objects.requireNonNull(builder.containerName, "containerName is required");
                this.imageUri = java.util.Objects.requireNonNull(builder.imageUri, "imageUri is required");
                this.dependsOn = builder.dependsOn;
                this.environmentOverride = builder.environmentOverride;
                this.essential = builder.essential;
                this.healthCheck = builder.healthCheck;
                this.memoryHardLimitMebibytes = builder.memoryHardLimitMebibytes;
                this.mountPoints = builder.mountPoints;
                this.portConfiguration = builder.portConfiguration;
                this.resolvedImageDigest = builder.resolvedImageDigest;
                this.vcpu = builder.vcpu;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public final java.lang.String getImageUri() {
                return this.imageUri;
            }

            @Override
            public final java.lang.Object getDependsOn() {
                return this.dependsOn;
            }

            @Override
            public final java.lang.Object getEnvironmentOverride() {
                return this.environmentOverride;
            }

            @Override
            public final java.lang.Object getEssential() {
                return this.essential;
            }

            @Override
            public final java.lang.Object getHealthCheck() {
                return this.healthCheck;
            }

            @Override
            public final java.lang.Number getMemoryHardLimitMebibytes() {
                return this.memoryHardLimitMebibytes;
            }

            @Override
            public final java.lang.Object getMountPoints() {
                return this.mountPoints;
            }

            @Override
            public final java.lang.Object getPortConfiguration() {
                return this.portConfiguration;
            }

            @Override
            public final java.lang.String getResolvedImageDigest() {
                return this.resolvedImageDigest;
            }

            @Override
            public final java.lang.Number getVcpu() {
                return this.vcpu;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containerName", om.valueToTree(this.getContainerName()));
                data.set("imageUri", om.valueToTree(this.getImageUri()));
                if (this.getDependsOn() != null) {
                    data.set("dependsOn", om.valueToTree(this.getDependsOn()));
                }
                if (this.getEnvironmentOverride() != null) {
                    data.set("environmentOverride", om.valueToTree(this.getEnvironmentOverride()));
                }
                if (this.getEssential() != null) {
                    data.set("essential", om.valueToTree(this.getEssential()));
                }
                if (this.getHealthCheck() != null) {
                    data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
                }
                if (this.getMemoryHardLimitMebibytes() != null) {
                    data.set("memoryHardLimitMebibytes", om.valueToTree(this.getMemoryHardLimitMebibytes()));
                }
                if (this.getMountPoints() != null) {
                    data.set("mountPoints", om.valueToTree(this.getMountPoints()));
                }
                if (this.getPortConfiguration() != null) {
                    data.set("portConfiguration", om.valueToTree(this.getPortConfiguration()));
                }
                if (this.getResolvedImageDigest() != null) {
                    data.set("resolvedImageDigest", om.valueToTree(this.getResolvedImageDigest()));
                }
                if (this.getVcpu() != null) {
                    data.set("vcpu", om.valueToTree(this.getVcpu()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.SupportContainerDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SupportContainerDefinitionProperty.Jsii$Proxy that = (SupportContainerDefinitionProperty.Jsii$Proxy) o;

                if (!containerName.equals(that.containerName)) return false;
                if (!imageUri.equals(that.imageUri)) return false;
                if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
                if (this.environmentOverride != null ? !this.environmentOverride.equals(that.environmentOverride) : that.environmentOverride != null) return false;
                if (this.essential != null ? !this.essential.equals(that.essential) : that.essential != null) return false;
                if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
                if (this.memoryHardLimitMebibytes != null ? !this.memoryHardLimitMebibytes.equals(that.memoryHardLimitMebibytes) : that.memoryHardLimitMebibytes != null) return false;
                if (this.mountPoints != null ? !this.mountPoints.equals(that.mountPoints) : that.mountPoints != null) return false;
                if (this.portConfiguration != null ? !this.portConfiguration.equals(that.portConfiguration) : that.portConfiguration != null) return false;
                if (this.resolvedImageDigest != null ? !this.resolvedImageDigest.equals(that.resolvedImageDigest) : that.resolvedImageDigest != null) return false;
                return this.vcpu != null ? this.vcpu.equals(that.vcpu) : that.vcpu == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerName.hashCode();
                result = 31 * result + (this.imageUri.hashCode());
                result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
                result = 31 * result + (this.environmentOverride != null ? this.environmentOverride.hashCode() : 0);
                result = 31 * result + (this.essential != null ? this.essential.hashCode() : 0);
                result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
                result = 31 * result + (this.memoryHardLimitMebibytes != null ? this.memoryHardLimitMebibytes.hashCode() : 0);
                result = 31 * result + (this.mountPoints != null ? this.mountPoints.hashCode() : 0);
                result = 31 * result + (this.portConfiguration != null ? this.portConfiguration.hashCode() : 0);
                result = 31 * result + (this.resolvedImageDigest != null ? this.resolvedImageDigest.hashCode() : 0);
                result = 31 * result + (this.vcpu != null ? this.vcpu.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinitionProps.Builder();
        }

        /**
         * A descriptive identifier for the container group definition.
         * <p>
         * The name value is unique in an AWS Region.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-name</a>
         * @param name A descriptive identifier for the container group definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The platform that all containers in the container group definition run on.
         * <p>
         * <blockquote>
         * <p>
         * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a href="https://docs.aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a> . For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">Migrate to server SDK version 5.</a>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-operatingsystem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-operatingsystem</a>
         * @param operatingSystem The platform that all containers in the container group definition run on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatingSystem(final java.lang.String operatingSystem) {
            this.props.operatingSystem(operatingSystem);
            return this;
        }

        /**
         * The amount of memory (in MiB) on a fleet instance to allocate for the container group.
         * <p>
         * All containers in the group share these resources.
         * <p>
         * You can set a limit for each container definition in the group. If individual containers have limits, this total value must be greater than any individual container's memory limit.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalmemorylimitmebibytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalmemorylimitmebibytes</a>
         * @param totalMemoryLimitMebibytes The amount of memory (in MiB) on a fleet instance to allocate for the container group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalMemoryLimitMebibytes(final java.lang.Number totalMemoryLimitMebibytes) {
            this.props.totalMemoryLimitMebibytes(totalMemoryLimitMebibytes);
            return this;
        }

        /**
         * The amount of vCPU units on a fleet instance to allocate for the container group (1 vCPU is equal to 1024 CPU units).
         * <p>
         * All containers in the group share these resources. You can set a limit for each container definition in the group. If individual containers have limits, this total value must be equal to or greater than the sum of the limits for each container in the group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalvcpulimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalvcpulimit</a>
         * @param totalVcpuLimit The amount of vCPU units on a fleet instance to allocate for the container group (1 vCPU is equal to 1024 CPU units). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalVcpuLimit(final java.lang.Number totalVcpuLimit) {
            this.props.totalVcpuLimit(totalVcpuLimit);
            return this;
        }

        /**
         * The type of container group.
         * <p>
         * Container group type determines how Amazon GameLift Servers deploys the container group on each fleet instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-containergrouptype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-containergrouptype</a>
         * @param containerGroupType The type of container group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerGroupType(final java.lang.String containerGroupType) {
            this.props.containerGroupType(containerGroupType);
            return this;
        }

        /**
         * The definition for the game server container in this group.
         * <p>
         * This property is used only when the container group type is <code>GAME_SERVER</code> . This container definition specifies a container image with the game server build.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition</a>
         * @param gameServerContainerDefinition The definition for the game server container in this group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameServerContainerDefinition(final software.amazon.awscdk.IResolvable gameServerContainerDefinition) {
            this.props.gameServerContainerDefinition(gameServerContainerDefinition);
            return this;
        }
        /**
         * The definition for the game server container in this group.
         * <p>
         * This property is used only when the container group type is <code>GAME_SERVER</code> . This container definition specifies a container image with the game server build.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition</a>
         * @param gameServerContainerDefinition The definition for the game server container in this group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameServerContainerDefinition(final software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.GameServerContainerDefinitionProperty gameServerContainerDefinition) {
            this.props.gameServerContainerDefinition(gameServerContainerDefinition);
            return this;
        }

        /**
         * A specific ContainerGroupDefinition version to be updated.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-sourceversionnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-sourceversionnumber</a>
         * @param sourceVersionNumber A specific ContainerGroupDefinition version to be updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceVersionNumber(final java.lang.Number sourceVersionNumber) {
            this.props.sourceVersionNumber(sourceVersionNumber);
            return this;
        }

        /**
         * The set of definitions for support containers in this group.
         * <p>
         * A container group definition might have zero support container definitions. Support container can be used in any type of container group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinitions</a>
         * @param supportContainerDefinitions The set of definitions for support containers in this group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportContainerDefinitions(final software.amazon.awscdk.IResolvable supportContainerDefinitions) {
            this.props.supportContainerDefinitions(supportContainerDefinitions);
            return this;
        }
        /**
         * The set of definitions for support containers in this group.
         * <p>
         * A container group definition might have zero support container definitions. Support container can be used in any type of container group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinitions</a>
         * @param supportContainerDefinitions The set of definitions for support containers in this group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportContainerDefinitions(final java.util.List<? extends java.lang.Object> supportContainerDefinitions) {
            this.props.supportContainerDefinitions(supportContainerDefinitions);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * An optional description that was provided for a container group definition update.
         * <p>
         * Each version can have a unique description.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-versiondescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-versiondescription</a>
         * @param versionDescription An optional description that was provided for a container group definition update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(final java.lang.String versionDescription) {
            this.props.versionDescription(versionDescription);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition build() {
            return new software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
