package software.amazon.awscdk.services.gamelift;

/**
 * Properties for defining a <code>CfnMatchmakingConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnMatchmakingConfigurationProps cfnMatchmakingConfigurationProps = CfnMatchmakingConfigurationProps.builder()
 *         .acceptanceRequired(false)
 *         .name("name")
 *         .requestTimeoutSeconds(123)
 *         .ruleSetName("ruleSetName")
 *         // the properties below are optional
 *         .acceptanceTimeoutSeconds(123)
 *         .additionalPlayerCount(123)
 *         .backfillMode("backfillMode")
 *         .creationTime("creationTime")
 *         .customEventData("customEventData")
 *         .description("description")
 *         .flexMatchMode("flexMatchMode")
 *         .gameProperties(List.of(GamePropertyProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .gameSessionData("gameSessionData")
 *         .gameSessionQueueArns(List.of("gameSessionQueueArns"))
 *         .notificationTarget("notificationTarget")
 *         .ruleSetArn("ruleSetArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:15.075Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnMatchmakingConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnMatchmakingConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMatchmakingConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A flag that determines whether a match that was created with this configuration must be accepted by the matched players.
     * <p>
     * To require acceptance, set to <code>TRUE</code> . With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-acceptancerequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-acceptancerequired</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAcceptanceRequired();

    /**
     * A unique identifier for the matchmaking configuration.
     * <p>
     * This name is used to identify the configuration associated with a matchmaking request or ticket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
     * <p>
     * Requests that fail due to timing out can be resubmitted as needed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-requesttimeoutseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-requesttimeoutseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getRequestTimeoutSeconds();

    /**
     * A unique identifier for the matchmaking rule set to use with this configuration.
     * <p>
     * You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-rulesetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-rulesetname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleSetName();

    /**
     * The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-acceptancetimeoutseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-acceptancetimeoutseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAcceptanceTimeoutSeconds() {
        return null;
    }

    /**
     * The number of player slots in a match to keep open for future players.
     * <p>
     * For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-additionalplayercount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-additionalplayercount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAdditionalPlayerCount() {
        return null;
    }

    /**
     * The method used to backfill game sessions that are created with this matchmaking configuration.
     * <p>
     * Specify <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill feature. Specify <code>AUTOMATIC</code> to have GameLift create a <code>StartMatchBackfill</code> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill Existing Games with FlexMatch</a> . Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-backfillmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-backfillmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBackfillMode() {
        return null;
    }

    /**
     * A time stamp indicating when this data object was created.
     * <p>
     * Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-creationtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-creationtime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCreationTime() {
        return null;
    }

    /**
     * Information to add to all events related to the matchmaking configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-customeventdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-customeventdata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomEventData() {
        return null;
    }

    /**
     * A description for the matchmaking configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Indicates whether this matchmaking configuration is being used with Amazon GameLift Servers hosting or as a standalone matchmaking solution.
     * <p>
     * <ul>
     * <li><em>STANDALONE</em> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded">MatchmakingSucceeded</a> event.</li>
     * <li><em>WITH_QUEUE</em> - FlexMatch forms matches and uses the specified Amazon GameLift Servers queue to start a game session for the match.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-flexmatchmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-flexmatchmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFlexMatchMode() {
        return null;
    }

    /**
     * A set of custom properties for a game session, formatted as key-value pairs.
     * <p>
     * These properties are passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gameproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gameproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGameProperties() {
        return null;
    }

    /**
     * A set of custom game session properties, formatted as a single string value.
     * <p>
     * This data is passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gamesessiondata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gamesessiondata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGameSessionData() {
        return null;
    }

    /**
     * The Amazon Resource Name ( <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a> ) that is assigned to a Amazon GameLift Servers game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code> . Queues can be located in any Region. Queues are used to start new Amazon GameLift Servers-hosted game sessions for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code> , do not set this parameter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gamesessionqueuearns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gamesessionqueuearns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGameSessionQueueArns() {
        return null;
    }

    /**
     * An SNS topic ARN that is set up to receive matchmaking notifications.
     * <p>
     * See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html">Setting up notifications for matchmaking</a> for more information.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-notificationtarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-notificationtarget</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNotificationTarget() {
        return null;
    }

    /**
     * The Amazon Resource Name ( <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a> ) associated with the GameLift matchmaking rule set resource that this configuration uses.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-rulesetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-rulesetarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuleSetArn() {
        return null;
    }

    /**
     * A list of labels to assign to the new matchmaking configuration resource.
     * <p>
     * Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in the <em>AWS General Reference</em> . Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMatchmakingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMatchmakingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMatchmakingConfigurationProps> {
        java.lang.Object acceptanceRequired;
        java.lang.String name;
        java.lang.Number requestTimeoutSeconds;
        java.lang.String ruleSetName;
        java.lang.Number acceptanceTimeoutSeconds;
        java.lang.Number additionalPlayerCount;
        java.lang.String backfillMode;
        java.lang.String creationTime;
        java.lang.String customEventData;
        java.lang.String description;
        java.lang.String flexMatchMode;
        java.lang.Object gameProperties;
        java.lang.String gameSessionData;
        java.util.List<java.lang.String> gameSessionQueueArns;
        java.lang.String notificationTarget;
        java.lang.String ruleSetArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getAcceptanceRequired}
         * @param acceptanceRequired A flag that determines whether a match that was created with this configuration must be accepted by the matched players. This parameter is required.
         *                           To require acceptance, set to <code>TRUE</code> . With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptanceRequired(java.lang.Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getAcceptanceRequired}
         * @param acceptanceRequired A flag that determines whether a match that was created with this configuration must be accepted by the matched players. This parameter is required.
         *                           To require acceptance, set to <code>TRUE</code> . With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptanceRequired(software.amazon.awscdk.IResolvable acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getName}
         * @param name A unique identifier for the matchmaking configuration. This parameter is required.
         *             This name is used to identify the configuration associated with a matchmaking request or ticket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getRequestTimeoutSeconds}
         * @param requestTimeoutSeconds The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. This parameter is required.
         *                              Requests that fail due to timing out can be resubmitted as needed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTimeoutSeconds(java.lang.Number requestTimeoutSeconds) {
            this.requestTimeoutSeconds = requestTimeoutSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getRuleSetName}
         * @param ruleSetName A unique identifier for the matchmaking rule set to use with this configuration. This parameter is required.
         *                    You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSetName(java.lang.String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getAcceptanceTimeoutSeconds}
         * @param acceptanceTimeoutSeconds The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptanceTimeoutSeconds(java.lang.Number acceptanceTimeoutSeconds) {
            this.acceptanceTimeoutSeconds = acceptanceTimeoutSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getAdditionalPlayerCount}
         * @param additionalPlayerCount The number of player slots in a match to keep open for future players.
         *                              For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalPlayerCount(java.lang.Number additionalPlayerCount) {
            this.additionalPlayerCount = additionalPlayerCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getBackfillMode}
         * @param backfillMode The method used to backfill game sessions that are created with this matchmaking configuration.
         *                     Specify <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill feature. Specify <code>AUTOMATIC</code> to have GameLift create a <code>StartMatchBackfill</code> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill Existing Games with FlexMatch</a> . Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backfillMode(java.lang.String backfillMode) {
            this.backfillMode = backfillMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getCreationTime}
         * @param creationTime A time stamp indicating when this data object was created.
         *                     Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code> ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creationTime(java.lang.String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getCustomEventData}
         * @param customEventData Information to add to all events related to the matchmaking configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEventData(java.lang.String customEventData) {
            this.customEventData = customEventData;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getDescription}
         * @param description A description for the matchmaking configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getFlexMatchMode}
         * @param flexMatchMode Indicates whether this matchmaking configuration is being used with Amazon GameLift Servers hosting or as a standalone matchmaking solution.
         *                      <ul>
         *                      <li><em>STANDALONE</em> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded">MatchmakingSucceeded</a> event.</li>
         *                      <li><em>WITH_QUEUE</em> - FlexMatch forms matches and uses the specified Amazon GameLift Servers queue to start a game session for the match.</li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flexMatchMode(java.lang.String flexMatchMode) {
            this.flexMatchMode = flexMatchMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getGameProperties}
         * @param gameProperties A set of custom properties for a game session, formatted as key-value pairs.
         *                       These properties are passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameProperties(software.amazon.awscdk.IResolvable gameProperties) {
            this.gameProperties = gameProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getGameProperties}
         * @param gameProperties A set of custom properties for a game session, formatted as key-value pairs.
         *                       These properties are passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameProperties(java.util.List<? extends java.lang.Object> gameProperties) {
            this.gameProperties = gameProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getGameSessionData}
         * @param gameSessionData A set of custom game session properties, formatted as a single string value.
         *                        This data is passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameSessionData(java.lang.String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getGameSessionQueueArns}
         * @param gameSessionQueueArns The Amazon Resource Name ( <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a> ) that is assigned to a Amazon GameLift Servers game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code> . Queues can be located in any Region. Queues are used to start new Amazon GameLift Servers-hosted game sessions for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code> , do not set this parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameSessionQueueArns(java.util.List<java.lang.String> gameSessionQueueArns) {
            this.gameSessionQueueArns = gameSessionQueueArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getNotificationTarget}
         * @param notificationTarget An SNS topic ARN that is set up to receive matchmaking notifications.
         *                           See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html">Setting up notifications for matchmaking</a> for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTarget(java.lang.String notificationTarget) {
            this.notificationTarget = notificationTarget;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getRuleSetArn}
         * @param ruleSetArn The Amazon Resource Name ( <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a> ) associated with the GameLift matchmaking rule set resource that this configuration uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSetArn(java.lang.String ruleSetArn) {
            this.ruleSetArn = ruleSetArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchmakingConfigurationProps#getTags}
         * @param tags A list of labels to assign to the new matchmaking configuration resource.
         *             Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in the <em>AWS General Reference</em> . Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMatchmakingConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMatchmakingConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMatchmakingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMatchmakingConfigurationProps {
        private final java.lang.Object acceptanceRequired;
        private final java.lang.String name;
        private final java.lang.Number requestTimeoutSeconds;
        private final java.lang.String ruleSetName;
        private final java.lang.Number acceptanceTimeoutSeconds;
        private final java.lang.Number additionalPlayerCount;
        private final java.lang.String backfillMode;
        private final java.lang.String creationTime;
        private final java.lang.String customEventData;
        private final java.lang.String description;
        private final java.lang.String flexMatchMode;
        private final java.lang.Object gameProperties;
        private final java.lang.String gameSessionData;
        private final java.util.List<java.lang.String> gameSessionQueueArns;
        private final java.lang.String notificationTarget;
        private final java.lang.String ruleSetArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.acceptanceRequired = software.amazon.jsii.Kernel.get(this, "acceptanceRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requestTimeoutSeconds = software.amazon.jsii.Kernel.get(this, "requestTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ruleSetName = software.amazon.jsii.Kernel.get(this, "ruleSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.acceptanceTimeoutSeconds = software.amazon.jsii.Kernel.get(this, "acceptanceTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.additionalPlayerCount = software.amazon.jsii.Kernel.get(this, "additionalPlayerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.backfillMode = software.amazon.jsii.Kernel.get(this, "backfillMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.creationTime = software.amazon.jsii.Kernel.get(this, "creationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customEventData = software.amazon.jsii.Kernel.get(this, "customEventData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.flexMatchMode = software.amazon.jsii.Kernel.get(this, "flexMatchMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gameProperties = software.amazon.jsii.Kernel.get(this, "gameProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.gameSessionData = software.amazon.jsii.Kernel.get(this, "gameSessionData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gameSessionQueueArns = software.amazon.jsii.Kernel.get(this, "gameSessionQueueArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.notificationTarget = software.amazon.jsii.Kernel.get(this, "notificationTarget", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleSetArn = software.amazon.jsii.Kernel.get(this, "ruleSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.acceptanceRequired = java.util.Objects.requireNonNull(builder.acceptanceRequired, "acceptanceRequired is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.requestTimeoutSeconds = java.util.Objects.requireNonNull(builder.requestTimeoutSeconds, "requestTimeoutSeconds is required");
            this.ruleSetName = java.util.Objects.requireNonNull(builder.ruleSetName, "ruleSetName is required");
            this.acceptanceTimeoutSeconds = builder.acceptanceTimeoutSeconds;
            this.additionalPlayerCount = builder.additionalPlayerCount;
            this.backfillMode = builder.backfillMode;
            this.creationTime = builder.creationTime;
            this.customEventData = builder.customEventData;
            this.description = builder.description;
            this.flexMatchMode = builder.flexMatchMode;
            this.gameProperties = builder.gameProperties;
            this.gameSessionData = builder.gameSessionData;
            this.gameSessionQueueArns = builder.gameSessionQueueArns;
            this.notificationTarget = builder.notificationTarget;
            this.ruleSetArn = builder.ruleSetArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getRequestTimeoutSeconds() {
            return this.requestTimeoutSeconds;
        }

        @Override
        public final java.lang.String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final java.lang.Number getAcceptanceTimeoutSeconds() {
            return this.acceptanceTimeoutSeconds;
        }

        @Override
        public final java.lang.Number getAdditionalPlayerCount() {
            return this.additionalPlayerCount;
        }

        @Override
        public final java.lang.String getBackfillMode() {
            return this.backfillMode;
        }

        @Override
        public final java.lang.String getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final java.lang.String getCustomEventData() {
            return this.customEventData;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getFlexMatchMode() {
            return this.flexMatchMode;
        }

        @Override
        public final java.lang.Object getGameProperties() {
            return this.gameProperties;
        }

        @Override
        public final java.lang.String getGameSessionData() {
            return this.gameSessionData;
        }

        @Override
        public final java.util.List<java.lang.String> getGameSessionQueueArns() {
            return this.gameSessionQueueArns;
        }

        @Override
        public final java.lang.String getNotificationTarget() {
            return this.notificationTarget;
        }

        @Override
        public final java.lang.String getRuleSetArn() {
            return this.ruleSetArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("acceptanceRequired", om.valueToTree(this.getAcceptanceRequired()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("requestTimeoutSeconds", om.valueToTree(this.getRequestTimeoutSeconds()));
            data.set("ruleSetName", om.valueToTree(this.getRuleSetName()));
            if (this.getAcceptanceTimeoutSeconds() != null) {
                data.set("acceptanceTimeoutSeconds", om.valueToTree(this.getAcceptanceTimeoutSeconds()));
            }
            if (this.getAdditionalPlayerCount() != null) {
                data.set("additionalPlayerCount", om.valueToTree(this.getAdditionalPlayerCount()));
            }
            if (this.getBackfillMode() != null) {
                data.set("backfillMode", om.valueToTree(this.getBackfillMode()));
            }
            if (this.getCreationTime() != null) {
                data.set("creationTime", om.valueToTree(this.getCreationTime()));
            }
            if (this.getCustomEventData() != null) {
                data.set("customEventData", om.valueToTree(this.getCustomEventData()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFlexMatchMode() != null) {
                data.set("flexMatchMode", om.valueToTree(this.getFlexMatchMode()));
            }
            if (this.getGameProperties() != null) {
                data.set("gameProperties", om.valueToTree(this.getGameProperties()));
            }
            if (this.getGameSessionData() != null) {
                data.set("gameSessionData", om.valueToTree(this.getGameSessionData()));
            }
            if (this.getGameSessionQueueArns() != null) {
                data.set("gameSessionQueueArns", om.valueToTree(this.getGameSessionQueueArns()));
            }
            if (this.getNotificationTarget() != null) {
                data.set("notificationTarget", om.valueToTree(this.getNotificationTarget()));
            }
            if (this.getRuleSetArn() != null) {
                data.set("ruleSetArn", om.valueToTree(this.getRuleSetArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnMatchmakingConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMatchmakingConfigurationProps.Jsii$Proxy that = (CfnMatchmakingConfigurationProps.Jsii$Proxy) o;

            if (!acceptanceRequired.equals(that.acceptanceRequired)) return false;
            if (!name.equals(that.name)) return false;
            if (!requestTimeoutSeconds.equals(that.requestTimeoutSeconds)) return false;
            if (!ruleSetName.equals(that.ruleSetName)) return false;
            if (this.acceptanceTimeoutSeconds != null ? !this.acceptanceTimeoutSeconds.equals(that.acceptanceTimeoutSeconds) : that.acceptanceTimeoutSeconds != null) return false;
            if (this.additionalPlayerCount != null ? !this.additionalPlayerCount.equals(that.additionalPlayerCount) : that.additionalPlayerCount != null) return false;
            if (this.backfillMode != null ? !this.backfillMode.equals(that.backfillMode) : that.backfillMode != null) return false;
            if (this.creationTime != null ? !this.creationTime.equals(that.creationTime) : that.creationTime != null) return false;
            if (this.customEventData != null ? !this.customEventData.equals(that.customEventData) : that.customEventData != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.flexMatchMode != null ? !this.flexMatchMode.equals(that.flexMatchMode) : that.flexMatchMode != null) return false;
            if (this.gameProperties != null ? !this.gameProperties.equals(that.gameProperties) : that.gameProperties != null) return false;
            if (this.gameSessionData != null ? !this.gameSessionData.equals(that.gameSessionData) : that.gameSessionData != null) return false;
            if (this.gameSessionQueueArns != null ? !this.gameSessionQueueArns.equals(that.gameSessionQueueArns) : that.gameSessionQueueArns != null) return false;
            if (this.notificationTarget != null ? !this.notificationTarget.equals(that.notificationTarget) : that.notificationTarget != null) return false;
            if (this.ruleSetArn != null ? !this.ruleSetArn.equals(that.ruleSetArn) : that.ruleSetArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.acceptanceRequired.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.requestTimeoutSeconds.hashCode());
            result = 31 * result + (this.ruleSetName.hashCode());
            result = 31 * result + (this.acceptanceTimeoutSeconds != null ? this.acceptanceTimeoutSeconds.hashCode() : 0);
            result = 31 * result + (this.additionalPlayerCount != null ? this.additionalPlayerCount.hashCode() : 0);
            result = 31 * result + (this.backfillMode != null ? this.backfillMode.hashCode() : 0);
            result = 31 * result + (this.creationTime != null ? this.creationTime.hashCode() : 0);
            result = 31 * result + (this.customEventData != null ? this.customEventData.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.flexMatchMode != null ? this.flexMatchMode.hashCode() : 0);
            result = 31 * result + (this.gameProperties != null ? this.gameProperties.hashCode() : 0);
            result = 31 * result + (this.gameSessionData != null ? this.gameSessionData.hashCode() : 0);
            result = 31 * result + (this.gameSessionQueueArns != null ? this.gameSessionQueueArns.hashCode() : 0);
            result = 31 * result + (this.notificationTarget != null ? this.notificationTarget.hashCode() : 0);
            result = 31 * result + (this.ruleSetArn != null ? this.ruleSetArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
