package software.amazon.awscdk.services.glue;

/**
 * The <code>AWS::Glue::Classifier</code> resource creates an AWS Glue classifier that categorizes data sources and specifies schemas.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-classifier.html">Adding Classifiers to a Crawler</a> and <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-Classifier">Classifier Structure</a> in the <em>AWS Glue Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * CfnClassifier cfnClassifier = CfnClassifier.Builder.create(this, "MyCfnClassifier")
 *         .csvClassifier(CsvClassifierProperty.builder()
 *                 .allowSingleColumn(false)
 *                 .containsCustomDatatype(List.of("containsCustomDatatype"))
 *                 .containsHeader("containsHeader")
 *                 .customDatatypeConfigured(false)
 *                 .delimiter("delimiter")
 *                 .disableValueTrimming(false)
 *                 .header(List.of("header"))
 *                 .name("name")
 *                 .quoteSymbol("quoteSymbol")
 *                 .build())
 *         .grokClassifier(GrokClassifierProperty.builder()
 *                 .classification("classification")
 *                 .grokPattern("grokPattern")
 *                 // the properties below are optional
 *                 .customPatterns("customPatterns")
 *                 .name("name")
 *                 .build())
 *         .jsonClassifier(JsonClassifierProperty.builder()
 *                 .jsonPath("jsonPath")
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build())
 *         .xmlClassifier(XMLClassifierProperty.builder()
 *                 .classification("classification")
 *                 .rowTag("rowTag")
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:15.129Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnClassifier")
public class CfnClassifier extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnClassifier(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnClassifier(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.CfnClassifier.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnClassifier(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnClassifierProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnClassifier(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A classifier for comma-separated values (CSV).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCsvClassifier() {
        return software.amazon.jsii.Kernel.get(this, "csvClassifier", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A classifier for comma-separated values (CSV).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCsvClassifier(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "csvClassifier", value);
    }

    /**
     * A classifier for comma-separated values (CSV).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCsvClassifier(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnClassifier.CsvClassifierProperty value) {
        software.amazon.jsii.Kernel.set(this, "csvClassifier", value);
    }

    /**
     * A classifier that uses <code>grok</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGrokClassifier() {
        return software.amazon.jsii.Kernel.get(this, "grokClassifier", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A classifier that uses <code>grok</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGrokClassifier(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "grokClassifier", value);
    }

    /**
     * A classifier that uses <code>grok</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGrokClassifier(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnClassifier.GrokClassifierProperty value) {
        software.amazon.jsii.Kernel.set(this, "grokClassifier", value);
    }

    /**
     * A classifier for JSON content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getJsonClassifier() {
        return software.amazon.jsii.Kernel.get(this, "jsonClassifier", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A classifier for JSON content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJsonClassifier(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "jsonClassifier", value);
    }

    /**
     * A classifier for JSON content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJsonClassifier(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnClassifier.JsonClassifierProperty value) {
        software.amazon.jsii.Kernel.set(this, "jsonClassifier", value);
    }

    /**
     * A classifier for XML content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getXmlClassifier() {
        return software.amazon.jsii.Kernel.get(this, "xmlClassifier", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A classifier for XML content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setXmlClassifier(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "xmlClassifier", value);
    }

    /**
     * A classifier for XML content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setXmlClassifier(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnClassifier.XMLClassifierProperty value) {
        software.amazon.jsii.Kernel.set(this, "xmlClassifier", value);
    }
    /**
     * A classifier for custom <code>CSV</code> content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * CsvClassifierProperty csvClassifierProperty = CsvClassifierProperty.builder()
     *         .allowSingleColumn(false)
     *         .containsCustomDatatype(List.of("containsCustomDatatype"))
     *         .containsHeader("containsHeader")
     *         .customDatatypeConfigured(false)
     *         .delimiter("delimiter")
     *         .disableValueTrimming(false)
     *         .header(List.of("header"))
     *         .name("name")
     *         .quoteSymbol("quoteSymbol")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnClassifier.CsvClassifierProperty")
    @software.amazon.jsii.Jsii.Proxy(CsvClassifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CsvClassifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables the processing of files that contain only one column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-allowsinglecolumn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-allowsinglecolumn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowSingleColumn() {
            return null;
        }

        /**
         * Indicates whether the CSV file contains custom data types.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-containscustomdatatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-containscustomdatatype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainsCustomDatatype() {
            return null;
        }

        /**
         * Indicates whether the CSV file contains a header.
         * <p>
         * A value of <code>UNKNOWN</code> specifies that the classifier will detect whether the CSV file contains headings.
         * <p>
         * A value of <code>PRESENT</code> specifies that the CSV file contains headings.
         * <p>
         * A value of <code>ABSENT</code> specifies that the CSV file does not contain headings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-containsheader">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-containsheader</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainsHeader() {
            return null;
        }

        /**
         * Enables the configuration of custom data types.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-customdatatypeconfigured">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-customdatatypeconfigured</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomDatatypeConfigured() {
            return null;
        }

        /**
         * A custom symbol to denote what separates each column entry in the row.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-delimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-delimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
            return null;
        }

        /**
         * Specifies not to trim values before identifying the type of column values.
         * <p>
         * The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-disablevaluetrimming">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-disablevaluetrimming</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableValueTrimming() {
            return null;
        }

        /**
         * A list of strings representing column names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-header">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-header</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeader() {
            return null;
        }

        /**
         * The name of the classifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * A custom symbol to denote what combines content into a single column value.
         * <p>
         * It must be different from the column delimiter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-quotesymbol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-quotesymbol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQuoteSymbol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CsvClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CsvClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CsvClassifierProperty> {
            java.lang.Object allowSingleColumn;
            java.util.List<java.lang.String> containsCustomDatatype;
            java.lang.String containsHeader;
            java.lang.Object customDatatypeConfigured;
            java.lang.String delimiter;
            java.lang.Object disableValueTrimming;
            java.util.List<java.lang.String> header;
            java.lang.String name;
            java.lang.String quoteSymbol;

            /**
             * Sets the value of {@link CsvClassifierProperty#getAllowSingleColumn}
             * @param allowSingleColumn Enables the processing of files that contain only one column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowSingleColumn(java.lang.Boolean allowSingleColumn) {
                this.allowSingleColumn = allowSingleColumn;
                return this;
            }

            /**
             * Sets the value of {@link CsvClassifierProperty#getAllowSingleColumn}
             * @param allowSingleColumn Enables the processing of files that contain only one column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowSingleColumn(software.amazon.awscdk.IResolvable allowSingleColumn) {
                this.allowSingleColumn = allowSingleColumn;
                return this;
            }

            /**
             * Sets the value of {@link CsvClassifierProperty#getContainsCustomDatatype}
             * @param containsCustomDatatype Indicates whether the CSV file contains custom data types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsCustomDatatype(java.util.List<java.lang.String> containsCustomDatatype) {
                this.containsCustomDatatype = containsCustomDatatype;
                return this;
            }

            /**
             * Sets the value of {@link CsvClassifierProperty#getContainsHeader}
             * @param containsHeader Indicates whether the CSV file contains a header.
             *                       A value of <code>UNKNOWN</code> specifies that the classifier will detect whether the CSV file contains headings.
             *                       <p>
             *                       A value of <code>PRESENT</code> specifies that the CSV file contains headings.
             *                       <p>
             *                       A value of <code>ABSENT</code> specifies that the CSV file does not contain headings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsHeader(java.lang.String containsHeader) {
                this.containsHeader = containsHeader;
                return this;
            }

            /**
             * Sets the value of {@link CsvClassifierProperty#getCustomDatatypeConfigured}
             * @param customDatatypeConfigured Enables the configuration of custom data types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customDatatypeConfigured(java.lang.Boolean customDatatypeConfigured) {
                this.customDatatypeConfigured = customDatatypeConfigured;
                return this;
            }

            /**
             * Sets the value of {@link CsvClassifierProperty#getCustomDatatypeConfigured}
             * @param customDatatypeConfigured Enables the configuration of custom data types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customDatatypeConfigured(software.amazon.awscdk.IResolvable customDatatypeConfigured) {
                this.customDatatypeConfigured = customDatatypeConfigured;
                return this;
            }

            /**
             * Sets the value of {@link CsvClassifierProperty#getDelimiter}
             * @param delimiter A custom symbol to denote what separates each column entry in the row.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Sets the value of {@link CsvClassifierProperty#getDisableValueTrimming}
             * @param disableValueTrimming Specifies not to trim values before identifying the type of column values.
             *                             The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableValueTrimming(java.lang.Boolean disableValueTrimming) {
                this.disableValueTrimming = disableValueTrimming;
                return this;
            }

            /**
             * Sets the value of {@link CsvClassifierProperty#getDisableValueTrimming}
             * @param disableValueTrimming Specifies not to trim values before identifying the type of column values.
             *                             The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableValueTrimming(software.amazon.awscdk.IResolvable disableValueTrimming) {
                this.disableValueTrimming = disableValueTrimming;
                return this;
            }

            /**
             * Sets the value of {@link CsvClassifierProperty#getHeader}
             * @param header A list of strings representing column names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(java.util.List<java.lang.String> header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link CsvClassifierProperty#getName}
             * @param name The name of the classifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CsvClassifierProperty#getQuoteSymbol}
             * @param quoteSymbol A custom symbol to denote what combines content into a single column value.
             *                    It must be different from the column delimiter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quoteSymbol(java.lang.String quoteSymbol) {
                this.quoteSymbol = quoteSymbol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CsvClassifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CsvClassifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CsvClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsvClassifierProperty {
            private final java.lang.Object allowSingleColumn;
            private final java.util.List<java.lang.String> containsCustomDatatype;
            private final java.lang.String containsHeader;
            private final java.lang.Object customDatatypeConfigured;
            private final java.lang.String delimiter;
            private final java.lang.Object disableValueTrimming;
            private final java.util.List<java.lang.String> header;
            private final java.lang.String name;
            private final java.lang.String quoteSymbol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowSingleColumn = software.amazon.jsii.Kernel.get(this, "allowSingleColumn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.containsCustomDatatype = software.amazon.jsii.Kernel.get(this, "containsCustomDatatype", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.containsHeader = software.amazon.jsii.Kernel.get(this, "containsHeader", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customDatatypeConfigured = software.amazon.jsii.Kernel.get(this, "customDatatypeConfigured", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.disableValueTrimming = software.amazon.jsii.Kernel.get(this, "disableValueTrimming", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.header = software.amazon.jsii.Kernel.get(this, "header", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.quoteSymbol = software.amazon.jsii.Kernel.get(this, "quoteSymbol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowSingleColumn = builder.allowSingleColumn;
                this.containsCustomDatatype = builder.containsCustomDatatype;
                this.containsHeader = builder.containsHeader;
                this.customDatatypeConfigured = builder.customDatatypeConfigured;
                this.delimiter = builder.delimiter;
                this.disableValueTrimming = builder.disableValueTrimming;
                this.header = builder.header;
                this.name = builder.name;
                this.quoteSymbol = builder.quoteSymbol;
            }

            @Override
            public final java.lang.Object getAllowSingleColumn() {
                return this.allowSingleColumn;
            }

            @Override
            public final java.util.List<java.lang.String> getContainsCustomDatatype() {
                return this.containsCustomDatatype;
            }

            @Override
            public final java.lang.String getContainsHeader() {
                return this.containsHeader;
            }

            @Override
            public final java.lang.Object getCustomDatatypeConfigured() {
                return this.customDatatypeConfigured;
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            public final java.lang.Object getDisableValueTrimming() {
                return this.disableValueTrimming;
            }

            @Override
            public final java.util.List<java.lang.String> getHeader() {
                return this.header;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getQuoteSymbol() {
                return this.quoteSymbol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowSingleColumn() != null) {
                    data.set("allowSingleColumn", om.valueToTree(this.getAllowSingleColumn()));
                }
                if (this.getContainsCustomDatatype() != null) {
                    data.set("containsCustomDatatype", om.valueToTree(this.getContainsCustomDatatype()));
                }
                if (this.getContainsHeader() != null) {
                    data.set("containsHeader", om.valueToTree(this.getContainsHeader()));
                }
                if (this.getCustomDatatypeConfigured() != null) {
                    data.set("customDatatypeConfigured", om.valueToTree(this.getCustomDatatypeConfigured()));
                }
                if (this.getDelimiter() != null) {
                    data.set("delimiter", om.valueToTree(this.getDelimiter()));
                }
                if (this.getDisableValueTrimming() != null) {
                    data.set("disableValueTrimming", om.valueToTree(this.getDisableValueTrimming()));
                }
                if (this.getHeader() != null) {
                    data.set("header", om.valueToTree(this.getHeader()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getQuoteSymbol() != null) {
                    data.set("quoteSymbol", om.valueToTree(this.getQuoteSymbol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnClassifier.CsvClassifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CsvClassifierProperty.Jsii$Proxy that = (CsvClassifierProperty.Jsii$Proxy) o;

                if (this.allowSingleColumn != null ? !this.allowSingleColumn.equals(that.allowSingleColumn) : that.allowSingleColumn != null) return false;
                if (this.containsCustomDatatype != null ? !this.containsCustomDatatype.equals(that.containsCustomDatatype) : that.containsCustomDatatype != null) return false;
                if (this.containsHeader != null ? !this.containsHeader.equals(that.containsHeader) : that.containsHeader != null) return false;
                if (this.customDatatypeConfigured != null ? !this.customDatatypeConfigured.equals(that.customDatatypeConfigured) : that.customDatatypeConfigured != null) return false;
                if (this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null) return false;
                if (this.disableValueTrimming != null ? !this.disableValueTrimming.equals(that.disableValueTrimming) : that.disableValueTrimming != null) return false;
                if (this.header != null ? !this.header.equals(that.header) : that.header != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.quoteSymbol != null ? this.quoteSymbol.equals(that.quoteSymbol) : that.quoteSymbol == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowSingleColumn != null ? this.allowSingleColumn.hashCode() : 0;
                result = 31 * result + (this.containsCustomDatatype != null ? this.containsCustomDatatype.hashCode() : 0);
                result = 31 * result + (this.containsHeader != null ? this.containsHeader.hashCode() : 0);
                result = 31 * result + (this.customDatatypeConfigured != null ? this.customDatatypeConfigured.hashCode() : 0);
                result = 31 * result + (this.delimiter != null ? this.delimiter.hashCode() : 0);
                result = 31 * result + (this.disableValueTrimming != null ? this.disableValueTrimming.hashCode() : 0);
                result = 31 * result + (this.header != null ? this.header.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.quoteSymbol != null ? this.quoteSymbol.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A classifier that uses <code>grok</code> patterns.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * GrokClassifierProperty grokClassifierProperty = GrokClassifierProperty.builder()
     *         .classification("classification")
     *         .grokPattern("grokPattern")
     *         // the properties below are optional
     *         .customPatterns("customPatterns")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnClassifier.GrokClassifierProperty")
    @software.amazon.jsii.Jsii.Proxy(GrokClassifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrokClassifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, and so on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-classification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-classification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClassification();

        /**
         * The grok pattern applied to a data store by this classifier.
         * <p>
         * For more information, see built-in patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-grokpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-grokpattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGrokPattern();

        /**
         * Optional custom grok patterns defined by this classifier.
         * <p>
         * For more information, see custom patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-custompatterns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-custompatterns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomPatterns() {
            return null;
        }

        /**
         * The name of the classifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrokClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrokClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrokClassifierProperty> {
            java.lang.String classification;
            java.lang.String grokPattern;
            java.lang.String customPatterns;
            java.lang.String name;

            /**
             * Sets the value of {@link GrokClassifierProperty#getClassification}
             * @param classification An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, and so on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classification(java.lang.String classification) {
                this.classification = classification;
                return this;
            }

            /**
             * Sets the value of {@link GrokClassifierProperty#getGrokPattern}
             * @param grokPattern The grok pattern applied to a data store by this classifier. This parameter is required.
             *                    For more information, see built-in patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grokPattern(java.lang.String grokPattern) {
                this.grokPattern = grokPattern;
                return this;
            }

            /**
             * Sets the value of {@link GrokClassifierProperty#getCustomPatterns}
             * @param customPatterns Optional custom grok patterns defined by this classifier.
             *                       For more information, see custom patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPatterns(java.lang.String customPatterns) {
                this.customPatterns = customPatterns;
                return this;
            }

            /**
             * Sets the value of {@link GrokClassifierProperty#getName}
             * @param name The name of the classifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrokClassifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrokClassifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrokClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrokClassifierProperty {
            private final java.lang.String classification;
            private final java.lang.String grokPattern;
            private final java.lang.String customPatterns;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classification = software.amazon.jsii.Kernel.get(this, "classification", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.grokPattern = software.amazon.jsii.Kernel.get(this, "grokPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customPatterns = software.amazon.jsii.Kernel.get(this, "customPatterns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classification = java.util.Objects.requireNonNull(builder.classification, "classification is required");
                this.grokPattern = java.util.Objects.requireNonNull(builder.grokPattern, "grokPattern is required");
                this.customPatterns = builder.customPatterns;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getClassification() {
                return this.classification;
            }

            @Override
            public final java.lang.String getGrokPattern() {
                return this.grokPattern;
            }

            @Override
            public final java.lang.String getCustomPatterns() {
                return this.customPatterns;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("classification", om.valueToTree(this.getClassification()));
                data.set("grokPattern", om.valueToTree(this.getGrokPattern()));
                if (this.getCustomPatterns() != null) {
                    data.set("customPatterns", om.valueToTree(this.getCustomPatterns()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnClassifier.GrokClassifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrokClassifierProperty.Jsii$Proxy that = (GrokClassifierProperty.Jsii$Proxy) o;

                if (!classification.equals(that.classification)) return false;
                if (!grokPattern.equals(that.grokPattern)) return false;
                if (this.customPatterns != null ? !this.customPatterns.equals(that.customPatterns) : that.customPatterns != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.classification.hashCode();
                result = 31 * result + (this.grokPattern.hashCode());
                result = 31 * result + (this.customPatterns != null ? this.customPatterns.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A classifier for <code>JSON</code> content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * JsonClassifierProperty jsonClassifierProperty = JsonClassifierProperty.builder()
     *         .jsonPath("jsonPath")
     *         // the properties below are optional
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnClassifier.JsonClassifierProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonClassifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonClassifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A <code>JsonPath</code> string defining the JSON data for the classifier to classify.
         * <p>
         * AWS Glue supports a subset of <code>JsonPath</code> , as described in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath Custom Classifiers</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html#cfn-glue-classifier-jsonclassifier-jsonpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html#cfn-glue-classifier-jsonclassifier-jsonpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getJsonPath();

        /**
         * The name of the classifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html#cfn-glue-classifier-jsonclassifier-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html#cfn-glue-classifier-jsonclassifier-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JsonClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonClassifierProperty> {
            java.lang.String jsonPath;
            java.lang.String name;

            /**
             * Sets the value of {@link JsonClassifierProperty#getJsonPath}
             * @param jsonPath A <code>JsonPath</code> string defining the JSON data for the classifier to classify. This parameter is required.
             *                 AWS Glue supports a subset of <code>JsonPath</code> , as described in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath Custom Classifiers</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonPath(java.lang.String jsonPath) {
                this.jsonPath = jsonPath;
                return this;
            }

            /**
             * Sets the value of {@link JsonClassifierProperty#getName}
             * @param name The name of the classifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonClassifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonClassifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonClassifierProperty {
            private final java.lang.String jsonPath;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jsonPath = software.amazon.jsii.Kernel.get(this, "jsonPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jsonPath = java.util.Objects.requireNonNull(builder.jsonPath, "jsonPath is required");
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getJsonPath() {
                return this.jsonPath;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("jsonPath", om.valueToTree(this.getJsonPath()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnClassifier.JsonClassifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonClassifierProperty.Jsii$Proxy that = (JsonClassifierProperty.Jsii$Proxy) o;

                if (!jsonPath.equals(that.jsonPath)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jsonPath.hashCode();
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A classifier for <code>XML</code> content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * XMLClassifierProperty xMLClassifierProperty = XMLClassifierProperty.builder()
     *         .classification("classification")
     *         .rowTag("rowTag")
     *         // the properties below are optional
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnClassifier.XMLClassifierProperty")
    @software.amazon.jsii.Jsii.Proxy(XMLClassifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface XMLClassifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier of the data format that the classifier matches.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-classification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-classification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClassification();

        /**
         * The XML tag designating the element that contains each record in an XML document being parsed.
         * <p>
         * This can't identify a self-closing element (closed by <code>/&gt;</code> ). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-rowtag">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-rowtag</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRowTag();

        /**
         * The name of the classifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link XMLClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link XMLClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<XMLClassifierProperty> {
            java.lang.String classification;
            java.lang.String rowTag;
            java.lang.String name;

            /**
             * Sets the value of {@link XMLClassifierProperty#getClassification}
             * @param classification An identifier of the data format that the classifier matches. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classification(java.lang.String classification) {
                this.classification = classification;
                return this;
            }

            /**
             * Sets the value of {@link XMLClassifierProperty#getRowTag}
             * @param rowTag The XML tag designating the element that contains each record in an XML document being parsed. This parameter is required.
             *               This can't identify a self-closing element (closed by <code>/&gt;</code> ). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rowTag(java.lang.String rowTag) {
                this.rowTag = rowTag;
                return this;
            }

            /**
             * Sets the value of {@link XMLClassifierProperty#getName}
             * @param name The name of the classifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link XMLClassifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public XMLClassifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link XMLClassifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements XMLClassifierProperty {
            private final java.lang.String classification;
            private final java.lang.String rowTag;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classification = software.amazon.jsii.Kernel.get(this, "classification", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rowTag = software.amazon.jsii.Kernel.get(this, "rowTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classification = java.util.Objects.requireNonNull(builder.classification, "classification is required");
                this.rowTag = java.util.Objects.requireNonNull(builder.rowTag, "rowTag is required");
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getClassification() {
                return this.classification;
            }

            @Override
            public final java.lang.String getRowTag() {
                return this.rowTag;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("classification", om.valueToTree(this.getClassification()));
                data.set("rowTag", om.valueToTree(this.getRowTag()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnClassifier.XMLClassifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                XMLClassifierProperty.Jsii$Proxy that = (XMLClassifierProperty.Jsii$Proxy) o;

                if (!classification.equals(that.classification)) return false;
                if (!rowTag.equals(that.rowTag)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.classification.hashCode();
                result = 31 * result + (this.rowTag.hashCode());
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.glue.CfnClassifier}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.CfnClassifier> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.glue.CfnClassifierProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A classifier for comma-separated values (CSV).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-csvclassifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-csvclassifier</a>
         * @param csvClassifier A classifier for comma-separated values (CSV). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder csvClassifier(final software.amazon.awscdk.IResolvable csvClassifier) {
            this.props().csvClassifier(csvClassifier);
            return this;
        }
        /**
         * A classifier for comma-separated values (CSV).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-csvclassifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-csvclassifier</a>
         * @param csvClassifier A classifier for comma-separated values (CSV). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder csvClassifier(final software.amazon.awscdk.services.glue.CfnClassifier.CsvClassifierProperty csvClassifier) {
            this.props().csvClassifier(csvClassifier);
            return this;
        }

        /**
         * A classifier that uses <code>grok</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-grokclassifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-grokclassifier</a>
         * @param grokClassifier A classifier that uses <code>grok</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grokClassifier(final software.amazon.awscdk.IResolvable grokClassifier) {
            this.props().grokClassifier(grokClassifier);
            return this;
        }
        /**
         * A classifier that uses <code>grok</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-grokclassifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-grokclassifier</a>
         * @param grokClassifier A classifier that uses <code>grok</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grokClassifier(final software.amazon.awscdk.services.glue.CfnClassifier.GrokClassifierProperty grokClassifier) {
            this.props().grokClassifier(grokClassifier);
            return this;
        }

        /**
         * A classifier for JSON content.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-jsonclassifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-jsonclassifier</a>
         * @param jsonClassifier A classifier for JSON content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonClassifier(final software.amazon.awscdk.IResolvable jsonClassifier) {
            this.props().jsonClassifier(jsonClassifier);
            return this;
        }
        /**
         * A classifier for JSON content.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-jsonclassifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-jsonclassifier</a>
         * @param jsonClassifier A classifier for JSON content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonClassifier(final software.amazon.awscdk.services.glue.CfnClassifier.JsonClassifierProperty jsonClassifier) {
            this.props().jsonClassifier(jsonClassifier);
            return this;
        }

        /**
         * A classifier for XML content.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-xmlclassifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-xmlclassifier</a>
         * @param xmlClassifier A classifier for XML content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xmlClassifier(final software.amazon.awscdk.IResolvable xmlClassifier) {
            this.props().xmlClassifier(xmlClassifier);
            return this;
        }
        /**
         * A classifier for XML content.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-xmlclassifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-xmlclassifier</a>
         * @param xmlClassifier A classifier for XML content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xmlClassifier(final software.amazon.awscdk.services.glue.CfnClassifier.XMLClassifierProperty xmlClassifier) {
            this.props().xmlClassifier(xmlClassifier);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.CfnClassifier}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.glue.CfnClassifier build() {
            return new software.amazon.awscdk.services.glue.CfnClassifier(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.glue.CfnClassifierProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.glue.CfnClassifierProps.Builder();
            }
            return this.props;
        }
    }
}
