package software.amazon.awscdk.services.glue;

/**
 * The <code>AWS::Glue::Connection</code> resource specifies an AWS Glue connection to a data source.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/populate-add-connection.html">Adding a Connection to Your Data Store</a> and <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-Connection">Connection Structure</a> in the <em>AWS Glue Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object athenaProperties;
 * Object connectionProperties;
 * Object customAuthenticationCredentials;
 * Object pythonProperties;
 * Object sparkProperties;
 * Object tokenUrlParametersMap;
 * CfnConnection cfnConnection = CfnConnection.Builder.create(this, "MyCfnConnection")
 *         .catalogId("catalogId")
 *         .connectionInput(ConnectionInputProperty.builder()
 *                 .connectionType("connectionType")
 *                 // the properties below are optional
 *                 .athenaProperties(athenaProperties)
 *                 .authenticationConfiguration(AuthenticationConfigurationInputProperty.builder()
 *                         .authenticationType("authenticationType")
 *                         // the properties below are optional
 *                         .basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .customAuthenticationCredentials(customAuthenticationCredentials)
 *                         .kmsKeyArn("kmsKeyArn")
 *                         .oAuth2Properties(OAuth2PropertiesInputProperty.builder()
 *                                 .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
 *                                         .authorizationCode("authorizationCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
 *                                         .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
 *                                         .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
 *                                         .build())
 *                                 .oAuth2Credentials(OAuth2CredentialsProperty.builder()
 *                                         .accessToken("accessToken")
 *                                         .jwtToken("jwtToken")
 *                                         .refreshToken("refreshToken")
 *                                         .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
 *                                         .build())
 *                                 .oAuth2GrantType("oAuth2GrantType")
 *                                 .tokenUrl("tokenUrl")
 *                                 .tokenUrlParametersMap(tokenUrlParametersMap)
 *                                 .build())
 *                         .secretArn("secretArn")
 *                         .build())
 *                 .connectionProperties(connectionProperties)
 *                 .description("description")
 *                 .matchCriteria(List.of("matchCriteria"))
 *                 .name("name")
 *                 .physicalConnectionRequirements(PhysicalConnectionRequirementsProperty.builder()
 *                         .availabilityZone("availabilityZone")
 *                         .securityGroupIdList(List.of("securityGroupIdList"))
 *                         .subnetId("subnetId")
 *                         .build())
 *                 .pythonProperties(pythonProperties)
 *                 .sparkProperties(sparkProperties)
 *                 .validateCredentials(false)
 *                 .validateForComputeEnvironments(List.of("validateForComputeEnvironments"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:15.133Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection")
public class CfnConnection extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConnection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.CfnConnection.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnection(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnConnectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the data catalog to create the catalog object in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCatalogId() {
        return software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the data catalog to create the catalog object in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCatalogId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "catalogId", java.util.Objects.requireNonNull(value, "catalogId is required"));
    }

    /**
     * The connection that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConnectionInput() {
        return software.amazon.jsii.Kernel.get(this, "connectionInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The connection that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "connectionInput", java.util.Objects.requireNonNull(value, "connectionInput is required"));
    }

    /**
     * The connection that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnConnection.ConnectionInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "connectionInput", java.util.Objects.requireNonNull(value, "connectionInput is required"));
    }
    /**
     * A structure containing the authentication configuration in the CreateConnection request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * Object customAuthenticationCredentials;
     * Object tokenUrlParametersMap;
     * AuthenticationConfigurationInputProperty authenticationConfigurationInputProperty = AuthenticationConfigurationInputProperty.builder()
     *         .authenticationType("authenticationType")
     *         // the properties below are optional
     *         .basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .customAuthenticationCredentials(customAuthenticationCredentials)
     *         .kmsKeyArn("kmsKeyArn")
     *         .oAuth2Properties(OAuth2PropertiesInputProperty.builder()
     *                 .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
     *                         .authorizationCode("authorizationCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
     *                         .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
     *                         .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
     *                         .build())
     *                 .oAuth2Credentials(OAuth2CredentialsProperty.builder()
     *                         .accessToken("accessToken")
     *                         .jwtToken("jwtToken")
     *                         .refreshToken("refreshToken")
     *                         .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
     *                         .build())
     *                 .oAuth2GrantType("oAuth2GrantType")
     *                 .tokenUrl("tokenUrl")
     *                 .tokenUrlParametersMap(tokenUrlParametersMap)
     *                 .build())
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection.AuthenticationConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticationConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticationConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure containing the authentication configuration in the CreateConnection request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-authenticationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType();

        /**
         * The credentials used when the authentication type is basic authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-basicauthenticationcredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-basicauthenticationcredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBasicAuthenticationCredentials() {
            return null;
        }

        /**
         * The credentials used when the authentication type is custom authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-customauthenticationcredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-customauthenticationcredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomAuthenticationCredentials() {
            return null;
        }

        /**
         * The ARN of the KMS key used to encrypt the connection.
         * <p>
         * Only taken an as input in the request and stored in the Secret Manager.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * The properties for OAuth2 authentication in the CreateConnection request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-oauth2properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-oauth2properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuth2Properties() {
            return null;
        }

        /**
         * The secret manager ARN to store credentials in the CreateConnection request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authenticationconfigurationinput.html#cfn-glue-connection-authenticationconfigurationinput-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthenticationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticationConfigurationInputProperty> {
            java.lang.String authenticationType;
            java.lang.Object basicAuthenticationCredentials;
            java.lang.Object customAuthenticationCredentials;
            java.lang.String kmsKeyArn;
            java.lang.Object oAuth2Properties;
            java.lang.String secretArn;

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getAuthenticationType}
             * @param authenticationType A structure containing the authentication configuration in the CreateConnection request. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationType(java.lang.String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getBasicAuthenticationCredentials}
             * @param basicAuthenticationCredentials The credentials used when the authentication type is basic authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthenticationCredentials(software.amazon.awscdk.IResolvable basicAuthenticationCredentials) {
                this.basicAuthenticationCredentials = basicAuthenticationCredentials;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getBasicAuthenticationCredentials}
             * @param basicAuthenticationCredentials The credentials used when the authentication type is basic authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthenticationCredentials(software.amazon.awscdk.services.glue.CfnConnection.BasicAuthenticationCredentialsProperty basicAuthenticationCredentials) {
                this.basicAuthenticationCredentials = basicAuthenticationCredentials;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getCustomAuthenticationCredentials}
             * @param customAuthenticationCredentials The credentials used when the authentication type is custom authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAuthenticationCredentials(java.lang.Object customAuthenticationCredentials) {
                this.customAuthenticationCredentials = customAuthenticationCredentials;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getKmsKeyArn}
             * @param kmsKeyArn The ARN of the KMS key used to encrypt the connection.
             *                  Only taken an as input in the request and stored in the Secret Manager.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getOAuth2Properties}
             * @param oAuth2Properties The properties for OAuth2 authentication in the CreateConnection request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Properties(software.amazon.awscdk.IResolvable oAuth2Properties) {
                this.oAuth2Properties = oAuth2Properties;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getOAuth2Properties}
             * @param oAuth2Properties The properties for OAuth2 authentication in the CreateConnection request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Properties(software.amazon.awscdk.services.glue.CfnConnection.OAuth2PropertiesInputProperty oAuth2Properties) {
                this.oAuth2Properties = oAuth2Properties;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getSecretArn}
             * @param secretArn The secret manager ARN to store credentials in the CreateConnection request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticationConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticationConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthenticationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticationConfigurationInputProperty {
            private final java.lang.String authenticationType;
            private final java.lang.Object basicAuthenticationCredentials;
            private final java.lang.Object customAuthenticationCredentials;
            private final java.lang.String kmsKeyArn;
            private final java.lang.Object oAuth2Properties;
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.basicAuthenticationCredentials = software.amazon.jsii.Kernel.get(this, "basicAuthenticationCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customAuthenticationCredentials = software.amazon.jsii.Kernel.get(this, "customAuthenticationCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oAuth2Properties = software.amazon.jsii.Kernel.get(this, "oAuth2Properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationType = java.util.Objects.requireNonNull(builder.authenticationType, "authenticationType is required");
                this.basicAuthenticationCredentials = builder.basicAuthenticationCredentials;
                this.customAuthenticationCredentials = builder.customAuthenticationCredentials;
                this.kmsKeyArn = builder.kmsKeyArn;
                this.oAuth2Properties = builder.oAuth2Properties;
                this.secretArn = builder.secretArn;
            }

            @Override
            public final java.lang.String getAuthenticationType() {
                return this.authenticationType;
            }

            @Override
            public final java.lang.Object getBasicAuthenticationCredentials() {
                return this.basicAuthenticationCredentials;
            }

            @Override
            public final java.lang.Object getCustomAuthenticationCredentials() {
                return this.customAuthenticationCredentials;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            public final java.lang.Object getOAuth2Properties() {
                return this.oAuth2Properties;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
                if (this.getBasicAuthenticationCredentials() != null) {
                    data.set("basicAuthenticationCredentials", om.valueToTree(this.getBasicAuthenticationCredentials()));
                }
                if (this.getCustomAuthenticationCredentials() != null) {
                    data.set("customAuthenticationCredentials", om.valueToTree(this.getCustomAuthenticationCredentials()));
                }
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }
                if (this.getOAuth2Properties() != null) {
                    data.set("oAuth2Properties", om.valueToTree(this.getOAuth2Properties()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnConnection.AuthenticationConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticationConfigurationInputProperty.Jsii$Proxy that = (AuthenticationConfigurationInputProperty.Jsii$Proxy) o;

                if (!authenticationType.equals(that.authenticationType)) return false;
                if (this.basicAuthenticationCredentials != null ? !this.basicAuthenticationCredentials.equals(that.basicAuthenticationCredentials) : that.basicAuthenticationCredentials != null) return false;
                if (this.customAuthenticationCredentials != null ? !this.customAuthenticationCredentials.equals(that.customAuthenticationCredentials) : that.customAuthenticationCredentials != null) return false;
                if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
                if (this.oAuth2Properties != null ? !this.oAuth2Properties.equals(that.oAuth2Properties) : that.oAuth2Properties != null) return false;
                return this.secretArn != null ? this.secretArn.equals(that.secretArn) : that.secretArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationType.hashCode();
                result = 31 * result + (this.basicAuthenticationCredentials != null ? this.basicAuthenticationCredentials.hashCode() : 0);
                result = 31 * result + (this.customAuthenticationCredentials != null ? this.customAuthenticationCredentials.hashCode() : 0);
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.oAuth2Properties != null ? this.oAuth2Properties.hashCode() : 0);
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The set of properties required for the the OAuth2 <code>AUTHORIZATION_CODE</code> grant type workflow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * AuthorizationCodePropertiesProperty authorizationCodePropertiesProperty = AuthorizationCodePropertiesProperty.builder()
     *         .authorizationCode("authorizationCode")
     *         .redirectUri("redirectUri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authorizationcodeproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authorizationcodeproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection.AuthorizationCodePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthorizationCodePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthorizationCodePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An authorization code to be used in the third leg of the <code>AUTHORIZATION_CODE</code> grant workflow.
         * <p>
         * This is a single-use code which becomes invalid once exchanged for an access token, thus it is acceptable to have this value as a request parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authorizationcodeproperties.html#cfn-glue-connection-authorizationcodeproperties-authorizationcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authorizationcodeproperties.html#cfn-glue-connection-authorizationcodeproperties-authorizationcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationCode() {
            return null;
        }

        /**
         * The redirect URI where the user gets redirected to by authorization server when issuing an authorization code.
         * <p>
         * The URI is subsequently used when the authorization code is exchanged for an access token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authorizationcodeproperties.html#cfn-glue-connection-authorizationcodeproperties-redirecturi">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-authorizationcodeproperties.html#cfn-glue-connection-authorizationcodeproperties-redirecturi</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRedirectUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthorizationCodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthorizationCodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthorizationCodePropertiesProperty> {
            java.lang.String authorizationCode;
            java.lang.String redirectUri;

            /**
             * Sets the value of {@link AuthorizationCodePropertiesProperty#getAuthorizationCode}
             * @param authorizationCode An authorization code to be used in the third leg of the <code>AUTHORIZATION_CODE</code> grant workflow.
             *                          This is a single-use code which becomes invalid once exchanged for an access token, thus it is acceptable to have this value as a request parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationCode(java.lang.String authorizationCode) {
                this.authorizationCode = authorizationCode;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizationCodePropertiesProperty#getRedirectUri}
             * @param redirectUri The redirect URI where the user gets redirected to by authorization server when issuing an authorization code.
             *                    The URI is subsequently used when the authorization code is exchanged for an access token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectUri(java.lang.String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthorizationCodePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthorizationCodePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthorizationCodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizationCodePropertiesProperty {
            private final java.lang.String authorizationCode;
            private final java.lang.String redirectUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationCode = software.amazon.jsii.Kernel.get(this, "authorizationCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.redirectUri = software.amazon.jsii.Kernel.get(this, "redirectUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationCode = builder.authorizationCode;
                this.redirectUri = builder.redirectUri;
            }

            @Override
            public final java.lang.String getAuthorizationCode() {
                return this.authorizationCode;
            }

            @Override
            public final java.lang.String getRedirectUri() {
                return this.redirectUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthorizationCode() != null) {
                    data.set("authorizationCode", om.valueToTree(this.getAuthorizationCode()));
                }
                if (this.getRedirectUri() != null) {
                    data.set("redirectUri", om.valueToTree(this.getRedirectUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnConnection.AuthorizationCodePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthorizationCodePropertiesProperty.Jsii$Proxy that = (AuthorizationCodePropertiesProperty.Jsii$Proxy) o;

                if (this.authorizationCode != null ? !this.authorizationCode.equals(that.authorizationCode) : that.authorizationCode != null) return false;
                return this.redirectUri != null ? this.redirectUri.equals(that.redirectUri) : that.redirectUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizationCode != null ? this.authorizationCode.hashCode() : 0;
                result = 31 * result + (this.redirectUri != null ? this.redirectUri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * For supplying basic auth credentials when not providing a <code>SecretArn</code> value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * BasicAuthenticationCredentialsProperty basicAuthenticationCredentialsProperty = BasicAuthenticationCredentialsProperty.builder()
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-basicauthenticationcredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-basicauthenticationcredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection.BasicAuthenticationCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(BasicAuthenticationCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BasicAuthenticationCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password to connect to the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-basicauthenticationcredentials.html#cfn-glue-connection-basicauthenticationcredentials-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-basicauthenticationcredentials.html#cfn-glue-connection-basicauthenticationcredentials-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * The username to connect to the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-basicauthenticationcredentials.html#cfn-glue-connection-basicauthenticationcredentials-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-basicauthenticationcredentials.html#cfn-glue-connection-basicauthenticationcredentials-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BasicAuthenticationCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BasicAuthenticationCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BasicAuthenticationCredentialsProperty> {
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link BasicAuthenticationCredentialsProperty#getPassword}
             * @param password The password to connect to the data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link BasicAuthenticationCredentialsProperty#getUsername}
             * @param username The username to connect to the data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BasicAuthenticationCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BasicAuthenticationCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BasicAuthenticationCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicAuthenticationCredentialsProperty {
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = builder.password;
                this.username = builder.username;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnConnection.BasicAuthenticationCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BasicAuthenticationCredentialsProperty.Jsii$Proxy that = (BasicAuthenticationCredentialsProperty.Jsii$Proxy) o;

                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.password != null ? this.password.hashCode() : 0;
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that is used to specify a connection to create or update.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * Object athenaProperties;
     * Object connectionProperties;
     * Object customAuthenticationCredentials;
     * Object pythonProperties;
     * Object sparkProperties;
     * Object tokenUrlParametersMap;
     * ConnectionInputProperty connectionInputProperty = ConnectionInputProperty.builder()
     *         .connectionType("connectionType")
     *         // the properties below are optional
     *         .athenaProperties(athenaProperties)
     *         .authenticationConfiguration(AuthenticationConfigurationInputProperty.builder()
     *                 .authenticationType("authenticationType")
     *                 // the properties below are optional
     *                 .basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty.builder()
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .customAuthenticationCredentials(customAuthenticationCredentials)
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .oAuth2Properties(OAuth2PropertiesInputProperty.builder()
     *                         .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
     *                                 .authorizationCode("authorizationCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
     *                                 .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
     *                                 .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
     *                                 .build())
     *                         .oAuth2Credentials(OAuth2CredentialsProperty.builder()
     *                                 .accessToken("accessToken")
     *                                 .jwtToken("jwtToken")
     *                                 .refreshToken("refreshToken")
     *                                 .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
     *                                 .build())
     *                         .oAuth2GrantType("oAuth2GrantType")
     *                         .tokenUrl("tokenUrl")
     *                         .tokenUrlParametersMap(tokenUrlParametersMap)
     *                         .build())
     *                 .secretArn("secretArn")
     *                 .build())
     *         .connectionProperties(connectionProperties)
     *         .description("description")
     *         .matchCriteria(List.of("matchCriteria"))
     *         .name("name")
     *         .physicalConnectionRequirements(PhysicalConnectionRequirementsProperty.builder()
     *                 .availabilityZone("availabilityZone")
     *                 .securityGroupIdList(List.of("securityGroupIdList"))
     *                 .subnetId("subnetId")
     *                 .build())
     *         .pythonProperties(pythonProperties)
     *         .sparkProperties(sparkProperties)
     *         .validateCredentials(false)
     *         .validateForComputeEnvironments(List.of("validateForComputeEnvironments"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection.ConnectionInputProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectionInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of the connection. Currently, these types are supported:.
         * <p>
         * <ul>
         * <li><code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).</li>
         * </ul>
         * <p>
         * <code>JDBC</code> Connections use the following ConnectionParameters.
         * <p>
         * <ul>
         * <li>Required: All of ( <code>HOST</code> , <code>PORT</code> , <code>JDBC_ENGINE</code> ) or <code>JDBC_CONNECTION_URL</code> .</li>
         * <li>Required: All of ( <code>USERNAME</code> , <code>PASSWORD</code> ) or <code>SECRET_ID</code> .</li>
         * <li>Optional: <code>JDBC_ENFORCE_SSL</code> , <code>CUSTOM_JDBC_CERT</code> , <code>CUSTOM_JDBC_CERT_STRING</code> , <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> . These parameters are used to configure SSL with JDBC.</li>
         * <li><code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.</li>
         * </ul>
         * <p>
         * <code>KAFKA</code> Connections use the following ConnectionParameters.
         * <p>
         * <ul>
         * <li>Required: <code>KAFKA_BOOTSTRAP_SERVERS</code> .</li>
         * <li>Optional: <code>KAFKA_SSL_ENABLED</code> , <code>KAFKA_CUSTOM_CERT</code> , <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> . These parameters are used to configure SSL with <code>KAFKA</code> .</li>
         * <li>Optional: <code>KAFKA_CLIENT_KEYSTORE</code> , <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> , <code>KAFKA_CLIENT_KEY_PASSWORD</code> , <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> , <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> . These parameters are used to configure TLS client configuration with SSL in <code>KAFKA</code> .</li>
         * <li>Optional: <code>KAFKA_SASL_MECHANISM</code> . Can be specified as <code>SCRAM-SHA-512</code> , <code>GSSAPI</code> , or <code>AWS_MSK_IAM</code> .</li>
         * <li>Optional: <code>KAFKA_SASL_SCRAM_USERNAME</code> , <code>KAFKA_SASL_SCRAM_PASSWORD</code> , <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code> . These parameters are used to configure SASL/SCRAM-SHA-512 authentication with <code>KAFKA</code> .</li>
         * <li>Optional: <code>KAFKA_SASL_GSSAPI_KEYTAB</code> , <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code> , <code>KAFKA_SASL_GSSAPI_SERVICE</code> , <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code> . These parameters are used to configure SASL/GSSAPI authentication with <code>KAFKA</code> .</li>
         * <li><code>MONGODB</code> - Designates a connection to a MongoDB document database.</li>
         * </ul>
         * <p>
         * <code>MONGODB</code> Connections use the following ConnectionParameters.
         * <p>
         * <ul>
         * <li>Required: <code>CONNECTION_URL</code> .</li>
         * <li>Required: All of ( <code>USERNAME</code> , <code>PASSWORD</code> ) or <code>SECRET_ID</code> .</li>
         * <li><code>VIEW_VALIDATION_REDSHIFT</code> - Designates a connection used for view validation by Amazon Redshift.</li>
         * <li><code>VIEW_VALIDATION_ATHENA</code> - Designates a connection used for view validation by Amazon Athena.</li>
         * <li><code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).</li>
         * </ul>
         * <p>
         * <code>NETWORK</code> Connections do not require ConnectionParameters. Instead, provide a PhysicalConnectionRequirements.
         * <p>
         * <ul>
         * <li><code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from AWS Marketplace to read from and write to data stores that are not natively supported by AWS Glue .</li>
         * </ul>
         * <p>
         * <code>MARKETPLACE</code> Connections use the following ConnectionParameters.
         * <p>
         * <ul>
         * <li>Required: <code>CONNECTOR_TYPE</code> , <code>CONNECTOR_URL</code> , <code>CONNECTOR_CLASS_NAME</code> , <code>CONNECTION_URL</code> .</li>
         * <li>Required for <code>JDBC</code> <code>CONNECTOR_TYPE</code> connections: All of ( <code>USERNAME</code> , <code>PASSWORD</code> ) or <code>SECRET_ID</code> .</li>
         * <li><code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to data stores that are not natively supported by AWS Glue .</li>
         * </ul>
         * <p>
         * Additionally, a <code>ConnectionType</code> for the following SaaS connectors is supported:
         * <p>
         * <ul>
         * <li><code>FACEBOOKADS</code> - Designates a connection to Facebook Ads.</li>
         * <li><code>GOOGLEADS</code> - Designates a connection to Google Ads.</li>
         * <li><code>GOOGLESHEETS</code> - Designates a connection to Google Sheets.</li>
         * <li><code>GOOGLEANALYTICS4</code> - Designates a connection to Google Analytics 4.</li>
         * <li><code>HUBSPOT</code> - Designates a connection to HubSpot.</li>
         * <li><code>INSTAGRAMADS</code> - Designates a connection to Instagram Ads.</li>
         * <li><code>INTERCOM</code> - Designates a connection to Intercom.</li>
         * <li><code>JIRACLOUD</code> - Designates a connection to Jira Cloud.</li>
         * <li><code>MARKETO</code> - Designates a connection to Adobe Marketo Engage.</li>
         * <li><code>NETSUITEERP</code> - Designates a connection to Oracle NetSuite.</li>
         * <li><code>SALESFORCE</code> - Designates a connection to Salesforce using OAuth authentication.</li>
         * <li><code>SALESFORCEMARKETINGCLOUD</code> - Designates a connection to Salesforce Marketing Cloud.</li>
         * <li><code>SALESFORCEPARDOT</code> - Designates a connection to Salesforce Marketing Cloud Account Engagement (MCAE).</li>
         * <li><code>SAPODATA</code> - Designates a connection to SAP OData.</li>
         * <li><code>SERVICENOW</code> - Designates a connection to ServiceNow.</li>
         * <li><code>SLACK</code> - Designates a connection to Slack.</li>
         * <li><code>SNAPCHATADS</code> - Designates a connection to Snapchat Ads.</li>
         * <li><code>STRIPE</code> - Designates a connection to Stripe.</li>
         * <li><code>ZENDESK</code> - Designates a connection to Zendesk.</li>
         * <li><code>ZOHOCRM</code> - Designates a connection to Zoho CRM.</li>
         * </ul>
         * <p>
         * For more information on the connection parameters needed for a particular connector, see the documentation for the connector in <a href="https://docs.aws.amazon.com/glue/latest/dg/console-connections.html">Adding an AWS Glue connection</a> in the AWS Glue User Guide.
         * <p>
         * <code>SFTP</code> is not supported.
         * <p>
         * For more information about how optional ConnectionProperties are used to configure features in AWS Glue , consult <a href="https://docs.aws.amazon.com/glue/latest/dg/connection-defining.html">AWS Glue connection properties</a> .
         * <p>
         * For more information about how optional ConnectionProperties are used to configure features in AWS Glue Studio, consult <a href="https://docs.aws.amazon.com/glue/latest/ug/connectors-chapter.html">Using connectors and connections</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-connectiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-connectiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectionType();

        /**
         * Connection properties specific to the Athena compute environment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-athenaproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-athenaproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAthenaProperties() {
            return null;
        }

        /**
         * The authentication properties of the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-authenticationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-authenticationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationConfiguration() {
            return null;
        }

        /**
         * These key-value pairs define parameters for the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-connectionproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-connectionproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectionProperties() {
            return null;
        }

        /**
         * The description of the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * A list of criteria that can be used in selecting this connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-matchcriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-matchcriteria</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchCriteria() {
            return null;
        }

        /**
         * The name of the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code> , that are needed to successfully make this connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-physicalconnectionrequirements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-physicalconnectionrequirements</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPhysicalConnectionRequirements() {
            return null;
        }

        /**
         * Connection properties specific to the Python compute environment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-pythonproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-pythonproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPythonProperties() {
            return null;
        }

        /**
         * Connection properties specific to the Spark compute environment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-sparkproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-sparkproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSparkProperties() {
            return null;
        }

        /**
         * A flag to validate the credentials during create connection.
         * <p>
         * Default is true.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-validatecredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-validatecredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValidateCredentials() {
            return null;
        }

        /**
         * The compute environments that the specified connection properties are validated against.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-validateforcomputeenvironments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-validateforcomputeenvironments</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValidateForComputeEnvironments() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectionInputProperty> {
            java.lang.String connectionType;
            java.lang.Object athenaProperties;
            java.lang.Object authenticationConfiguration;
            java.lang.Object connectionProperties;
            java.lang.String description;
            java.util.List<java.lang.String> matchCriteria;
            java.lang.String name;
            java.lang.Object physicalConnectionRequirements;
            java.lang.Object pythonProperties;
            java.lang.Object sparkProperties;
            java.lang.Object validateCredentials;
            java.util.List<java.lang.String> validateForComputeEnvironments;

            /**
             * Sets the value of {@link ConnectionInputProperty#getConnectionType}
             * @param connectionType The type of the connection. Currently, these types are supported:. This parameter is required.
             *                       <ul>
             *                       <li><code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).</li>
             *                       </ul>
             *                       <p>
             *                       <code>JDBC</code> Connections use the following ConnectionParameters.
             *                       <p>
             *                       <ul>
             *                       <li>Required: All of ( <code>HOST</code> , <code>PORT</code> , <code>JDBC_ENGINE</code> ) or <code>JDBC_CONNECTION_URL</code> .</li>
             *                       <li>Required: All of ( <code>USERNAME</code> , <code>PASSWORD</code> ) or <code>SECRET_ID</code> .</li>
             *                       <li>Optional: <code>JDBC_ENFORCE_SSL</code> , <code>CUSTOM_JDBC_CERT</code> , <code>CUSTOM_JDBC_CERT_STRING</code> , <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> . These parameters are used to configure SSL with JDBC.</li>
             *                       <li><code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.</li>
             *                       </ul>
             *                       <p>
             *                       <code>KAFKA</code> Connections use the following ConnectionParameters.
             *                       <p>
             *                       <ul>
             *                       <li>Required: <code>KAFKA_BOOTSTRAP_SERVERS</code> .</li>
             *                       <li>Optional: <code>KAFKA_SSL_ENABLED</code> , <code>KAFKA_CUSTOM_CERT</code> , <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> . These parameters are used to configure SSL with <code>KAFKA</code> .</li>
             *                       <li>Optional: <code>KAFKA_CLIENT_KEYSTORE</code> , <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> , <code>KAFKA_CLIENT_KEY_PASSWORD</code> , <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> , <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> . These parameters are used to configure TLS client configuration with SSL in <code>KAFKA</code> .</li>
             *                       <li>Optional: <code>KAFKA_SASL_MECHANISM</code> . Can be specified as <code>SCRAM-SHA-512</code> , <code>GSSAPI</code> , or <code>AWS_MSK_IAM</code> .</li>
             *                       <li>Optional: <code>KAFKA_SASL_SCRAM_USERNAME</code> , <code>KAFKA_SASL_SCRAM_PASSWORD</code> , <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code> . These parameters are used to configure SASL/SCRAM-SHA-512 authentication with <code>KAFKA</code> .</li>
             *                       <li>Optional: <code>KAFKA_SASL_GSSAPI_KEYTAB</code> , <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code> , <code>KAFKA_SASL_GSSAPI_SERVICE</code> , <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code> . These parameters are used to configure SASL/GSSAPI authentication with <code>KAFKA</code> .</li>
             *                       <li><code>MONGODB</code> - Designates a connection to a MongoDB document database.</li>
             *                       </ul>
             *                       <p>
             *                       <code>MONGODB</code> Connections use the following ConnectionParameters.
             *                       <p>
             *                       <ul>
             *                       <li>Required: <code>CONNECTION_URL</code> .</li>
             *                       <li>Required: All of ( <code>USERNAME</code> , <code>PASSWORD</code> ) or <code>SECRET_ID</code> .</li>
             *                       <li><code>VIEW_VALIDATION_REDSHIFT</code> - Designates a connection used for view validation by Amazon Redshift.</li>
             *                       <li><code>VIEW_VALIDATION_ATHENA</code> - Designates a connection used for view validation by Amazon Athena.</li>
             *                       <li><code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).</li>
             *                       </ul>
             *                       <p>
             *                       <code>NETWORK</code> Connections do not require ConnectionParameters. Instead, provide a PhysicalConnectionRequirements.
             *                       <p>
             *                       <ul>
             *                       <li><code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from AWS Marketplace to read from and write to data stores that are not natively supported by AWS Glue .</li>
             *                       </ul>
             *                       <p>
             *                       <code>MARKETPLACE</code> Connections use the following ConnectionParameters.
             *                       <p>
             *                       <ul>
             *                       <li>Required: <code>CONNECTOR_TYPE</code> , <code>CONNECTOR_URL</code> , <code>CONNECTOR_CLASS_NAME</code> , <code>CONNECTION_URL</code> .</li>
             *                       <li>Required for <code>JDBC</code> <code>CONNECTOR_TYPE</code> connections: All of ( <code>USERNAME</code> , <code>PASSWORD</code> ) or <code>SECRET_ID</code> .</li>
             *                       <li><code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to data stores that are not natively supported by AWS Glue .</li>
             *                       </ul>
             *                       <p>
             *                       Additionally, a <code>ConnectionType</code> for the following SaaS connectors is supported:
             *                       <p>
             *                       <ul>
             *                       <li><code>FACEBOOKADS</code> - Designates a connection to Facebook Ads.</li>
             *                       <li><code>GOOGLEADS</code> - Designates a connection to Google Ads.</li>
             *                       <li><code>GOOGLESHEETS</code> - Designates a connection to Google Sheets.</li>
             *                       <li><code>GOOGLEANALYTICS4</code> - Designates a connection to Google Analytics 4.</li>
             *                       <li><code>HUBSPOT</code> - Designates a connection to HubSpot.</li>
             *                       <li><code>INSTAGRAMADS</code> - Designates a connection to Instagram Ads.</li>
             *                       <li><code>INTERCOM</code> - Designates a connection to Intercom.</li>
             *                       <li><code>JIRACLOUD</code> - Designates a connection to Jira Cloud.</li>
             *                       <li><code>MARKETO</code> - Designates a connection to Adobe Marketo Engage.</li>
             *                       <li><code>NETSUITEERP</code> - Designates a connection to Oracle NetSuite.</li>
             *                       <li><code>SALESFORCE</code> - Designates a connection to Salesforce using OAuth authentication.</li>
             *                       <li><code>SALESFORCEMARKETINGCLOUD</code> - Designates a connection to Salesforce Marketing Cloud.</li>
             *                       <li><code>SALESFORCEPARDOT</code> - Designates a connection to Salesforce Marketing Cloud Account Engagement (MCAE).</li>
             *                       <li><code>SAPODATA</code> - Designates a connection to SAP OData.</li>
             *                       <li><code>SERVICENOW</code> - Designates a connection to ServiceNow.</li>
             *                       <li><code>SLACK</code> - Designates a connection to Slack.</li>
             *                       <li><code>SNAPCHATADS</code> - Designates a connection to Snapchat Ads.</li>
             *                       <li><code>STRIPE</code> - Designates a connection to Stripe.</li>
             *                       <li><code>ZENDESK</code> - Designates a connection to Zendesk.</li>
             *                       <li><code>ZOHOCRM</code> - Designates a connection to Zoho CRM.</li>
             *                       </ul>
             *                       <p>
             *                       For more information on the connection parameters needed for a particular connector, see the documentation for the connector in <a href="https://docs.aws.amazon.com/glue/latest/dg/console-connections.html">Adding an AWS Glue connection</a> in the AWS Glue User Guide.
             *                       <p>
             *                       <code>SFTP</code> is not supported.
             *                       <p>
             *                       For more information about how optional ConnectionProperties are used to configure features in AWS Glue , consult <a href="https://docs.aws.amazon.com/glue/latest/dg/connection-defining.html">AWS Glue connection properties</a> .
             *                       <p>
             *                       For more information about how optional ConnectionProperties are used to configure features in AWS Glue Studio, consult <a href="https://docs.aws.amazon.com/glue/latest/ug/connectors-chapter.html">Using connectors and connections</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionType(java.lang.String connectionType) {
                this.connectionType = connectionType;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getAthenaProperties}
             * @param athenaProperties Connection properties specific to the Athena compute environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder athenaProperties(java.lang.Object athenaProperties) {
                this.athenaProperties = athenaProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration The authentication properties of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.IResolvable authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration The authentication properties of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.services.glue.CfnConnection.AuthenticationConfigurationInputProperty authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getConnectionProperties}
             * @param connectionProperties These key-value pairs define parameters for the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionProperties(java.lang.Object connectionProperties) {
                this.connectionProperties = connectionProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getDescription}
             * @param description The description of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getMatchCriteria}
             * @param matchCriteria A list of criteria that can be used in selecting this connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchCriteria(java.util.List<java.lang.String> matchCriteria) {
                this.matchCriteria = matchCriteria;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getName}
             * @param name The name of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getPhysicalConnectionRequirements}
             * @param physicalConnectionRequirements The physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code> , that are needed to successfully make this connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalConnectionRequirements(software.amazon.awscdk.IResolvable physicalConnectionRequirements) {
                this.physicalConnectionRequirements = physicalConnectionRequirements;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getPhysicalConnectionRequirements}
             * @param physicalConnectionRequirements The physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code> , that are needed to successfully make this connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalConnectionRequirements(software.amazon.awscdk.services.glue.CfnConnection.PhysicalConnectionRequirementsProperty physicalConnectionRequirements) {
                this.physicalConnectionRequirements = physicalConnectionRequirements;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getPythonProperties}
             * @param pythonProperties Connection properties specific to the Python compute environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pythonProperties(java.lang.Object pythonProperties) {
                this.pythonProperties = pythonProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getSparkProperties}
             * @param sparkProperties Connection properties specific to the Spark compute environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sparkProperties(java.lang.Object sparkProperties) {
                this.sparkProperties = sparkProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getValidateCredentials}
             * @param validateCredentials A flag to validate the credentials during create connection.
             *                            Default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateCredentials(java.lang.Boolean validateCredentials) {
                this.validateCredentials = validateCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getValidateCredentials}
             * @param validateCredentials A flag to validate the credentials during create connection.
             *                            Default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateCredentials(software.amazon.awscdk.IResolvable validateCredentials) {
                this.validateCredentials = validateCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getValidateForComputeEnvironments}
             * @param validateForComputeEnvironments The compute environments that the specified connection properties are validated against.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateForComputeEnvironments(java.util.List<java.lang.String> validateForComputeEnvironments) {
                this.validateForComputeEnvironments = validateForComputeEnvironments;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectionInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionInputProperty {
            private final java.lang.String connectionType;
            private final java.lang.Object athenaProperties;
            private final java.lang.Object authenticationConfiguration;
            private final java.lang.Object connectionProperties;
            private final java.lang.String description;
            private final java.util.List<java.lang.String> matchCriteria;
            private final java.lang.String name;
            private final java.lang.Object physicalConnectionRequirements;
            private final java.lang.Object pythonProperties;
            private final java.lang.Object sparkProperties;
            private final java.lang.Object validateCredentials;
            private final java.util.List<java.lang.String> validateForComputeEnvironments;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.athenaProperties = software.amazon.jsii.Kernel.get(this, "athenaProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.authenticationConfiguration = software.amazon.jsii.Kernel.get(this, "authenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectionProperties = software.amazon.jsii.Kernel.get(this, "connectionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.matchCriteria = software.amazon.jsii.Kernel.get(this, "matchCriteria", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.physicalConnectionRequirements = software.amazon.jsii.Kernel.get(this, "physicalConnectionRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pythonProperties = software.amazon.jsii.Kernel.get(this, "pythonProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sparkProperties = software.amazon.jsii.Kernel.get(this, "sparkProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.validateCredentials = software.amazon.jsii.Kernel.get(this, "validateCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.validateForComputeEnvironments = software.amazon.jsii.Kernel.get(this, "validateForComputeEnvironments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionType = java.util.Objects.requireNonNull(builder.connectionType, "connectionType is required");
                this.athenaProperties = builder.athenaProperties;
                this.authenticationConfiguration = builder.authenticationConfiguration;
                this.connectionProperties = builder.connectionProperties;
                this.description = builder.description;
                this.matchCriteria = builder.matchCriteria;
                this.name = builder.name;
                this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
                this.pythonProperties = builder.pythonProperties;
                this.sparkProperties = builder.sparkProperties;
                this.validateCredentials = builder.validateCredentials;
                this.validateForComputeEnvironments = builder.validateForComputeEnvironments;
            }

            @Override
            public final java.lang.String getConnectionType() {
                return this.connectionType;
            }

            @Override
            public final java.lang.Object getAthenaProperties() {
                return this.athenaProperties;
            }

            @Override
            public final java.lang.Object getAuthenticationConfiguration() {
                return this.authenticationConfiguration;
            }

            @Override
            public final java.lang.Object getConnectionProperties() {
                return this.connectionProperties;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchCriteria() {
                return this.matchCriteria;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getPhysicalConnectionRequirements() {
                return this.physicalConnectionRequirements;
            }

            @Override
            public final java.lang.Object getPythonProperties() {
                return this.pythonProperties;
            }

            @Override
            public final java.lang.Object getSparkProperties() {
                return this.sparkProperties;
            }

            @Override
            public final java.lang.Object getValidateCredentials() {
                return this.validateCredentials;
            }

            @Override
            public final java.util.List<java.lang.String> getValidateForComputeEnvironments() {
                return this.validateForComputeEnvironments;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectionType", om.valueToTree(this.getConnectionType()));
                if (this.getAthenaProperties() != null) {
                    data.set("athenaProperties", om.valueToTree(this.getAthenaProperties()));
                }
                if (this.getAuthenticationConfiguration() != null) {
                    data.set("authenticationConfiguration", om.valueToTree(this.getAuthenticationConfiguration()));
                }
                if (this.getConnectionProperties() != null) {
                    data.set("connectionProperties", om.valueToTree(this.getConnectionProperties()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getMatchCriteria() != null) {
                    data.set("matchCriteria", om.valueToTree(this.getMatchCriteria()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getPhysicalConnectionRequirements() != null) {
                    data.set("physicalConnectionRequirements", om.valueToTree(this.getPhysicalConnectionRequirements()));
                }
                if (this.getPythonProperties() != null) {
                    data.set("pythonProperties", om.valueToTree(this.getPythonProperties()));
                }
                if (this.getSparkProperties() != null) {
                    data.set("sparkProperties", om.valueToTree(this.getSparkProperties()));
                }
                if (this.getValidateCredentials() != null) {
                    data.set("validateCredentials", om.valueToTree(this.getValidateCredentials()));
                }
                if (this.getValidateForComputeEnvironments() != null) {
                    data.set("validateForComputeEnvironments", om.valueToTree(this.getValidateForComputeEnvironments()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnConnection.ConnectionInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionInputProperty.Jsii$Proxy that = (ConnectionInputProperty.Jsii$Proxy) o;

                if (!connectionType.equals(that.connectionType)) return false;
                if (this.athenaProperties != null ? !this.athenaProperties.equals(that.athenaProperties) : that.athenaProperties != null) return false;
                if (this.authenticationConfiguration != null ? !this.authenticationConfiguration.equals(that.authenticationConfiguration) : that.authenticationConfiguration != null) return false;
                if (this.connectionProperties != null ? !this.connectionProperties.equals(that.connectionProperties) : that.connectionProperties != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.matchCriteria != null ? !this.matchCriteria.equals(that.matchCriteria) : that.matchCriteria != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.physicalConnectionRequirements != null ? !this.physicalConnectionRequirements.equals(that.physicalConnectionRequirements) : that.physicalConnectionRequirements != null) return false;
                if (this.pythonProperties != null ? !this.pythonProperties.equals(that.pythonProperties) : that.pythonProperties != null) return false;
                if (this.sparkProperties != null ? !this.sparkProperties.equals(that.sparkProperties) : that.sparkProperties != null) return false;
                if (this.validateCredentials != null ? !this.validateCredentials.equals(that.validateCredentials) : that.validateCredentials != null) return false;
                return this.validateForComputeEnvironments != null ? this.validateForComputeEnvironments.equals(that.validateForComputeEnvironments) : that.validateForComputeEnvironments == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionType.hashCode();
                result = 31 * result + (this.athenaProperties != null ? this.athenaProperties.hashCode() : 0);
                result = 31 * result + (this.authenticationConfiguration != null ? this.authenticationConfiguration.hashCode() : 0);
                result = 31 * result + (this.connectionProperties != null ? this.connectionProperties.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.matchCriteria != null ? this.matchCriteria.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.physicalConnectionRequirements != null ? this.physicalConnectionRequirements.hashCode() : 0);
                result = 31 * result + (this.pythonProperties != null ? this.pythonProperties.hashCode() : 0);
                result = 31 * result + (this.sparkProperties != null ? this.sparkProperties.hashCode() : 0);
                result = 31 * result + (this.validateCredentials != null ? this.validateCredentials.hashCode() : 0);
                result = 31 * result + (this.validateForComputeEnvironments != null ? this.validateForComputeEnvironments.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The OAuth2 client app used for the connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * OAuth2ClientApplicationProperty oAuth2ClientApplicationProperty = OAuth2ClientApplicationProperty.builder()
     *         .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
     *         .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2clientapplication.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2clientapplication.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection.OAuth2ClientApplicationProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuth2ClientApplicationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuth2ClientApplicationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The reference to the SaaS-side client app that is AWS managed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2clientapplication.html#cfn-glue-connection-oauth2clientapplication-awsmanagedclientapplicationreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2clientapplication.html#cfn-glue-connection-oauth2clientapplication-awsmanagedclientapplicationreference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsManagedClientApplicationReference() {
            return null;
        }

        /**
         * The client application clientID if the ClientAppType is <code>USER_MANAGED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2clientapplication.html#cfn-glue-connection-oauth2clientapplication-usermanagedclientapplicationclientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2clientapplication.html#cfn-glue-connection-oauth2clientapplication-usermanagedclientapplicationclientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserManagedClientApplicationClientId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuth2ClientApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuth2ClientApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuth2ClientApplicationProperty> {
            java.lang.String awsManagedClientApplicationReference;
            java.lang.String userManagedClientApplicationClientId;

            /**
             * Sets the value of {@link OAuth2ClientApplicationProperty#getAwsManagedClientApplicationReference}
             * @param awsManagedClientApplicationReference The reference to the SaaS-side client app that is AWS managed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsManagedClientApplicationReference(java.lang.String awsManagedClientApplicationReference) {
                this.awsManagedClientApplicationReference = awsManagedClientApplicationReference;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2ClientApplicationProperty#getUserManagedClientApplicationClientId}
             * @param userManagedClientApplicationClientId The client application clientID if the ClientAppType is <code>USER_MANAGED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userManagedClientApplicationClientId(java.lang.String userManagedClientApplicationClientId) {
                this.userManagedClientApplicationClientId = userManagedClientApplicationClientId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuth2ClientApplicationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuth2ClientApplicationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuth2ClientApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuth2ClientApplicationProperty {
            private final java.lang.String awsManagedClientApplicationReference;
            private final java.lang.String userManagedClientApplicationClientId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsManagedClientApplicationReference = software.amazon.jsii.Kernel.get(this, "awsManagedClientApplicationReference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userManagedClientApplicationClientId = software.amazon.jsii.Kernel.get(this, "userManagedClientApplicationClientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsManagedClientApplicationReference = builder.awsManagedClientApplicationReference;
                this.userManagedClientApplicationClientId = builder.userManagedClientApplicationClientId;
            }

            @Override
            public final java.lang.String getAwsManagedClientApplicationReference() {
                return this.awsManagedClientApplicationReference;
            }

            @Override
            public final java.lang.String getUserManagedClientApplicationClientId() {
                return this.userManagedClientApplicationClientId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsManagedClientApplicationReference() != null) {
                    data.set("awsManagedClientApplicationReference", om.valueToTree(this.getAwsManagedClientApplicationReference()));
                }
                if (this.getUserManagedClientApplicationClientId() != null) {
                    data.set("userManagedClientApplicationClientId", om.valueToTree(this.getUserManagedClientApplicationClientId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnConnection.OAuth2ClientApplicationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuth2ClientApplicationProperty.Jsii$Proxy that = (OAuth2ClientApplicationProperty.Jsii$Proxy) o;

                if (this.awsManagedClientApplicationReference != null ? !this.awsManagedClientApplicationReference.equals(that.awsManagedClientApplicationReference) : that.awsManagedClientApplicationReference != null) return false;
                return this.userManagedClientApplicationClientId != null ? this.userManagedClientApplicationClientId.equals(that.userManagedClientApplicationClientId) : that.userManagedClientApplicationClientId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsManagedClientApplicationReference != null ? this.awsManagedClientApplicationReference.hashCode() : 0;
                result = 31 * result + (this.userManagedClientApplicationClientId != null ? this.userManagedClientApplicationClientId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The credentials used when the authentication type is OAuth2 authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * OAuth2CredentialsProperty oAuth2CredentialsProperty = OAuth2CredentialsProperty.builder()
     *         .accessToken("accessToken")
     *         .jwtToken("jwtToken")
     *         .refreshToken("refreshToken")
     *         .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2credentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2credentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection.OAuth2CredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuth2CredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuth2CredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The access token used when the authentication type is OAuth2.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2credentials.html#cfn-glue-connection-oauth2credentials-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2credentials.html#cfn-glue-connection-oauth2credentials-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * The JSON Web Token (JWT) used when the authentication type is OAuth2.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2credentials.html#cfn-glue-connection-oauth2credentials-jwttoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2credentials.html#cfn-glue-connection-oauth2credentials-jwttoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJwtToken() {
            return null;
        }

        /**
         * The refresh token used when the authentication type is OAuth2.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2credentials.html#cfn-glue-connection-oauth2credentials-refreshtoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2credentials.html#cfn-glue-connection-oauth2credentials-refreshtoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshToken() {
            return null;
        }

        /**
         * The client application client secret if the client application is user managed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2credentials.html#cfn-glue-connection-oauth2credentials-usermanagedclientapplicationclientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2credentials.html#cfn-glue-connection-oauth2credentials-usermanagedclientapplicationclientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserManagedClientApplicationClientSecret() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuth2CredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuth2CredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuth2CredentialsProperty> {
            java.lang.String accessToken;
            java.lang.String jwtToken;
            java.lang.String refreshToken;
            java.lang.String userManagedClientApplicationClientSecret;

            /**
             * Sets the value of {@link OAuth2CredentialsProperty#getAccessToken}
             * @param accessToken The access token used when the authentication type is OAuth2.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2CredentialsProperty#getJwtToken}
             * @param jwtToken The JSON Web Token (JWT) used when the authentication type is OAuth2.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jwtToken(java.lang.String jwtToken) {
                this.jwtToken = jwtToken;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2CredentialsProperty#getRefreshToken}
             * @param refreshToken The refresh token used when the authentication type is OAuth2.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2CredentialsProperty#getUserManagedClientApplicationClientSecret}
             * @param userManagedClientApplicationClientSecret The client application client secret if the client application is user managed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userManagedClientApplicationClientSecret(java.lang.String userManagedClientApplicationClientSecret) {
                this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuth2CredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuth2CredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuth2CredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuth2CredentialsProperty {
            private final java.lang.String accessToken;
            private final java.lang.String jwtToken;
            private final java.lang.String refreshToken;
            private final java.lang.String userManagedClientApplicationClientSecret;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.jwtToken = software.amazon.jsii.Kernel.get(this, "jwtToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userManagedClientApplicationClientSecret = software.amazon.jsii.Kernel.get(this, "userManagedClientApplicationClientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessToken = builder.accessToken;
                this.jwtToken = builder.jwtToken;
                this.refreshToken = builder.refreshToken;
                this.userManagedClientApplicationClientSecret = builder.userManagedClientApplicationClientSecret;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.String getJwtToken() {
                return this.jwtToken;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            public final java.lang.String getUserManagedClientApplicationClientSecret() {
                return this.userManagedClientApplicationClientSecret;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getJwtToken() != null) {
                    data.set("jwtToken", om.valueToTree(this.getJwtToken()));
                }
                if (this.getRefreshToken() != null) {
                    data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
                }
                if (this.getUserManagedClientApplicationClientSecret() != null) {
                    data.set("userManagedClientApplicationClientSecret", om.valueToTree(this.getUserManagedClientApplicationClientSecret()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnConnection.OAuth2CredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuth2CredentialsProperty.Jsii$Proxy that = (OAuth2CredentialsProperty.Jsii$Proxy) o;

                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                if (this.jwtToken != null ? !this.jwtToken.equals(that.jwtToken) : that.jwtToken != null) return false;
                if (this.refreshToken != null ? !this.refreshToken.equals(that.refreshToken) : that.refreshToken != null) return false;
                return this.userManagedClientApplicationClientSecret != null ? this.userManagedClientApplicationClientSecret.equals(that.userManagedClientApplicationClientSecret) : that.userManagedClientApplicationClientSecret == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessToken != null ? this.accessToken.hashCode() : 0;
                result = 31 * result + (this.jwtToken != null ? this.jwtToken.hashCode() : 0);
                result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
                result = 31 * result + (this.userManagedClientApplicationClientSecret != null ? this.userManagedClientApplicationClientSecret.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure containing properties for OAuth2 in the CreateConnection request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * Object tokenUrlParametersMap;
     * OAuth2PropertiesInputProperty oAuth2PropertiesInputProperty = OAuth2PropertiesInputProperty.builder()
     *         .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
     *                 .authorizationCode("authorizationCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
     *                 .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
     *                 .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
     *                 .build())
     *         .oAuth2Credentials(OAuth2CredentialsProperty.builder()
     *                 .accessToken("accessToken")
     *                 .jwtToken("jwtToken")
     *                 .refreshToken("refreshToken")
     *                 .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
     *                 .build())
     *         .oAuth2GrantType("oAuth2GrantType")
     *         .tokenUrl("tokenUrl")
     *         .tokenUrlParametersMap(tokenUrlParametersMap)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection.OAuth2PropertiesInputProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuth2PropertiesInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuth2PropertiesInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The set of properties required for the the OAuth2 <code>AUTHORIZATION_CODE</code> grant type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-authorizationcodeproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-authorizationcodeproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizationCodeProperties() {
            return null;
        }

        /**
         * The client application type in the CreateConnection request.
         * <p>
         * For example, <code>AWS_MANAGED</code> or <code>USER_MANAGED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-oauth2clientapplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-oauth2clientapplication</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuth2ClientApplication() {
            return null;
        }

        /**
         * The credentials used when the authentication type is OAuth2 authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-oauth2credentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-oauth2credentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuth2Credentials() {
            return null;
        }

        /**
         * The OAuth2 grant type in the CreateConnection request.
         * <p>
         * For example, <code>AUTHORIZATION_CODE</code> , <code>JWT_BEARER</code> , or <code>CLIENT_CREDENTIALS</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-oauth2granttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-oauth2granttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOAuth2GrantType() {
            return null;
        }

        /**
         * The URL of the provider's authentication server, to exchange an authorization code for an access token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-tokenurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-tokenurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTokenUrl() {
            return null;
        }

        /**
         * A map of parameters that are added to the token <code>GET</code> request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-tokenurlparametersmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-oauth2propertiesinput.html#cfn-glue-connection-oauth2propertiesinput-tokenurlparametersmap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTokenUrlParametersMap() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuth2PropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuth2PropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuth2PropertiesInputProperty> {
            java.lang.Object authorizationCodeProperties;
            java.lang.Object oAuth2ClientApplication;
            java.lang.Object oAuth2Credentials;
            java.lang.String oAuth2GrantType;
            java.lang.String tokenUrl;
            java.lang.Object tokenUrlParametersMap;

            /**
             * Sets the value of {@link OAuth2PropertiesInputProperty#getAuthorizationCodeProperties}
             * @param authorizationCodeProperties The set of properties required for the the OAuth2 <code>AUTHORIZATION_CODE</code> grant type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationCodeProperties(software.amazon.awscdk.IResolvable authorizationCodeProperties) {
                this.authorizationCodeProperties = authorizationCodeProperties;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesInputProperty#getAuthorizationCodeProperties}
             * @param authorizationCodeProperties The set of properties required for the the OAuth2 <code>AUTHORIZATION_CODE</code> grant type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationCodeProperties(software.amazon.awscdk.services.glue.CfnConnection.AuthorizationCodePropertiesProperty authorizationCodeProperties) {
                this.authorizationCodeProperties = authorizationCodeProperties;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesInputProperty#getOAuth2ClientApplication}
             * @param oAuth2ClientApplication The client application type in the CreateConnection request.
             *                                For example, <code>AWS_MANAGED</code> or <code>USER_MANAGED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2ClientApplication(software.amazon.awscdk.IResolvable oAuth2ClientApplication) {
                this.oAuth2ClientApplication = oAuth2ClientApplication;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesInputProperty#getOAuth2ClientApplication}
             * @param oAuth2ClientApplication The client application type in the CreateConnection request.
             *                                For example, <code>AWS_MANAGED</code> or <code>USER_MANAGED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2ClientApplication(software.amazon.awscdk.services.glue.CfnConnection.OAuth2ClientApplicationProperty oAuth2ClientApplication) {
                this.oAuth2ClientApplication = oAuth2ClientApplication;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesInputProperty#getOAuth2Credentials}
             * @param oAuth2Credentials The credentials used when the authentication type is OAuth2 authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Credentials(software.amazon.awscdk.IResolvable oAuth2Credentials) {
                this.oAuth2Credentials = oAuth2Credentials;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesInputProperty#getOAuth2Credentials}
             * @param oAuth2Credentials The credentials used when the authentication type is OAuth2 authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Credentials(software.amazon.awscdk.services.glue.CfnConnection.OAuth2CredentialsProperty oAuth2Credentials) {
                this.oAuth2Credentials = oAuth2Credentials;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesInputProperty#getOAuth2GrantType}
             * @param oAuth2GrantType The OAuth2 grant type in the CreateConnection request.
             *                        For example, <code>AUTHORIZATION_CODE</code> , <code>JWT_BEARER</code> , or <code>CLIENT_CREDENTIALS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2GrantType(java.lang.String oAuth2GrantType) {
                this.oAuth2GrantType = oAuth2GrantType;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesInputProperty#getTokenUrl}
             * @param tokenUrl The URL of the provider's authentication server, to exchange an authorization code for an access token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenUrl(java.lang.String tokenUrl) {
                this.tokenUrl = tokenUrl;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesInputProperty#getTokenUrlParametersMap}
             * @param tokenUrlParametersMap A map of parameters that are added to the token <code>GET</code> request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenUrlParametersMap(java.lang.Object tokenUrlParametersMap) {
                this.tokenUrlParametersMap = tokenUrlParametersMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuth2PropertiesInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuth2PropertiesInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuth2PropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuth2PropertiesInputProperty {
            private final java.lang.Object authorizationCodeProperties;
            private final java.lang.Object oAuth2ClientApplication;
            private final java.lang.Object oAuth2Credentials;
            private final java.lang.String oAuth2GrantType;
            private final java.lang.String tokenUrl;
            private final java.lang.Object tokenUrlParametersMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationCodeProperties = software.amazon.jsii.Kernel.get(this, "authorizationCodeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oAuth2ClientApplication = software.amazon.jsii.Kernel.get(this, "oAuth2ClientApplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oAuth2Credentials = software.amazon.jsii.Kernel.get(this, "oAuth2Credentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oAuth2GrantType = software.amazon.jsii.Kernel.get(this, "oAuth2GrantType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenUrl = software.amazon.jsii.Kernel.get(this, "tokenUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenUrlParametersMap = software.amazon.jsii.Kernel.get(this, "tokenUrlParametersMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationCodeProperties = builder.authorizationCodeProperties;
                this.oAuth2ClientApplication = builder.oAuth2ClientApplication;
                this.oAuth2Credentials = builder.oAuth2Credentials;
                this.oAuth2GrantType = builder.oAuth2GrantType;
                this.tokenUrl = builder.tokenUrl;
                this.tokenUrlParametersMap = builder.tokenUrlParametersMap;
            }

            @Override
            public final java.lang.Object getAuthorizationCodeProperties() {
                return this.authorizationCodeProperties;
            }

            @Override
            public final java.lang.Object getOAuth2ClientApplication() {
                return this.oAuth2ClientApplication;
            }

            @Override
            public final java.lang.Object getOAuth2Credentials() {
                return this.oAuth2Credentials;
            }

            @Override
            public final java.lang.String getOAuth2GrantType() {
                return this.oAuth2GrantType;
            }

            @Override
            public final java.lang.String getTokenUrl() {
                return this.tokenUrl;
            }

            @Override
            public final java.lang.Object getTokenUrlParametersMap() {
                return this.tokenUrlParametersMap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthorizationCodeProperties() != null) {
                    data.set("authorizationCodeProperties", om.valueToTree(this.getAuthorizationCodeProperties()));
                }
                if (this.getOAuth2ClientApplication() != null) {
                    data.set("oAuth2ClientApplication", om.valueToTree(this.getOAuth2ClientApplication()));
                }
                if (this.getOAuth2Credentials() != null) {
                    data.set("oAuth2Credentials", om.valueToTree(this.getOAuth2Credentials()));
                }
                if (this.getOAuth2GrantType() != null) {
                    data.set("oAuth2GrantType", om.valueToTree(this.getOAuth2GrantType()));
                }
                if (this.getTokenUrl() != null) {
                    data.set("tokenUrl", om.valueToTree(this.getTokenUrl()));
                }
                if (this.getTokenUrlParametersMap() != null) {
                    data.set("tokenUrlParametersMap", om.valueToTree(this.getTokenUrlParametersMap()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnConnection.OAuth2PropertiesInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuth2PropertiesInputProperty.Jsii$Proxy that = (OAuth2PropertiesInputProperty.Jsii$Proxy) o;

                if (this.authorizationCodeProperties != null ? !this.authorizationCodeProperties.equals(that.authorizationCodeProperties) : that.authorizationCodeProperties != null) return false;
                if (this.oAuth2ClientApplication != null ? !this.oAuth2ClientApplication.equals(that.oAuth2ClientApplication) : that.oAuth2ClientApplication != null) return false;
                if (this.oAuth2Credentials != null ? !this.oAuth2Credentials.equals(that.oAuth2Credentials) : that.oAuth2Credentials != null) return false;
                if (this.oAuth2GrantType != null ? !this.oAuth2GrantType.equals(that.oAuth2GrantType) : that.oAuth2GrantType != null) return false;
                if (this.tokenUrl != null ? !this.tokenUrl.equals(that.tokenUrl) : that.tokenUrl != null) return false;
                return this.tokenUrlParametersMap != null ? this.tokenUrlParametersMap.equals(that.tokenUrlParametersMap) : that.tokenUrlParametersMap == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizationCodeProperties != null ? this.authorizationCodeProperties.hashCode() : 0;
                result = 31 * result + (this.oAuth2ClientApplication != null ? this.oAuth2ClientApplication.hashCode() : 0);
                result = 31 * result + (this.oAuth2Credentials != null ? this.oAuth2Credentials.hashCode() : 0);
                result = 31 * result + (this.oAuth2GrantType != null ? this.oAuth2GrantType.hashCode() : 0);
                result = 31 * result + (this.tokenUrl != null ? this.tokenUrl.hashCode() : 0);
                result = 31 * result + (this.tokenUrlParametersMap != null ? this.tokenUrlParametersMap.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The OAuth client app in GetConnection response.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * PhysicalConnectionRequirementsProperty physicalConnectionRequirementsProperty = PhysicalConnectionRequirementsProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .securityGroupIdList(List.of("securityGroupIdList"))
     *         .subnetId("subnetId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection.PhysicalConnectionRequirementsProperty")
    @software.amazon.jsii.Jsii.Proxy(PhysicalConnectionRequirementsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PhysicalConnectionRequirementsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The connection's Availability Zone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-availabilityzone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The security group ID list used by the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-securitygroupidlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-securitygroupidlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIdList() {
            return null;
        }

        /**
         * The subnet ID used by the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-subnetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PhysicalConnectionRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PhysicalConnectionRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PhysicalConnectionRequirementsProperty> {
            java.lang.String availabilityZone;
            java.util.List<java.lang.String> securityGroupIdList;
            java.lang.String subnetId;

            /**
             * Sets the value of {@link PhysicalConnectionRequirementsProperty#getAvailabilityZone}
             * @param availabilityZone The connection's Availability Zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalConnectionRequirementsProperty#getSecurityGroupIdList}
             * @param securityGroupIdList The security group ID list used by the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIdList(java.util.List<java.lang.String> securityGroupIdList) {
                this.securityGroupIdList = securityGroupIdList;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalConnectionRequirementsProperty#getSubnetId}
             * @param subnetId The subnet ID used by the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PhysicalConnectionRequirementsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PhysicalConnectionRequirementsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PhysicalConnectionRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PhysicalConnectionRequirementsProperty {
            private final java.lang.String availabilityZone;
            private final java.util.List<java.lang.String> securityGroupIdList;
            private final java.lang.String subnetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroupIdList = software.amazon.jsii.Kernel.get(this, "securityGroupIdList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.securityGroupIdList = builder.securityGroupIdList;
                this.subnetId = builder.subnetId;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIdList() {
                return this.securityGroupIdList;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getSecurityGroupIdList() != null) {
                    data.set("securityGroupIdList", om.valueToTree(this.getSecurityGroupIdList()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnConnection.PhysicalConnectionRequirementsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PhysicalConnectionRequirementsProperty.Jsii$Proxy that = (PhysicalConnectionRequirementsProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.securityGroupIdList != null ? !this.securityGroupIdList.equals(that.securityGroupIdList) : that.securityGroupIdList != null) return false;
                return this.subnetId != null ? this.subnetId.equals(that.subnetId) : that.subnetId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.securityGroupIdList != null ? this.securityGroupIdList.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.glue.CfnConnection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.CfnConnection> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.CfnConnectionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.CfnConnectionProps.Builder();
        }

        /**
         * The ID of the data catalog to create the catalog object in.
         * <p>
         * Currently, this should be the AWS account ID.
         * <p>
         * <blockquote>
         * <p>
         * To specify the account ID, you can use the <code>Ref</code> intrinsic function with the <code>AWS::AccountId</code> pseudo parameter. For example: <code>!Ref AWS::AccountId</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-catalogid</a>
         * @param catalogId The ID of the data catalog to create the catalog object in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogId(final java.lang.String catalogId) {
            this.props.catalogId(catalogId);
            return this;
        }

        /**
         * The connection that you want to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-connectioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-connectioninput</a>
         * @param connectionInput The connection that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionInput(final software.amazon.awscdk.IResolvable connectionInput) {
            this.props.connectionInput(connectionInput);
            return this;
        }
        /**
         * The connection that you want to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-connectioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-connectioninput</a>
         * @param connectionInput The connection that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionInput(final software.amazon.awscdk.services.glue.CfnConnection.ConnectionInputProperty connectionInput) {
            this.props.connectionInput(connectionInput);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.CfnConnection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.glue.CfnConnection build() {
            return new software.amazon.awscdk.services.glue.CfnConnection(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
