package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnDevEndpoint</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object arguments_;
 * Object tags;
 * CfnDevEndpointProps cfnDevEndpointProps = CfnDevEndpointProps.builder()
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .arguments(arguments_)
 *         .endpointName("endpointName")
 *         .extraJarsS3Path("extraJarsS3Path")
 *         .extraPythonLibsS3Path("extraPythonLibsS3Path")
 *         .glueVersion("glueVersion")
 *         .numberOfNodes(123)
 *         .numberOfWorkers(123)
 *         .publicKey("publicKey")
 *         .publicKeys(List.of("publicKeys"))
 *         .securityConfiguration("securityConfiguration")
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .subnetId("subnetId")
 *         .tags(tags)
 *         .workerType("workerType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:15.173Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnDevEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnDevEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDevEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the IAM role used in this <code>DevEndpoint</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * A map of arguments used to configure the <code>DevEndpoint</code> .
     * <p>
     * Valid arguments are:
     * <p>
     * <ul>
     * <li><code>"--enable-glue-datacatalog": ""</code></li>
     * <li><code>"GLUE_PYTHON_VERSION": "3"</code></li>
     * <li><code>"GLUE_PYTHON_VERSION": "2"</code></li>
     * </ul>
     * <p>
     * You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-arguments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-arguments</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getArguments() {
        return null;
    }

    /**
     * The name of the <code>DevEndpoint</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-endpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-endpointname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointName() {
        return null;
    }

    /**
     * The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your <code>DevEndpoint</code> .
     * <p>
     * <blockquote>
     * <p>
     * You can only use pure Java/Scala libraries with a <code>DevEndpoint</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrajarss3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrajarss3path</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExtraJarsS3Path() {
        return null;
    }

    /**
     * The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your <code>DevEndpoint</code> .
     * <p>
     * Multiple values must be complete paths separated by a comma.
     * <p>
     * <blockquote>
     * <p>
     * You can only use pure Python libraries with a <code>DevEndpoint</code> . Libraries that rely on C extensions, such as the <a href="https://docs.aws.amazon.com/http://pandas.pydata.org/">pandas</a> Python data analysis library, are not currently supported.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrapythonlibss3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrapythonlibss3path</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExtraPythonLibsS3Path() {
        return null;
    }

    /**
     * The AWS Glue version determines the versions of Apache Spark and Python that AWS Glue supports.
     * <p>
     * The Python version indicates the version supported for running your ETL scripts on development endpoints.
     * <p>
     * For more information about the available AWS Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
     * <p>
     * Development endpoints that are created without specifying a Glue version default to Glue 0.9.
     * <p>
     * You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-glueversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-glueversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGlueVersion() {
        return null;
    }

    /**
     * The number of AWS Glue Data Processing Units (DPUs) allocated to this <code>DevEndpoint</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofnodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofnodes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfNodes() {
        return null;
    }

    /**
     * The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.
     * <p>
     * The maximum number of workers you can define are 299 for <code>G.1X</code> , and 149 for <code>G.2X</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofworkers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofworkers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfWorkers() {
        return null;
    }

    /**
     * The public key to be used by this <code>DevEndpoint</code> for authentication.
     * <p>
     * This attribute is provided for backward compatibility because the recommended attribute to use is public keys.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPublicKey() {
        return null;
    }

    /**
     * A list of public keys to be used by the <code>DevEndpoints</code> for authentication.
     * <p>
     * Using this attribute is preferred over a single public key because the public keys allow you to have a different private key per client.
     * <p>
     * <blockquote>
     * <p>
     * If you previously created an endpoint with a public key, you must remove that key to be able to set a list of public keys. Call the <code>UpdateDevEndpoint</code> API operation with the public key content in the <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code> attribute.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickeys</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPublicKeys() {
        return null;
    }

    /**
     * The name of the <code>SecurityConfiguration</code> structure to be used with this <code>DevEndpoint</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securityconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityConfiguration() {
        return null;
    }

    /**
     * A list of security group identifiers used in this <code>DevEndpoint</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securitygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * The subnet ID for this <code>DevEndpoint</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-subnetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
        return null;
    }

    /**
     * The tags to use with this DevEndpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * The type of predefined worker that is allocated to the development endpoint.
     * <p>
     * Accepts a value of Standard, G.1X, or G.2X.
     * <p>
     * <ul>
     * <li>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</li>
     * <li>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</li>
     * <li>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</li>
     * </ul>
     * <p>
     * Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code> configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-workertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-workertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkerType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDevEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDevEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDevEndpointProps> {
        java.lang.String roleArn;
        java.lang.Object arguments;
        java.lang.String endpointName;
        java.lang.String extraJarsS3Path;
        java.lang.String extraPythonLibsS3Path;
        java.lang.String glueVersion;
        java.lang.Number numberOfNodes;
        java.lang.Number numberOfWorkers;
        java.lang.String publicKey;
        java.util.List<java.lang.String> publicKeys;
        java.lang.String securityConfiguration;
        java.util.List<java.lang.String> securityGroupIds;
        java.lang.String subnetId;
        java.lang.Object tags;
        java.lang.String workerType;

        /**
         * Sets the value of {@link CfnDevEndpointProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role used in this <code>DevEndpoint</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getArguments}
         * @param arguments A map of arguments used to configure the <code>DevEndpoint</code> .
         *                  Valid arguments are:
         *                  <p>
         *                  <ul>
         *                  <li><code>"--enable-glue-datacatalog": ""</code></li>
         *                  <li><code>"GLUE_PYTHON_VERSION": "3"</code></li>
         *                  <li><code>"GLUE_PYTHON_VERSION": "2"</code></li>
         *                  </ul>
         *                  <p>
         *                  You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arguments(java.lang.Object arguments) {
            this.arguments = arguments;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getEndpointName}
         * @param endpointName The name of the <code>DevEndpoint</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(java.lang.String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getExtraJarsS3Path}
         * @param extraJarsS3Path The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your <code>DevEndpoint</code> .
         *                        <blockquote>
         *                        <p>
         *                        You can only use pure Java/Scala libraries with a <code>DevEndpoint</code> .
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraJarsS3Path(java.lang.String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getExtraPythonLibsS3Path}
         * @param extraPythonLibsS3Path The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your <code>DevEndpoint</code> .
         *                              Multiple values must be complete paths separated by a comma.
         *                              <p>
         *                              <blockquote>
         *                              <p>
         *                              You can only use pure Python libraries with a <code>DevEndpoint</code> . Libraries that rely on C extensions, such as the <a href="https://docs.aws.amazon.com/http://pandas.pydata.org/">pandas</a> Python data analysis library, are not currently supported.
         *                              <p>
         *                              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraPythonLibsS3Path(java.lang.String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getGlueVersion}
         * @param glueVersion The AWS Glue version determines the versions of Apache Spark and Python that AWS Glue supports.
         *                    The Python version indicates the version supported for running your ETL scripts on development endpoints.
         *                    <p>
         *                    For more information about the available AWS Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
         *                    <p>
         *                    Development endpoints that are created without specifying a Glue version default to Glue 0.9.
         *                    <p>
         *                    You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder glueVersion(java.lang.String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getNumberOfNodes}
         * @param numberOfNodes The number of AWS Glue Data Processing Units (DPUs) allocated to this <code>DevEndpoint</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberOfNodes(java.lang.Number numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getNumberOfWorkers}
         * @param numberOfWorkers The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.
         *                        The maximum number of workers you can define are 299 for <code>G.1X</code> , and 149 for <code>G.2X</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberOfWorkers(java.lang.Number numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getPublicKey}
         * @param publicKey The public key to be used by this <code>DevEndpoint</code> for authentication.
         *                  This attribute is provided for backward compatibility because the recommended attribute to use is public keys.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicKey(java.lang.String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getPublicKeys}
         * @param publicKeys A list of public keys to be used by the <code>DevEndpoints</code> for authentication.
         *                   Using this attribute is preferred over a single public key because the public keys allow you to have a different private key per client.
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   If you previously created an endpoint with a public key, you must remove that key to be able to set a list of public keys. Call the <code>UpdateDevEndpoint</code> API operation with the public key content in the <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code> attribute.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicKeys(java.util.List<java.lang.String> publicKeys) {
            this.publicKeys = publicKeys;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getSecurityConfiguration}
         * @param securityConfiguration The name of the <code>SecurityConfiguration</code> structure to be used with this <code>DevEndpoint</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfiguration(java.lang.String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getSecurityGroupIds}
         * @param securityGroupIds A list of security group identifiers used in this <code>DevEndpoint</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getSubnetId}
         * @param subnetId The subnet ID for this <code>DevEndpoint</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getTags}
         * @param tags The tags to use with this DevEndpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDevEndpointProps#getWorkerType}
         * @param workerType The type of predefined worker that is allocated to the development endpoint.
         *                   Accepts a value of Standard, G.1X, or G.2X.
         *                   <p>
         *                   <ul>
         *                   <li>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</li>
         *                   <li>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</li>
         *                   <li>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</li>
         *                   </ul>
         *                   <p>
         *                   Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code> configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerType(java.lang.String workerType) {
            this.workerType = workerType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDevEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDevEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDevEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDevEndpointProps {
        private final java.lang.String roleArn;
        private final java.lang.Object arguments;
        private final java.lang.String endpointName;
        private final java.lang.String extraJarsS3Path;
        private final java.lang.String extraPythonLibsS3Path;
        private final java.lang.String glueVersion;
        private final java.lang.Number numberOfNodes;
        private final java.lang.Number numberOfWorkers;
        private final java.lang.String publicKey;
        private final java.util.List<java.lang.String> publicKeys;
        private final java.lang.String securityConfiguration;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.String subnetId;
        private final java.lang.Object tags;
        private final java.lang.String workerType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.arguments = software.amazon.jsii.Kernel.get(this, "arguments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extraJarsS3Path = software.amazon.jsii.Kernel.get(this, "extraJarsS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extraPythonLibsS3Path = software.amazon.jsii.Kernel.get(this, "extraPythonLibsS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.glueVersion = software.amazon.jsii.Kernel.get(this, "glueVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.numberOfNodes = software.amazon.jsii.Kernel.get(this, "numberOfNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.numberOfWorkers = software.amazon.jsii.Kernel.get(this, "numberOfWorkers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.publicKey = software.amazon.jsii.Kernel.get(this, "publicKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publicKeys = software.amazon.jsii.Kernel.get(this, "publicKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.securityConfiguration = software.amazon.jsii.Kernel.get(this, "securityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.workerType = software.amazon.jsii.Kernel.get(this, "workerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.arguments = builder.arguments;
            this.endpointName = builder.endpointName;
            this.extraJarsS3Path = builder.extraJarsS3Path;
            this.extraPythonLibsS3Path = builder.extraPythonLibsS3Path;
            this.glueVersion = builder.glueVersion;
            this.numberOfNodes = builder.numberOfNodes;
            this.numberOfWorkers = builder.numberOfWorkers;
            this.publicKey = builder.publicKey;
            this.publicKeys = builder.publicKeys;
            this.securityConfiguration = builder.securityConfiguration;
            this.securityGroupIds = builder.securityGroupIds;
            this.subnetId = builder.subnetId;
            this.tags = builder.tags;
            this.workerType = builder.workerType;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getArguments() {
            return this.arguments;
        }

        @Override
        public final java.lang.String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final java.lang.String getExtraJarsS3Path() {
            return this.extraJarsS3Path;
        }

        @Override
        public final java.lang.String getExtraPythonLibsS3Path() {
            return this.extraPythonLibsS3Path;
        }

        @Override
        public final java.lang.String getGlueVersion() {
            return this.glueVersion;
        }

        @Override
        public final java.lang.Number getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final java.lang.Number getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        @Override
        public final java.lang.String getPublicKey() {
            return this.publicKey;
        }

        @Override
        public final java.util.List<java.lang.String> getPublicKeys() {
            return this.publicKeys;
        }

        @Override
        public final java.lang.String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getWorkerType() {
            return this.workerType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getArguments() != null) {
                data.set("arguments", om.valueToTree(this.getArguments()));
            }
            if (this.getEndpointName() != null) {
                data.set("endpointName", om.valueToTree(this.getEndpointName()));
            }
            if (this.getExtraJarsS3Path() != null) {
                data.set("extraJarsS3Path", om.valueToTree(this.getExtraJarsS3Path()));
            }
            if (this.getExtraPythonLibsS3Path() != null) {
                data.set("extraPythonLibsS3Path", om.valueToTree(this.getExtraPythonLibsS3Path()));
            }
            if (this.getGlueVersion() != null) {
                data.set("glueVersion", om.valueToTree(this.getGlueVersion()));
            }
            if (this.getNumberOfNodes() != null) {
                data.set("numberOfNodes", om.valueToTree(this.getNumberOfNodes()));
            }
            if (this.getNumberOfWorkers() != null) {
                data.set("numberOfWorkers", om.valueToTree(this.getNumberOfWorkers()));
            }
            if (this.getPublicKey() != null) {
                data.set("publicKey", om.valueToTree(this.getPublicKey()));
            }
            if (this.getPublicKeys() != null) {
                data.set("publicKeys", om.valueToTree(this.getPublicKeys()));
            }
            if (this.getSecurityConfiguration() != null) {
                data.set("securityConfiguration", om.valueToTree(this.getSecurityConfiguration()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSubnetId() != null) {
                data.set("subnetId", om.valueToTree(this.getSubnetId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkerType() != null) {
                data.set("workerType", om.valueToTree(this.getWorkerType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnDevEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDevEndpointProps.Jsii$Proxy that = (CfnDevEndpointProps.Jsii$Proxy) o;

            if (!roleArn.equals(that.roleArn)) return false;
            if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) return false;
            if (this.endpointName != null ? !this.endpointName.equals(that.endpointName) : that.endpointName != null) return false;
            if (this.extraJarsS3Path != null ? !this.extraJarsS3Path.equals(that.extraJarsS3Path) : that.extraJarsS3Path != null) return false;
            if (this.extraPythonLibsS3Path != null ? !this.extraPythonLibsS3Path.equals(that.extraPythonLibsS3Path) : that.extraPythonLibsS3Path != null) return false;
            if (this.glueVersion != null ? !this.glueVersion.equals(that.glueVersion) : that.glueVersion != null) return false;
            if (this.numberOfNodes != null ? !this.numberOfNodes.equals(that.numberOfNodes) : that.numberOfNodes != null) return false;
            if (this.numberOfWorkers != null ? !this.numberOfWorkers.equals(that.numberOfWorkers) : that.numberOfWorkers != null) return false;
            if (this.publicKey != null ? !this.publicKey.equals(that.publicKey) : that.publicKey != null) return false;
            if (this.publicKeys != null ? !this.publicKeys.equals(that.publicKeys) : that.publicKeys != null) return false;
            if (this.securityConfiguration != null ? !this.securityConfiguration.equals(that.securityConfiguration) : that.securityConfiguration != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.workerType != null ? this.workerType.equals(that.workerType) : that.workerType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.roleArn.hashCode();
            result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
            result = 31 * result + (this.endpointName != null ? this.endpointName.hashCode() : 0);
            result = 31 * result + (this.extraJarsS3Path != null ? this.extraJarsS3Path.hashCode() : 0);
            result = 31 * result + (this.extraPythonLibsS3Path != null ? this.extraPythonLibsS3Path.hashCode() : 0);
            result = 31 * result + (this.glueVersion != null ? this.glueVersion.hashCode() : 0);
            result = 31 * result + (this.numberOfNodes != null ? this.numberOfNodes.hashCode() : 0);
            result = 31 * result + (this.numberOfWorkers != null ? this.numberOfWorkers.hashCode() : 0);
            result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
            result = 31 * result + (this.publicKeys != null ? this.publicKeys.hashCode() : 0);
            result = 31 * result + (this.securityConfiguration != null ? this.securityConfiguration.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workerType != null ? this.workerType.hashCode() : 0);
            return result;
        }
    }
}
