package software.amazon.awscdk.services.glue;

/**
 * Creates an AWS Glue usage profile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * CfnUsageProfile cfnUsageProfile = CfnUsageProfile.Builder.create(this, "MyCfnUsageProfile")
 *         .name("name")
 *         // the properties below are optional
 *         .configuration(ProfileConfigurationProperty.builder()
 *                 .jobConfiguration(Map.of(
 *                         "jobConfigurationKey", ConfigurationObjectProperty.builder()
 *                                 .allowedValues(List.of("allowedValues"))
 *                                 .defaultValue("defaultValue")
 *                                 .maxValue("maxValue")
 *                                 .minValue("minValue")
 *                                 .build()))
 *                 .sessionConfiguration(Map.of(
 *                         "sessionConfigurationKey", ConfigurationObjectProperty.builder()
 *                                 .allowedValues(List.of("allowedValues"))
 *                                 .defaultValue("defaultValue")
 *                                 .maxValue("maxValue")
 *                                 .minValue("minValue")
 *                                 .build()))
 *                 .build())
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:15.248Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnUsageProfile")
public class CfnUsageProfile extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnUsageProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUsageProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.CfnUsageProfile.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUsageProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnUsageProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The date and time when the usage profile was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedOn() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedOn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the usage profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the usage profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnUsageProfile.ProfileConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * A description of the usage profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the usage profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The tags to be applied to this UsageProfiles.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to be applied to this UsageProfiles.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Specifies the values that an admin sets for each job or session parameter configured in a AWS Glue usage profile.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * ConfigurationObjectProperty configurationObjectProperty = ConfigurationObjectProperty.builder()
     *         .allowedValues(List.of("allowedValues"))
     *         .defaultValue("defaultValue")
     *         .maxValue("maxValue")
     *         .minValue("minValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-configurationobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-configurationobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnUsageProfile.ConfigurationObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of allowed values for the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-configurationobject.html#cfn-glue-usageprofile-configurationobject-allowedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-configurationobject.html#cfn-glue-usageprofile-configurationobject-allowedvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedValues() {
            return null;
        }

        /**
         * A default value for the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-configurationobject.html#cfn-glue-usageprofile-configurationobject-defaultvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-configurationobject.html#cfn-glue-usageprofile-configurationobject-defaultvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultValue() {
            return null;
        }

        /**
         * A maximum allowed value for the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-configurationobject.html#cfn-glue-usageprofile-configurationobject-maxvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-configurationobject.html#cfn-glue-usageprofile-configurationobject-maxvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxValue() {
            return null;
        }

        /**
         * A minimum allowed value for the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-configurationobject.html#cfn-glue-usageprofile-configurationobject-minvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-configurationobject.html#cfn-glue-usageprofile-configurationobject-minvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMinValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationObjectProperty> {
            java.util.List<java.lang.String> allowedValues;
            java.lang.String defaultValue;
            java.lang.String maxValue;
            java.lang.String minValue;

            /**
             * Sets the value of {@link ConfigurationObjectProperty#getAllowedValues}
             * @param allowedValues A list of allowed values for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedValues(java.util.List<java.lang.String> allowedValues) {
                this.allowedValues = allowedValues;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationObjectProperty#getDefaultValue}
             * @param defaultValue A default value for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationObjectProperty#getMaxValue}
             * @param maxValue A maximum allowed value for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxValue(java.lang.String maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationObjectProperty#getMinValue}
             * @param minValue A minimum allowed value for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minValue(java.lang.String minValue) {
                this.minValue = minValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationObjectProperty {
            private final java.util.List<java.lang.String> allowedValues;
            private final java.lang.String defaultValue;
            private final java.lang.String maxValue;
            private final java.lang.String minValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedValues = software.amazon.jsii.Kernel.get(this, "allowedValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxValue = software.amazon.jsii.Kernel.get(this, "maxValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minValue = software.amazon.jsii.Kernel.get(this, "minValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedValues = builder.allowedValues;
                this.defaultValue = builder.defaultValue;
                this.maxValue = builder.maxValue;
                this.minValue = builder.minValue;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedValues() {
                return this.allowedValues;
            }

            @Override
            public final java.lang.String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.String getMaxValue() {
                return this.maxValue;
            }

            @Override
            public final java.lang.String getMinValue() {
                return this.minValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowedValues() != null) {
                    data.set("allowedValues", om.valueToTree(this.getAllowedValues()));
                }
                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getMaxValue() != null) {
                    data.set("maxValue", om.valueToTree(this.getMaxValue()));
                }
                if (this.getMinValue() != null) {
                    data.set("minValue", om.valueToTree(this.getMinValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnUsageProfile.ConfigurationObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationObjectProperty.Jsii$Proxy that = (ConfigurationObjectProperty.Jsii$Proxy) o;

                if (this.allowedValues != null ? !this.allowedValues.equals(that.allowedValues) : that.allowedValues != null) return false;
                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                if (this.maxValue != null ? !this.maxValue.equals(that.maxValue) : that.maxValue != null) return false;
                return this.minValue != null ? this.minValue.equals(that.minValue) : that.minValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedValues != null ? this.allowedValues.hashCode() : 0;
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                result = 31 * result + (this.maxValue != null ? this.maxValue.hashCode() : 0);
                result = 31 * result + (this.minValue != null ? this.minValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the job and session values that an admin configures in an AWS Glue usage profile.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * ProfileConfigurationProperty profileConfigurationProperty = ProfileConfigurationProperty.builder()
     *         .jobConfiguration(Map.of(
     *                 "jobConfigurationKey", ConfigurationObjectProperty.builder()
     *                         .allowedValues(List.of("allowedValues"))
     *                         .defaultValue("defaultValue")
     *                         .maxValue("maxValue")
     *                         .minValue("minValue")
     *                         .build()))
     *         .sessionConfiguration(Map.of(
     *                 "sessionConfigurationKey", ConfigurationObjectProperty.builder()
     *                         .allowedValues(List.of("allowedValues"))
     *                         .defaultValue("defaultValue")
     *                         .maxValue("maxValue")
     *                         .minValue("minValue")
     *                         .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-profileconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-profileconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnUsageProfile.ProfileConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProfileConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProfileConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A key-value map of configuration parameters for AWS Glue jobs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-profileconfiguration.html#cfn-glue-usageprofile-profileconfiguration-jobconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-profileconfiguration.html#cfn-glue-usageprofile-profileconfiguration-jobconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJobConfiguration() {
            return null;
        }

        /**
         * A key-value map of configuration parameters for AWS Glue sessions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-profileconfiguration.html#cfn-glue-usageprofile-profileconfiguration-sessionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-usageprofile-profileconfiguration.html#cfn-glue-usageprofile-profileconfiguration-sessionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSessionConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProfileConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProfileConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProfileConfigurationProperty> {
            java.lang.Object jobConfiguration;
            java.lang.Object sessionConfiguration;

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getJobConfiguration}
             * @param jobConfiguration A key-value map of configuration parameters for AWS Glue jobs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobConfiguration(software.amazon.awscdk.IResolvable jobConfiguration) {
                this.jobConfiguration = jobConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getJobConfiguration}
             * @param jobConfiguration A key-value map of configuration parameters for AWS Glue jobs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobConfiguration(java.util.Map<java.lang.String, ? extends java.lang.Object> jobConfiguration) {
                this.jobConfiguration = jobConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getSessionConfiguration}
             * @param sessionConfiguration A key-value map of configuration parameters for AWS Glue sessions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionConfiguration(software.amazon.awscdk.IResolvable sessionConfiguration) {
                this.sessionConfiguration = sessionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getSessionConfiguration}
             * @param sessionConfiguration A key-value map of configuration parameters for AWS Glue sessions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionConfiguration(java.util.Map<java.lang.String, ? extends java.lang.Object> sessionConfiguration) {
                this.sessionConfiguration = sessionConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProfileConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProfileConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProfileConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProfileConfigurationProperty {
            private final java.lang.Object jobConfiguration;
            private final java.lang.Object sessionConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jobConfiguration = software.amazon.jsii.Kernel.get(this, "jobConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sessionConfiguration = software.amazon.jsii.Kernel.get(this, "sessionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jobConfiguration = builder.jobConfiguration;
                this.sessionConfiguration = builder.sessionConfiguration;
            }

            @Override
            public final java.lang.Object getJobConfiguration() {
                return this.jobConfiguration;
            }

            @Override
            public final java.lang.Object getSessionConfiguration() {
                return this.sessionConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJobConfiguration() != null) {
                    data.set("jobConfiguration", om.valueToTree(this.getJobConfiguration()));
                }
                if (this.getSessionConfiguration() != null) {
                    data.set("sessionConfiguration", om.valueToTree(this.getSessionConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnUsageProfile.ProfileConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProfileConfigurationProperty.Jsii$Proxy that = (ProfileConfigurationProperty.Jsii$Proxy) o;

                if (this.jobConfiguration != null ? !this.jobConfiguration.equals(that.jobConfiguration) : that.jobConfiguration != null) return false;
                return this.sessionConfiguration != null ? this.sessionConfiguration.equals(that.sessionConfiguration) : that.sessionConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jobConfiguration != null ? this.jobConfiguration.hashCode() : 0;
                result = 31 * result + (this.sessionConfiguration != null ? this.sessionConfiguration.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.glue.CfnUsageProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.CfnUsageProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.CfnUsageProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.CfnUsageProfileProps.Builder();
        }

        /**
         * The name of the usage profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html#cfn-glue-usageprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html#cfn-glue-usageprofile-name</a>
         * @param name The name of the usage profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html#cfn-glue-usageprofile-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html#cfn-glue-usageprofile-configuration</a>
         * @param configuration This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html#cfn-glue-usageprofile-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html#cfn-glue-usageprofile-configuration</a>
         * @param configuration This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.glue.CfnUsageProfile.ProfileConfigurationProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * A description of the usage profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html#cfn-glue-usageprofile-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html#cfn-glue-usageprofile-description</a>
         * @param description A description of the usage profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The tags to be applied to this UsageProfiles.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html#cfn-glue-usageprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-usageprofile.html#cfn-glue-usageprofile-tags</a>
         * @param tags The tags to be applied to this UsageProfiles. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.CfnUsageProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.glue.CfnUsageProfile build() {
            return new software.amazon.awscdk.services.glue.CfnUsageProfile(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
