package software.amazon.awscdk.services.greengrass;

/**
 * The <code>AWS::Greengrass::DeviceDefinitionVersion</code> resource represents a device definition version for AWS IoT Greengrass .
 * <p>
 * A device definition version contains a list of devices.
 * <p>
 * <blockquote>
 * <p>
 * To create a device definition version, you must specify the ID of the device definition that you want to associate with the version. For information about creating a device definition, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html"><code>AWS::Greengrass::DeviceDefinition</code></a> .
 * <p>
 * After you create a device definition version that contains the devices you want to deploy, you must add it to your group version. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html"><code>AWS::Greengrass::Group</code></a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * CfnDeviceDefinitionVersion cfnDeviceDefinitionVersion = CfnDeviceDefinitionVersion.Builder.create(this, "MyCfnDeviceDefinitionVersion")
 *         .deviceDefinitionId("deviceDefinitionId")
 *         .devices(List.of(DeviceProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .id("id")
 *                 .thingArn("thingArn")
 *                 // the properties below are optional
 *                 .syncShadow(false)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:15.285Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnDeviceDefinitionVersion")
public class CfnDeviceDefinitionVersion extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDeviceDefinitionVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeviceDefinitionVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.greengrass.CfnDeviceDefinitionVersion.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeviceDefinitionVersion(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.greengrass.CfnDeviceDefinitionVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the device definition associated with this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeviceDefinitionId() {
        return software.amazon.jsii.Kernel.get(this, "deviceDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the device definition associated with this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeviceDefinitionId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deviceDefinitionId", java.util.Objects.requireNonNull(value, "deviceDefinitionId is required"));
    }

    /**
     * The devices in this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDevices() {
        return software.amazon.jsii.Kernel.get(this, "devices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The devices in this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDevices(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "devices", java.util.Objects.requireNonNull(value, "devices is required"));
    }

    /**
     * The devices in this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDevices(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.greengrass.CfnDeviceDefinitionVersion.DeviceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.greengrass.CfnDeviceDefinitionVersion.DeviceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "devices", java.util.Objects.requireNonNull(value, "devices is required"));
    }
    /**
     * A device is an AWS IoT device (thing) that's added to a Greengrass group.
     * <p>
     * Greengrass devices can communicate with the Greengrass core in the same group. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/what-is-gg.html">What Is AWS IoT Greengrass ?</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, the <code>Devices</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html"><code>AWS::Greengrass::DeviceDefinitionVersion</code></a> resource contains a list of <code>Device</code> property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * DeviceProperty deviceProperty = DeviceProperty.builder()
     *         .certificateArn("certificateArn")
     *         .id("id")
     *         .thingArn("thingArn")
     *         // the properties below are optional
     *         .syncShadow(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnDeviceDefinitionVersion.DeviceProperty")
    @software.amazon.jsii.Jsii.Proxy(DeviceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the device certificate for the device.
         * <p>
         * This X.509 certificate is used to authenticate the device with AWS IoT and AWS IoT Greengrass services.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCertificateArn();

        /**
         * A descriptive or arbitrary ID for the device.
         * <p>
         * This value must be unique within the device definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The Amazon Resource Name (ARN) of the device, which is an AWS IoT device (thing).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-thingarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-thingarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getThingArn();

        /**
         * Indicates whether the device's local shadow is synced with the cloud automatically.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-syncshadow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-syncshadow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSyncShadow() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeviceProperty> {
            java.lang.String certificateArn;
            java.lang.String id;
            java.lang.String thingArn;
            java.lang.Object syncShadow;

            /**
             * Sets the value of {@link DeviceProperty#getCertificateArn}
             * @param certificateArn The ARN of the device certificate for the device. This parameter is required.
             *                       This X.509 certificate is used to authenticate the device with AWS IoT and AWS IoT Greengrass services.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getId}
             * @param id A descriptive or arbitrary ID for the device. This parameter is required.
             *           This value must be unique within the device definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getThingArn}
             * @param thingArn The Amazon Resource Name (ARN) of the device, which is an AWS IoT device (thing). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thingArn(java.lang.String thingArn) {
                this.thingArn = thingArn;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getSyncShadow}
             * @param syncShadow Indicates whether the device's local shadow is synced with the cloud automatically.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder syncShadow(java.lang.Boolean syncShadow) {
                this.syncShadow = syncShadow;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getSyncShadow}
             * @param syncShadow Indicates whether the device's local shadow is synced with the cloud automatically.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder syncShadow(software.amazon.awscdk.IResolvable syncShadow) {
                this.syncShadow = syncShadow;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeviceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceProperty {
            private final java.lang.String certificateArn;
            private final java.lang.String id;
            private final java.lang.String thingArn;
            private final java.lang.Object syncShadow;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.thingArn = software.amazon.jsii.Kernel.get(this, "thingArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.syncShadow = software.amazon.jsii.Kernel.get(this, "syncShadow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateArn = java.util.Objects.requireNonNull(builder.certificateArn, "certificateArn is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.thingArn = java.util.Objects.requireNonNull(builder.thingArn, "thingArn is required");
                this.syncShadow = builder.syncShadow;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getThingArn() {
                return this.thingArn;
            }

            @Override
            public final java.lang.Object getSyncShadow() {
                return this.syncShadow;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                data.set("id", om.valueToTree(this.getId()));
                data.set("thingArn", om.valueToTree(this.getThingArn()));
                if (this.getSyncShadow() != null) {
                    data.set("syncShadow", om.valueToTree(this.getSyncShadow()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnDeviceDefinitionVersion.DeviceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeviceProperty.Jsii$Proxy that = (DeviceProperty.Jsii$Proxy) o;

                if (!certificateArn.equals(that.certificateArn)) return false;
                if (!id.equals(that.id)) return false;
                if (!thingArn.equals(that.thingArn)) return false;
                return this.syncShadow != null ? this.syncShadow.equals(that.syncShadow) : that.syncShadow == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateArn.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.thingArn.hashCode());
                result = 31 * result + (this.syncShadow != null ? this.syncShadow.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.greengrass.CfnDeviceDefinitionVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.greengrass.CfnDeviceDefinitionVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.greengrass.CfnDeviceDefinitionVersionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.greengrass.CfnDeviceDefinitionVersionProps.Builder();
        }

        /**
         * The ID of the device definition associated with this version.
         * <p>
         * This value is a GUID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devicedefinitionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devicedefinitionid</a>
         * @param deviceDefinitionId The ID of the device definition associated with this version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceDefinitionId(final java.lang.String deviceDefinitionId) {
            this.props.deviceDefinitionId(deviceDefinitionId);
            return this;
        }

        /**
         * The devices in this version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devices</a>
         * @param devices The devices in this version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder devices(final software.amazon.awscdk.IResolvable devices) {
            this.props.devices(devices);
            return this;
        }
        /**
         * The devices in this version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devices</a>
         * @param devices The devices in this version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder devices(final java.util.List<? extends java.lang.Object> devices) {
            this.props.devices(devices);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.greengrass.CfnDeviceDefinitionVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.greengrass.CfnDeviceDefinitionVersion build() {
            return new software.amazon.awscdk.services.greengrass.CfnDeviceDefinitionVersion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
