package software.amazon.awscdk.services.greengrass;

/**
 * Properties for defining a <code>CfnGroupVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * CfnGroupVersionProps cfnGroupVersionProps = CfnGroupVersionProps.builder()
 *         .groupId("groupId")
 *         // the properties below are optional
 *         .connectorDefinitionVersionArn("connectorDefinitionVersionArn")
 *         .coreDefinitionVersionArn("coreDefinitionVersionArn")
 *         .deviceDefinitionVersionArn("deviceDefinitionVersionArn")
 *         .functionDefinitionVersionArn("functionDefinitionVersionArn")
 *         .loggerDefinitionVersionArn("loggerDefinitionVersionArn")
 *         .resourceDefinitionVersionArn("resourceDefinitionVersionArn")
 *         .subscriptionDefinitionVersionArn("subscriptionDefinitionVersionArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:15.318Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnGroupVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnGroupVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGroupVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the group associated with this version.
     * <p>
     * This value is a GUID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-groupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-groupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupId();

    /**
     * The Amazon Resource Name (ARN) of the connector definition version that contains the connectors you want to deploy with the group version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-connectordefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-connectordefinitionversionarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectorDefinitionVersionArn() {
        return null;
    }

    /**
     * The ARN of the core definition version that contains the core you want to deploy with the group version.
     * <p>
     * Currently, the core definition version can contain only one core.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-coredefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-coredefinitionversionarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCoreDefinitionVersionArn() {
        return null;
    }

    /**
     * The ARN of the device definition version that contains the devices you want to deploy with the group version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-devicedefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-devicedefinitionversionarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeviceDefinitionVersionArn() {
        return null;
    }

    /**
     * The ARN of the function definition version that contains the functions you want to deploy with the group version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-functiondefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-functiondefinitionversionarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFunctionDefinitionVersionArn() {
        return null;
    }

    /**
     * The ARN of the logger definition version that contains the loggers you want to deploy with the group version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-loggerdefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-loggerdefinitionversionarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoggerDefinitionVersionArn() {
        return null;
    }

    /**
     * The ARN of the resource definition version that contains the resources you want to deploy with the group version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-resourcedefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-resourcedefinitionversionarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceDefinitionVersionArn() {
        return null;
    }

    /**
     * The ARN of the subscription definition version that contains the subscriptions you want to deploy with the group version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-subscriptiondefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-subscriptiondefinitionversionarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubscriptionDefinitionVersionArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGroupVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGroupVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGroupVersionProps> {
        java.lang.String groupId;
        java.lang.String connectorDefinitionVersionArn;
        java.lang.String coreDefinitionVersionArn;
        java.lang.String deviceDefinitionVersionArn;
        java.lang.String functionDefinitionVersionArn;
        java.lang.String loggerDefinitionVersionArn;
        java.lang.String resourceDefinitionVersionArn;
        java.lang.String subscriptionDefinitionVersionArn;

        /**
         * Sets the value of {@link CfnGroupVersionProps#getGroupId}
         * @param groupId The ID of the group associated with this version. This parameter is required.
         *                This value is a GUID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupId(java.lang.String groupId) {
            this.groupId = groupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupVersionProps#getConnectorDefinitionVersionArn}
         * @param connectorDefinitionVersionArn The Amazon Resource Name (ARN) of the connector definition version that contains the connectors you want to deploy with the group version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorDefinitionVersionArn(java.lang.String connectorDefinitionVersionArn) {
            this.connectorDefinitionVersionArn = connectorDefinitionVersionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupVersionProps#getCoreDefinitionVersionArn}
         * @param coreDefinitionVersionArn The ARN of the core definition version that contains the core you want to deploy with the group version.
         *                                 Currently, the core definition version can contain only one core.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreDefinitionVersionArn(java.lang.String coreDefinitionVersionArn) {
            this.coreDefinitionVersionArn = coreDefinitionVersionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupVersionProps#getDeviceDefinitionVersionArn}
         * @param deviceDefinitionVersionArn The ARN of the device definition version that contains the devices you want to deploy with the group version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceDefinitionVersionArn(java.lang.String deviceDefinitionVersionArn) {
            this.deviceDefinitionVersionArn = deviceDefinitionVersionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupVersionProps#getFunctionDefinitionVersionArn}
         * @param functionDefinitionVersionArn The ARN of the function definition version that contains the functions you want to deploy with the group version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionDefinitionVersionArn(java.lang.String functionDefinitionVersionArn) {
            this.functionDefinitionVersionArn = functionDefinitionVersionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupVersionProps#getLoggerDefinitionVersionArn}
         * @param loggerDefinitionVersionArn The ARN of the logger definition version that contains the loggers you want to deploy with the group version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggerDefinitionVersionArn(java.lang.String loggerDefinitionVersionArn) {
            this.loggerDefinitionVersionArn = loggerDefinitionVersionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupVersionProps#getResourceDefinitionVersionArn}
         * @param resourceDefinitionVersionArn The ARN of the resource definition version that contains the resources you want to deploy with the group version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceDefinitionVersionArn(java.lang.String resourceDefinitionVersionArn) {
            this.resourceDefinitionVersionArn = resourceDefinitionVersionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupVersionProps#getSubscriptionDefinitionVersionArn}
         * @param subscriptionDefinitionVersionArn The ARN of the subscription definition version that contains the subscriptions you want to deploy with the group version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionDefinitionVersionArn(java.lang.String subscriptionDefinitionVersionArn) {
            this.subscriptionDefinitionVersionArn = subscriptionDefinitionVersionArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGroupVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGroupVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGroupVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGroupVersionProps {
        private final java.lang.String groupId;
        private final java.lang.String connectorDefinitionVersionArn;
        private final java.lang.String coreDefinitionVersionArn;
        private final java.lang.String deviceDefinitionVersionArn;
        private final java.lang.String functionDefinitionVersionArn;
        private final java.lang.String loggerDefinitionVersionArn;
        private final java.lang.String resourceDefinitionVersionArn;
        private final java.lang.String subscriptionDefinitionVersionArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectorDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "connectorDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.coreDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "coreDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deviceDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "deviceDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functionDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "functionDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggerDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "loggerDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "resourceDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscriptionDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "subscriptionDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groupId = java.util.Objects.requireNonNull(builder.groupId, "groupId is required");
            this.connectorDefinitionVersionArn = builder.connectorDefinitionVersionArn;
            this.coreDefinitionVersionArn = builder.coreDefinitionVersionArn;
            this.deviceDefinitionVersionArn = builder.deviceDefinitionVersionArn;
            this.functionDefinitionVersionArn = builder.functionDefinitionVersionArn;
            this.loggerDefinitionVersionArn = builder.loggerDefinitionVersionArn;
            this.resourceDefinitionVersionArn = builder.resourceDefinitionVersionArn;
            this.subscriptionDefinitionVersionArn = builder.subscriptionDefinitionVersionArn;
        }

        @Override
        public final java.lang.String getGroupId() {
            return this.groupId;
        }

        @Override
        public final java.lang.String getConnectorDefinitionVersionArn() {
            return this.connectorDefinitionVersionArn;
        }

        @Override
        public final java.lang.String getCoreDefinitionVersionArn() {
            return this.coreDefinitionVersionArn;
        }

        @Override
        public final java.lang.String getDeviceDefinitionVersionArn() {
            return this.deviceDefinitionVersionArn;
        }

        @Override
        public final java.lang.String getFunctionDefinitionVersionArn() {
            return this.functionDefinitionVersionArn;
        }

        @Override
        public final java.lang.String getLoggerDefinitionVersionArn() {
            return this.loggerDefinitionVersionArn;
        }

        @Override
        public final java.lang.String getResourceDefinitionVersionArn() {
            return this.resourceDefinitionVersionArn;
        }

        @Override
        public final java.lang.String getSubscriptionDefinitionVersionArn() {
            return this.subscriptionDefinitionVersionArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("groupId", om.valueToTree(this.getGroupId()));
            if (this.getConnectorDefinitionVersionArn() != null) {
                data.set("connectorDefinitionVersionArn", om.valueToTree(this.getConnectorDefinitionVersionArn()));
            }
            if (this.getCoreDefinitionVersionArn() != null) {
                data.set("coreDefinitionVersionArn", om.valueToTree(this.getCoreDefinitionVersionArn()));
            }
            if (this.getDeviceDefinitionVersionArn() != null) {
                data.set("deviceDefinitionVersionArn", om.valueToTree(this.getDeviceDefinitionVersionArn()));
            }
            if (this.getFunctionDefinitionVersionArn() != null) {
                data.set("functionDefinitionVersionArn", om.valueToTree(this.getFunctionDefinitionVersionArn()));
            }
            if (this.getLoggerDefinitionVersionArn() != null) {
                data.set("loggerDefinitionVersionArn", om.valueToTree(this.getLoggerDefinitionVersionArn()));
            }
            if (this.getResourceDefinitionVersionArn() != null) {
                data.set("resourceDefinitionVersionArn", om.valueToTree(this.getResourceDefinitionVersionArn()));
            }
            if (this.getSubscriptionDefinitionVersionArn() != null) {
                data.set("subscriptionDefinitionVersionArn", om.valueToTree(this.getSubscriptionDefinitionVersionArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnGroupVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGroupVersionProps.Jsii$Proxy that = (CfnGroupVersionProps.Jsii$Proxy) o;

            if (!groupId.equals(that.groupId)) return false;
            if (this.connectorDefinitionVersionArn != null ? !this.connectorDefinitionVersionArn.equals(that.connectorDefinitionVersionArn) : that.connectorDefinitionVersionArn != null) return false;
            if (this.coreDefinitionVersionArn != null ? !this.coreDefinitionVersionArn.equals(that.coreDefinitionVersionArn) : that.coreDefinitionVersionArn != null) return false;
            if (this.deviceDefinitionVersionArn != null ? !this.deviceDefinitionVersionArn.equals(that.deviceDefinitionVersionArn) : that.deviceDefinitionVersionArn != null) return false;
            if (this.functionDefinitionVersionArn != null ? !this.functionDefinitionVersionArn.equals(that.functionDefinitionVersionArn) : that.functionDefinitionVersionArn != null) return false;
            if (this.loggerDefinitionVersionArn != null ? !this.loggerDefinitionVersionArn.equals(that.loggerDefinitionVersionArn) : that.loggerDefinitionVersionArn != null) return false;
            if (this.resourceDefinitionVersionArn != null ? !this.resourceDefinitionVersionArn.equals(that.resourceDefinitionVersionArn) : that.resourceDefinitionVersionArn != null) return false;
            return this.subscriptionDefinitionVersionArn != null ? this.subscriptionDefinitionVersionArn.equals(that.subscriptionDefinitionVersionArn) : that.subscriptionDefinitionVersionArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + (this.connectorDefinitionVersionArn != null ? this.connectorDefinitionVersionArn.hashCode() : 0);
            result = 31 * result + (this.coreDefinitionVersionArn != null ? this.coreDefinitionVersionArn.hashCode() : 0);
            result = 31 * result + (this.deviceDefinitionVersionArn != null ? this.deviceDefinitionVersionArn.hashCode() : 0);
            result = 31 * result + (this.functionDefinitionVersionArn != null ? this.functionDefinitionVersionArn.hashCode() : 0);
            result = 31 * result + (this.loggerDefinitionVersionArn != null ? this.loggerDefinitionVersionArn.hashCode() : 0);
            result = 31 * result + (this.resourceDefinitionVersionArn != null ? this.resourceDefinitionVersionArn.hashCode() : 0);
            result = 31 * result + (this.subscriptionDefinitionVersionArn != null ? this.subscriptionDefinitionVersionArn.hashCode() : 0);
            return result;
        }
    }
}
