package software.amazon.awscdk.services.groundstation;

/**
 * Properties for defining a <code>CfnDataflowEndpointGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.groundstation.*;
 * CfnDataflowEndpointGroupProps cfnDataflowEndpointGroupProps = CfnDataflowEndpointGroupProps.builder()
 *         .endpointDetails(List.of(EndpointDetailsProperty.builder()
 *                 .awsGroundStationAgentEndpoint(AwsGroundStationAgentEndpointProperty.builder()
 *                         .agentStatus("agentStatus")
 *                         .auditResults("auditResults")
 *                         .egressAddress(ConnectionDetailsProperty.builder()
 *                                 .mtu(123)
 *                                 .socketAddress(SocketAddressProperty.builder()
 *                                         .name("name")
 *                                         .port(123)
 *                                         .build())
 *                                 .build())
 *                         .ingressAddress(RangedConnectionDetailsProperty.builder()
 *                                 .mtu(123)
 *                                 .socketAddress(RangedSocketAddressProperty.builder()
 *                                         .name("name")
 *                                         .portRange(IntegerRangeProperty.builder()
 *                                                 .maximum(123)
 *                                                 .minimum(123)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .name("name")
 *                         .build())
 *                 .endpoint(DataflowEndpointProperty.builder()
 *                         .address(SocketAddressProperty.builder()
 *                                 .name("name")
 *                                 .port(123)
 *                                 .build())
 *                         .mtu(123)
 *                         .name("name")
 *                         .build())
 *                 .securityDetails(SecurityDetailsProperty.builder()
 *                         .roleArn("roleArn")
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnetIds(List.of("subnetIds"))
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .contactPostPassDurationSeconds(123)
 *         .contactPrePassDurationSeconds(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:15.401Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_groundstation.CfnDataflowEndpointGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataflowEndpointGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataflowEndpointGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of Endpoint Details, containing address and port for each endpoint.
     * <p>
     * All dataflow endpoints within a single dataflow endpoint group must be of the same type. You cannot mix AWS Ground Station Agent endpoints with Dataflow endpoints in the same group. If your use case requires both types of endpoints, you must create separate dataflow endpoint groups for each type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-endpointdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-endpointdetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getEndpointDetails();

    /**
     * Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be in a <code>POSTPASS</code> state.
     * <p>
     * A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-contactpostpassdurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-contactpostpassdurationseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getContactPostPassDurationSeconds() {
        return null;
    }

    /**
     * Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will be in a <code>PREPASS</code> state.
     * <p>
     * A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-contactprepassdurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-contactprepassdurationseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getContactPrePassDurationSeconds() {
        return null;
    }

    /**
     * Tags assigned to a resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataflowEndpointGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataflowEndpointGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataflowEndpointGroupProps> {
        java.lang.Object endpointDetails;
        java.lang.Number contactPostPassDurationSeconds;
        java.lang.Number contactPrePassDurationSeconds;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataflowEndpointGroupProps#getEndpointDetails}
         * @param endpointDetails List of Endpoint Details, containing address and port for each endpoint. This parameter is required.
         *                        All dataflow endpoints within a single dataflow endpoint group must be of the same type. You cannot mix AWS Ground Station Agent endpoints with Dataflow endpoints in the same group. If your use case requires both types of endpoints, you must create separate dataflow endpoint groups for each type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointDetails(software.amazon.awscdk.IResolvable endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataflowEndpointGroupProps#getEndpointDetails}
         * @param endpointDetails List of Endpoint Details, containing address and port for each endpoint. This parameter is required.
         *                        All dataflow endpoints within a single dataflow endpoint group must be of the same type. You cannot mix AWS Ground Station Agent endpoints with Dataflow endpoints in the same group. If your use case requires both types of endpoints, you must create separate dataflow endpoint groups for each type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointDetails(java.util.List<? extends java.lang.Object> endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataflowEndpointGroupProps#getContactPostPassDurationSeconds}
         * @param contactPostPassDurationSeconds Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be in a <code>POSTPASS</code> state.
         *                                       A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactPostPassDurationSeconds(java.lang.Number contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataflowEndpointGroupProps#getContactPrePassDurationSeconds}
         * @param contactPrePassDurationSeconds Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will be in a <code>PREPASS</code> state.
         *                                      A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactPrePassDurationSeconds(java.lang.Number contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataflowEndpointGroupProps#getTags}
         * @param tags Tags assigned to a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataflowEndpointGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataflowEndpointGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataflowEndpointGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataflowEndpointGroupProps {
        private final java.lang.Object endpointDetails;
        private final java.lang.Number contactPostPassDurationSeconds;
        private final java.lang.Number contactPrePassDurationSeconds;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.endpointDetails = software.amazon.jsii.Kernel.get(this, "endpointDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.contactPostPassDurationSeconds = software.amazon.jsii.Kernel.get(this, "contactPostPassDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.contactPrePassDurationSeconds = software.amazon.jsii.Kernel.get(this, "contactPrePassDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.endpointDetails = java.util.Objects.requireNonNull(builder.endpointDetails, "endpointDetails is required");
            this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
            this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getEndpointDetails() {
            return this.endpointDetails;
        }

        @Override
        public final java.lang.Number getContactPostPassDurationSeconds() {
            return this.contactPostPassDurationSeconds;
        }

        @Override
        public final java.lang.Number getContactPrePassDurationSeconds() {
            return this.contactPrePassDurationSeconds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("endpointDetails", om.valueToTree(this.getEndpointDetails()));
            if (this.getContactPostPassDurationSeconds() != null) {
                data.set("contactPostPassDurationSeconds", om.valueToTree(this.getContactPostPassDurationSeconds()));
            }
            if (this.getContactPrePassDurationSeconds() != null) {
                data.set("contactPrePassDurationSeconds", om.valueToTree(this.getContactPrePassDurationSeconds()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_groundstation.CfnDataflowEndpointGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataflowEndpointGroupProps.Jsii$Proxy that = (CfnDataflowEndpointGroupProps.Jsii$Proxy) o;

            if (!endpointDetails.equals(that.endpointDetails)) return false;
            if (this.contactPostPassDurationSeconds != null ? !this.contactPostPassDurationSeconds.equals(that.contactPostPassDurationSeconds) : that.contactPostPassDurationSeconds != null) return false;
            if (this.contactPrePassDurationSeconds != null ? !this.contactPrePassDurationSeconds.equals(that.contactPrePassDurationSeconds) : that.contactPrePassDurationSeconds != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.endpointDetails.hashCode();
            result = 31 * result + (this.contactPostPassDurationSeconds != null ? this.contactPostPassDurationSeconds.hashCode() : 0);
            result = 31 * result + (this.contactPrePassDurationSeconds != null ? this.contactPrePassDurationSeconds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
