package software.amazon.awscdk.services.iam;

/**
 * Initialization properties for <code>OIDCProviderNative</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * OidcProviderNative nativeProvider = OidcProviderNative.Builder.create(this, "MyProvider")
 *         .url("https://openid/connect")
 *         .clientIds(List.of("myclient1", "myclient2"))
 *         .thumbprints(List.of("aa00aa1122aa00aa1122aa00aa1122aa00aa1122"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:15.560Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.OidcProviderNativeProps")
@software.amazon.jsii.Jsii.Proxy(OidcProviderNativeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OidcProviderNativeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The URL of the identity provider.
     * <p>
     * The URL must begin with https:// and
     * should correspond to the iss claim in the provider's OpenID Connect ID
     * tokens. Per the OIDC standard, path components are allowed but query
     * parameters are not. Typically the URL consists of only a hostname, like
     * https://server.example.org or https://example.com.
     * <p>
     * You cannot register the same provider multiple times in a single AWS
     * account. If you try to submit a URL that has already been used for an
     * OpenID Connect provider in the AWS account, you will get an error.
     * <p>
     * Warning: This URL cannot contain any port numbers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUrl();

    /**
     * A list of client IDs (also known as audiences).
     * <p>
     * When a mobile or web app
     * registers with an OpenID Connect provider, they establish a value that
     * identifies the application. (This is the value that's sent as the client_id
     * parameter on OAuth requests.)
     * <p>
     * You can register multiple client IDs with the same provider. For example,
     * you might have multiple applications that use the same OIDC provider. You
     * cannot register more than 100 client IDs with a single IAM OIDC provider.
     * <p>
     * Client IDs are up to 255 characters long.
     * <p>
     * Default: - no clients are allowed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClientIds() {
        return null;
    }

    /**
     * The name of the Native OIDC Provider.
     * <p>
     * Default: - A name is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOidcProviderName() {
        return null;
    }

    /**
     * A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificates.
     * <p>
     * Typically this list includes only 1 entry or empty. However, IAM lets
     * you have up to 5 thumbprints for an OIDC provider. This lets you maintain
     * multiple thumbprints if the identity provider is rotating certificates.
     * <p>
     * The server certificate thumbprint is the hex-encoded SHA-1 hash value of
     * the X.509 certificate used by the domain where the OpenID Connect provider
     * makes its keys available. It is always a 40-character string.
     * <p>
     * For example, assume that the OIDC provider is server.example.com and the
     * provider stores its keys at https://keys.server.example.com/openid-connect.
     * In that case, the thumbprint string would be the hex-encoded SHA-1 hash
     * value of the certificate used by https://keys.server.example.com.
     * <p>
     * This property is optional. If it is not included, IAM will retrieve and use
     * the top intermediate certificate authority (CA) thumbprint of the OpenID
     * Connect identity provider server certificate.
     * <p>
     * Obtain the thumbprint of the root certificate authority from the provider's
     * server as described in https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc_verify-thumbprint.html
     * <p>
     * Default: - no thumbprints are allowed. IAM will retrieve and use thumbprint
     * of idenity provider server cerctificate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getThumbprints() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OidcProviderNativeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OidcProviderNativeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OidcProviderNativeProps> {
        java.lang.String url;
        java.util.List<java.lang.String> clientIds;
        java.lang.String oidcProviderName;
        java.util.List<java.lang.String> thumbprints;

        /**
         * Sets the value of {@link OidcProviderNativeProps#getUrl}
         * @param url The URL of the identity provider. This parameter is required.
         *            The URL must begin with https:// and
         *            should correspond to the iss claim in the provider's OpenID Connect ID
         *            tokens. Per the OIDC standard, path components are allowed but query
         *            parameters are not. Typically the URL consists of only a hostname, like
         *            https://server.example.org or https://example.com.
         *            <p>
         *            You cannot register the same provider multiple times in a single AWS
         *            account. If you try to submit a URL that has already been used for an
         *            OpenID Connect provider in the AWS account, you will get an error.
         *            <p>
         *            Warning: This URL cannot contain any port numbers
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder url(java.lang.String url) {
            this.url = url;
            return this;
        }

        /**
         * Sets the value of {@link OidcProviderNativeProps#getClientIds}
         * @param clientIds A list of client IDs (also known as audiences).
         *                  When a mobile or web app
         *                  registers with an OpenID Connect provider, they establish a value that
         *                  identifies the application. (This is the value that's sent as the client_id
         *                  parameter on OAuth requests.)
         *                  <p>
         *                  You can register multiple client IDs with the same provider. For example,
         *                  you might have multiple applications that use the same OIDC provider. You
         *                  cannot register more than 100 client IDs with a single IAM OIDC provider.
         *                  <p>
         *                  Client IDs are up to 255 characters long.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientIds(java.util.List<java.lang.String> clientIds) {
            this.clientIds = clientIds;
            return this;
        }

        /**
         * Sets the value of {@link OidcProviderNativeProps#getOidcProviderName}
         * @param oidcProviderName The name of the Native OIDC Provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oidcProviderName(java.lang.String oidcProviderName) {
            this.oidcProviderName = oidcProviderName;
            return this;
        }

        /**
         * Sets the value of {@link OidcProviderNativeProps#getThumbprints}
         * @param thumbprints A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificates.
         *                    Typically this list includes only 1 entry or empty. However, IAM lets
         *                    you have up to 5 thumbprints for an OIDC provider. This lets you maintain
         *                    multiple thumbprints if the identity provider is rotating certificates.
         *                    <p>
         *                    The server certificate thumbprint is the hex-encoded SHA-1 hash value of
         *                    the X.509 certificate used by the domain where the OpenID Connect provider
         *                    makes its keys available. It is always a 40-character string.
         *                    <p>
         *                    For example, assume that the OIDC provider is server.example.com and the
         *                    provider stores its keys at https://keys.server.example.com/openid-connect.
         *                    In that case, the thumbprint string would be the hex-encoded SHA-1 hash
         *                    value of the certificate used by https://keys.server.example.com.
         *                    <p>
         *                    This property is optional. If it is not included, IAM will retrieve and use
         *                    the top intermediate certificate authority (CA) thumbprint of the OpenID
         *                    Connect identity provider server certificate.
         *                    <p>
         *                    Obtain the thumbprint of the root certificate authority from the provider's
         *                    server as described in https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc_verify-thumbprint.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thumbprints(java.util.List<java.lang.String> thumbprints) {
            this.thumbprints = thumbprints;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OidcProviderNativeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OidcProviderNativeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OidcProviderNativeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OidcProviderNativeProps {
        private final java.lang.String url;
        private final java.util.List<java.lang.String> clientIds;
        private final java.lang.String oidcProviderName;
        private final java.util.List<java.lang.String> thumbprints;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientIds = software.amazon.jsii.Kernel.get(this, "clientIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.oidcProviderName = software.amazon.jsii.Kernel.get(this, "oidcProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.thumbprints = software.amazon.jsii.Kernel.get(this, "thumbprints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.url = java.util.Objects.requireNonNull(builder.url, "url is required");
            this.clientIds = builder.clientIds;
            this.oidcProviderName = builder.oidcProviderName;
            this.thumbprints = builder.thumbprints;
        }

        @Override
        public final java.lang.String getUrl() {
            return this.url;
        }

        @Override
        public final java.util.List<java.lang.String> getClientIds() {
            return this.clientIds;
        }

        @Override
        public final java.lang.String getOidcProviderName() {
            return this.oidcProviderName;
        }

        @Override
        public final java.util.List<java.lang.String> getThumbprints() {
            return this.thumbprints;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("url", om.valueToTree(this.getUrl()));
            if (this.getClientIds() != null) {
                data.set("clientIds", om.valueToTree(this.getClientIds()));
            }
            if (this.getOidcProviderName() != null) {
                data.set("oidcProviderName", om.valueToTree(this.getOidcProviderName()));
            }
            if (this.getThumbprints() != null) {
                data.set("thumbprints", om.valueToTree(this.getThumbprints()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.OidcProviderNativeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OidcProviderNativeProps.Jsii$Proxy that = (OidcProviderNativeProps.Jsii$Proxy) o;

            if (!url.equals(that.url)) return false;
            if (this.clientIds != null ? !this.clientIds.equals(that.clientIds) : that.clientIds != null) return false;
            if (this.oidcProviderName != null ? !this.oidcProviderName.equals(that.oidcProviderName) : that.oidcProviderName != null) return false;
            return this.thumbprints != null ? this.thumbprints.equals(that.thumbprints) : that.thumbprints == null;
        }

        @Override
        public final int hashCode() {
            int result = this.url.hashCode();
            result = 31 * result + (this.clientIds != null ? this.clientIds.hashCode() : 0);
            result = 31 * result + (this.oidcProviderName != null ? this.oidcProviderName.hashCode() : 0);
            result = 31 * result + (this.thumbprints != null ? this.thumbprints.hashCode() : 0);
            return result;
        }
    }
}
