package software.amazon.awscdk.services.iotanalytics;

/**
 * AWS::IoTAnalytics::Datastore resource is a repository for messages.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/welcome.html#aws-iot-analytics-how">How to Use AWS IoT Analytics</a> in the <em>AWS IoT Analytics User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotanalytics.*;
 * Object jsonConfiguration;
 * Object serviceManagedS3;
 * CfnDatastore cfnDatastore = CfnDatastore.Builder.create(this, "MyCfnDatastore")
 *         .datastoreName("datastoreName")
 *         .datastorePartitions(DatastorePartitionsProperty.builder()
 *                 .partitions(List.of(DatastorePartitionProperty.builder()
 *                         .partition(PartitionProperty.builder()
 *                                 .attributeName("attributeName")
 *                                 .build())
 *                         .timestampPartition(TimestampPartitionProperty.builder()
 *                                 .attributeName("attributeName")
 *                                 // the properties below are optional
 *                                 .timestampFormat("timestampFormat")
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .datastoreStorage(DatastoreStorageProperty.builder()
 *                 .customerManagedS3(CustomerManagedS3Property.builder()
 *                         .bucket("bucket")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .keyPrefix("keyPrefix")
 *                         .build())
 *                 .iotSiteWiseMultiLayerStorage(IotSiteWiseMultiLayerStorageProperty.builder()
 *                         .customerManagedS3Storage(CustomerManagedS3StorageProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .keyPrefix("keyPrefix")
 *                                 .build())
 *                         .build())
 *                 .serviceManagedS3(serviceManagedS3)
 *                 .build())
 *         .fileFormatConfiguration(FileFormatConfigurationProperty.builder()
 *                 .jsonConfiguration(jsonConfiguration)
 *                 .parquetConfiguration(ParquetConfigurationProperty.builder()
 *                         .schemaDefinition(SchemaDefinitionProperty.builder()
 *                                 .columns(List.of(ColumnProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .retentionPeriod(RetentionPeriodProperty.builder()
 *                 .numberOfDays(123)
 *                 .unlimited(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:15.885Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore")
public class CfnDatastore extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDatastore(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDatastore(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotanalytics.CfnDatastore.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDatastore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotanalytics.CfnDatastoreProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDatastore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatastoreName() {
        return software.amazon.jsii.Kernel.get(this, "datastoreName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatastoreName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datastoreName", value);
    }

    /**
     * Information about the partition dimensions in a data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDatastorePartitions() {
        return software.amazon.jsii.Kernel.get(this, "datastorePartitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the partition dimensions in a data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatastorePartitions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "datastorePartitions", value);
    }

    /**
     * Information about the partition dimensions in a data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatastorePartitions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotanalytics.CfnDatastore.DatastorePartitionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "datastorePartitions", value);
    }

    /**
     * Where data store data is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDatastoreStorage() {
        return software.amazon.jsii.Kernel.get(this, "datastoreStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Where data store data is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatastoreStorage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "datastoreStorage", value);
    }

    /**
     * Where data store data is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatastoreStorage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotanalytics.CfnDatastore.DatastoreStorageProperty value) {
        software.amazon.jsii.Kernel.set(this, "datastoreStorage", value);
    }

    /**
     * Contains the configuration information of file formats.
     * <p>
     * AWS IoT Analytics data stores support JSON and <a href="https://docs.aws.amazon.com/https://parquet.apache.org/">Parquet</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFileFormatConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "fileFormatConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains the configuration information of file formats.
     * <p>
     * AWS IoT Analytics data stores support JSON and <a href="https://docs.aws.amazon.com/https://parquet.apache.org/">Parquet</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileFormatConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fileFormatConfiguration", value);
    }

    /**
     * Contains the configuration information of file formats.
     * <p>
     * AWS IoT Analytics data stores support JSON and <a href="https://docs.aws.amazon.com/https://parquet.apache.org/">Parquet</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileFormatConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotanalytics.CfnDatastore.FileFormatConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "fileFormatConfiguration", value);
    }

    /**
     * How long, in days, message data is kept for the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * How long, in days, message data is kept for the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionPeriod(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "retentionPeriod", value);
    }

    /**
     * How long, in days, message data is kept for the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionPeriod(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotanalytics.CfnDatastore.RetentionPeriodProperty value) {
        software.amazon.jsii.Kernel.set(this, "retentionPeriod", value);
    }

    /**
     * Metadata which can be used to manage the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata which can be used to manage the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Contains information about a column that stores your data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * ColumnProperty columnProperty = ColumnProperty.builder()
     *         .name("name")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-column.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-column.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.ColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-column.html#cfn-iotanalytics-datastore-column-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-column.html#cfn-iotanalytics-datastore-column-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The type of data.
         * <p>
         * For more information about the supported data types, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html">Common data types</a> in the <em>AWS Glue Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-column.html#cfn-iotanalytics-datastore-column-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-column.html#cfn-iotanalytics-datastore-column-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnProperty> {
            java.lang.String name;
            java.lang.String type;

            /**
             * Sets the value of {@link ColumnProperty#getName}
             * @param name The name of the column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ColumnProperty#getType}
             * @param type The type of data. This parameter is required.
             *             For more information about the supported data types, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html">Common data types</a> in the <em>AWS Glue Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnProperty {
            private final java.lang.String name;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.ColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnProperty.Jsii$Proxy that = (ColumnProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * S3-customer-managed;
     * <p>
     * When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is ignored. You can't change the choice of Amazon S3 storage after your data store is created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * CustomerManagedS3Property customerManagedS3Property = CustomerManagedS3Property.builder()
     *         .bucket("bucket")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .keyPrefix("keyPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.CustomerManagedS3Property")
    @software.amazon.jsii.Jsii.Proxy(CustomerManagedS3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomerManagedS3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket where your data is stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html#cfn-iotanalytics-datastore-customermanageds3-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html#cfn-iotanalytics-datastore-customermanageds3-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html#cfn-iotanalytics-datastore-customermanageds3-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html#cfn-iotanalytics-datastore-customermanageds3-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * (Optional) The prefix used to create the keys of the data store data objects.
         * <p>
         * Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html#cfn-iotanalytics-datastore-customermanageds3-keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html#cfn-iotanalytics-datastore-customermanageds3-keyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomerManagedS3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomerManagedS3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomerManagedS3Property> {
            java.lang.String bucket;
            java.lang.String roleArn;
            java.lang.String keyPrefix;

            /**
             * Sets the value of {@link CustomerManagedS3Property#getBucket}
             * @param bucket The name of the Amazon S3 bucket where your data is stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedS3Property#getRoleArn}
             * @param roleArn The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 resources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedS3Property#getKeyPrefix}
             * @param keyPrefix (Optional) The prefix used to create the keys of the data store data objects.
             *                  Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyPrefix(java.lang.String keyPrefix) {
                this.keyPrefix = keyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomerManagedS3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomerManagedS3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomerManagedS3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomerManagedS3Property {
            private final java.lang.String bucket;
            private final java.lang.String roleArn;
            private final java.lang.String keyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyPrefix = software.amazon.jsii.Kernel.get(this, "keyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.keyPrefix = builder.keyPrefix;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getKeyPrefix() {
                return this.keyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getKeyPrefix() != null) {
                    data.set("keyPrefix", om.valueToTree(this.getKeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.CustomerManagedS3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomerManagedS3Property.Jsii$Proxy that = (CustomerManagedS3Property.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.keyPrefix != null ? this.keyPrefix.equals(that.keyPrefix) : that.keyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.keyPrefix != null ? this.keyPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Amazon S3 -customer-managed;
     * <p>
     * When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is ignored. You can't change the choice of Amazon S3 storage after your data store is created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * CustomerManagedS3StorageProperty customerManagedS3StorageProperty = CustomerManagedS3StorageProperty.builder()
     *         .bucket("bucket")
     *         // the properties below are optional
     *         .keyPrefix("keyPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3storage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3storage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.CustomerManagedS3StorageProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomerManagedS3StorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomerManagedS3StorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket where your data is stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3storage.html#cfn-iotanalytics-datastore-customermanageds3storage-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3storage.html#cfn-iotanalytics-datastore-customermanageds3storage-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * (Optional) The prefix used to create the keys of the data store data objects.
         * <p>
         * Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3storage.html#cfn-iotanalytics-datastore-customermanageds3storage-keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3storage.html#cfn-iotanalytics-datastore-customermanageds3storage-keyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomerManagedS3StorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomerManagedS3StorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomerManagedS3StorageProperty> {
            java.lang.String bucket;
            java.lang.String keyPrefix;

            /**
             * Sets the value of {@link CustomerManagedS3StorageProperty#getBucket}
             * @param bucket The name of the Amazon S3 bucket where your data is stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link CustomerManagedS3StorageProperty#getKeyPrefix}
             * @param keyPrefix (Optional) The prefix used to create the keys of the data store data objects.
             *                  Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyPrefix(java.lang.String keyPrefix) {
                this.keyPrefix = keyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomerManagedS3StorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomerManagedS3StorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomerManagedS3StorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomerManagedS3StorageProperty {
            private final java.lang.String bucket;
            private final java.lang.String keyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyPrefix = software.amazon.jsii.Kernel.get(this, "keyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.keyPrefix = builder.keyPrefix;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKeyPrefix() {
                return this.keyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getKeyPrefix() != null) {
                    data.set("keyPrefix", om.valueToTree(this.getKeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.CustomerManagedS3StorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomerManagedS3StorageProperty.Jsii$Proxy that = (CustomerManagedS3StorageProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                return this.keyPrefix != null ? this.keyPrefix.equals(that.keyPrefix) : that.keyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.keyPrefix != null ? this.keyPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A single dimension to partition a data store.
     * <p>
     * The dimension must be an <code>AttributePartition</code> or a <code>TimestampPartition</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * DatastorePartitionProperty datastorePartitionProperty = DatastorePartitionProperty.builder()
     *         .partition(PartitionProperty.builder()
     *                 .attributeName("attributeName")
     *                 .build())
     *         .timestampPartition(TimestampPartitionProperty.builder()
     *                 .attributeName("attributeName")
     *                 // the properties below are optional
     *                 .timestampFormat("timestampFormat")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.DatastorePartitionProperty")
    @software.amazon.jsii.Jsii.Proxy(DatastorePartitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatastorePartitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A partition dimension defined by an attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartition.html#cfn-iotanalytics-datastore-datastorepartition-partition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartition.html#cfn-iotanalytics-datastore-datastorepartition-partition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPartition() {
            return null;
        }

        /**
         * A partition dimension defined by a timestamp attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartition.html#cfn-iotanalytics-datastore-datastorepartition-timestamppartition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartition.html#cfn-iotanalytics-datastore-datastorepartition-timestamppartition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimestampPartition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatastorePartitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatastorePartitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatastorePartitionProperty> {
            java.lang.Object partition;
            java.lang.Object timestampPartition;

            /**
             * Sets the value of {@link DatastorePartitionProperty#getPartition}
             * @param partition A partition dimension defined by an attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partition(software.amazon.awscdk.IResolvable partition) {
                this.partition = partition;
                return this;
            }

            /**
             * Sets the value of {@link DatastorePartitionProperty#getPartition}
             * @param partition A partition dimension defined by an attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partition(software.amazon.awscdk.services.iotanalytics.CfnDatastore.PartitionProperty partition) {
                this.partition = partition;
                return this;
            }

            /**
             * Sets the value of {@link DatastorePartitionProperty#getTimestampPartition}
             * @param timestampPartition A partition dimension defined by a timestamp attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestampPartition(software.amazon.awscdk.IResolvable timestampPartition) {
                this.timestampPartition = timestampPartition;
                return this;
            }

            /**
             * Sets the value of {@link DatastorePartitionProperty#getTimestampPartition}
             * @param timestampPartition A partition dimension defined by a timestamp attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestampPartition(software.amazon.awscdk.services.iotanalytics.CfnDatastore.TimestampPartitionProperty timestampPartition) {
                this.timestampPartition = timestampPartition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatastorePartitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatastorePartitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatastorePartitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatastorePartitionProperty {
            private final java.lang.Object partition;
            private final java.lang.Object timestampPartition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.partition = software.amazon.jsii.Kernel.get(this, "partition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timestampPartition = software.amazon.jsii.Kernel.get(this, "timestampPartition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.partition = builder.partition;
                this.timestampPartition = builder.timestampPartition;
            }

            @Override
            public final java.lang.Object getPartition() {
                return this.partition;
            }

            @Override
            public final java.lang.Object getTimestampPartition() {
                return this.timestampPartition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPartition() != null) {
                    data.set("partition", om.valueToTree(this.getPartition()));
                }
                if (this.getTimestampPartition() != null) {
                    data.set("timestampPartition", om.valueToTree(this.getTimestampPartition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.DatastorePartitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatastorePartitionProperty.Jsii$Proxy that = (DatastorePartitionProperty.Jsii$Proxy) o;

                if (this.partition != null ? !this.partition.equals(that.partition) : that.partition != null) return false;
                return this.timestampPartition != null ? this.timestampPartition.equals(that.timestampPartition) : that.timestampPartition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.partition != null ? this.partition.hashCode() : 0;
                result = 31 * result + (this.timestampPartition != null ? this.timestampPartition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the partition dimensions in a data store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * DatastorePartitionsProperty datastorePartitionsProperty = DatastorePartitionsProperty.builder()
     *         .partitions(List.of(DatastorePartitionProperty.builder()
     *                 .partition(PartitionProperty.builder()
     *                         .attributeName("attributeName")
     *                         .build())
     *                 .timestampPartition(TimestampPartitionProperty.builder()
     *                         .attributeName("attributeName")
     *                         // the properties below are optional
     *                         .timestampFormat("timestampFormat")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartitions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartitions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.DatastorePartitionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DatastorePartitionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatastorePartitionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of partition dimensions in a data store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartitions.html#cfn-iotanalytics-datastore-datastorepartitions-partitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartitions.html#cfn-iotanalytics-datastore-datastorepartitions-partitions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPartitions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatastorePartitionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatastorePartitionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatastorePartitionsProperty> {
            java.lang.Object partitions;

            /**
             * Sets the value of {@link DatastorePartitionsProperty#getPartitions}
             * @param partitions A list of partition dimensions in a data store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitions(software.amazon.awscdk.IResolvable partitions) {
                this.partitions = partitions;
                return this;
            }

            /**
             * Sets the value of {@link DatastorePartitionsProperty#getPartitions}
             * @param partitions A list of partition dimensions in a data store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitions(java.util.List<? extends java.lang.Object> partitions) {
                this.partitions = partitions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatastorePartitionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatastorePartitionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatastorePartitionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatastorePartitionsProperty {
            private final java.lang.Object partitions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.partitions = software.amazon.jsii.Kernel.get(this, "partitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.partitions = builder.partitions;
            }

            @Override
            public final java.lang.Object getPartitions() {
                return this.partitions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPartitions() != null) {
                    data.set("partitions", om.valueToTree(this.getPartitions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.DatastorePartitionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatastorePartitionsProperty.Jsii$Proxy that = (DatastorePartitionsProperty.Jsii$Proxy) o;

                return this.partitions != null ? this.partitions.equals(that.partitions) : that.partitions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.partitions != null ? this.partitions.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Where data store data is stored.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * Object serviceManagedS3;
     * DatastoreStorageProperty datastoreStorageProperty = DatastoreStorageProperty.builder()
     *         .customerManagedS3(CustomerManagedS3Property.builder()
     *                 .bucket("bucket")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .keyPrefix("keyPrefix")
     *                 .build())
     *         .iotSiteWiseMultiLayerStorage(IotSiteWiseMultiLayerStorageProperty.builder()
     *                 .customerManagedS3Storage(CustomerManagedS3StorageProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .keyPrefix("keyPrefix")
     *                         .build())
     *                 .build())
     *         .serviceManagedS3(serviceManagedS3)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.DatastoreStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(DatastoreStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatastoreStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Use this to store data store data in an S3 bucket that you manage.
         * <p>
         * The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html#cfn-iotanalytics-datastore-datastorestorage-customermanageds3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html#cfn-iotanalytics-datastore-datastorestorage-customermanageds3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerManagedS3() {
            return null;
        }

        /**
         * Use this to store data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage.
         * <p>
         * You can't change the choice of Amazon S3 storage after your data store is created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html#cfn-iotanalytics-datastore-datastorestorage-iotsitewisemultilayerstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html#cfn-iotanalytics-datastore-datastorestorage-iotsitewisemultilayerstorage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIotSiteWiseMultiLayerStorage() {
            return null;
        }

        /**
         * Use this to store data store data in an S3 bucket managed by the AWS IoT Analytics service.
         * <p>
         * The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html#cfn-iotanalytics-datastore-datastorestorage-servicemanageds3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html#cfn-iotanalytics-datastore-datastorestorage-servicemanageds3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceManagedS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatastoreStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatastoreStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatastoreStorageProperty> {
            java.lang.Object customerManagedS3;
            java.lang.Object iotSiteWiseMultiLayerStorage;
            java.lang.Object serviceManagedS3;

            /**
             * Sets the value of {@link DatastoreStorageProperty#getCustomerManagedS3}
             * @param customerManagedS3 Use this to store data store data in an S3 bucket that you manage.
             *                          The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerManagedS3(software.amazon.awscdk.IResolvable customerManagedS3) {
                this.customerManagedS3 = customerManagedS3;
                return this;
            }

            /**
             * Sets the value of {@link DatastoreStorageProperty#getCustomerManagedS3}
             * @param customerManagedS3 Use this to store data store data in an S3 bucket that you manage.
             *                          The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerManagedS3(software.amazon.awscdk.services.iotanalytics.CfnDatastore.CustomerManagedS3Property customerManagedS3) {
                this.customerManagedS3 = customerManagedS3;
                return this;
            }

            /**
             * Sets the value of {@link DatastoreStorageProperty#getIotSiteWiseMultiLayerStorage}
             * @param iotSiteWiseMultiLayerStorage Use this to store data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage.
             *                                     You can't change the choice of Amazon S3 storage after your data store is created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotSiteWiseMultiLayerStorage(software.amazon.awscdk.IResolvable iotSiteWiseMultiLayerStorage) {
                this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage;
                return this;
            }

            /**
             * Sets the value of {@link DatastoreStorageProperty#getIotSiteWiseMultiLayerStorage}
             * @param iotSiteWiseMultiLayerStorage Use this to store data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage.
             *                                     You can't change the choice of Amazon S3 storage after your data store is created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotSiteWiseMultiLayerStorage(software.amazon.awscdk.services.iotanalytics.CfnDatastore.IotSiteWiseMultiLayerStorageProperty iotSiteWiseMultiLayerStorage) {
                this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage;
                return this;
            }

            /**
             * Sets the value of {@link DatastoreStorageProperty#getServiceManagedS3}
             * @param serviceManagedS3 Use this to store data store data in an S3 bucket managed by the AWS IoT Analytics service.
             *                         The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceManagedS3(java.lang.Object serviceManagedS3) {
                this.serviceManagedS3 = serviceManagedS3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatastoreStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatastoreStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatastoreStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatastoreStorageProperty {
            private final java.lang.Object customerManagedS3;
            private final java.lang.Object iotSiteWiseMultiLayerStorage;
            private final java.lang.Object serviceManagedS3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customerManagedS3 = software.amazon.jsii.Kernel.get(this, "customerManagedS3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iotSiteWiseMultiLayerStorage = software.amazon.jsii.Kernel.get(this, "iotSiteWiseMultiLayerStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceManagedS3 = software.amazon.jsii.Kernel.get(this, "serviceManagedS3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customerManagedS3 = builder.customerManagedS3;
                this.iotSiteWiseMultiLayerStorage = builder.iotSiteWiseMultiLayerStorage;
                this.serviceManagedS3 = builder.serviceManagedS3;
            }

            @Override
            public final java.lang.Object getCustomerManagedS3() {
                return this.customerManagedS3;
            }

            @Override
            public final java.lang.Object getIotSiteWiseMultiLayerStorage() {
                return this.iotSiteWiseMultiLayerStorage;
            }

            @Override
            public final java.lang.Object getServiceManagedS3() {
                return this.serviceManagedS3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomerManagedS3() != null) {
                    data.set("customerManagedS3", om.valueToTree(this.getCustomerManagedS3()));
                }
                if (this.getIotSiteWiseMultiLayerStorage() != null) {
                    data.set("iotSiteWiseMultiLayerStorage", om.valueToTree(this.getIotSiteWiseMultiLayerStorage()));
                }
                if (this.getServiceManagedS3() != null) {
                    data.set("serviceManagedS3", om.valueToTree(this.getServiceManagedS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.DatastoreStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatastoreStorageProperty.Jsii$Proxy that = (DatastoreStorageProperty.Jsii$Proxy) o;

                if (this.customerManagedS3 != null ? !this.customerManagedS3.equals(that.customerManagedS3) : that.customerManagedS3 != null) return false;
                if (this.iotSiteWiseMultiLayerStorage != null ? !this.iotSiteWiseMultiLayerStorage.equals(that.iotSiteWiseMultiLayerStorage) : that.iotSiteWiseMultiLayerStorage != null) return false;
                return this.serviceManagedS3 != null ? this.serviceManagedS3.equals(that.serviceManagedS3) : that.serviceManagedS3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customerManagedS3 != null ? this.customerManagedS3.hashCode() : 0;
                result = 31 * result + (this.iotSiteWiseMultiLayerStorage != null ? this.iotSiteWiseMultiLayerStorage.hashCode() : 0);
                result = 31 * result + (this.serviceManagedS3 != null ? this.serviceManagedS3.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and <a href="https://docs.aws.amazon.com/https://parquet.apache.org/">Parquet</a> .
     * <p>
     * The default file format is JSON. You can specify only one format.
     * <p>
     * You can't change the file format after you create the data store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * Object jsonConfiguration;
     * FileFormatConfigurationProperty fileFormatConfigurationProperty = FileFormatConfigurationProperty.builder()
     *         .jsonConfiguration(jsonConfiguration)
     *         .parquetConfiguration(ParquetConfigurationProperty.builder()
     *                 .schemaDefinition(SchemaDefinitionProperty.builder()
     *                         .columns(List.of(ColumnProperty.builder()
     *                                 .name("name")
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-fileformatconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-fileformatconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.FileFormatConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FileFormatConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FileFormatConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains the configuration information of the JSON format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-fileformatconfiguration.html#cfn-iotanalytics-datastore-fileformatconfiguration-jsonconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-fileformatconfiguration.html#cfn-iotanalytics-datastore-fileformatconfiguration-jsonconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJsonConfiguration() {
            return null;
        }

        /**
         * Contains the configuration information of the Parquet format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-fileformatconfiguration.html#cfn-iotanalytics-datastore-fileformatconfiguration-parquetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-fileformatconfiguration.html#cfn-iotanalytics-datastore-fileformatconfiguration-parquetconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParquetConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FileFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FileFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FileFormatConfigurationProperty> {
            java.lang.Object jsonConfiguration;
            java.lang.Object parquetConfiguration;

            /**
             * Sets the value of {@link FileFormatConfigurationProperty#getJsonConfiguration}
             * @param jsonConfiguration Contains the configuration information of the JSON format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonConfiguration(java.lang.Object jsonConfiguration) {
                this.jsonConfiguration = jsonConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FileFormatConfigurationProperty#getParquetConfiguration}
             * @param parquetConfiguration Contains the configuration information of the Parquet format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquetConfiguration(software.amazon.awscdk.IResolvable parquetConfiguration) {
                this.parquetConfiguration = parquetConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FileFormatConfigurationProperty#getParquetConfiguration}
             * @param parquetConfiguration Contains the configuration information of the Parquet format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquetConfiguration(software.amazon.awscdk.services.iotanalytics.CfnDatastore.ParquetConfigurationProperty parquetConfiguration) {
                this.parquetConfiguration = parquetConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FileFormatConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FileFormatConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FileFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileFormatConfigurationProperty {
            private final java.lang.Object jsonConfiguration;
            private final java.lang.Object parquetConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jsonConfiguration = software.amazon.jsii.Kernel.get(this, "jsonConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parquetConfiguration = software.amazon.jsii.Kernel.get(this, "parquetConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jsonConfiguration = builder.jsonConfiguration;
                this.parquetConfiguration = builder.parquetConfiguration;
            }

            @Override
            public final java.lang.Object getJsonConfiguration() {
                return this.jsonConfiguration;
            }

            @Override
            public final java.lang.Object getParquetConfiguration() {
                return this.parquetConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJsonConfiguration() != null) {
                    data.set("jsonConfiguration", om.valueToTree(this.getJsonConfiguration()));
                }
                if (this.getParquetConfiguration() != null) {
                    data.set("parquetConfiguration", om.valueToTree(this.getParquetConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.FileFormatConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FileFormatConfigurationProperty.Jsii$Proxy that = (FileFormatConfigurationProperty.Jsii$Proxy) o;

                if (this.jsonConfiguration != null ? !this.jsonConfiguration.equals(that.jsonConfiguration) : that.jsonConfiguration != null) return false;
                return this.parquetConfiguration != null ? this.parquetConfiguration.equals(that.parquetConfiguration) : that.parquetConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jsonConfiguration != null ? this.jsonConfiguration.hashCode() : 0;
                result = 31 * result + (this.parquetConfiguration != null ? this.parquetConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Stores data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage.
     * <p>
     * You can't change the choice of Amazon S3 storage after your data store is created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * IotSiteWiseMultiLayerStorageProperty iotSiteWiseMultiLayerStorageProperty = IotSiteWiseMultiLayerStorageProperty.builder()
     *         .customerManagedS3Storage(CustomerManagedS3StorageProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .keyPrefix("keyPrefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-iotsitewisemultilayerstorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-iotsitewisemultilayerstorage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.IotSiteWiseMultiLayerStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(IotSiteWiseMultiLayerStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IotSiteWiseMultiLayerStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Stores data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-iotsitewisemultilayerstorage.html#cfn-iotanalytics-datastore-iotsitewisemultilayerstorage-customermanageds3storage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-iotsitewisemultilayerstorage.html#cfn-iotanalytics-datastore-iotsitewisemultilayerstorage-customermanageds3storage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerManagedS3Storage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IotSiteWiseMultiLayerStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IotSiteWiseMultiLayerStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IotSiteWiseMultiLayerStorageProperty> {
            java.lang.Object customerManagedS3Storage;

            /**
             * Sets the value of {@link IotSiteWiseMultiLayerStorageProperty#getCustomerManagedS3Storage}
             * @param customerManagedS3Storage Stores data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerManagedS3Storage(software.amazon.awscdk.IResolvable customerManagedS3Storage) {
                this.customerManagedS3Storage = customerManagedS3Storage;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseMultiLayerStorageProperty#getCustomerManagedS3Storage}
             * @param customerManagedS3Storage Stores data used by AWS IoT SiteWise in an Amazon S3 bucket that you manage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerManagedS3Storage(software.amazon.awscdk.services.iotanalytics.CfnDatastore.CustomerManagedS3StorageProperty customerManagedS3Storage) {
                this.customerManagedS3Storage = customerManagedS3Storage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IotSiteWiseMultiLayerStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IotSiteWiseMultiLayerStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IotSiteWiseMultiLayerStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotSiteWiseMultiLayerStorageProperty {
            private final java.lang.Object customerManagedS3Storage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customerManagedS3Storage = software.amazon.jsii.Kernel.get(this, "customerManagedS3Storage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customerManagedS3Storage = builder.customerManagedS3Storage;
            }

            @Override
            public final java.lang.Object getCustomerManagedS3Storage() {
                return this.customerManagedS3Storage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomerManagedS3Storage() != null) {
                    data.set("customerManagedS3Storage", om.valueToTree(this.getCustomerManagedS3Storage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.IotSiteWiseMultiLayerStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IotSiteWiseMultiLayerStorageProperty.Jsii$Proxy that = (IotSiteWiseMultiLayerStorageProperty.Jsii$Proxy) o;

                return this.customerManagedS3Storage != null ? this.customerManagedS3Storage.equals(that.customerManagedS3Storage) : that.customerManagedS3Storage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customerManagedS3Storage != null ? this.customerManagedS3Storage.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains the configuration information of the Parquet format.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * ParquetConfigurationProperty parquetConfigurationProperty = ParquetConfigurationProperty.builder()
     *         .schemaDefinition(SchemaDefinitionProperty.builder()
     *                 .columns(List.of(ColumnProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-parquetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-parquetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.ParquetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ParquetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParquetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information needed to define a schema.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-parquetconfiguration.html#cfn-iotanalytics-datastore-parquetconfiguration-schemadefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-parquetconfiguration.html#cfn-iotanalytics-datastore-parquetconfiguration-schemadefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSchemaDefinition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParquetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParquetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParquetConfigurationProperty> {
            java.lang.Object schemaDefinition;

            /**
             * Sets the value of {@link ParquetConfigurationProperty#getSchemaDefinition}
             * @param schemaDefinition Information needed to define a schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaDefinition(software.amazon.awscdk.IResolvable schemaDefinition) {
                this.schemaDefinition = schemaDefinition;
                return this;
            }

            /**
             * Sets the value of {@link ParquetConfigurationProperty#getSchemaDefinition}
             * @param schemaDefinition Information needed to define a schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaDefinition(software.amazon.awscdk.services.iotanalytics.CfnDatastore.SchemaDefinitionProperty schemaDefinition) {
                this.schemaDefinition = schemaDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParquetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParquetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParquetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParquetConfigurationProperty {
            private final java.lang.Object schemaDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.schemaDefinition = software.amazon.jsii.Kernel.get(this, "schemaDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.schemaDefinition = builder.schemaDefinition;
            }

            @Override
            public final java.lang.Object getSchemaDefinition() {
                return this.schemaDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSchemaDefinition() != null) {
                    data.set("schemaDefinition", om.valueToTree(this.getSchemaDefinition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.ParquetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParquetConfigurationProperty.Jsii$Proxy that = (ParquetConfigurationProperty.Jsii$Proxy) o;

                return this.schemaDefinition != null ? this.schemaDefinition.equals(that.schemaDefinition) : that.schemaDefinition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.schemaDefinition != null ? this.schemaDefinition.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A single dimension to partition a data store.
     * <p>
     * The dimension must be an <code>AttributePartition</code> or a <code>TimestampPartition</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * PartitionProperty partitionProperty = PartitionProperty.builder()
     *         .attributeName("attributeName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-partition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-partition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.PartitionProperty")
    @software.amazon.jsii.Jsii.Proxy(PartitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PartitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the attribute that defines a partition dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-partition.html#cfn-iotanalytics-datastore-partition-attributename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-partition.html#cfn-iotanalytics-datastore-partition-attributename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeName();

        /**
         * @return a {@link Builder} of {@link PartitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PartitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PartitionProperty> {
            java.lang.String attributeName;

            /**
             * Sets the value of {@link PartitionProperty#getAttributeName}
             * @param attributeName The name of the attribute that defines a partition dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PartitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PartitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PartitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PartitionProperty {
            private final java.lang.String attributeName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeName = software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeName = java.util.Objects.requireNonNull(builder.attributeName, "attributeName is required");
            }

            @Override
            public final java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeName", om.valueToTree(this.getAttributeName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.PartitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PartitionProperty.Jsii$Proxy that = (PartitionProperty.Jsii$Proxy) o;

                return this.attributeName.equals(that.attributeName);
            }

            @Override
            public final int hashCode() {
                int result = this.attributeName.hashCode();
                return result;
            }
        }
    }
    /**
     * How long, in days, message data is kept.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * RetentionPeriodProperty retentionPeriodProperty = RetentionPeriodProperty.builder()
     *         .numberOfDays(123)
     *         .unlimited(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-retentionperiod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-retentionperiod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.RetentionPeriodProperty")
    @software.amazon.jsii.Jsii.Proxy(RetentionPeriodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetentionPeriodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of days that message data is kept.
         * <p>
         * The <code>unlimited</code> parameter must be false.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-retentionperiod.html#cfn-iotanalytics-datastore-retentionperiod-numberofdays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-retentionperiod.html#cfn-iotanalytics-datastore-retentionperiod-numberofdays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfDays() {
            return null;
        }

        /**
         * If true, message data is kept indefinitely.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-retentionperiod.html#cfn-iotanalytics-datastore-retentionperiod-unlimited">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-retentionperiod.html#cfn-iotanalytics-datastore-retentionperiod-unlimited</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUnlimited() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetentionPeriodProperty> {
            java.lang.Number numberOfDays;
            java.lang.Object unlimited;

            /**
             * Sets the value of {@link RetentionPeriodProperty#getNumberOfDays}
             * @param numberOfDays The number of days that message data is kept.
             *                     The <code>unlimited</code> parameter must be false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfDays(java.lang.Number numberOfDays) {
                this.numberOfDays = numberOfDays;
                return this;
            }

            /**
             * Sets the value of {@link RetentionPeriodProperty#getUnlimited}
             * @param unlimited If true, message data is kept indefinitely.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unlimited(java.lang.Boolean unlimited) {
                this.unlimited = unlimited;
                return this;
            }

            /**
             * Sets the value of {@link RetentionPeriodProperty#getUnlimited}
             * @param unlimited If true, message data is kept indefinitely.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unlimited(software.amazon.awscdk.IResolvable unlimited) {
                this.unlimited = unlimited;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetentionPeriodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetentionPeriodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetentionPeriodProperty {
            private final java.lang.Number numberOfDays;
            private final java.lang.Object unlimited;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.numberOfDays = software.amazon.jsii.Kernel.get(this, "numberOfDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unlimited = software.amazon.jsii.Kernel.get(this, "unlimited", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.numberOfDays = builder.numberOfDays;
                this.unlimited = builder.unlimited;
            }

            @Override
            public final java.lang.Number getNumberOfDays() {
                return this.numberOfDays;
            }

            @Override
            public final java.lang.Object getUnlimited() {
                return this.unlimited;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNumberOfDays() != null) {
                    data.set("numberOfDays", om.valueToTree(this.getNumberOfDays()));
                }
                if (this.getUnlimited() != null) {
                    data.set("unlimited", om.valueToTree(this.getUnlimited()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.RetentionPeriodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetentionPeriodProperty.Jsii$Proxy that = (RetentionPeriodProperty.Jsii$Proxy) o;

                if (this.numberOfDays != null ? !this.numberOfDays.equals(that.numberOfDays) : that.numberOfDays != null) return false;
                return this.unlimited != null ? this.unlimited.equals(that.unlimited) : that.unlimited == null;
            }

            @Override
            public final int hashCode() {
                int result = this.numberOfDays != null ? this.numberOfDays.hashCode() : 0;
                result = 31 * result + (this.unlimited != null ? this.unlimited.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information needed to define a schema.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * SchemaDefinitionProperty schemaDefinitionProperty = SchemaDefinitionProperty.builder()
     *         .columns(List.of(ColumnProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-schemadefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-schemadefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.SchemaDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies one or more columns that store your data.
         * <p>
         * Each schema can have up to 100 columns. Each column can have up to 100 nested types.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-schemadefinition.html#cfn-iotanalytics-datastore-schemadefinition-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-schemadefinition.html#cfn-iotanalytics-datastore-schemadefinition-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaDefinitionProperty> {
            java.lang.Object columns;

            /**
             * Sets the value of {@link SchemaDefinitionProperty#getColumns}
             * @param columns Specifies one or more columns that store your data.
             *                Each schema can have up to 100 columns. Each column can have up to 100 nested types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link SchemaDefinitionProperty#getColumns}
             * @param columns Specifies one or more columns that store your data.
             *                Each schema can have up to 100 columns. Each column can have up to 100 nested types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<? extends java.lang.Object> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaDefinitionProperty {
            private final java.lang.Object columns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = builder.columns;
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumns() != null) {
                    data.set("columns", om.valueToTree(this.getColumns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.SchemaDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaDefinitionProperty.Jsii$Proxy that = (SchemaDefinitionProperty.Jsii$Proxy) o;

                return this.columns != null ? this.columns.equals(that.columns) : that.columns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columns != null ? this.columns.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A partition dimension defined by a timestamp attribute.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * TimestampPartitionProperty timestampPartitionProperty = TimestampPartitionProperty.builder()
     *         .attributeName("attributeName")
     *         // the properties below are optional
     *         .timestampFormat("timestampFormat")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-timestamppartition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-timestamppartition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastore.TimestampPartitionProperty")
    @software.amazon.jsii.Jsii.Proxy(TimestampPartitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimestampPartitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The attribute name of the partition defined by a timestamp.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-timestamppartition.html#cfn-iotanalytics-datastore-timestamppartition-attributename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-timestamppartition.html#cfn-iotanalytics-datastore-timestamppartition-attributename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeName();

        /**
         * The timestamp format of a partition defined by a timestamp.
         * <p>
         * The default format is seconds since epoch (January 1, 1970 at midnight UTC time).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-timestamppartition.html#cfn-iotanalytics-datastore-timestamppartition-timestampformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-timestamppartition.html#cfn-iotanalytics-datastore-timestamppartition-timestampformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimestampFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimestampPartitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimestampPartitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimestampPartitionProperty> {
            java.lang.String attributeName;
            java.lang.String timestampFormat;

            /**
             * Sets the value of {@link TimestampPartitionProperty#getAttributeName}
             * @param attributeName The attribute name of the partition defined by a timestamp. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Sets the value of {@link TimestampPartitionProperty#getTimestampFormat}
             * @param timestampFormat The timestamp format of a partition defined by a timestamp.
             *                        The default format is seconds since epoch (January 1, 1970 at midnight UTC time).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestampFormat(java.lang.String timestampFormat) {
                this.timestampFormat = timestampFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimestampPartitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimestampPartitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimestampPartitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimestampPartitionProperty {
            private final java.lang.String attributeName;
            private final java.lang.String timestampFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeName = software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timestampFormat = software.amazon.jsii.Kernel.get(this, "timestampFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeName = java.util.Objects.requireNonNull(builder.attributeName, "attributeName is required");
                this.timestampFormat = builder.timestampFormat;
            }

            @Override
            public final java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public final java.lang.String getTimestampFormat() {
                return this.timestampFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeName", om.valueToTree(this.getAttributeName()));
                if (this.getTimestampFormat() != null) {
                    data.set("timestampFormat", om.valueToTree(this.getTimestampFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastore.TimestampPartitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimestampPartitionProperty.Jsii$Proxy that = (TimestampPartitionProperty.Jsii$Proxy) o;

                if (!attributeName.equals(that.attributeName)) return false;
                return this.timestampFormat != null ? this.timestampFormat.equals(that.timestampFormat) : that.timestampFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributeName.hashCode();
                result = 31 * result + (this.timestampFormat != null ? this.timestampFormat.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotanalytics.CfnDatastore}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotanalytics.CfnDatastore> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iotanalytics.CfnDatastoreProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorename</a>
         * @param datastoreName The name of the data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreName(final java.lang.String datastoreName) {
            this.props().datastoreName(datastoreName);
            return this;
        }

        /**
         * Information about the partition dimensions in a data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorepartitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorepartitions</a>
         * @param datastorePartitions Information about the partition dimensions in a data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastorePartitions(final software.amazon.awscdk.IResolvable datastorePartitions) {
            this.props().datastorePartitions(datastorePartitions);
            return this;
        }
        /**
         * Information about the partition dimensions in a data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorepartitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorepartitions</a>
         * @param datastorePartitions Information about the partition dimensions in a data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastorePartitions(final software.amazon.awscdk.services.iotanalytics.CfnDatastore.DatastorePartitionsProperty datastorePartitions) {
            this.props().datastorePartitions(datastorePartitions);
            return this;
        }

        /**
         * Where data store data is stored.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorestorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorestorage</a>
         * @param datastoreStorage Where data store data is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreStorage(final software.amazon.awscdk.IResolvable datastoreStorage) {
            this.props().datastoreStorage(datastoreStorage);
            return this;
        }
        /**
         * Where data store data is stored.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorestorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorestorage</a>
         * @param datastoreStorage Where data store data is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreStorage(final software.amazon.awscdk.services.iotanalytics.CfnDatastore.DatastoreStorageProperty datastoreStorage) {
            this.props().datastoreStorage(datastoreStorage);
            return this;
        }

        /**
         * Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and <a href="https://docs.aws.amazon.com/https://parquet.apache.org/">Parquet</a> .
         * <p>
         * The default file format is JSON. You can specify only one format.
         * <p>
         * You can't change the file format after you create the data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-fileformatconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-fileformatconfiguration</a>
         * @param fileFormatConfiguration Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and <a href="https://docs.aws.amazon.com/https://parquet.apache.org/">Parquet</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileFormatConfiguration(final software.amazon.awscdk.IResolvable fileFormatConfiguration) {
            this.props().fileFormatConfiguration(fileFormatConfiguration);
            return this;
        }
        /**
         * Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and <a href="https://docs.aws.amazon.com/https://parquet.apache.org/">Parquet</a> .
         * <p>
         * The default file format is JSON. You can specify only one format.
         * <p>
         * You can't change the file format after you create the data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-fileformatconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-fileformatconfiguration</a>
         * @param fileFormatConfiguration Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and <a href="https://docs.aws.amazon.com/https://parquet.apache.org/">Parquet</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileFormatConfiguration(final software.amazon.awscdk.services.iotanalytics.CfnDatastore.FileFormatConfigurationProperty fileFormatConfiguration) {
            this.props().fileFormatConfiguration(fileFormatConfiguration);
            return this;
        }

        /**
         * How long, in days, message data is kept for the data store.
         * <p>
         * When <code>customerManagedS3</code> storage is selected, this parameter is ignored.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-retentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-retentionperiod</a>
         * @param retentionPeriod How long, in days, message data is kept for the data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final software.amazon.awscdk.IResolvable retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }
        /**
         * How long, in days, message data is kept for the data store.
         * <p>
         * When <code>customerManagedS3</code> storage is selected, this parameter is ignored.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-retentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-retentionperiod</a>
         * @param retentionPeriod How long, in days, message data is kept for the data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final software.amazon.awscdk.services.iotanalytics.CfnDatastore.RetentionPeriodProperty retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }

        /**
         * Metadata which can be used to manage the data store.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-tags</a>
         * @param tags Metadata which can be used to manage the data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotanalytics.CfnDatastore}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotanalytics.CfnDatastore build() {
            return new software.amazon.awscdk.services.iotanalytics.CfnDatastore(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iotanalytics.CfnDatastoreProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iotanalytics.CfnDatastoreProps.Builder();
            }
            return this.props;
        }
    }
}
