package software.amazon.awscdk.services.iotsitewise;

/**
 * Properties for defining a <code>CfnAccessPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * CfnAccessPolicyProps cfnAccessPolicyProps = CfnAccessPolicyProps.builder()
 *         .accessPolicyIdentity(AccessPolicyIdentityProperty.builder()
 *                 .iamRole(IamRoleProperty.builder()
 *                         .arn("arn")
 *                         .build())
 *                 .iamUser(IamUserProperty.builder()
 *                         .arn("arn")
 *                         .build())
 *                 .user(UserProperty.builder()
 *                         .id("id")
 *                         .build())
 *                 .build())
 *         .accessPolicyPermission("accessPolicyPermission")
 *         .accessPolicyResource(AccessPolicyResourceProperty.builder()
 *                 .portal(PortalProperty.builder()
 *                         .id("id")
 *                         .build())
 *                 .project(ProjectProperty.builder()
 *                         .id("id")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:16.035Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAccessPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnAccessPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAccessPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identity for this access policy.
     * <p>
     * Choose an IAM Identity Center user, an IAM Identity Center group, or an IAM user.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicyidentity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicyidentity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAccessPolicyIdentity();

    /**
     * The permission level for this access policy.
     * <p>
     * Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicypermission">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicypermission</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessPolicyPermission();

    /**
     * The AWS IoT SiteWise Monitor resource for this access policy.
     * <p>
     * Choose either a portal or a project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicyresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicyresource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAccessPolicyResource();

    /**
     * @return a {@link Builder} of {@link CfnAccessPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAccessPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAccessPolicyProps> {
        java.lang.Object accessPolicyIdentity;
        java.lang.String accessPolicyPermission;
        java.lang.Object accessPolicyResource;

        /**
         * Sets the value of {@link CfnAccessPolicyProps#getAccessPolicyIdentity}
         * @param accessPolicyIdentity The identity for this access policy. This parameter is required.
         *                             Choose an IAM Identity Center user, an IAM Identity Center group, or an IAM user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicyIdentity(software.amazon.awscdk.IResolvable accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPolicyProps#getAccessPolicyIdentity}
         * @param accessPolicyIdentity The identity for this access policy. This parameter is required.
         *                             Choose an IAM Identity Center user, an IAM Identity Center group, or an IAM user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicyIdentity(software.amazon.awscdk.services.iotsitewise.CfnAccessPolicy.AccessPolicyIdentityProperty accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPolicyProps#getAccessPolicyPermission}
         * @param accessPolicyPermission The permission level for this access policy. This parameter is required.
         *                               Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicyPermission(java.lang.String accessPolicyPermission) {
            this.accessPolicyPermission = accessPolicyPermission;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPolicyProps#getAccessPolicyResource}
         * @param accessPolicyResource The AWS IoT SiteWise Monitor resource for this access policy. This parameter is required.
         *                             Choose either a portal or a project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicyResource(software.amazon.awscdk.IResolvable accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPolicyProps#getAccessPolicyResource}
         * @param accessPolicyResource The AWS IoT SiteWise Monitor resource for this access policy. This parameter is required.
         *                             Choose either a portal or a project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicyResource(software.amazon.awscdk.services.iotsitewise.CfnAccessPolicy.AccessPolicyResourceProperty accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAccessPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAccessPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAccessPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAccessPolicyProps {
        private final java.lang.Object accessPolicyIdentity;
        private final java.lang.String accessPolicyPermission;
        private final java.lang.Object accessPolicyResource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessPolicyIdentity = software.amazon.jsii.Kernel.get(this, "accessPolicyIdentity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.accessPolicyPermission = software.amazon.jsii.Kernel.get(this, "accessPolicyPermission", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessPolicyResource = software.amazon.jsii.Kernel.get(this, "accessPolicyResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessPolicyIdentity = java.util.Objects.requireNonNull(builder.accessPolicyIdentity, "accessPolicyIdentity is required");
            this.accessPolicyPermission = java.util.Objects.requireNonNull(builder.accessPolicyPermission, "accessPolicyPermission is required");
            this.accessPolicyResource = java.util.Objects.requireNonNull(builder.accessPolicyResource, "accessPolicyResource is required");
        }

        @Override
        public final java.lang.Object getAccessPolicyIdentity() {
            return this.accessPolicyIdentity;
        }

        @Override
        public final java.lang.String getAccessPolicyPermission() {
            return this.accessPolicyPermission;
        }

        @Override
        public final java.lang.Object getAccessPolicyResource() {
            return this.accessPolicyResource;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessPolicyIdentity", om.valueToTree(this.getAccessPolicyIdentity()));
            data.set("accessPolicyPermission", om.valueToTree(this.getAccessPolicyPermission()));
            data.set("accessPolicyResource", om.valueToTree(this.getAccessPolicyResource()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAccessPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAccessPolicyProps.Jsii$Proxy that = (CfnAccessPolicyProps.Jsii$Proxy) o;

            if (!accessPolicyIdentity.equals(that.accessPolicyIdentity)) return false;
            if (!accessPolicyPermission.equals(that.accessPolicyPermission)) return false;
            return this.accessPolicyResource.equals(that.accessPolicyResource);
        }

        @Override
        public final int hashCode() {
            int result = this.accessPolicyIdentity.hashCode();
            result = 31 * result + (this.accessPolicyPermission.hashCode());
            result = 31 * result + (this.accessPolicyResource.hashCode());
            return result;
        }
    }
}
