package software.amazon.awscdk.services.kms;

/**
 * Defines a display name for a customer master key (CMK) in AWS Key Management Service (AWS KMS).
 * <p>
 * Using an alias to refer to a key can help you simplify key
 * management. For example, when rotating keys, you can just update the alias
 * mapping instead of tracking and changing key IDs. For more information, see
 * Working with Aliases in the AWS Key Management Service Developer Guide.
 * <p>
 * You can also add an alias for a key by calling <code>key.addAlias(alias)</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Passing an encrypted replication bucket created in a different stack.
 * App app = new App();
 * Stack replicationStack = Stack.Builder.create(app, "ReplicationStack")
 *         .env(Environment.builder()
 *                 .region("us-west-1")
 *                 .build())
 *         .build();
 * Key key = new Key(replicationStack, "ReplicationKey");
 * Alias alias = Alias.Builder.create(replicationStack, "ReplicationAlias")
 *         // aliasName is required
 *         .aliasName(PhysicalName.GENERATE_IF_NEEDED)
 *         .targetKey(key)
 *         .build();
 * Bucket replicationBucket = Bucket.Builder.create(replicationStack, "ReplicationBucket")
 *         .bucketName(PhysicalName.GENERATE_IF_NEEDED)
 *         .encryptionKey(alias)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:16.566Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kms.Alias")
public class Alias extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.kms.IAlias {

    protected Alias(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Alias(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kms.Alias.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Alias(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.AliasProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing KMS Alias defined outside the CDK app.
     * <p>
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs the properties of the referenced KMS Alias. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IAlias fromAliasAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.AliasAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kms.Alias.class, "fromAliasAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IAlias.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import an existing KMS Alias defined outside the CDK app, by the alias name.
     * <p>
     * This method should be used
     * instead of 'fromAliasAttributes' when the underlying KMS Key ARN is not available.
     * This Alias will not have a direct reference to the KMS Key, so addAlias method is not supported.
     * <p>
     * If the <code>&#64;aws-cdk/aws-kms:applyImportedAliasPermissionsToPrincipal</code> feature flag is set to <code>true</code>,
     * the grant* methods will use the kms:ResourceAliases condition to grant permissions to the specific alias name.
     * They will only modify the principal policy, not the key resource policy.
     * Without the feature flag <code>grant*</code> methods will be a no-op.
     * <p>
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param aliasName The full name of the KMS Alias (e.g., 'alias/aws/s3', 'alias/myKeyAlias'). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IAlias fromAliasName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String aliasName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kms.Alias.class, "fromAliasName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IAlias.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(aliasName, "aliasName is required") });
    }

    /**
     * Defines a new alias for the key.
     * <p>
     * @param alias This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.Alias addAlias(final @org.jetbrains.annotations.NotNull java.lang.String alias) {
        return software.amazon.jsii.Kernel.call(this, "addAlias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.Alias.class), new Object[] { java.util.Objects.requireNonNull(alias, "alias is required") });
    }

    /**
     * Adds a statement to the KMS key resource policy.
     * <p>
     * @param statement This parameter is required.
     * @param allowNoOp
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement, final @org.jetbrains.annotations.Nullable java.lang.Boolean allowNoOp) {
        return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required"), allowNoOp });
    }

    /**
     * Adds a statement to the KMS key resource policy.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.lang.String generatePhysicalName() {
        return software.amazon.jsii.Kernel.call(this, "generatePhysicalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Grant the indicated permissions on this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant decryption permissions using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDecrypt(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantDecrypt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant encryption permissions using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantEncrypt(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantEncrypt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant encryption and decryption permissions using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantEncryptDecrypt(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantEncryptDecrypt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant permissions to generating MACs to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantGenerateMac(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantGenerateMac", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant sign permissions using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSign(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantSign", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant sign and verify permissions using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSignVerify(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantSignVerify", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant verify permissions using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantVerify(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantVerify", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant permissions to verifying MACs to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantVerifyMac(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantVerifyMac", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The ARN of the alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAliasArn() {
        return software.amazon.jsii.Kernel.get(this, "aliasArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the alias.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAliasName() {
        return software.amazon.jsii.Kernel.get(this, "aliasName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Key to which the Alias refers.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey getAliasTargetKey() {
        return software.amazon.jsii.Kernel.get(this, "aliasTargetKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * (deprecated) The ARN of the alias.
     * <p>
     * @deprecated use <code>aliasArn</code> instead
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "keyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyId() {
        return software.amazon.jsii.Kernel.get(this, "keyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kms.Alias}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kms.Alias> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kms.AliasProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kms.AliasProps.Builder();
        }

        /**
         * The name of the alias.
         * <p>
         * The name must start with alias followed by a
         * forward slash, such as alias/. You can't specify aliases that begin with
         * alias/AWS. These aliases are reserved.
         * <p>
         * @return {@code this}
         * @param aliasName The name of the alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasName(final java.lang.String aliasName) {
            this.props.aliasName(aliasName);
            return this;
        }

        /**
         * The ID of the key for which you are creating the alias.
         * <p>
         * Specify the key's
         * globally unique identifier or Amazon Resource Name (ARN). You can't
         * specify another alias.
         * <p>
         * @return {@code this}
         * @param targetKey The ID of the key for which you are creating the alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetKey(final software.amazon.awscdk.services.kms.IKey targetKey) {
            this.props.targetKey(targetKey);
            return this;
        }

        /**
         * Policy to apply when the alias is removed from this stack.
         * <p>
         * Default: - The alias will be deleted
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the alias is removed from this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kms.Alias}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kms.Alias build() {
            return new software.amazon.awscdk.services.kms.Alias(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
