package software.amazon.awscdk.services.logs;

/**
 * Creates a custom resource to control the retention policy of a CloudWatch Logs log group.
 * <p>
 * The log group is created if it doesn't already exist. The policy
 * is removed when <code>retentionDays</code> is <code>undefined</code> or equal to <code>Infinity</code>.
 * Log group can be created in the region that is different from stack region by
 * specifying <code>logGroupRegion</code>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.logs.*;
 * Role role;
 * LogRetention logRetention = LogRetention.Builder.create(this, "MyLogRetention")
 *         .logGroupName("logGroupName")
 *         .retention(RetentionDays.ONE_DAY)
 *         // the properties below are optional
 *         .logGroupRegion("logGroupRegion")
 *         .logRetentionRetryOptions(LogRetentionRetryOptions.builder()
 *                 .base(Duration.minutes(30))
 *                 .maxRetries(123)
 *                 .build())
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .role(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:17.309Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.LogRetention")
public class LogRetention extends software.constructs.Construct {

    protected LogRetention(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogRetention(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.LogRetention.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LogRetention(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogRetentionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The ARN of the LogGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.LogRetention}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.LogRetention> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.logs.LogRetentionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.logs.LogRetentionProps.Builder();
        }

        /**
         * The log group name.
         * <p>
         * @return {@code this}
         * @param logGroupName The log group name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(final java.lang.String logGroupName) {
            this.props.logGroupName(logGroupName);
            return this;
        }

        /**
         * The number of days log events are kept in CloudWatch Logs.
         * <p>
         * @return {@code this}
         * @param retention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(final software.amazon.awscdk.services.logs.RetentionDays retention) {
            this.props.retention(retention);
            return this;
        }

        /**
         * The region where the log group should be created.
         * <p>
         * Default: - same region as the stack
         * <p>
         * @return {@code this}
         * @param logGroupRegion The region where the log group should be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupRegion(final java.lang.String logGroupRegion) {
            this.props.logGroupRegion(logGroupRegion);
            return this;
        }

        /**
         * Retry options for all AWS API calls.
         * <p>
         * Default: - AWS SDK default retry options
         * <p>
         * @return {@code this}
         * @param logRetentionRetryOptions Retry options for all AWS API calls. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRetryOptions(final software.amazon.awscdk.services.logs.LogRetentionRetryOptions logRetentionRetryOptions) {
            this.props.logRetentionRetryOptions(logRetentionRetryOptions);
            return this;
        }

        /**
         * The removalPolicy for the log group when the stack is deleted.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy The removalPolicy for the log group when the stack is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * The IAM role for the Lambda function associated with the custom resource.
         * <p>
         * Default: - A new role is created
         * <p>
         * @return {@code this}
         * @param role The IAM role for the Lambda function associated with the custom resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.LogRetention}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.LogRetention build() {
            return new software.amazon.awscdk.services.logs.LogRetention(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
