package software.amazon.awscdk.services.logs;

/**
 * Processor for string mutation operations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * StringMutatorProcessor stringMutatorProcessor = StringMutatorProcessor.Builder.create()
 *         .type(StringMutatorType.LOWER_CASE)
 *         // the properties below are optional
 *         .lowerCaseKeys(List.of("lowerCaseKeys"))
 *         .splitOptions(SplitStringProperty.builder()
 *                 .entries(List.of(SplitStringEntryProperty.builder()
 *                         .delimiter(DelimiterCharacter.COMMA)
 *                         .source("source")
 *                         .build()))
 *                 .build())
 *         .substituteOptions(SubstituteStringProperty.builder()
 *                 .entries(List.of(SubstituteStringEntryProperty.builder()
 *                         .from("from")
 *                         .source("source")
 *                         .to("to")
 *                         .build()))
 *                 .build())
 *         .trimKeys(List.of("trimKeys"))
 *         .upperCaseKeys(List.of("upperCaseKeys"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:17.366Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.StringMutatorProcessor")
public class StringMutatorProcessor extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.logs.IProcessor {

    protected StringMutatorProcessor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StringMutatorProcessor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new string mutator processor.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StringMutatorProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.StringMutatorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The type of string mutation operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.StringMutatorType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.StringMutatorType.class));
    }

    /**
     * The type of string mutation operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.StringMutatorType value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.StringMutatorProcessor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.StringMutatorProcessor> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.logs.StringMutatorProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.logs.StringMutatorProps.Builder();
        }

        /**
         * The type of string mutation operation.
         * <p>
         * @return {@code this}
         * @param type The type of string mutation operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.logs.StringMutatorType type) {
            this.props.type(type);
            return this;
        }

        /**
         * Keys for strings to convert to lowercase.
         * <p>
         * Required when type is LOWER_CASE.
         * <p>
         * Default: - No lowercase processor is created if props not set
         * <p>
         * @return {@code this}
         * @param lowerCaseKeys Keys for strings to convert to lowercase. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowerCaseKeys(final java.util.List<java.lang.String> lowerCaseKeys) {
            this.props.lowerCaseKeys(lowerCaseKeys);
            return this;
        }

        /**
         * Options for string splitting.
         * <p>
         * Required when type is SPLIT.
         * <p>
         * Default: - No string splitting processor is created if props not set
         * <p>
         * @return {@code this}
         * @param splitOptions Options for string splitting. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splitOptions(final software.amazon.awscdk.services.logs.SplitStringProperty splitOptions) {
            this.props.splitOptions(splitOptions);
            return this;
        }

        /**
         * Options for string substitution.
         * <p>
         * Required when type is SUBSTITUTE.
         * <p>
         * Default: - No string substitution processor is created if props not set
         * <p>
         * @return {@code this}
         * @param substituteOptions Options for string substitution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder substituteOptions(final software.amazon.awscdk.services.logs.SubstituteStringProperty substituteOptions) {
            this.props.substituteOptions(substituteOptions);
            return this;
        }

        /**
         * Keys for strings to trim.
         * <p>
         * Required when type is TRIM.
         * <p>
         * Default: - No trim processor is created if props not set
         * <p>
         * @return {@code this}
         * @param trimKeys Keys for strings to trim. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trimKeys(final java.util.List<java.lang.String> trimKeys) {
            this.props.trimKeys(trimKeys);
            return this;
        }

        /**
         * Keys for strings to convert to uppercase.
         * <p>
         * Required when type is UPPER_CASE.
         * <p>
         * Default: - No uppercase processor is created if props not set
         * <p>
         * @return {@code this}
         * @param upperCaseKeys Keys for strings to convert to uppercase. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder upperCaseKeys(final java.util.List<java.lang.String> upperCaseKeys) {
            this.props.upperCaseKeys(upperCaseKeys);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.StringMutatorProcessor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.StringMutatorProcessor build() {
            return new software.amazon.awscdk.services.logs.StringMutatorProcessor(
                this.props.build()
            );
        }
    }
}
