package software.amazon.awscdk.services.medialive;

/**
 * Properties for defining a <code>CfnMultiplexprogram</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * CfnMultiplexprogramProps cfnMultiplexprogramProps = CfnMultiplexprogramProps.builder()
 *         .multiplexId("multiplexId")
 *         .multiplexProgramSettings(MultiplexProgramSettingsProperty.builder()
 *                 .programNumber(123)
 *                 // the properties below are optional
 *                 .preferredChannelPipeline("preferredChannelPipeline")
 *                 .serviceDescriptor(MultiplexProgramServiceDescriptorProperty.builder()
 *                         .providerName("providerName")
 *                         .serviceName("serviceName")
 *                         .build())
 *                 .videoSettings(MultiplexVideoSettingsProperty.builder()
 *                         .constantBitrate(123)
 *                         .statmuxSettings(MultiplexStatmuxVideoSettingsProperty.builder()
 *                                 .maximumBitrate(123)
 *                                 .minimumBitrate(123)
 *                                 .priority(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .packetIdentifiersMap(MultiplexProgramPacketIdentifiersMapProperty.builder()
 *                 .audioPids(List.of(123))
 *                 .dvbSubPids(List.of(123))
 *                 .dvbTeletextPid(123)
 *                 .etvPlatformPid(123)
 *                 .etvSignalPid(123)
 *                 .klvDataPids(List.of(123))
 *                 .pcrPid(123)
 *                 .pmtPid(123)
 *                 .privateMetadataPid(123)
 *                 .scte27Pids(List.of(123))
 *                 .scte35Pid(123)
 *                 .timedMetadataPid(123)
 *                 .videoPid(123)
 *                 .build())
 *         .pipelineDetails(List.of(MultiplexProgramPipelineDetailProperty.builder()
 *                 .activeChannelPipeline("activeChannelPipeline")
 *                 .pipelineId("pipelineId")
 *                 .build()))
 *         .preferredChannelPipeline("preferredChannelPipeline")
 *         .programName("programName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:18.184Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplexprogramProps")
@software.amazon.jsii.Jsii.Proxy(CfnMultiplexprogramProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMultiplexprogramProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique id of the multiplex.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-multiplexid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-multiplexid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMultiplexId() {
        return null;
    }

    /**
     * Multiplex Program settings configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-multiplexprogramsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-multiplexprogramsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultiplexProgramSettings() {
        return null;
    }

    /**
     * Packet identifiers map for a given Multiplex program.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-packetidentifiersmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-packetidentifiersmap</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPacketIdentifiersMap() {
        return null;
    }

    /**
     * Contains information about the current sources for the specified program in the specified multiplex.
     * <p>
     * Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-pipelinedetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-pipelinedetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPipelineDetails() {
        return null;
    }

    /**
     * Indicates which pipeline is preferred by the multiplex for program ingest.
     * <p>
     * If set to "PIPELINE_0" or "PIPELINE_1" and an unhealthy ingest causes the multiplex to switch to the non-preferred pipeline,
     * it will switch back once that ingest is healthy again. If set to "CURRENTLY_ACTIVE",
     * it will not switch back to the other pipeline based on it recovering to a healthy state,
     * it will only switch if the active pipeline becomes unhealthy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-preferredchannelpipeline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-preferredchannelpipeline</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredChannelPipeline() {
        return null;
    }

    /**
     * The name of the multiplex program.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-programname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-programname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProgramName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMultiplexprogramProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMultiplexprogramProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMultiplexprogramProps> {
        java.lang.String multiplexId;
        java.lang.Object multiplexProgramSettings;
        java.lang.Object packetIdentifiersMap;
        java.lang.Object pipelineDetails;
        java.lang.String preferredChannelPipeline;
        java.lang.String programName;

        /**
         * Sets the value of {@link CfnMultiplexprogramProps#getMultiplexId}
         * @param multiplexId The unique id of the multiplex.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiplexId(java.lang.String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiplexprogramProps#getMultiplexProgramSettings}
         * @param multiplexProgramSettings Multiplex Program settings configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiplexProgramSettings(software.amazon.awscdk.IResolvable multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiplexprogramProps#getMultiplexProgramSettings}
         * @param multiplexProgramSettings Multiplex Program settings configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiplexProgramSettings(software.amazon.awscdk.services.medialive.CfnMultiplexprogram.MultiplexProgramSettingsProperty multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiplexprogramProps#getPacketIdentifiersMap}
         * @param packetIdentifiersMap Packet identifiers map for a given Multiplex program.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packetIdentifiersMap(software.amazon.awscdk.IResolvable packetIdentifiersMap) {
            this.packetIdentifiersMap = packetIdentifiersMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiplexprogramProps#getPacketIdentifiersMap}
         * @param packetIdentifiersMap Packet identifiers map for a given Multiplex program.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packetIdentifiersMap(software.amazon.awscdk.services.medialive.CfnMultiplexprogram.MultiplexProgramPacketIdentifiersMapProperty packetIdentifiersMap) {
            this.packetIdentifiersMap = packetIdentifiersMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiplexprogramProps#getPipelineDetails}
         * @param pipelineDetails Contains information about the current sources for the specified program in the specified multiplex.
         *                        Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineDetails(software.amazon.awscdk.IResolvable pipelineDetails) {
            this.pipelineDetails = pipelineDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiplexprogramProps#getPipelineDetails}
         * @param pipelineDetails Contains information about the current sources for the specified program in the specified multiplex.
         *                        Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineDetails(java.util.List<? extends java.lang.Object> pipelineDetails) {
            this.pipelineDetails = pipelineDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiplexprogramProps#getPreferredChannelPipeline}
         * @param preferredChannelPipeline Indicates which pipeline is preferred by the multiplex for program ingest.
         *                                 If set to "PIPELINE_0" or "PIPELINE_1" and an unhealthy ingest causes the multiplex to switch to the non-preferred pipeline,
         *                                 it will switch back once that ingest is healthy again. If set to "CURRENTLY_ACTIVE",
         *                                 it will not switch back to the other pipeline based on it recovering to a healthy state,
         *                                 it will only switch if the active pipeline becomes unhealthy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredChannelPipeline(java.lang.String preferredChannelPipeline) {
            this.preferredChannelPipeline = preferredChannelPipeline;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiplexprogramProps#getProgramName}
         * @param programName The name of the multiplex program.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder programName(java.lang.String programName) {
            this.programName = programName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMultiplexprogramProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMultiplexprogramProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMultiplexprogramProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMultiplexprogramProps {
        private final java.lang.String multiplexId;
        private final java.lang.Object multiplexProgramSettings;
        private final java.lang.Object packetIdentifiersMap;
        private final java.lang.Object pipelineDetails;
        private final java.lang.String preferredChannelPipeline;
        private final java.lang.String programName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.multiplexId = software.amazon.jsii.Kernel.get(this, "multiplexId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiplexProgramSettings = software.amazon.jsii.Kernel.get(this, "multiplexProgramSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.packetIdentifiersMap = software.amazon.jsii.Kernel.get(this, "packetIdentifiersMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pipelineDetails = software.amazon.jsii.Kernel.get(this, "pipelineDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.preferredChannelPipeline = software.amazon.jsii.Kernel.get(this, "preferredChannelPipeline", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.programName = software.amazon.jsii.Kernel.get(this, "programName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.multiplexId = builder.multiplexId;
            this.multiplexProgramSettings = builder.multiplexProgramSettings;
            this.packetIdentifiersMap = builder.packetIdentifiersMap;
            this.pipelineDetails = builder.pipelineDetails;
            this.preferredChannelPipeline = builder.preferredChannelPipeline;
            this.programName = builder.programName;
        }

        @Override
        public final java.lang.String getMultiplexId() {
            return this.multiplexId;
        }

        @Override
        public final java.lang.Object getMultiplexProgramSettings() {
            return this.multiplexProgramSettings;
        }

        @Override
        public final java.lang.Object getPacketIdentifiersMap() {
            return this.packetIdentifiersMap;
        }

        @Override
        public final java.lang.Object getPipelineDetails() {
            return this.pipelineDetails;
        }

        @Override
        public final java.lang.String getPreferredChannelPipeline() {
            return this.preferredChannelPipeline;
        }

        @Override
        public final java.lang.String getProgramName() {
            return this.programName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMultiplexId() != null) {
                data.set("multiplexId", om.valueToTree(this.getMultiplexId()));
            }
            if (this.getMultiplexProgramSettings() != null) {
                data.set("multiplexProgramSettings", om.valueToTree(this.getMultiplexProgramSettings()));
            }
            if (this.getPacketIdentifiersMap() != null) {
                data.set("packetIdentifiersMap", om.valueToTree(this.getPacketIdentifiersMap()));
            }
            if (this.getPipelineDetails() != null) {
                data.set("pipelineDetails", om.valueToTree(this.getPipelineDetails()));
            }
            if (this.getPreferredChannelPipeline() != null) {
                data.set("preferredChannelPipeline", om.valueToTree(this.getPreferredChannelPipeline()));
            }
            if (this.getProgramName() != null) {
                data.set("programName", om.valueToTree(this.getProgramName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnMultiplexprogramProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMultiplexprogramProps.Jsii$Proxy that = (CfnMultiplexprogramProps.Jsii$Proxy) o;

            if (this.multiplexId != null ? !this.multiplexId.equals(that.multiplexId) : that.multiplexId != null) return false;
            if (this.multiplexProgramSettings != null ? !this.multiplexProgramSettings.equals(that.multiplexProgramSettings) : that.multiplexProgramSettings != null) return false;
            if (this.packetIdentifiersMap != null ? !this.packetIdentifiersMap.equals(that.packetIdentifiersMap) : that.packetIdentifiersMap != null) return false;
            if (this.pipelineDetails != null ? !this.pipelineDetails.equals(that.pipelineDetails) : that.pipelineDetails != null) return false;
            if (this.preferredChannelPipeline != null ? !this.preferredChannelPipeline.equals(that.preferredChannelPipeline) : that.preferredChannelPipeline != null) return false;
            return this.programName != null ? this.programName.equals(that.programName) : that.programName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.multiplexId != null ? this.multiplexId.hashCode() : 0;
            result = 31 * result + (this.multiplexProgramSettings != null ? this.multiplexProgramSettings.hashCode() : 0);
            result = 31 * result + (this.packetIdentifiersMap != null ? this.packetIdentifiersMap.hashCode() : 0);
            result = 31 * result + (this.pipelineDetails != null ? this.pipelineDetails.hashCode() : 0);
            result = 31 * result + (this.preferredChannelPipeline != null ? this.preferredChannelPipeline.hashCode() : 0);
            result = 31 * result + (this.programName != null ? this.programName.hashCode() : 0);
            return result;
        }
    }
}
