package software.amazon.awscdk.services.mediatailor;

/**
 * The configuration parameters for a channel.
 * <p>
 * For information about MediaTailor channels, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a> in the <em>MediaTailor User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediatailor.*;
 * CfnChannel cfnChannel = CfnChannel.Builder.create(this, "MyCfnChannel")
 *         .channelName("channelName")
 *         .outputs(List.of(RequestOutputItemProperty.builder()
 *                 .manifestName("manifestName")
 *                 .sourceGroup("sourceGroup")
 *                 // the properties below are optional
 *                 .dashPlaylistSettings(DashPlaylistSettingsProperty.builder()
 *                         .manifestWindowSeconds(123)
 *                         .minBufferTimeSeconds(123)
 *                         .minUpdatePeriodSeconds(123)
 *                         .suggestedPresentationDelaySeconds(123)
 *                         .build())
 *                 .hlsPlaylistSettings(HlsPlaylistSettingsProperty.builder()
 *                         .adMarkupType(List.of("adMarkupType"))
 *                         .manifestWindowSeconds(123)
 *                         .build())
 *                 .build()))
 *         .playbackMode("playbackMode")
 *         // the properties below are optional
 *         .audiences(List.of("audiences"))
 *         .fillerSlate(SlateSourceProperty.builder()
 *                 .sourceLocationName("sourceLocationName")
 *                 .vodSourceName("vodSourceName")
 *                 .build())
 *         .logConfiguration(LogConfigurationForChannelProperty.builder()
 *                 .logTypes(List.of("logTypes"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tier("tier")
 *         .timeShiftConfiguration(TimeShiftConfigurationProperty.builder()
 *                 .maxTimeDelaySeconds(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:18.439Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnChannel")
public class CfnChannel extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnChannel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnChannel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediatailor.CfnChannel.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnChannel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediatailor.CfnChannelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * <p>The ARN of the channel.</p>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelName() {
        return software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelName", java.util.Objects.requireNonNull(value, "channelName is required"));
    }

    /**
     * The channel's output properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOutputs() {
        return software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The channel's output properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputs", java.util.Objects.requireNonNull(value, "outputs is required"));
    }

    /**
     * The channel's output properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputs(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mediatailor.CfnChannel.RequestOutputItemProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediatailor.CfnChannel.RequestOutputItemProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "outputs", java.util.Objects.requireNonNull(value, "outputs is required"));
    }

    /**
     * The type of playback mode for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPlaybackMode() {
        return software.amazon.jsii.Kernel.get(this, "playbackMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of playback mode for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlaybackMode(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "playbackMode", java.util.Objects.requireNonNull(value, "playbackMode is required"));
    }

    /**
     * The list of audiences defined in channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAudiences() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "audiences", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of audiences defined in channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAudiences(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "audiences", value);
    }

    /**
     * The slate used to fill gaps between programs in the schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFillerSlate() {
        return software.amazon.jsii.Kernel.get(this, "fillerSlate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The slate used to fill gaps between programs in the schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFillerSlate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fillerSlate", value);
    }

    /**
     * The slate used to fill gaps between programs in the schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFillerSlate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediatailor.CfnChannel.SlateSourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "fillerSlate", value);
    }

    /**
     * The log configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The log configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logConfiguration", value);
    }

    /**
     * The log configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediatailor.CfnChannel.LogConfigurationForChannelProperty value) {
        software.amazon.jsii.Kernel.set(this, "logConfiguration", value);
    }

    /**
     * The tags to assign to the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to assign to the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The tier for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTier() {
        return software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The tier for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tier", value);
    }

    /**
     * The configuration for time-shifted viewing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTimeShiftConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "timeShiftConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for time-shifted viewing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeShiftConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "timeShiftConfiguration", value);
    }

    /**
     * The configuration for time-shifted viewing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeShiftConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediatailor.CfnChannel.TimeShiftConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "timeShiftConfiguration", value);
    }
    /**
     * Dash manifest configuration parameters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * DashPlaylistSettingsProperty dashPlaylistSettingsProperty = DashPlaylistSettingsProperty.builder()
     *         .manifestWindowSeconds(123)
     *         .minBufferTimeSeconds(123)
     *         .minUpdatePeriodSeconds(123)
     *         .suggestedPresentationDelaySeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-dashplaylistsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-dashplaylistsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnChannel.DashPlaylistSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DashPlaylistSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashPlaylistSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The total duration (in seconds) of each manifest.
         * <p>
         * Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-dashplaylistsettings.html#cfn-mediatailor-channel-dashplaylistsettings-manifestwindowseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-dashplaylistsettings.html#cfn-mediatailor-channel-dashplaylistsettings-manifestwindowseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getManifestWindowSeconds() {
            return null;
        }

        /**
         * Minimum amount of content (measured in seconds) that a player must keep available in the buffer.
         * <p>
         * Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-dashplaylistsettings.html#cfn-mediatailor-channel-dashplaylistsettings-minbuffertimeseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-dashplaylistsettings.html#cfn-mediatailor-channel-dashplaylistsettings-minbuffertimeseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinBufferTimeSeconds() {
            return null;
        }

        /**
         * Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
         * <p>
         * Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-dashplaylistsettings.html#cfn-mediatailor-channel-dashplaylistsettings-minupdateperiodseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-dashplaylistsettings.html#cfn-mediatailor-channel-dashplaylistsettings-minupdateperiodseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinUpdatePeriodSeconds() {
            return null;
        }

        /**
         * Amount of time (in seconds) that the player should be from the live point at the end of the manifest.
         * <p>
         * Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-dashplaylistsettings.html#cfn-mediatailor-channel-dashplaylistsettings-suggestedpresentationdelayseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-dashplaylistsettings.html#cfn-mediatailor-channel-dashplaylistsettings-suggestedpresentationdelayseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSuggestedPresentationDelaySeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashPlaylistSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashPlaylistSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashPlaylistSettingsProperty> {
            java.lang.Number manifestWindowSeconds;
            java.lang.Number minBufferTimeSeconds;
            java.lang.Number minUpdatePeriodSeconds;
            java.lang.Number suggestedPresentationDelaySeconds;

            /**
             * Sets the value of {@link DashPlaylistSettingsProperty#getManifestWindowSeconds}
             * @param manifestWindowSeconds The total duration (in seconds) of each manifest.
             *                              Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestWindowSeconds(java.lang.Number manifestWindowSeconds) {
                this.manifestWindowSeconds = manifestWindowSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashPlaylistSettingsProperty#getMinBufferTimeSeconds}
             * @param minBufferTimeSeconds Minimum amount of content (measured in seconds) that a player must keep available in the buffer.
             *                             Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minBufferTimeSeconds(java.lang.Number minBufferTimeSeconds) {
                this.minBufferTimeSeconds = minBufferTimeSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashPlaylistSettingsProperty#getMinUpdatePeriodSeconds}
             * @param minUpdatePeriodSeconds Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
             *                               Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minUpdatePeriodSeconds(java.lang.Number minUpdatePeriodSeconds) {
                this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashPlaylistSettingsProperty#getSuggestedPresentationDelaySeconds}
             * @param suggestedPresentationDelaySeconds Amount of time (in seconds) that the player should be from the live point at the end of the manifest.
             *                                          Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suggestedPresentationDelaySeconds(java.lang.Number suggestedPresentationDelaySeconds) {
                this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashPlaylistSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashPlaylistSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashPlaylistSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashPlaylistSettingsProperty {
            private final java.lang.Number manifestWindowSeconds;
            private final java.lang.Number minBufferTimeSeconds;
            private final java.lang.Number minUpdatePeriodSeconds;
            private final java.lang.Number suggestedPresentationDelaySeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifestWindowSeconds = software.amazon.jsii.Kernel.get(this, "manifestWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minBufferTimeSeconds = software.amazon.jsii.Kernel.get(this, "minBufferTimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minUpdatePeriodSeconds = software.amazon.jsii.Kernel.get(this, "minUpdatePeriodSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.suggestedPresentationDelaySeconds = software.amazon.jsii.Kernel.get(this, "suggestedPresentationDelaySeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifestWindowSeconds = builder.manifestWindowSeconds;
                this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
                this.minUpdatePeriodSeconds = builder.minUpdatePeriodSeconds;
                this.suggestedPresentationDelaySeconds = builder.suggestedPresentationDelaySeconds;
            }

            @Override
            public final java.lang.Number getManifestWindowSeconds() {
                return this.manifestWindowSeconds;
            }

            @Override
            public final java.lang.Number getMinBufferTimeSeconds() {
                return this.minBufferTimeSeconds;
            }

            @Override
            public final java.lang.Number getMinUpdatePeriodSeconds() {
                return this.minUpdatePeriodSeconds;
            }

            @Override
            public final java.lang.Number getSuggestedPresentationDelaySeconds() {
                return this.suggestedPresentationDelaySeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getManifestWindowSeconds() != null) {
                    data.set("manifestWindowSeconds", om.valueToTree(this.getManifestWindowSeconds()));
                }
                if (this.getMinBufferTimeSeconds() != null) {
                    data.set("minBufferTimeSeconds", om.valueToTree(this.getMinBufferTimeSeconds()));
                }
                if (this.getMinUpdatePeriodSeconds() != null) {
                    data.set("minUpdatePeriodSeconds", om.valueToTree(this.getMinUpdatePeriodSeconds()));
                }
                if (this.getSuggestedPresentationDelaySeconds() != null) {
                    data.set("suggestedPresentationDelaySeconds", om.valueToTree(this.getSuggestedPresentationDelaySeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnChannel.DashPlaylistSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashPlaylistSettingsProperty.Jsii$Proxy that = (DashPlaylistSettingsProperty.Jsii$Proxy) o;

                if (this.manifestWindowSeconds != null ? !this.manifestWindowSeconds.equals(that.manifestWindowSeconds) : that.manifestWindowSeconds != null) return false;
                if (this.minBufferTimeSeconds != null ? !this.minBufferTimeSeconds.equals(that.minBufferTimeSeconds) : that.minBufferTimeSeconds != null) return false;
                if (this.minUpdatePeriodSeconds != null ? !this.minUpdatePeriodSeconds.equals(that.minUpdatePeriodSeconds) : that.minUpdatePeriodSeconds != null) return false;
                return this.suggestedPresentationDelaySeconds != null ? this.suggestedPresentationDelaySeconds.equals(that.suggestedPresentationDelaySeconds) : that.suggestedPresentationDelaySeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifestWindowSeconds != null ? this.manifestWindowSeconds.hashCode() : 0;
                result = 31 * result + (this.minBufferTimeSeconds != null ? this.minBufferTimeSeconds.hashCode() : 0);
                result = 31 * result + (this.minUpdatePeriodSeconds != null ? this.minUpdatePeriodSeconds.hashCode() : 0);
                result = 31 * result + (this.suggestedPresentationDelaySeconds != null ? this.suggestedPresentationDelaySeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * HLS playlist configuration parameters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * HlsPlaylistSettingsProperty hlsPlaylistSettingsProperty = HlsPlaylistSettingsProperty.builder()
     *         .adMarkupType(List.of("adMarkupType"))
     *         .manifestWindowSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-hlsplaylistsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-hlsplaylistsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnChannel.HlsPlaylistSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(HlsPlaylistSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HlsPlaylistSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines the type of SCTE 35 tags to use in ad markup.
         * <p>
         * Specify <code>DATERANGE</code> to use <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-hlsplaylistsettings.html#cfn-mediatailor-channel-hlsplaylistsettings-admarkuptype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-hlsplaylistsettings.html#cfn-mediatailor-channel-hlsplaylistsettings-admarkuptype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdMarkupType() {
            return null;
        }

        /**
         * The total duration (in seconds) of each manifest.
         * <p>
         * Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-hlsplaylistsettings.html#cfn-mediatailor-channel-hlsplaylistsettings-manifestwindowseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-hlsplaylistsettings.html#cfn-mediatailor-channel-hlsplaylistsettings-manifestwindowseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getManifestWindowSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HlsPlaylistSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HlsPlaylistSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HlsPlaylistSettingsProperty> {
            java.util.List<java.lang.String> adMarkupType;
            java.lang.Number manifestWindowSeconds;

            /**
             * Sets the value of {@link HlsPlaylistSettingsProperty#getAdMarkupType}
             * @param adMarkupType Determines the type of SCTE 35 tags to use in ad markup.
             *                     Specify <code>DATERANGE</code> to use <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adMarkupType(java.util.List<java.lang.String> adMarkupType) {
                this.adMarkupType = adMarkupType;
                return this;
            }

            /**
             * Sets the value of {@link HlsPlaylistSettingsProperty#getManifestWindowSeconds}
             * @param manifestWindowSeconds The total duration (in seconds) of each manifest.
             *                              Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestWindowSeconds(java.lang.Number manifestWindowSeconds) {
                this.manifestWindowSeconds = manifestWindowSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HlsPlaylistSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HlsPlaylistSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HlsPlaylistSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HlsPlaylistSettingsProperty {
            private final java.util.List<java.lang.String> adMarkupType;
            private final java.lang.Number manifestWindowSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adMarkupType = software.amazon.jsii.Kernel.get(this, "adMarkupType", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.manifestWindowSeconds = software.amazon.jsii.Kernel.get(this, "manifestWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adMarkupType = builder.adMarkupType;
                this.manifestWindowSeconds = builder.manifestWindowSeconds;
            }

            @Override
            public final java.util.List<java.lang.String> getAdMarkupType() {
                return this.adMarkupType;
            }

            @Override
            public final java.lang.Number getManifestWindowSeconds() {
                return this.manifestWindowSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdMarkupType() != null) {
                    data.set("adMarkupType", om.valueToTree(this.getAdMarkupType()));
                }
                if (this.getManifestWindowSeconds() != null) {
                    data.set("manifestWindowSeconds", om.valueToTree(this.getManifestWindowSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnChannel.HlsPlaylistSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HlsPlaylistSettingsProperty.Jsii$Proxy that = (HlsPlaylistSettingsProperty.Jsii$Proxy) o;

                if (this.adMarkupType != null ? !this.adMarkupType.equals(that.adMarkupType) : that.adMarkupType != null) return false;
                return this.manifestWindowSeconds != null ? this.manifestWindowSeconds.equals(that.manifestWindowSeconds) : that.manifestWindowSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adMarkupType != null ? this.adMarkupType.hashCode() : 0;
                result = 31 * result + (this.manifestWindowSeconds != null ? this.manifestWindowSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The log configuration for the channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * LogConfigurationForChannelProperty logConfigurationForChannelProperty = LogConfigurationForChannelProperty.builder()
     *         .logTypes(List.of("logTypes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-logconfigurationforchannel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-logconfigurationforchannel.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnChannel.LogConfigurationForChannelProperty")
    @software.amazon.jsii.Jsii.Proxy(LogConfigurationForChannelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogConfigurationForChannelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The log types.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-logconfigurationforchannel.html#cfn-mediatailor-channel-logconfigurationforchannel-logtypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-logconfigurationforchannel.html#cfn-mediatailor-channel-logconfigurationforchannel-logtypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogConfigurationForChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogConfigurationForChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogConfigurationForChannelProperty> {
            java.util.List<java.lang.String> logTypes;

            /**
             * Sets the value of {@link LogConfigurationForChannelProperty#getLogTypes}
             * @param logTypes The log types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logTypes(java.util.List<java.lang.String> logTypes) {
                this.logTypes = logTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogConfigurationForChannelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogConfigurationForChannelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogConfigurationForChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfigurationForChannelProperty {
            private final java.util.List<java.lang.String> logTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logTypes = software.amazon.jsii.Kernel.get(this, "logTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logTypes = builder.logTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getLogTypes() {
                return this.logTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLogTypes() != null) {
                    data.set("logTypes", om.valueToTree(this.getLogTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnChannel.LogConfigurationForChannelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogConfigurationForChannelProperty.Jsii$Proxy that = (LogConfigurationForChannelProperty.Jsii$Proxy) o;

                return this.logTypes != null ? this.logTypes.equals(that.logTypes) : that.logTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logTypes != null ? this.logTypes.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The output configuration for this channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * RequestOutputItemProperty requestOutputItemProperty = RequestOutputItemProperty.builder()
     *         .manifestName("manifestName")
     *         .sourceGroup("sourceGroup")
     *         // the properties below are optional
     *         .dashPlaylistSettings(DashPlaylistSettingsProperty.builder()
     *                 .manifestWindowSeconds(123)
     *                 .minBufferTimeSeconds(123)
     *                 .minUpdatePeriodSeconds(123)
     *                 .suggestedPresentationDelaySeconds(123)
     *                 .build())
     *         .hlsPlaylistSettings(HlsPlaylistSettingsProperty.builder()
     *                 .adMarkupType(List.of("adMarkupType"))
     *                 .manifestWindowSeconds(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-requestoutputitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-requestoutputitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnChannel.RequestOutputItemProperty")
    @software.amazon.jsii.Jsii.Proxy(RequestOutputItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RequestOutputItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the manifest for the channel.
         * <p>
         * The name appears in the <code>PlaybackUrl</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-requestoutputitem.html#cfn-mediatailor-channel-requestoutputitem-manifestname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-requestoutputitem.html#cfn-mediatailor-channel-requestoutputitem-manifestname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getManifestName();

        /**
         * A string used to match which <code>HttpPackageConfiguration</code> is used for each <code>VodSource</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-requestoutputitem.html#cfn-mediatailor-channel-requestoutputitem-sourcegroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-requestoutputitem.html#cfn-mediatailor-channel-requestoutputitem-sourcegroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceGroup();

        /**
         * DASH manifest configuration parameters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-requestoutputitem.html#cfn-mediatailor-channel-requestoutputitem-dashplaylistsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-requestoutputitem.html#cfn-mediatailor-channel-requestoutputitem-dashplaylistsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDashPlaylistSettings() {
            return null;
        }

        /**
         * HLS playlist configuration parameters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-requestoutputitem.html#cfn-mediatailor-channel-requestoutputitem-hlsplaylistsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-requestoutputitem.html#cfn-mediatailor-channel-requestoutputitem-hlsplaylistsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHlsPlaylistSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RequestOutputItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RequestOutputItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RequestOutputItemProperty> {
            java.lang.String manifestName;
            java.lang.String sourceGroup;
            java.lang.Object dashPlaylistSettings;
            java.lang.Object hlsPlaylistSettings;

            /**
             * Sets the value of {@link RequestOutputItemProperty#getManifestName}
             * @param manifestName The name of the manifest for the channel. This parameter is required.
             *                     The name appears in the <code>PlaybackUrl</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestName(java.lang.String manifestName) {
                this.manifestName = manifestName;
                return this;
            }

            /**
             * Sets the value of {@link RequestOutputItemProperty#getSourceGroup}
             * @param sourceGroup A string used to match which <code>HttpPackageConfiguration</code> is used for each <code>VodSource</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceGroup(java.lang.String sourceGroup) {
                this.sourceGroup = sourceGroup;
                return this;
            }

            /**
             * Sets the value of {@link RequestOutputItemProperty#getDashPlaylistSettings}
             * @param dashPlaylistSettings DASH manifest configuration parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dashPlaylistSettings(software.amazon.awscdk.IResolvable dashPlaylistSettings) {
                this.dashPlaylistSettings = dashPlaylistSettings;
                return this;
            }

            /**
             * Sets the value of {@link RequestOutputItemProperty#getDashPlaylistSettings}
             * @param dashPlaylistSettings DASH manifest configuration parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dashPlaylistSettings(software.amazon.awscdk.services.mediatailor.CfnChannel.DashPlaylistSettingsProperty dashPlaylistSettings) {
                this.dashPlaylistSettings = dashPlaylistSettings;
                return this;
            }

            /**
             * Sets the value of {@link RequestOutputItemProperty#getHlsPlaylistSettings}
             * @param hlsPlaylistSettings HLS playlist configuration parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hlsPlaylistSettings(software.amazon.awscdk.IResolvable hlsPlaylistSettings) {
                this.hlsPlaylistSettings = hlsPlaylistSettings;
                return this;
            }

            /**
             * Sets the value of {@link RequestOutputItemProperty#getHlsPlaylistSettings}
             * @param hlsPlaylistSettings HLS playlist configuration parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hlsPlaylistSettings(software.amazon.awscdk.services.mediatailor.CfnChannel.HlsPlaylistSettingsProperty hlsPlaylistSettings) {
                this.hlsPlaylistSettings = hlsPlaylistSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RequestOutputItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RequestOutputItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RequestOutputItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestOutputItemProperty {
            private final java.lang.String manifestName;
            private final java.lang.String sourceGroup;
            private final java.lang.Object dashPlaylistSettings;
            private final java.lang.Object hlsPlaylistSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifestName = software.amazon.jsii.Kernel.get(this, "manifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceGroup = software.amazon.jsii.Kernel.get(this, "sourceGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dashPlaylistSettings = software.amazon.jsii.Kernel.get(this, "dashPlaylistSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hlsPlaylistSettings = software.amazon.jsii.Kernel.get(this, "hlsPlaylistSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifestName = java.util.Objects.requireNonNull(builder.manifestName, "manifestName is required");
                this.sourceGroup = java.util.Objects.requireNonNull(builder.sourceGroup, "sourceGroup is required");
                this.dashPlaylistSettings = builder.dashPlaylistSettings;
                this.hlsPlaylistSettings = builder.hlsPlaylistSettings;
            }

            @Override
            public final java.lang.String getManifestName() {
                return this.manifestName;
            }

            @Override
            public final java.lang.String getSourceGroup() {
                return this.sourceGroup;
            }

            @Override
            public final java.lang.Object getDashPlaylistSettings() {
                return this.dashPlaylistSettings;
            }

            @Override
            public final java.lang.Object getHlsPlaylistSettings() {
                return this.hlsPlaylistSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("manifestName", om.valueToTree(this.getManifestName()));
                data.set("sourceGroup", om.valueToTree(this.getSourceGroup()));
                if (this.getDashPlaylistSettings() != null) {
                    data.set("dashPlaylistSettings", om.valueToTree(this.getDashPlaylistSettings()));
                }
                if (this.getHlsPlaylistSettings() != null) {
                    data.set("hlsPlaylistSettings", om.valueToTree(this.getHlsPlaylistSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnChannel.RequestOutputItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RequestOutputItemProperty.Jsii$Proxy that = (RequestOutputItemProperty.Jsii$Proxy) o;

                if (!manifestName.equals(that.manifestName)) return false;
                if (!sourceGroup.equals(that.sourceGroup)) return false;
                if (this.dashPlaylistSettings != null ? !this.dashPlaylistSettings.equals(that.dashPlaylistSettings) : that.dashPlaylistSettings != null) return false;
                return this.hlsPlaylistSettings != null ? this.hlsPlaylistSettings.equals(that.hlsPlaylistSettings) : that.hlsPlaylistSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifestName.hashCode();
                result = 31 * result + (this.sourceGroup.hashCode());
                result = 31 * result + (this.dashPlaylistSettings != null ? this.dashPlaylistSettings.hashCode() : 0);
                result = 31 * result + (this.hlsPlaylistSettings != null ? this.hlsPlaylistSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Slate VOD source configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * SlateSourceProperty slateSourceProperty = SlateSourceProperty.builder()
     *         .sourceLocationName("sourceLocationName")
     *         .vodSourceName("vodSourceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-slatesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-slatesource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnChannel.SlateSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SlateSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlateSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the source location where the slate VOD source is stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-slatesource.html#cfn-mediatailor-channel-slatesource-sourcelocationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-slatesource.html#cfn-mediatailor-channel-slatesource-sourcelocationname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceLocationName() {
            return null;
        }

        /**
         * The slate VOD source name.
         * <p>
         * The VOD source must already exist in a source location before it can be used for slate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-slatesource.html#cfn-mediatailor-channel-slatesource-vodsourcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-slatesource.html#cfn-mediatailor-channel-slatesource-vodsourcename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVodSourceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlateSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlateSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlateSourceProperty> {
            java.lang.String sourceLocationName;
            java.lang.String vodSourceName;

            /**
             * Sets the value of {@link SlateSourceProperty#getSourceLocationName}
             * @param sourceLocationName The name of the source location where the slate VOD source is stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceLocationName(java.lang.String sourceLocationName) {
                this.sourceLocationName = sourceLocationName;
                return this;
            }

            /**
             * Sets the value of {@link SlateSourceProperty#getVodSourceName}
             * @param vodSourceName The slate VOD source name.
             *                      The VOD source must already exist in a source location before it can be used for slate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vodSourceName(java.lang.String vodSourceName) {
                this.vodSourceName = vodSourceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlateSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlateSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlateSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlateSourceProperty {
            private final java.lang.String sourceLocationName;
            private final java.lang.String vodSourceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceLocationName = software.amazon.jsii.Kernel.get(this, "sourceLocationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vodSourceName = software.amazon.jsii.Kernel.get(this, "vodSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceLocationName = builder.sourceLocationName;
                this.vodSourceName = builder.vodSourceName;
            }

            @Override
            public final java.lang.String getSourceLocationName() {
                return this.sourceLocationName;
            }

            @Override
            public final java.lang.String getVodSourceName() {
                return this.vodSourceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourceLocationName() != null) {
                    data.set("sourceLocationName", om.valueToTree(this.getSourceLocationName()));
                }
                if (this.getVodSourceName() != null) {
                    data.set("vodSourceName", om.valueToTree(this.getVodSourceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnChannel.SlateSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlateSourceProperty.Jsii$Proxy that = (SlateSourceProperty.Jsii$Proxy) o;

                if (this.sourceLocationName != null ? !this.sourceLocationName.equals(that.sourceLocationName) : that.sourceLocationName != null) return false;
                return this.vodSourceName != null ? this.vodSourceName.equals(that.vodSourceName) : that.vodSourceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceLocationName != null ? this.sourceLocationName.hashCode() : 0;
                result = 31 * result + (this.vodSourceName != null ? this.vodSourceName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for time-shifted viewing.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * TimeShiftConfigurationProperty timeShiftConfigurationProperty = TimeShiftConfigurationProperty.builder()
     *         .maxTimeDelaySeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-timeshiftconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-timeshiftconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnChannel.TimeShiftConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeShiftConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeShiftConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum time delay for time-shifted viewing.
         * <p>
         * The minimum allowed maximum time delay is 0 seconds, and the maximum allowed maximum time delay is 21600 seconds (6 hours).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-timeshiftconfiguration.html#cfn-mediatailor-channel-timeshiftconfiguration-maxtimedelayseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-channel-timeshiftconfiguration.html#cfn-mediatailor-channel-timeshiftconfiguration-maxtimedelayseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxTimeDelaySeconds();

        /**
         * @return a {@link Builder} of {@link TimeShiftConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeShiftConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeShiftConfigurationProperty> {
            java.lang.Number maxTimeDelaySeconds;

            /**
             * Sets the value of {@link TimeShiftConfigurationProperty#getMaxTimeDelaySeconds}
             * @param maxTimeDelaySeconds The maximum time delay for time-shifted viewing. This parameter is required.
             *                            The minimum allowed maximum time delay is 0 seconds, and the maximum allowed maximum time delay is 21600 seconds (6 hours).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTimeDelaySeconds(java.lang.Number maxTimeDelaySeconds) {
                this.maxTimeDelaySeconds = maxTimeDelaySeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeShiftConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeShiftConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeShiftConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeShiftConfigurationProperty {
            private final java.lang.Number maxTimeDelaySeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxTimeDelaySeconds = software.amazon.jsii.Kernel.get(this, "maxTimeDelaySeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxTimeDelaySeconds = java.util.Objects.requireNonNull(builder.maxTimeDelaySeconds, "maxTimeDelaySeconds is required");
            }

            @Override
            public final java.lang.Number getMaxTimeDelaySeconds() {
                return this.maxTimeDelaySeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxTimeDelaySeconds", om.valueToTree(this.getMaxTimeDelaySeconds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnChannel.TimeShiftConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeShiftConfigurationProperty.Jsii$Proxy that = (TimeShiftConfigurationProperty.Jsii$Proxy) o;

                return this.maxTimeDelaySeconds.equals(that.maxTimeDelaySeconds);
            }

            @Override
            public final int hashCode() {
                int result = this.maxTimeDelaySeconds.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediatailor.CfnChannel}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediatailor.CfnChannel> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediatailor.CfnChannelProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediatailor.CfnChannelProps.Builder();
        }

        /**
         * The name of the channel.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-channelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-channelname</a>
         * @param channelName The name of the channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelName(final java.lang.String channelName) {
            this.props.channelName(channelName);
            return this;
        }

        /**
         * The channel's output properties.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-outputs</a>
         * @param outputs The channel's output properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final software.amazon.awscdk.IResolvable outputs) {
            this.props.outputs(outputs);
            return this;
        }
        /**
         * The channel's output properties.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-outputs</a>
         * @param outputs The channel's output properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final java.util.List<? extends java.lang.Object> outputs) {
            this.props.outputs(outputs);
            return this;
        }

        /**
         * The type of playback mode for this channel.
         * <p>
         * <code>LINEAR</code> - Programs play back-to-back only once.
         * <p>
         * <code>LOOP</code> - Programs play back-to-back in an endless loop. When the last program in the schedule plays, playback loops back to the first program in the schedule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-playbackmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-playbackmode</a>
         * @param playbackMode The type of playback mode for this channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder playbackMode(final java.lang.String playbackMode) {
            this.props.playbackMode(playbackMode);
            return this;
        }

        /**
         * The list of audiences defined in channel.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-audiences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-audiences</a>
         * @param audiences The list of audiences defined in channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder audiences(final java.util.List<java.lang.String> audiences) {
            this.props.audiences(audiences);
            return this;
        }

        /**
         * The slate used to fill gaps between programs in the schedule.
         * <p>
         * You must configure filler slate if your channel uses the <code>LINEAR</code> <code>PlaybackMode</code> . MediaTailor doesn't support filler slate for channels using the <code>LOOP</code> <code>PlaybackMode</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-fillerslate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-fillerslate</a>
         * @param fillerSlate The slate used to fill gaps between programs in the schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fillerSlate(final software.amazon.awscdk.IResolvable fillerSlate) {
            this.props.fillerSlate(fillerSlate);
            return this;
        }
        /**
         * The slate used to fill gaps between programs in the schedule.
         * <p>
         * You must configure filler slate if your channel uses the <code>LINEAR</code> <code>PlaybackMode</code> . MediaTailor doesn't support filler slate for channels using the <code>LOOP</code> <code>PlaybackMode</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-fillerslate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-fillerslate</a>
         * @param fillerSlate The slate used to fill gaps between programs in the schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fillerSlate(final software.amazon.awscdk.services.mediatailor.CfnChannel.SlateSourceProperty fillerSlate) {
            this.props.fillerSlate(fillerSlate);
            return this;
        }

        /**
         * The log configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-logconfiguration</a>
         * @param logConfiguration The log configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(final software.amazon.awscdk.IResolvable logConfiguration) {
            this.props.logConfiguration(logConfiguration);
            return this;
        }
        /**
         * The log configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-logconfiguration</a>
         * @param logConfiguration The log configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(final software.amazon.awscdk.services.mediatailor.CfnChannel.LogConfigurationForChannelProperty logConfiguration) {
            this.props.logConfiguration(logConfiguration);
            return this;
        }

        /**
         * The tags to assign to the channel.
         * <p>
         * Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-tags</a>
         * @param tags The tags to assign to the channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The tier for this channel.
         * <p>
         * STANDARD tier channels can contain live programs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-tier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-tier</a>
         * @param tier The tier for this channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(final java.lang.String tier) {
            this.props.tier(tier);
            return this;
        }

        /**
         * The configuration for time-shifted viewing.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-timeshiftconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-timeshiftconfiguration</a>
         * @param timeShiftConfiguration The configuration for time-shifted viewing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeShiftConfiguration(final software.amazon.awscdk.IResolvable timeShiftConfiguration) {
            this.props.timeShiftConfiguration(timeShiftConfiguration);
            return this;
        }
        /**
         * The configuration for time-shifted viewing.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-timeshiftconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-timeshiftconfiguration</a>
         * @param timeShiftConfiguration The configuration for time-shifted viewing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeShiftConfiguration(final software.amazon.awscdk.services.mediatailor.CfnChannel.TimeShiftConfigurationProperty timeShiftConfiguration) {
            this.props.timeShiftConfiguration(timeShiftConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediatailor.CfnChannel}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediatailor.CfnChannel build() {
            return new software.amazon.awscdk.services.mediatailor.CfnChannel(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
