package software.amazon.awscdk.services.msk;

/**
 * Properties for defining a <code>CfnBatchScramSecret</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.msk.*;
 * CfnBatchScramSecretProps cfnBatchScramSecretProps = CfnBatchScramSecretProps.builder()
 *         .clusterArn("clusterArn")
 *         // the properties below are optional
 *         .secretArnList(List.of("secretArnList"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-batchscramsecret.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-batchscramsecret.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:18.570Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnBatchScramSecretProps")
@software.amazon.jsii.Jsii.Proxy(CfnBatchScramSecretProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBatchScramSecretProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-batchscramsecret.html#cfn-msk-batchscramsecret-clusterarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-batchscramsecret.html#cfn-msk-batchscramsecret-clusterarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterArn();

    /**
     * List of Amazon Resource Name (ARN)s of Secrets Manager secrets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-batchscramsecret.html#cfn-msk-batchscramsecret-secretarnlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-batchscramsecret.html#cfn-msk-batchscramsecret-secretarnlist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecretArnList() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBatchScramSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBatchScramSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBatchScramSecretProps> {
        java.lang.String clusterArn;
        java.util.List<java.lang.String> secretArnList;

        /**
         * Sets the value of {@link CfnBatchScramSecretProps#getClusterArn}
         * @param clusterArn The Amazon Resource Name (ARN) that uniquely identifies the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterArn(java.lang.String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnBatchScramSecretProps#getSecretArnList}
         * @param secretArnList List of Amazon Resource Name (ARN)s of Secrets Manager secrets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretArnList(java.util.List<java.lang.String> secretArnList) {
            this.secretArnList = secretArnList;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBatchScramSecretProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBatchScramSecretProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBatchScramSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBatchScramSecretProps {
        private final java.lang.String clusterArn;
        private final java.util.List<java.lang.String> secretArnList;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterArn = software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secretArnList = software.amazon.jsii.Kernel.get(this, "secretArnList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterArn = java.util.Objects.requireNonNull(builder.clusterArn, "clusterArn is required");
            this.secretArnList = builder.secretArnList;
        }

        @Override
        public final java.lang.String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final java.util.List<java.lang.String> getSecretArnList() {
            return this.secretArnList;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterArn", om.valueToTree(this.getClusterArn()));
            if (this.getSecretArnList() != null) {
                data.set("secretArnList", om.valueToTree(this.getSecretArnList()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnBatchScramSecretProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBatchScramSecretProps.Jsii$Proxy that = (CfnBatchScramSecretProps.Jsii$Proxy) o;

            if (!clusterArn.equals(that.clusterArn)) return false;
            return this.secretArnList != null ? this.secretArnList.equals(that.secretArnList) : that.secretArnList == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterArn.hashCode();
            result = 31 * result + (this.secretArnList != null ? this.secretArnList.hashCode() : 0);
            return result;
        }
    }
}
