package software.amazon.awscdk.services.networkfirewall;

/**
 * Properties for defining a <code>CfnLoggingConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkfirewall.*;
 * CfnLoggingConfigurationProps cfnLoggingConfigurationProps = CfnLoggingConfigurationProps.builder()
 *         .firewallArn("firewallArn")
 *         .loggingConfiguration(LoggingConfigurationProperty.builder()
 *                 .logDestinationConfigs(List.of(LogDestinationConfigProperty.builder()
 *                         .logDestination(Map.of(
 *                                 "logDestinationKey", "logDestination"))
 *                         .logDestinationType("logDestinationType")
 *                         .logType("logType")
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .enableMonitoringDashboard(false)
 *         .firewallName("firewallName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:18.835Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnLoggingConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnLoggingConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLoggingConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the <code>Firewall</code> that the logging configuration is associated with.
     * <p>
     * You can't change the firewall specification after you create the logging configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirewallArn();

    /**
     * Defines how AWS Network Firewall performs logging for a <code>Firewall</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLoggingConfiguration();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-enablemonitoringdashboard">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-enablemonitoringdashboard</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableMonitoringDashboard() {
        return null;
    }

    /**
     * The name of the firewall that the logging configuration is associated with.
     * <p>
     * You can't change the firewall specification after you create the logging configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFirewallName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLoggingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLoggingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLoggingConfigurationProps> {
        java.lang.String firewallArn;
        java.lang.Object loggingConfiguration;
        java.lang.Object enableMonitoringDashboard;
        java.lang.String firewallName;

        /**
         * Sets the value of {@link CfnLoggingConfigurationProps#getFirewallArn}
         * @param firewallArn The Amazon Resource Name (ARN) of the <code>Firewall</code> that the logging configuration is associated with. This parameter is required.
         *                    You can't change the firewall specification after you create the logging configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallArn(java.lang.String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggingConfigurationProps#getLoggingConfiguration}
         * @param loggingConfiguration Defines how AWS Network Firewall performs logging for a <code>Firewall</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(software.amazon.awscdk.IResolvable loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggingConfigurationProps#getLoggingConfiguration}
         * @param loggingConfiguration Defines how AWS Network Firewall performs logging for a <code>Firewall</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration.LoggingConfigurationProperty loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggingConfigurationProps#getEnableMonitoringDashboard}
         * @param enableMonitoringDashboard the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableMonitoringDashboard(java.lang.Boolean enableMonitoringDashboard) {
            this.enableMonitoringDashboard = enableMonitoringDashboard;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggingConfigurationProps#getEnableMonitoringDashboard}
         * @param enableMonitoringDashboard the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableMonitoringDashboard(software.amazon.awscdk.IResolvable enableMonitoringDashboard) {
            this.enableMonitoringDashboard = enableMonitoringDashboard;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggingConfigurationProps#getFirewallName}
         * @param firewallName The name of the firewall that the logging configuration is associated with.
         *                     You can't change the firewall specification after you create the logging configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallName(java.lang.String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLoggingConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLoggingConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLoggingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLoggingConfigurationProps {
        private final java.lang.String firewallArn;
        private final java.lang.Object loggingConfiguration;
        private final java.lang.Object enableMonitoringDashboard;
        private final java.lang.String firewallName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.firewallArn = software.amazon.jsii.Kernel.get(this, "firewallArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingConfiguration = software.amazon.jsii.Kernel.get(this, "loggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableMonitoringDashboard = software.amazon.jsii.Kernel.get(this, "enableMonitoringDashboard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.firewallName = software.amazon.jsii.Kernel.get(this, "firewallName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.firewallArn = java.util.Objects.requireNonNull(builder.firewallArn, "firewallArn is required");
            this.loggingConfiguration = java.util.Objects.requireNonNull(builder.loggingConfiguration, "loggingConfiguration is required");
            this.enableMonitoringDashboard = builder.enableMonitoringDashboard;
            this.firewallName = builder.firewallName;
        }

        @Override
        public final java.lang.String getFirewallArn() {
            return this.firewallArn;
        }

        @Override
        public final java.lang.Object getLoggingConfiguration() {
            return this.loggingConfiguration;
        }

        @Override
        public final java.lang.Object getEnableMonitoringDashboard() {
            return this.enableMonitoringDashboard;
        }

        @Override
        public final java.lang.String getFirewallName() {
            return this.firewallName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("firewallArn", om.valueToTree(this.getFirewallArn()));
            data.set("loggingConfiguration", om.valueToTree(this.getLoggingConfiguration()));
            if (this.getEnableMonitoringDashboard() != null) {
                data.set("enableMonitoringDashboard", om.valueToTree(this.getEnableMonitoringDashboard()));
            }
            if (this.getFirewallName() != null) {
                data.set("firewallName", om.valueToTree(this.getFirewallName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnLoggingConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLoggingConfigurationProps.Jsii$Proxy that = (CfnLoggingConfigurationProps.Jsii$Proxy) o;

            if (!firewallArn.equals(that.firewallArn)) return false;
            if (!loggingConfiguration.equals(that.loggingConfiguration)) return false;
            if (this.enableMonitoringDashboard != null ? !this.enableMonitoringDashboard.equals(that.enableMonitoringDashboard) : that.enableMonitoringDashboard != null) return false;
            return this.firewallName != null ? this.firewallName.equals(that.firewallName) : that.firewallName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.firewallArn.hashCode();
            result = 31 * result + (this.loggingConfiguration.hashCode());
            result = 31 * result + (this.enableMonitoringDashboard != null ? this.enableMonitoringDashboard.hashCode() : 0);
            result = 31 * result + (this.firewallName != null ? this.firewallName.hashCode() : 0);
            return result;
        }
    }
}
