package software.amazon.awscdk.services.networkmanager;

/**
 * Properties for defining a <code>CfnConnectAttachment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnConnectAttachmentProps cfnConnectAttachmentProps = CfnConnectAttachmentProps.builder()
 *         .coreNetworkId("coreNetworkId")
 *         .edgeLocation("edgeLocation")
 *         .options(ConnectAttachmentOptionsProperty.builder()
 *                 .protocol("protocol")
 *                 .build())
 *         .transportAttachmentId("transportAttachmentId")
 *         // the properties below are optional
 *         .networkFunctionGroupName("networkFunctionGroupName")
 *         .proposedNetworkFunctionGroupChange(ProposedNetworkFunctionGroupChangeProperty.builder()
 *                 .attachmentPolicyRuleNumber(123)
 *                 .networkFunctionGroupName("networkFunctionGroupName")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .proposedSegmentChange(ProposedSegmentChangeProperty.builder()
 *                 .attachmentPolicyRuleNumber(123)
 *                 .segmentName("segmentName")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:18.982Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnConnectAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the core network where the Connect attachment is located.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-corenetworkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-corenetworkid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCoreNetworkId();

    /**
     * The Region where the edge is located.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-edgelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-edgelocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEdgeLocation();

    /**
     * Options for connecting an attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-options</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getOptions();

    /**
     * The ID of the transport attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-transportattachmentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-transportattachmentid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransportAttachmentId();

    /**
     * The name of the network function group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-networkfunctiongroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-networkfunctiongroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkFunctionGroupName() {
        return null;
    }

    /**
     * Describes proposed changes to a network function group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-proposednetworkfunctiongroupchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-proposednetworkfunctiongroupchange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProposedNetworkFunctionGroupChange() {
        return null;
    }

    /**
     * Describes a proposed segment change.
     * <p>
     * In some cases, the segment change must first be evaluated and accepted.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-proposedsegmentchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-proposedsegmentchange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProposedSegmentChange() {
        return null;
    }

    /**
     * The tags associated with the Connect attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectattachment.html#cfn-networkmanager-connectattachment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectAttachmentProps> {
        java.lang.String coreNetworkId;
        java.lang.String edgeLocation;
        java.lang.Object options;
        java.lang.String transportAttachmentId;
        java.lang.String networkFunctionGroupName;
        java.lang.Object proposedNetworkFunctionGroupChange;
        java.lang.Object proposedSegmentChange;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getCoreNetworkId}
         * @param coreNetworkId The ID of the core network where the Connect attachment is located. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkId(java.lang.String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getEdgeLocation}
         * @param edgeLocation The Region where the edge is located. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edgeLocation(java.lang.String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getOptions}
         * @param options Options for connecting an attachment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.IResolvable options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getOptions}
         * @param options Options for connecting an attachment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.networkmanager.CfnConnectAttachment.ConnectAttachmentOptionsProperty options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getTransportAttachmentId}
         * @param transportAttachmentId The ID of the transport attachment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transportAttachmentId(java.lang.String transportAttachmentId) {
            this.transportAttachmentId = transportAttachmentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getNetworkFunctionGroupName}
         * @param networkFunctionGroupName The name of the network function group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkFunctionGroupName(java.lang.String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getProposedNetworkFunctionGroupChange}
         * @param proposedNetworkFunctionGroupChange Describes proposed changes to a network function group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedNetworkFunctionGroupChange(software.amazon.awscdk.IResolvable proposedNetworkFunctionGroupChange) {
            this.proposedNetworkFunctionGroupChange = proposedNetworkFunctionGroupChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getProposedNetworkFunctionGroupChange}
         * @param proposedNetworkFunctionGroupChange Describes proposed changes to a network function group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedNetworkFunctionGroupChange(software.amazon.awscdk.services.networkmanager.CfnConnectAttachment.ProposedNetworkFunctionGroupChangeProperty proposedNetworkFunctionGroupChange) {
            this.proposedNetworkFunctionGroupChange = proposedNetworkFunctionGroupChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getProposedSegmentChange}
         * @param proposedSegmentChange Describes a proposed segment change.
         *                              In some cases, the segment change must first be evaluated and accepted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedSegmentChange(software.amazon.awscdk.IResolvable proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getProposedSegmentChange}
         * @param proposedSegmentChange Describes a proposed segment change.
         *                              In some cases, the segment change must first be evaluated and accepted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedSegmentChange(software.amazon.awscdk.services.networkmanager.CfnConnectAttachment.ProposedSegmentChangeProperty proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getTags}
         * @param tags The tags associated with the Connect attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectAttachmentProps {
        private final java.lang.String coreNetworkId;
        private final java.lang.String edgeLocation;
        private final java.lang.Object options;
        private final java.lang.String transportAttachmentId;
        private final java.lang.String networkFunctionGroupName;
        private final java.lang.Object proposedNetworkFunctionGroupChange;
        private final java.lang.Object proposedSegmentChange;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.coreNetworkId = software.amazon.jsii.Kernel.get(this, "coreNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.edgeLocation = software.amazon.jsii.Kernel.get(this, "edgeLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.transportAttachmentId = software.amazon.jsii.Kernel.get(this, "transportAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkFunctionGroupName = software.amazon.jsii.Kernel.get(this, "networkFunctionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proposedNetworkFunctionGroupChange = software.amazon.jsii.Kernel.get(this, "proposedNetworkFunctionGroupChange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.proposedSegmentChange = software.amazon.jsii.Kernel.get(this, "proposedSegmentChange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.coreNetworkId = java.util.Objects.requireNonNull(builder.coreNetworkId, "coreNetworkId is required");
            this.edgeLocation = java.util.Objects.requireNonNull(builder.edgeLocation, "edgeLocation is required");
            this.options = java.util.Objects.requireNonNull(builder.options, "options is required");
            this.transportAttachmentId = java.util.Objects.requireNonNull(builder.transportAttachmentId, "transportAttachmentId is required");
            this.networkFunctionGroupName = builder.networkFunctionGroupName;
            this.proposedNetworkFunctionGroupChange = builder.proposedNetworkFunctionGroupChange;
            this.proposedSegmentChange = builder.proposedSegmentChange;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        @Override
        public final java.lang.String getEdgeLocation() {
            return this.edgeLocation;
        }

        @Override
        public final java.lang.Object getOptions() {
            return this.options;
        }

        @Override
        public final java.lang.String getTransportAttachmentId() {
            return this.transportAttachmentId;
        }

        @Override
        public final java.lang.String getNetworkFunctionGroupName() {
            return this.networkFunctionGroupName;
        }

        @Override
        public final java.lang.Object getProposedNetworkFunctionGroupChange() {
            return this.proposedNetworkFunctionGroupChange;
        }

        @Override
        public final java.lang.Object getProposedSegmentChange() {
            return this.proposedSegmentChange;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("coreNetworkId", om.valueToTree(this.getCoreNetworkId()));
            data.set("edgeLocation", om.valueToTree(this.getEdgeLocation()));
            data.set("options", om.valueToTree(this.getOptions()));
            data.set("transportAttachmentId", om.valueToTree(this.getTransportAttachmentId()));
            if (this.getNetworkFunctionGroupName() != null) {
                data.set("networkFunctionGroupName", om.valueToTree(this.getNetworkFunctionGroupName()));
            }
            if (this.getProposedNetworkFunctionGroupChange() != null) {
                data.set("proposedNetworkFunctionGroupChange", om.valueToTree(this.getProposedNetworkFunctionGroupChange()));
            }
            if (this.getProposedSegmentChange() != null) {
                data.set("proposedSegmentChange", om.valueToTree(this.getProposedSegmentChange()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnConnectAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectAttachmentProps.Jsii$Proxy that = (CfnConnectAttachmentProps.Jsii$Proxy) o;

            if (!coreNetworkId.equals(that.coreNetworkId)) return false;
            if (!edgeLocation.equals(that.edgeLocation)) return false;
            if (!options.equals(that.options)) return false;
            if (!transportAttachmentId.equals(that.transportAttachmentId)) return false;
            if (this.networkFunctionGroupName != null ? !this.networkFunctionGroupName.equals(that.networkFunctionGroupName) : that.networkFunctionGroupName != null) return false;
            if (this.proposedNetworkFunctionGroupChange != null ? !this.proposedNetworkFunctionGroupChange.equals(that.proposedNetworkFunctionGroupChange) : that.proposedNetworkFunctionGroupChange != null) return false;
            if (this.proposedSegmentChange != null ? !this.proposedSegmentChange.equals(that.proposedSegmentChange) : that.proposedSegmentChange != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.coreNetworkId.hashCode();
            result = 31 * result + (this.edgeLocation.hashCode());
            result = 31 * result + (this.options.hashCode());
            result = 31 * result + (this.transportAttachmentId.hashCode());
            result = 31 * result + (this.networkFunctionGroupName != null ? this.networkFunctionGroupName.hashCode() : 0);
            result = 31 * result + (this.proposedNetworkFunctionGroupChange != null ? this.proposedNetworkFunctionGroupChange.hashCode() : 0);
            result = 31 * result + (this.proposedSegmentChange != null ? this.proposedSegmentChange.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
