package software.amazon.awscdk.services.odb;

/**
 * Properties for defining a <code>CfnOdbNetwork</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.odb.*;
 * CfnOdbNetworkProps cfnOdbNetworkProps = CfnOdbNetworkProps.builder()
 *         .availabilityZone("availabilityZone")
 *         .availabilityZoneId("availabilityZoneId")
 *         .backupSubnetCidr("backupSubnetCidr")
 *         .clientSubnetCidr("clientSubnetCidr")
 *         .defaultDnsPrefix("defaultDnsPrefix")
 *         .deleteAssociatedResources(false)
 *         .displayName("displayName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:19.086Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnOdbNetworkProps")
@software.amazon.jsii.Jsii.Proxy(CfnOdbNetworkProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOdbNetworkProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Availability Zone (AZ) where the ODB network is located.
     * <p>
     * Required when creating an ODB network. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-availabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The AZ ID of the AZ where the ODB network is located.
     * <p>
     * Required when creating an ODB network. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-availabilityzoneid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-availabilityzoneid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneId() {
        return null;
    }

    /**
     * The CIDR range of the backup subnet in the ODB network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-backupsubnetcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-backupsubnetcidr</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBackupSubnetCidr() {
        return null;
    }

    /**
     * The CIDR range of the client subnet in the ODB network.
     * <p>
     * Required when creating an ODB network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-clientsubnetcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-clientsubnetcidr</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientSubnetCidr() {
        return null;
    }

    /**
     * The DNS prefix to the default DNS domain name.
     * <p>
     * The default DNS domain name is oraclevcn.com.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-defaultdnsprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-defaultdnsprefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultDnsPrefix() {
        return null;
    }

    /**
     * Specifies whether to delete associated OCI networking resources along with the ODB network.
     * <p>
     * Required when creating an ODB network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-deleteassociatedresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-deleteassociatedresources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteAssociatedResources() {
        return null;
    }

    /**
     * The user-friendly name of the ODB network.
     * <p>
     * Required when creating an ODB network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * Tags to assign to the Odb Network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnOdbNetworkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnOdbNetworkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnOdbNetworkProps> {
        java.lang.String availabilityZone;
        java.lang.String availabilityZoneId;
        java.lang.String backupSubnetCidr;
        java.lang.String clientSubnetCidr;
        java.lang.String defaultDnsPrefix;
        java.lang.Object deleteAssociatedResources;
        java.lang.String displayName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnOdbNetworkProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone (AZ) where the ODB network is located.
         *                         Required when creating an ODB network. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnOdbNetworkProps#getAvailabilityZoneId}
         * @param availabilityZoneId The AZ ID of the AZ where the ODB network is located.
         *                           Required when creating an ODB network. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneId(java.lang.String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        /**
         * Sets the value of {@link CfnOdbNetworkProps#getBackupSubnetCidr}
         * @param backupSubnetCidr The CIDR range of the backup subnet in the ODB network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupSubnetCidr(java.lang.String backupSubnetCidr) {
            this.backupSubnetCidr = backupSubnetCidr;
            return this;
        }

        /**
         * Sets the value of {@link CfnOdbNetworkProps#getClientSubnetCidr}
         * @param clientSubnetCidr The CIDR range of the client subnet in the ODB network.
         *                         Required when creating an ODB network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSubnetCidr(java.lang.String clientSubnetCidr) {
            this.clientSubnetCidr = clientSubnetCidr;
            return this;
        }

        /**
         * Sets the value of {@link CfnOdbNetworkProps#getDefaultDnsPrefix}
         * @param defaultDnsPrefix The DNS prefix to the default DNS domain name.
         *                         The default DNS domain name is oraclevcn.com.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultDnsPrefix(java.lang.String defaultDnsPrefix) {
            this.defaultDnsPrefix = defaultDnsPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnOdbNetworkProps#getDeleteAssociatedResources}
         * @param deleteAssociatedResources Specifies whether to delete associated OCI networking resources along with the ODB network.
         *                                  Required when creating an ODB network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAssociatedResources(java.lang.Boolean deleteAssociatedResources) {
            this.deleteAssociatedResources = deleteAssociatedResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnOdbNetworkProps#getDeleteAssociatedResources}
         * @param deleteAssociatedResources Specifies whether to delete associated OCI networking resources along with the ODB network.
         *                                  Required when creating an ODB network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAssociatedResources(software.amazon.awscdk.IResolvable deleteAssociatedResources) {
            this.deleteAssociatedResources = deleteAssociatedResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnOdbNetworkProps#getDisplayName}
         * @param displayName The user-friendly name of the ODB network.
         *                    Required when creating an ODB network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnOdbNetworkProps#getTags}
         * @param tags Tags to assign to the Odb Network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOdbNetworkProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnOdbNetworkProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnOdbNetworkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOdbNetworkProps {
        private final java.lang.String availabilityZone;
        private final java.lang.String availabilityZoneId;
        private final java.lang.String backupSubnetCidr;
        private final java.lang.String clientSubnetCidr;
        private final java.lang.String defaultDnsPrefix;
        private final java.lang.Object deleteAssociatedResources;
        private final java.lang.String displayName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZoneId = software.amazon.jsii.Kernel.get(this, "availabilityZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backupSubnetCidr = software.amazon.jsii.Kernel.get(this, "backupSubnetCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientSubnetCidr = software.amazon.jsii.Kernel.get(this, "clientSubnetCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultDnsPrefix = software.amazon.jsii.Kernel.get(this, "defaultDnsPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deleteAssociatedResources = software.amazon.jsii.Kernel.get(this, "deleteAssociatedResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = builder.availabilityZone;
            this.availabilityZoneId = builder.availabilityZoneId;
            this.backupSubnetCidr = builder.backupSubnetCidr;
            this.clientSubnetCidr = builder.clientSubnetCidr;
            this.defaultDnsPrefix = builder.defaultDnsPrefix;
            this.deleteAssociatedResources = builder.deleteAssociatedResources;
            this.displayName = builder.displayName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final java.lang.String getBackupSubnetCidr() {
            return this.backupSubnetCidr;
        }

        @Override
        public final java.lang.String getClientSubnetCidr() {
            return this.clientSubnetCidr;
        }

        @Override
        public final java.lang.String getDefaultDnsPrefix() {
            return this.defaultDnsPrefix;
        }

        @Override
        public final java.lang.Object getDeleteAssociatedResources() {
            return this.deleteAssociatedResources;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getAvailabilityZoneId() != null) {
                data.set("availabilityZoneId", om.valueToTree(this.getAvailabilityZoneId()));
            }
            if (this.getBackupSubnetCidr() != null) {
                data.set("backupSubnetCidr", om.valueToTree(this.getBackupSubnetCidr()));
            }
            if (this.getClientSubnetCidr() != null) {
                data.set("clientSubnetCidr", om.valueToTree(this.getClientSubnetCidr()));
            }
            if (this.getDefaultDnsPrefix() != null) {
                data.set("defaultDnsPrefix", om.valueToTree(this.getDefaultDnsPrefix()));
            }
            if (this.getDeleteAssociatedResources() != null) {
                data.set("deleteAssociatedResources", om.valueToTree(this.getDeleteAssociatedResources()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnOdbNetworkProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOdbNetworkProps.Jsii$Proxy that = (CfnOdbNetworkProps.Jsii$Proxy) o;

            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.availabilityZoneId != null ? !this.availabilityZoneId.equals(that.availabilityZoneId) : that.availabilityZoneId != null) return false;
            if (this.backupSubnetCidr != null ? !this.backupSubnetCidr.equals(that.backupSubnetCidr) : that.backupSubnetCidr != null) return false;
            if (this.clientSubnetCidr != null ? !this.clientSubnetCidr.equals(that.clientSubnetCidr) : that.clientSubnetCidr != null) return false;
            if (this.defaultDnsPrefix != null ? !this.defaultDnsPrefix.equals(that.defaultDnsPrefix) : that.defaultDnsPrefix != null) return false;
            if (this.deleteAssociatedResources != null ? !this.deleteAssociatedResources.equals(that.deleteAssociatedResources) : that.deleteAssociatedResources != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
            result = 31 * result + (this.availabilityZoneId != null ? this.availabilityZoneId.hashCode() : 0);
            result = 31 * result + (this.backupSubnetCidr != null ? this.backupSubnetCidr.hashCode() : 0);
            result = 31 * result + (this.clientSubnetCidr != null ? this.clientSubnetCidr.hashCode() : 0);
            result = 31 * result + (this.defaultDnsPrefix != null ? this.defaultDnsPrefix.hashCode() : 0);
            result = 31 * result + (this.deleteAssociatedResources != null ? this.deleteAssociatedResources.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
