package software.amazon.awscdk.services.omics;

/**
 * Properties for defining a <code>CfnRunGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.omics.*;
 * CfnRunGroupProps cfnRunGroupProps = CfnRunGroupProps.builder()
 *         .maxCpus(123)
 *         .maxDuration(123)
 *         .maxGpus(123)
 *         .maxRuns(123)
 *         .name("name")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:19.112Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnRunGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnRunGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRunGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The group's maximum CPU count setting.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxcpus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxcpus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCpus() {
        return null;
    }

    /**
     * The group's maximum duration setting in minutes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxduration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxDuration() {
        return null;
    }

    /**
     * The maximum GPUs that can be used by a run group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxgpus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxgpus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxGpus() {
        return null;
    }

    /**
     * The group's maximum concurrent run setting.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxruns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxruns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRuns() {
        return null;
    }

    /**
     * The group's name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Tags for the group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRunGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRunGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRunGroupProps> {
        java.lang.Number maxCpus;
        java.lang.Number maxDuration;
        java.lang.Number maxGpus;
        java.lang.Number maxRuns;
        java.lang.String name;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnRunGroupProps#getMaxCpus}
         * @param maxCpus The group's maximum CPU count setting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCpus(java.lang.Number maxCpus) {
            this.maxCpus = maxCpus;
            return this;
        }

        /**
         * Sets the value of {@link CfnRunGroupProps#getMaxDuration}
         * @param maxDuration The group's maximum duration setting in minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxDuration(java.lang.Number maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRunGroupProps#getMaxGpus}
         * @param maxGpus The maximum GPUs that can be used by a run group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxGpus(java.lang.Number maxGpus) {
            this.maxGpus = maxGpus;
            return this;
        }

        /**
         * Sets the value of {@link CfnRunGroupProps#getMaxRuns}
         * @param maxRuns The group's maximum concurrent run setting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRuns(java.lang.Number maxRuns) {
            this.maxRuns = maxRuns;
            return this;
        }

        /**
         * Sets the value of {@link CfnRunGroupProps#getName}
         * @param name The group's name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRunGroupProps#getTags}
         * @param tags Tags for the group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRunGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRunGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRunGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRunGroupProps {
        private final java.lang.Number maxCpus;
        private final java.lang.Number maxDuration;
        private final java.lang.Number maxGpus;
        private final java.lang.Number maxRuns;
        private final java.lang.String name;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxCpus = software.amazon.jsii.Kernel.get(this, "maxCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxDuration = software.amazon.jsii.Kernel.get(this, "maxDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxGpus = software.amazon.jsii.Kernel.get(this, "maxGpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxRuns = software.amazon.jsii.Kernel.get(this, "maxRuns", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxCpus = builder.maxCpus;
            this.maxDuration = builder.maxDuration;
            this.maxGpus = builder.maxGpus;
            this.maxRuns = builder.maxRuns;
            this.name = builder.name;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Number getMaxCpus() {
            return this.maxCpus;
        }

        @Override
        public final java.lang.Number getMaxDuration() {
            return this.maxDuration;
        }

        @Override
        public final java.lang.Number getMaxGpus() {
            return this.maxGpus;
        }

        @Override
        public final java.lang.Number getMaxRuns() {
            return this.maxRuns;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxCpus() != null) {
                data.set("maxCpus", om.valueToTree(this.getMaxCpus()));
            }
            if (this.getMaxDuration() != null) {
                data.set("maxDuration", om.valueToTree(this.getMaxDuration()));
            }
            if (this.getMaxGpus() != null) {
                data.set("maxGpus", om.valueToTree(this.getMaxGpus()));
            }
            if (this.getMaxRuns() != null) {
                data.set("maxRuns", om.valueToTree(this.getMaxRuns()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.CfnRunGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRunGroupProps.Jsii$Proxy that = (CfnRunGroupProps.Jsii$Proxy) o;

            if (this.maxCpus != null ? !this.maxCpus.equals(that.maxCpus) : that.maxCpus != null) return false;
            if (this.maxDuration != null ? !this.maxDuration.equals(that.maxDuration) : that.maxDuration != null) return false;
            if (this.maxGpus != null ? !this.maxGpus.equals(that.maxGpus) : that.maxGpus != null) return false;
            if (this.maxRuns != null ? !this.maxRuns.equals(that.maxRuns) : that.maxRuns != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxCpus != null ? this.maxCpus.hashCode() : 0;
            result = 31 * result + (this.maxDuration != null ? this.maxDuration.hashCode() : 0);
            result = 31 * result + (this.maxGpus != null ? this.maxGpus.hashCode() : 0);
            result = 31 * result + (this.maxRuns != null ? this.maxRuns.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
