package software.amazon.awscdk.services.pcaconnectorad;

/**
 * Properties for defining a <code>CfnTemplateGroupAccessControlEntry</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pcaconnectorad.*;
 * CfnTemplateGroupAccessControlEntryProps cfnTemplateGroupAccessControlEntryProps = CfnTemplateGroupAccessControlEntryProps.builder()
 *         .accessRights(AccessRightsProperty.builder()
 *                 .autoEnroll("autoEnroll")
 *                 .enroll("enroll")
 *                 .build())
 *         .groupDisplayName("groupDisplayName")
 *         // the properties below are optional
 *         .groupSecurityIdentifier("groupSecurityIdentifier")
 *         .templateArn("templateArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:19.384Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplateGroupAccessControlEntryProps")
@software.amazon.jsii.Jsii.Proxy(CfnTemplateGroupAccessControlEntryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTemplateGroupAccessControlEntryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-accessrights">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-accessrights</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAccessRights();

    /**
     * Name of the Active Directory group.
     * <p>
     * This name does not need to match the group name in Active Directory.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-groupdisplayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-groupdisplayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupDisplayName();

    /**
     * Security identifier (SID) of the group object from Active Directory.
     * <p>
     * The SID starts with "S-".
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-groupsecurityidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-groupsecurityidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroupSecurityIdentifier() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-templatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-templatearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTemplateGroupAccessControlEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTemplateGroupAccessControlEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTemplateGroupAccessControlEntryProps> {
        java.lang.Object accessRights;
        java.lang.String groupDisplayName;
        java.lang.String groupSecurityIdentifier;
        java.lang.String templateArn;

        /**
         * Sets the value of {@link CfnTemplateGroupAccessControlEntryProps#getAccessRights}
         * @param accessRights Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRights(software.amazon.awscdk.IResolvable accessRights) {
            this.accessRights = accessRights;
            return this;
        }

        /**
         * Sets the value of {@link CfnTemplateGroupAccessControlEntryProps#getAccessRights}
         * @param accessRights Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRights(software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntry.AccessRightsProperty accessRights) {
            this.accessRights = accessRights;
            return this;
        }

        /**
         * Sets the value of {@link CfnTemplateGroupAccessControlEntryProps#getGroupDisplayName}
         * @param groupDisplayName Name of the Active Directory group. This parameter is required.
         *                         This name does not need to match the group name in Active Directory.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupDisplayName(java.lang.String groupDisplayName) {
            this.groupDisplayName = groupDisplayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTemplateGroupAccessControlEntryProps#getGroupSecurityIdentifier}
         * @param groupSecurityIdentifier Security identifier (SID) of the group object from Active Directory.
         *                                The SID starts with "S-".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupSecurityIdentifier(java.lang.String groupSecurityIdentifier) {
            this.groupSecurityIdentifier = groupSecurityIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnTemplateGroupAccessControlEntryProps#getTemplateArn}
         * @param templateArn The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateArn(java.lang.String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTemplateGroupAccessControlEntryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTemplateGroupAccessControlEntryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTemplateGroupAccessControlEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTemplateGroupAccessControlEntryProps {
        private final java.lang.Object accessRights;
        private final java.lang.String groupDisplayName;
        private final java.lang.String groupSecurityIdentifier;
        private final java.lang.String templateArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessRights = software.amazon.jsii.Kernel.get(this, "accessRights", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.groupDisplayName = software.amazon.jsii.Kernel.get(this, "groupDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupSecurityIdentifier = software.amazon.jsii.Kernel.get(this, "groupSecurityIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateArn = software.amazon.jsii.Kernel.get(this, "templateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessRights = java.util.Objects.requireNonNull(builder.accessRights, "accessRights is required");
            this.groupDisplayName = java.util.Objects.requireNonNull(builder.groupDisplayName, "groupDisplayName is required");
            this.groupSecurityIdentifier = builder.groupSecurityIdentifier;
            this.templateArn = builder.templateArn;
        }

        @Override
        public final java.lang.Object getAccessRights() {
            return this.accessRights;
        }

        @Override
        public final java.lang.String getGroupDisplayName() {
            return this.groupDisplayName;
        }

        @Override
        public final java.lang.String getGroupSecurityIdentifier() {
            return this.groupSecurityIdentifier;
        }

        @Override
        public final java.lang.String getTemplateArn() {
            return this.templateArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessRights", om.valueToTree(this.getAccessRights()));
            data.set("groupDisplayName", om.valueToTree(this.getGroupDisplayName()));
            if (this.getGroupSecurityIdentifier() != null) {
                data.set("groupSecurityIdentifier", om.valueToTree(this.getGroupSecurityIdentifier()));
            }
            if (this.getTemplateArn() != null) {
                data.set("templateArn", om.valueToTree(this.getTemplateArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplateGroupAccessControlEntryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTemplateGroupAccessControlEntryProps.Jsii$Proxy that = (CfnTemplateGroupAccessControlEntryProps.Jsii$Proxy) o;

            if (!accessRights.equals(that.accessRights)) return false;
            if (!groupDisplayName.equals(that.groupDisplayName)) return false;
            if (this.groupSecurityIdentifier != null ? !this.groupSecurityIdentifier.equals(that.groupSecurityIdentifier) : that.groupSecurityIdentifier != null) return false;
            return this.templateArn != null ? this.templateArn.equals(that.templateArn) : that.templateArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessRights.hashCode();
            result = 31 * result + (this.groupDisplayName.hashCode());
            result = 31 * result + (this.groupSecurityIdentifier != null ? this.groupSecurityIdentifier.hashCode() : 0);
            result = 31 * result + (this.templateArn != null ? this.templateArn.hashCode() : 0);
            return result;
        }
    }
}
