package software.amazon.awscdk.services.pinpoint;

/**
 * Properties for defining a <code>CfnSMSChannel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * CfnSMSChannelProps cfnSMSChannelProps = CfnSMSChannelProps.builder()
 *         .applicationId("applicationId")
 *         // the properties below are optional
 *         .enabled(false)
 *         .senderId("senderId")
 *         .shortCode("shortCode")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:19.549Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSMSChannelProps")
@software.amazon.jsii.Jsii.Proxy(CfnSMSChannelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSMSChannelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier for the Amazon Pinpoint application that the SMS channel applies to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-applicationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * Specifies whether to enable the SMS channel for the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-enabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return null;
    }

    /**
     * The identity that you want to display on recipients' devices when they receive messages from the SMS channel.
     * <p>
     * <blockquote>
     * <p>
     * SenderIDs are only supported in certain countries and regions. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries and Regions</a> in the <em>Amazon Pinpoint User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-senderid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-senderid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSenderId() {
        return null;
    }

    /**
     * The registered short code that you want to use when you send messages through the SMS channel.
     * <p>
     * <blockquote>
     * <p>
     * For information about obtaining a dedicated short code for sending SMS messages, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-short-code.html">Requesting Dedicated Short Codes for SMS Messaging with Amazon Pinpoint</a> in the <em>Amazon Pinpoint User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-shortcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-shortcode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getShortCode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSMSChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSMSChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSMSChannelProps> {
        java.lang.String applicationId;
        java.lang.Object enabled;
        java.lang.String senderId;
        java.lang.String shortCode;

        /**
         * Sets the value of {@link CfnSMSChannelProps#getApplicationId}
         * @param applicationId The unique identifier for the Amazon Pinpoint application that the SMS channel applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSMSChannelProps#getEnabled}
         * @param enabled Specifies whether to enable the SMS channel for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnSMSChannelProps#getEnabled}
         * @param enabled Specifies whether to enable the SMS channel for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnSMSChannelProps#getSenderId}
         * @param senderId The identity that you want to display on recipients' devices when they receive messages from the SMS channel.
         *                 <blockquote>
         *                 <p>
         *                 SenderIDs are only supported in certain countries and regions. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries and Regions</a> in the <em>Amazon Pinpoint User Guide</em> .
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder senderId(java.lang.String senderId) {
            this.senderId = senderId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSMSChannelProps#getShortCode}
         * @param shortCode The registered short code that you want to use when you send messages through the SMS channel.
         *                  <blockquote>
         *                  <p>
         *                  For information about obtaining a dedicated short code for sending SMS messages, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-short-code.html">Requesting Dedicated Short Codes for SMS Messaging with Amazon Pinpoint</a> in the <em>Amazon Pinpoint User Guide</em> .
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shortCode(java.lang.String shortCode) {
            this.shortCode = shortCode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSMSChannelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSMSChannelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSMSChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSMSChannelProps {
        private final java.lang.String applicationId;
        private final java.lang.Object enabled;
        private final java.lang.String senderId;
        private final java.lang.String shortCode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.senderId = software.amazon.jsii.Kernel.get(this, "senderId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.shortCode = software.amazon.jsii.Kernel.get(this, "shortCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.enabled = builder.enabled;
            this.senderId = builder.senderId;
            this.shortCode = builder.shortCode;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.Object getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getSenderId() {
            return this.senderId;
        }

        @Override
        public final java.lang.String getShortCode() {
            return this.shortCode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getSenderId() != null) {
                data.set("senderId", om.valueToTree(this.getSenderId()));
            }
            if (this.getShortCode() != null) {
                data.set("shortCode", om.valueToTree(this.getShortCode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSMSChannelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSMSChannelProps.Jsii$Proxy that = (CfnSMSChannelProps.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.senderId != null ? !this.senderId.equals(that.senderId) : that.senderId != null) return false;
            return this.shortCode != null ? this.shortCode.equals(that.shortCode) : that.shortCode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.senderId != null ? this.senderId.hashCode() : 0);
            result = 31 * result + (this.shortCode != null ? this.shortCode.hashCode() : 0);
            return result;
        }
    }
}
