package software.amazon.awscdk.services.rds;

/**
 * Features supported by this version of the Aurora Postgres cluster engine.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * AuroraPostgresEngineFeatures auroraPostgresEngineFeatures = AuroraPostgresEngineFeatures.builder()
 *         .s3Export(false)
 *         .s3Import(false)
 *         .serverlessV2AutoPauseSupported(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:21.477Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.AuroraPostgresEngineFeatures")
@software.amazon.jsii.Jsii.Proxy(AuroraPostgresEngineFeatures.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AuroraPostgresEngineFeatures extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether this version of the Aurora Postgres cluster engine supports the S3 data export feature.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getS3Export() {
        return null;
    }

    /**
     * Whether this version of the Aurora Postgres cluster engine supports the S3 data import feature.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getS3Import() {
        return null;
    }

    /**
     * Whether this version of the Aurora Postgres cluster engine supports the Aurora SeverlessV2 auto-pause feature.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2-auto-pause.html#auto-pause-prereqs">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2-auto-pause.html#auto-pause-prereqs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getServerlessV2AutoPauseSupported() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AuroraPostgresEngineFeatures}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AuroraPostgresEngineFeatures}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AuroraPostgresEngineFeatures> {
        java.lang.Boolean s3Export;
        java.lang.Boolean s3Import;
        java.lang.Boolean serverlessV2AutoPauseSupported;

        /**
         * Sets the value of {@link AuroraPostgresEngineFeatures#getS3Export}
         * @param s3Export Whether this version of the Aurora Postgres cluster engine supports the S3 data export feature.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Export(java.lang.Boolean s3Export) {
            this.s3Export = s3Export;
            return this;
        }

        /**
         * Sets the value of {@link AuroraPostgresEngineFeatures#getS3Import}
         * @param s3Import Whether this version of the Aurora Postgres cluster engine supports the S3 data import feature.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Import(java.lang.Boolean s3Import) {
            this.s3Import = s3Import;
            return this;
        }

        /**
         * Sets the value of {@link AuroraPostgresEngineFeatures#getServerlessV2AutoPauseSupported}
         * @param serverlessV2AutoPauseSupported Whether this version of the Aurora Postgres cluster engine supports the Aurora SeverlessV2 auto-pause feature.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessV2AutoPauseSupported(java.lang.Boolean serverlessV2AutoPauseSupported) {
            this.serverlessV2AutoPauseSupported = serverlessV2AutoPauseSupported;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AuroraPostgresEngineFeatures}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AuroraPostgresEngineFeatures build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AuroraPostgresEngineFeatures}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuroraPostgresEngineFeatures {
        private final java.lang.Boolean s3Export;
        private final java.lang.Boolean s3Import;
        private final java.lang.Boolean serverlessV2AutoPauseSupported;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3Export = software.amazon.jsii.Kernel.get(this, "s3Export", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.s3Import = software.amazon.jsii.Kernel.get(this, "s3Import", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.serverlessV2AutoPauseSupported = software.amazon.jsii.Kernel.get(this, "serverlessV2AutoPauseSupported", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3Export = builder.s3Export;
            this.s3Import = builder.s3Import;
            this.serverlessV2AutoPauseSupported = builder.serverlessV2AutoPauseSupported;
        }

        @Override
        public final java.lang.Boolean getS3Export() {
            return this.s3Export;
        }

        @Override
        public final java.lang.Boolean getS3Import() {
            return this.s3Import;
        }

        @Override
        public final java.lang.Boolean getServerlessV2AutoPauseSupported() {
            return this.serverlessV2AutoPauseSupported;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getS3Export() != null) {
                data.set("s3Export", om.valueToTree(this.getS3Export()));
            }
            if (this.getS3Import() != null) {
                data.set("s3Import", om.valueToTree(this.getS3Import()));
            }
            if (this.getServerlessV2AutoPauseSupported() != null) {
                data.set("serverlessV2AutoPauseSupported", om.valueToTree(this.getServerlessV2AutoPauseSupported()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.AuroraPostgresEngineFeatures"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AuroraPostgresEngineFeatures.Jsii$Proxy that = (AuroraPostgresEngineFeatures.Jsii$Proxy) o;

            if (this.s3Export != null ? !this.s3Export.equals(that.s3Export) : that.s3Export != null) return false;
            if (this.s3Import != null ? !this.s3Import.equals(that.s3Import) : that.s3Import != null) return false;
            return this.serverlessV2AutoPauseSupported != null ? this.serverlessV2AutoPauseSupported.equals(that.serverlessV2AutoPauseSupported) : that.serverlessV2AutoPauseSupported == null;
        }

        @Override
        public final int hashCode() {
            int result = this.s3Export != null ? this.s3Export.hashCode() : 0;
            result = 31 * result + (this.s3Import != null ? this.s3Import.hashCode() : 0);
            result = 31 * result + (this.serverlessV2AutoPauseSupported != null ? this.serverlessV2AutoPauseSupported.hashCode() : 0);
            return result;
        }
    }
}
