package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a <code>CfnDBInstance</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBInstanceProps cfnDBInstanceProps = CfnDBInstanceProps.builder()
 *         .allocatedStorage("allocatedStorage")
 *         .allowMajorVersionUpgrade(false)
 *         .applyImmediately(false)
 *         .associatedRoles(List.of(DBInstanceRoleProperty.builder()
 *                 .featureName("featureName")
 *                 .roleArn("roleArn")
 *                 .build()))
 *         .automaticBackupReplicationKmsKeyId("automaticBackupReplicationKmsKeyId")
 *         .automaticBackupReplicationRegion("automaticBackupReplicationRegion")
 *         .automaticBackupReplicationRetentionPeriod(123)
 *         .autoMinorVersionUpgrade(false)
 *         .availabilityZone("availabilityZone")
 *         .backupRetentionPeriod(123)
 *         .backupTarget("backupTarget")
 *         .caCertificateIdentifier("caCertificateIdentifier")
 *         .certificateRotationRestart(false)
 *         .characterSetName("characterSetName")
 *         .copyTagsToSnapshot(false)
 *         .customIamInstanceProfile("customIamInstanceProfile")
 *         .databaseInsightsMode("databaseInsightsMode")
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .dbClusterSnapshotIdentifier("dbClusterSnapshotIdentifier")
 *         .dbInstanceClass("dbInstanceClass")
 *         .dbInstanceIdentifier("dbInstanceIdentifier")
 *         .dbName("dbName")
 *         .dbParameterGroupName("dbParameterGroupName")
 *         .dbSecurityGroups(List.of("dbSecurityGroups"))
 *         .dbSnapshotIdentifier("dbSnapshotIdentifier")
 *         .dbSubnetGroupName("dbSubnetGroupName")
 *         .dbSystemId("dbSystemId")
 *         .dedicatedLogVolume(false)
 *         .deleteAutomatedBackups(false)
 *         .deletionProtection(false)
 *         .domain("domain")
 *         .domainAuthSecretArn("domainAuthSecretArn")
 *         .domainDnsIps(List.of("domainDnsIps"))
 *         .domainFqdn("domainFqdn")
 *         .domainIamRoleName("domainIamRoleName")
 *         .domainOu("domainOu")
 *         .enableCloudwatchLogsExports(List.of("enableCloudwatchLogsExports"))
 *         .enableIamDatabaseAuthentication(false)
 *         .enablePerformanceInsights(false)
 *         .engine("engine")
 *         .engineLifecycleSupport("engineLifecycleSupport")
 *         .engineVersion("engineVersion")
 *         .iops(123)
 *         .kmsKeyId("kmsKeyId")
 *         .licenseModel("licenseModel")
 *         .manageMasterUserPassword(false)
 *         .masterUsername("masterUsername")
 *         .masterUserPassword("masterUserPassword")
 *         .masterUserSecret(MasterUserSecretProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .secretArn("secretArn")
 *                 .build())
 *         .maxAllocatedStorage(123)
 *         .monitoringInterval(123)
 *         .monitoringRoleArn("monitoringRoleArn")
 *         .multiAz(false)
 *         .ncharCharacterSetName("ncharCharacterSetName")
 *         .networkType("networkType")
 *         .optionGroupName("optionGroupName")
 *         .performanceInsightsKmsKeyId("performanceInsightsKmsKeyId")
 *         .performanceInsightsRetentionPeriod(123)
 *         .port("port")
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .processorFeatures(List.of(ProcessorFeatureProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .promotionTier(123)
 *         .publiclyAccessible(false)
 *         .replicaMode("replicaMode")
 *         .restoreTime("restoreTime")
 *         .sourceDbClusterIdentifier("sourceDbClusterIdentifier")
 *         .sourceDbInstanceAutomatedBackupsArn("sourceDbInstanceAutomatedBackupsArn")
 *         .sourceDbInstanceIdentifier("sourceDbInstanceIdentifier")
 *         .sourceDbiResourceId("sourceDbiResourceId")
 *         .sourceRegion("sourceRegion")
 *         .storageEncrypted(false)
 *         .storageThroughput(123)
 *         .storageType("storageType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tdeCredentialArn("tdeCredentialArn")
 *         .tdeCredentialPassword("tdeCredentialPassword")
 *         .timezone("timezone")
 *         .useDefaultProcessorFeatures(false)
 *         .useLatestRestorableTime(false)
 *         .vpcSecurityGroups(List.of("vpcSecurityGroups"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:21.553Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnDBInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDBInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The amount of storage in gibibytes (GiB) to be initially allocated for the database instance.
     * <p>
     * <blockquote>
     * <p>
     * If any value is set in the <code>Iops</code> parameter, <code>AllocatedStorage</code> must be at least 100 GiB, which corresponds to the minimum Iops value of 1,000. If you increase the <code>Iops</code> value (in 1,000 IOPS increments), then you must also increase the <code>AllocatedStorage</code> value (in 100-GiB increments).
     * <p>
     * </blockquote>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.
     * <p>
     * <em>Db2</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp3): Must be an integer from 20 to 64000.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 64000.</li>
     * </ul>
     * <p>
     * <em>MySQL</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
     * </ul>
     * <p>
     * <em>MariaDB</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
     * </ul>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
     * </ul>
     * <p>
     * <em>Oracle</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 10 to 3072.</li>
     * </ul>
     * <p>
     * <em>SQL Server</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2):</li>
     * <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
     * <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
     * <li>Provisioned IOPS storage (io1):</li>
     * <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
     * <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
     * <li>Magnetic storage (standard):</li>
     * <li>Enterprise and Standard editions: Must be an integer from 20 to 1024.</li>
     * <li>Web and Express editions: Must be an integer from 20 to 1024.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-allocatedstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-allocatedstorage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAllocatedStorage() {
        return null;
    }

    /**
     * A value that indicates whether major version upgrades are allowed.
     * <p>
     * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
     * <p>
     * Constraints: Major version upgrades must be allowed when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB instance's current version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-allowmajorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-allowmajorversionupgrade</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowMajorVersionUpgrade() {
        return null;
    }

    /**
     * Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>PreferredMaintenanceWindow</code> setting.
     * <p>
     * If set to <code>false</code> , changes are applied during the next maintenance window. Until RDS applies the changes, the DB instance remains in a drift state. As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
     * <p>
     * In addition to the settings described in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB instance</a> , this property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
     * <p>
     * Default: <code>true</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-applyimmediately">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-applyimmediately</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApplyImmediately() {
        return null;
    }

    /**
     * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The associated roles are managed by the DB cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-associatedroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-associatedroles</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedRoles() {
        return null;
    }

    /**
     * The AWS KMS key identifier for encryption of the replicated automated backups.
     * <p>
     * The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS Region , for example, <code>arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationkmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutomaticBackupReplicationKmsKeyId() {
        return null;
    }

    /**
     * The AWS Region associated with the automated backup.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationregion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutomaticBackupReplicationRegion() {
        return null;
    }

    /**
     * The retention period for automated backups in a different AWS Region.
     * <p>
     * Use this parameter to set a unique retention period that only applies to cross-Region automated backups. To enable automated backups in a different Region, specify a positive value for the <code>AutomaticBackupReplicationRegion</code> parameter.
     * <p>
     * If not specified, this parameter defaults to the value of the <code>BackupRetentionPeriod</code> parameter. The maximum allowed value is 35.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationretentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticBackupReplicationRetentionPeriod() {
        return null;
    }

    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     * <p>
     * By default, minor engine upgrades are applied automatically.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-autominorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-autominorversionupgrade</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return null;
    }

    /**
     * The Availability Zone (AZ) where the database will be created.
     * <p>
     * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a> .
     * <p>
     * For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
     * <p>
     * Default: A random, system-chosen Availability Zone in the endpoint's AWS Region .
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment.</li>
     * <li>The specified Availability Zone must be in the same AWS Region as the current endpoint.</li>
     * </ul>
     * <p>
     * Example: <code>us-east-1d</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-availabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The number of days for which automated backups are retained.
     * <p>
     * Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The retention period for automated backups is managed by the DB cluster.
     * <p>
     * Default: 1
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a value from 0 to 35</li>
     * <li>Can't be set to 0 if the DB instance is a source to read replicas</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-backupretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-backupretentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionPeriod() {
        return null;
    }

    /**
     * The location for storing automated backups and manual snapshots.
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>local</code> (Dedicated Local Zone)</li>
     * <li><code>outposts</code> ( AWS Outposts)</li>
     * <li><code>region</code> ( AWS Region )</li>
     * </ul>
     * <p>
     * Default: <code>region</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on AWS Outposts</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-backuptarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-backuptarget</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBackupTarget() {
        return null;
    }

    /**
     * The identifier of the CA certificate for this DB instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-cacertificateidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-cacertificateidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCaCertificateIdentifier() {
        return null;
    }

    /**
     * Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
     * <p>
     * By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
     * <p>
     * <blockquote>
     * <p>
     * Set this parameter only if you are <em>not</em> using SSL/TLS to connect to the DB instance.
     * <p>
     * </blockquote>
     * <p>
     * If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:
     * <p>
     * <ul>
     * <li>For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate.</a> in the <em>Amazon RDS User Guide.</em></li>
     * <li>For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate</a> in the <em>Amazon Aurora User Guide</em> .</li>
     * </ul>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-certificaterotationrestart">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-certificaterotationrestart</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCertificateRotationRestart() {
        return null;
    }

    /**
     * For supported engines, indicates that the DB instance should be associated with the specified character set.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The character set is managed by the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html">AWS::RDS::DBCluster</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-charactersetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-charactersetname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCharacterSetName() {
        return null;
    }

    /**
     * Specifies whether to copy tags from the DB instance to snapshots of the DB instance.
     * <p>
     * By default, tags are not copied.
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-copytagstosnapshot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-copytagstosnapshot</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshot() {
        return null;
    }

    /**
     * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
     * <p>
     * This setting is required for RDS Custom.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>The profile must exist in your account.</li>
     * <li>The profile must have an IAM role that Amazon EC2 has permissions to assume.</li>
     * <li>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code> .</li>
     * </ul>
     * <p>
     * For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">Configure IAM and your VPC</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-customiaminstanceprofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-customiaminstanceprofile</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomIamInstanceProfile() {
        return null;
    }

    /**
     * The mode of Database Insights to enable for the DB instance.
     * <p>
     * <blockquote>
     * <p>
     * Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-databaseinsightsmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-databaseinsightsmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseInsightsMode() {
        return null;
    }

    /**
     * The identifier of the DB cluster that this DB instance will belong to.
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbClusterIdentifier() {
        return null;
    }

    /**
     * The identifier for the Multi-AZ DB cluster snapshot to restore from.
     * <p>
     * For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">Multi-AZ DB cluster deployments</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing Multi-AZ DB cluster snapshot.</li>
     * <li>Can't be specified when <code>DBSnapshotIdentifier</code> is specified.</li>
     * <li>Must be specified when <code>DBSnapshotIdentifier</code> isn't specified.</li>
     * <li>If you are restoring from a shared manual Multi-AZ DB cluster snapshot, the <code>DBClusterSnapshotIdentifier</code> must be the ARN of the shared snapshot.</li>
     * <li>Can't be the identifier of an Aurora DB cluster snapshot.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbclustersnapshotidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbclustersnapshotidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbClusterSnapshotIdentifier() {
        return null;
    }

    /**
     * The compute and memory capacity of the DB instance, for example <code>db.m5.large</code> . Not all DB instance classes are available in all AWS Regions , or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance classes</a> in the <em>Amazon RDS User Guide</em> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html">Aurora DB instance classes</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbinstanceclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbinstanceclass</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceClass() {
        return null;
    }

    /**
     * A name for the DB instance.
     * <p>
     * If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbinstanceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbinstanceidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceIdentifier() {
        return null;
    }

    /**
     * The meaning of this parameter differs according to the database engine you use.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>[DBSnapshotIdentifier](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier)</code> property, this property only applies to RDS for Oracle.
     * <p>
     * </blockquote>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The database name is managed by the DB cluster.
     * <p>
     * <em>Db2</em>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 64 letters or numbers.</li>
     * <li>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</li>
     * <li>Can't be a word reserved by the specified database engine.</li>
     * </ul>
     * <p>
     * <em>MySQL</em>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 64 letters or numbers.</li>
     * <li>Can't be a word reserved by the specified database engine</li>
     * </ul>
     * <p>
     * <em>MariaDB</em>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 64 letters or numbers.</li>
     * <li>Can't be a word reserved by the specified database engine</li>
     * </ul>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter is not specified, the default <code>postgres</code> database is created in the DB instance.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</li>
     * <li>Must contain 1 to 63 characters.</li>
     * <li>Can't be a word reserved by the specified database engine</li>
     * </ul>
     * <p>
     * <em>Oracle</em>
     * <p>
     * The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code> , the default value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code> .
     * <p>
     * Default: <code>ORCL</code>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Can't be longer than 8 characters</li>
     * </ul>
     * <p>
     * <em>SQL Server</em>
     * <p>
     * Not applicable. Must be null.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbName() {
        return null;
    }

    /**
     * The name of an existing DB parameter group or a reference to an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html">AWS::RDS::DBParameterGroup</a> resource created in the template.
     * <p>
     * To list all of the available DB parameter group names, use the following command:
     * <p>
     * <code>aws rds describe-db-parameter-groups --query "DBParameterGroups[].DBParameterGroupName" --output text</code>
     * <p>
     * <blockquote>
     * <p>
     * If any of the data members of the referenced parameter group are changed during an update, the DB instance might need to be restarted, which causes some interruption. If the parameter group contains static parameters, whether they were changed or not, an update triggers a reboot.
     * <p>
     * </blockquote>
     * <p>
     * If you don't specify a value for <code>DBParameterGroupName</code> property, the default DB parameter group for the specified engine and engine version is used.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbparametergroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbParameterGroupName() {
        return null;
    }

    /**
     * A list of the DB security groups to assign to the DB instance.
     * <p>
     * The list can include both the name of existing DB security groups or references to AWS::RDS::DBSecurityGroup resources created in the template.
     * <p>
     * If you set DBSecurityGroups, you must not set VPCSecurityGroups, and vice versa. Also, note that the DBSecurityGroups property exists only for backwards compatibility with older regions and is no longer recommended for providing security information to an RDS DB instance. Instead, use VPCSecurityGroups.
     * <p>
     * <blockquote>
     * <p>
     * If you specify this property, AWS CloudFormation sends only the following properties (if specified) to Amazon RDS during create operations:
     * <p>
     * <ul>
     * <li><code>AllocatedStorage</code></li>
     * <li><code>AutoMinorVersionUpgrade</code></li>
     * <li><code>AvailabilityZone</code></li>
     * <li><code>BackupRetentionPeriod</code></li>
     * <li><code>CharacterSetName</code></li>
     * <li><code>DBInstanceClass</code></li>
     * <li><code>DBName</code></li>
     * <li><code>DBParameterGroupName</code></li>
     * <li><code>DBSecurityGroups</code></li>
     * <li><code>DBSubnetGroupName</code></li>
     * <li><code>Engine</code></li>
     * <li><code>EngineVersion</code></li>
     * <li><code>Iops</code></li>
     * <li><code>LicenseModel</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>MultiAZ</code></li>
     * <li><code>OptionGroupName</code></li>
     * <li><code>PreferredBackupWindow</code></li>
     * <li><code>PreferredMaintenanceWindow</code></li>
     * </ul>
     * <p>
     * All other properties are ignored. Specify a virtual private cloud (VPC) security group if you want to submit other properties, such as <code>StorageType</code> , <code>StorageEncrypted</code> , or <code>KmsKeyId</code> . If you're already using the <code>DBSecurityGroups</code> property, you can't use these other properties by updating your DB instance to use a VPC security group. You must recreate the DB instance.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsecuritygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbSecurityGroups() {
        return null;
    }

    /**
     * The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance.
     * <p>
     * If you're restoring from a shared manual DB snapshot, you must specify the ARN of the snapshot.
     * <p>
     * By specifying this property, you can create a DB instance from the specified DB snapshot. If the <code>DBSnapshotIdentifier</code> property is an empty string or the <code>AWS::RDS::DBInstance</code> declaration has no <code>DBSnapshotIdentifier</code> property, AWS CloudFormation creates a new database. If the property contains a value (other than an empty string), AWS CloudFormation creates a database from the specified snapshot. If a snapshot with the specified name doesn't exist, AWS CloudFormation can't create the database and it rolls back the stack.
     * <p>
     * Some DB instance properties aren't valid when you restore from a snapshot, such as the <code>MasterUsername</code> and <code>MasterUserPassword</code> properties, and the point-in-time recovery properties <code>RestoreTime</code> and <code>UseLatestRestorableTime</code> . For information about the properties that you can specify, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceFromDBSnapshot.html"><code>RestoreDBInstanceFromDBSnapshot</code></a> action in the <em>Amazon RDS API Reference</em> .
     * <p>
     * After you restore a DB instance with a <code>DBSnapshotIdentifier</code> property, you must specify the same <code>DBSnapshotIdentifier</code> property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the <code>DBSnapshotIdentifier</code> property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified <code>DBSnapshotIdentifier</code> property, and the original DB instance is deleted.
     * <p>
     * If you specify the <code>DBSnapshotIdentifier</code> property to restore a DB instance (as opposed to specifying it for DB instance updates), then don't specify the following properties:
     * <p>
     * <ul>
     * <li><code>CharacterSetName</code></li>
     * <li><code>DBClusterIdentifier</code></li>
     * <li><code>DBName</code></li>
     * <li><code>KmsKeyId</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>PromotionTier</code></li>
     * <li><code>SourceDBInstanceIdentifier</code></li>
     * <li><code>SourceRegion</code></li>
     * <li><code>StorageEncrypted</code> (for an unencrypted snapshot)</li>
     * <li><code>Timezone</code></li>
     * </ul>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Snapshot restore is managed by the DB cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsnapshotidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsnapshotidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbSnapshotIdentifier() {
        return null;
    }

    /**
     * A DB subnet group to associate with the DB instance.
     * <p>
     * If you update this value, the new subnet group must be a subnet group in a new VPC.
     * <p>
     * If you don't specify a DB subnet group, RDS uses the default DB subnet group if one exists. If a default DB subnet group does not exist, and you don't specify a <code>DBSubnetGroupName</code> , the DB instance fails to launch.
     * <p>
     * For more information about using Amazon RDS in a VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Amazon VPC and Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. The DB subnet group is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsubnetgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsubnetgroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbSubnetGroupName() {
        return null;
    }

    /**
     * The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files.
     * <p>
     * In this context, the term "Oracle database instance" refers exclusively to the system global area (SGA) and Oracle background processes. If you don't specify a SID, the value defaults to <code>RDSCDB</code> . The Oracle SID is also the name of your CDB.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsystemid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbSystemId() {
        return null;
    }

    /**
     * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dedicatedlogvolume">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dedicatedlogvolume</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDedicatedLogVolume() {
        return null;
    }

    /**
     * A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
     * <p>
     * This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the DB cluster are not deleted.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deleteautomatedbackups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deleteautomatedbackups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteAutomatedBackups() {
        return null;
    }

    /**
     * Specifies whether the DB instance has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">Deleting a DB Instance</a> .
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code> . DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deletionprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deletionprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return null;
    }

    /**
     * The Active Directory directory ID to create the DB instance in.
     * <p>
     * Currently, only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return null;
    }

    /**
     * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
     * <p>
     * Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainauthsecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainauthsecretarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainAuthSecretArn() {
        return null;
    }

    /**
     * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.</li>
     * </ul>
     * <p>
     * Example: <code>123.124.125.126,234.235.236.237</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domaindnsips">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domaindnsips</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDomainDnsIps() {
        return null;
    }

    /**
     * The fully qualified domain name (FQDN) of an Active Directory domain.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Can't be longer than 64 characters.</li>
     * </ul>
     * <p>
     * Example: <code>mymanagedADtest.mymanagedAD.mydomain</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainfqdn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainfqdn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainFqdn() {
        return null;
    }

    /**
     * The name of the IAM role to use when making API calls to the Directory Service.
     * <p>
     * This setting doesn't apply to the following DB instances:
     * <p>
     * <ul>
     * <li>Amazon Aurora (The domain is managed by the DB cluster.)</li>
     * <li>RDS Custom</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainiamrolename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainiamrolename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainIamRoleName() {
        return null;
    }

    /**
     * The Active Directory organizational unit for your DB instance to join.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the distinguished name format.</li>
     * <li>Can't be longer than 64 characters.</li>
     * </ul>
     * <p>
     * Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainou">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainou</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainOu() {
        return null;
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Relational Database Service User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. CloudWatch Logs exports are managed by the DB cluster.
     * <p>
     * <em>Db2</em>
     * <p>
     * Valid values: <code>diag.log</code> , <code>notify.log</code>
     * <p>
     * <em>MariaDB</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Microsoft SQL Server</em>
     * <p>
     * Valid values: <code>agent</code> , <code>error</code>
     * <p>
     * <em>MySQL</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Oracle</em>
     * <p>
     * Valid values: <code>alert</code> , <code>audit</code> , <code>listener</code> , <code>trace</code> , <code>oemagent</code>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * Valid values: <code>postgresql</code> , <code>upgrade</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enablecloudwatchlogsexports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enablecloudwatchlogsexports</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
        return null;
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * This property is supported for RDS for MariaDB, RDS for MySQL, and RDS for PostgreSQL. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication for MariaDB, MySQL, and PostgreSQL</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableIamDatabaseAuthentication() {
        return null;
    }

    /**
     * Specifies whether to enable Performance Insights for the DB instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableperformanceinsights">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableperformanceinsights</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnablePerformanceInsights() {
        return null;
    }

    /**
     * The name of the database engine to use for this DB instance.
     * <p>
     * Not every database engine is available in every AWS Region.
     * <p>
     * This property is required when creating a DB instance.
     * <p>
     * <blockquote>
     * <p>
     * You can convert an Oracle database from the non-CDB architecture to the container database (CDB) architecture by updating the <code>Engine</code> value in your templates from <code>oracle-ee</code> to <code>oracle-ee-cdb</code> or from <code>oracle-se2</code> to <code>oracle-se2-cdb</code> . Converting to the CDB architecture requires an interruption.
     * <p>
     * </blockquote>
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>aurora-mysql</code> (for Aurora MySQL DB instances)</li>
     * <li><code>aurora-postgresql</code> (for Aurora PostgreSQL DB instances)</li>
     * <li><code>custom-oracle-ee</code> (for RDS Custom for Oracle DB instances)</li>
     * <li><code>custom-oracle-ee-cdb</code> (for RDS Custom for Oracle DB instances)</li>
     * <li><code>custom-sqlserver-ee</code> (for RDS Custom for SQL Server DB instances)</li>
     * <li><code>custom-sqlserver-se</code> (for RDS Custom for SQL Server DB instances)</li>
     * <li><code>custom-sqlserver-web</code> (for RDS Custom for SQL Server DB instances)</li>
     * <li><code>db2-ae</code></li>
     * <li><code>db2-se</code></li>
     * <li><code>mariadb</code></li>
     * <li><code>mysql</code></li>
     * <li><code>oracle-ee</code></li>
     * <li><code>oracle-ee-cdb</code></li>
     * <li><code>oracle-se2</code></li>
     * <li><code>oracle-se2-cdb</code></li>
     * <li><code>postgres</code></li>
     * <li><code>sqlserver-ee</code></li>
     * <li><code>sqlserver-se</code></li>
     * <li><code>sqlserver-ex</code></li>
     * <li><code>sqlserver-web</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return null;
    }

    /**
     * The life cycle type for this DB instance.
     * <p>
     * <blockquote>
     * <p>
     * By default, this value is set to <code>open-source-rds-extended-support</code> , which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code> . In this case, creating the DB instance will fail if the DB major version is past its end of standard support date.
     * <p>
     * </blockquote>
     * <p>
     * This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.
     * <p>
     * You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended Support with Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
     * <p>
     * Default: <code>open-source-rds-extended-support</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enginelifecyclesupport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enginelifecyclesupport</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineLifecycleSupport() {
        return null;
    }

    /**
     * The version number of the database engine to use.
     * <p>
     * For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.
     * <p>
     * The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.
     * <p>
     * <em>Db2</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt">Amazon RDS for Db2</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>MariaDB</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>Microsoft SQL Server</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>MySQL</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>Oracle</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions">Supported PostgreSQL Database Versions</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-engineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * The number of I/O operations per second (IOPS) that the database provisions.
     * <p>
     * The value must be equal to or greater than 1000.
     * <p>
     * If you specify this property, you must follow the range of allowed ratios of your requested IOPS rate to the amount of storage that you allocate (IOPS to allocated storage). For example, you can provision an Oracle database instance with 1000 IOPS and 200 GiB of storage (a ratio of 5:1), or specify 2000 IOPS with 200 GiB of storage (a ratio of 10:1). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify <code>io1</code> for the <code>StorageType</code> property, then you must also specify the <code>Iops</code> property.
     * <p>
     * </blockquote>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the storage amount for the DB instance.</li>
     * <li>For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-iops</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
        return null;
    }

    /**
     * The ARN of the AWS KMS key that's used to encrypt the DB instance, such as <code>arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef</code> .
     * <p>
     * If you enable the StorageEncrypted property but don't specify this property, AWS CloudFormation uses the default KMS key. If you specify this property, you must set the StorageEncrypted property to true.
     * <p>
     * If you specify the <code>SourceDBInstanceIdentifier</code> or <code>SourceDbiResourceId</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used. However, if the source DB instance is in a different AWS Region, you must specify a KMS key ID.
     * <p>
     * If you specify the <code>SourceDBInstanceAutomatedBackupsArn</code> property, don't specify this property. The value is inherited from the source DB instance automated backup, and if the automated backup is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you create an encrypted read replica in a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the region that they're created in, and you can't use encryption keys from one region in another region.
     * <p>
     * If you specify the <code>DBSnapshotIdentifier</code> property, don't specify this property. The <code>StorageEncrypted</code> property value is inherited from the snapshot. If the DB instance is encrypted, the specified <code>KmsKeyId</code> property is also inherited from the snapshot.
     * <p>
     * If you specify <code>DBSecurityGroups</code> , AWS CloudFormation ignores this property. To specify both a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Using Amazon RDS with Amazon VPC</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The KMS key identifier is managed by the DB cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * License model information for this DB instance.
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li>Aurora MySQL - <code>general-public-license</code></li>
     * <li>Aurora PostgreSQL - <code>postgresql-license</code></li>
     * <li>RDS for Db2 - <code>bring-your-own-license</code> . For more information about RDS for Db2 licensing, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html"></a> in the <em>Amazon RDS User Guide.</em></li>
     * <li>RDS for MariaDB - <code>general-public-license</code></li>
     * <li>RDS for Microsoft SQL Server - <code>license-included</code></li>
     * <li>RDS for MySQL - <code>general-public-license</code></li>
     * <li>RDS for Oracle - <code>bring-your-own-license</code> or <code>license-included</code></li>
     * <li>RDS for PostgreSQL - <code>postgresql-license</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you've specified <code>DBSecurityGroups</code> and then you update the license model, AWS CloudFormation replaces the underlying DB instance. This will incur some interruptions to database availability.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-licensemodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-licensemodel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLicenseModel() {
        return null;
    }

    /**
     * Specifies whether to manage the master user password with AWS Secrets Manager.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Can't manage the master user password with AWS Secrets Manager if <code>MasterUserPassword</code> is specified.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-managemasteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-managemasteruserpassword</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getManageMasterUserPassword() {
        return null;
    }

    /**
     * The master user name for the DB instance.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBInstanceIdentifier</code> or <code>DBSnapshotIdentifier</code> property, don't specify this property. The value is inherited from the source DB instance or snapshot.
     * <p>
     * When migrating a self-managed Db2 database, we recommend that you use the same master username as your self-managed Db2 instance name.
     * <p>
     * </blockquote>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The name for the master user is managed by the DB cluster.
     * <p>
     * <em>RDS for Db2</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 to 16 letters or numbers.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>RDS for MariaDB</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 to 16 letters or numbers.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>RDS for Microsoft SQL Server</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 to 128 letters or numbers.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>RDS for MySQL</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 to 16 letters or numbers.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>RDS for Oracle</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 to 30 letters or numbers.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>RDS for PostgreSQL</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 to 63 letters or numbers.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masterusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masterusername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterUsername() {
        return null;
    }

    /**
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "&#64;".
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The password for the master user is managed by the DB cluster.
     * <p>
     * <em>RDS for Db2</em>
     * <p>
     * Must contain from 8 to 255 characters.
     * <p>
     * <em>RDS for MariaDB</em>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * <p>
     * <em>RDS for Microsoft SQL Server</em>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * <p>
     * <em>RDS for MySQL</em>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * <p>
     * <em>RDS for Oracle</em>
     * <p>
     * Constraints: Must contain from 8 to 30 characters.
     * <p>
     * <em>RDS for PostgreSQL</em>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masteruserpassword</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return null;
    }

    /**
     * The secret managed by RDS in AWS Secrets Manager for the master user password.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masterusersecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masterusersecret</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMasterUserSecret() {
        return null;
    }

    /**
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     * <p>
     * For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting doesn't apply to the following DB instances:
     * <p>
     * <ul>
     * <li>Amazon Aurora (Storage is managed by the DB cluster.)</li>
     * <li>RDS Custom</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-maxallocatedstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-maxallocatedstorage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAllocatedStorage() {
        return null;
    }

    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
     * <p>
     * To disable collection of Enhanced Monitoring metrics, specify <code>0</code> .
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value other than <code>0</code> .
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * <p>
     * Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
     * <p>
     * Default: <code>0</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-monitoringinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-monitoringinterval</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMonitoringInterval() {
        return null;
    }

    /**
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
     * <p>
     * For example, <code>arn:aws:iam:123456789012:role/emaccess</code> . For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than <code>0</code> , then you must supply a <code>MonitoringRoleArn</code> value.
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-monitoringrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-monitoringrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMonitoringRoleArn() {
        return null;
    }

    /**
     * Specifies whether the DB instance is a Multi-AZ deployment.
     * <p>
     * You can't set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.
     * <p>
     * This setting doesn't apply to Amazon Aurora because the DB instance Availability Zones (AZs) are managed by the DB cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-multiaz">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-multiaz</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultiAz() {
        return null;
    }

    /**
     * The name of the NCHAR character set for the Oracle DB instance.
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-ncharcharactersetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-ncharcharactersetname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNcharCharacterSetName() {
        return null;
    }

    /**
     * The network type of the DB instance.
     * <p>
     * Valid values:
     * <p>
     * <ul>
     * <li><code>IPV4</code></li>
     * <li><code>DUAL</code></li>
     * </ul>
     * <p>
     * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and IPv6 protocols ( <code>DUAL</code> ).
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">Working with a DB instance in a VPC</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-networktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-networktype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkType() {
        return null;
    }

    /**
     * Indicates that the DB instance should be associated with the specified option group.
     * <p>
     * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-optiongroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-optiongroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOptionGroupName() {
        return null;
    }

    /**
     * The AWS KMS key identifier for encryption of Performance Insights data.
     * <p>
     * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * <p>
     * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code> , then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account. Your AWS account has a different default KMS key for each AWS Region.
     * <p>
     * For information about enabling Performance Insights, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights">EnablePerformanceInsights</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-performanceinsightskmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-performanceinsightskmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPerformanceInsightsKmsKeyId() {
        return null;
    }

    /**
     * The number of days to retain Performance Insights data.
     * <p>
     * When creating a DB instance without enabling Performance Insights, you can't specify the parameter <code>PerformanceInsightsRetentionPeriod</code> .
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>7</code></li>
     * <li><em>month</em> * 31, where <em>month</em> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</li>
     * <li><code>731</code></li>
     * </ul>
     * <p>
     * Default: <code>7</code> days
     * <p>
     * If you specify a retention period that isn't valid, such as <code>94</code> , Amazon RDS returns an error.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-performanceinsightsretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-performanceinsightsretentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPerformanceInsightsRetentionPeriod() {
        return null;
    }

    /**
     * The port number on which the database accepts connections.
     * <p>
     * This setting doesn't apply to Aurora DB instances. The port number is managed by the cluster.
     * <p>
     * Valid Values: <code>1150-65535</code>
     * <p>
     * Default:
     * <p>
     * <ul>
     * <li>RDS for Db2 - <code>50000</code></li>
     * <li>RDS for MariaDB - <code>3306</code></li>
     * <li>RDS for Microsoft SQL Server - <code>1433</code></li>
     * <li>RDS for MySQL - <code>3306</code></li>
     * <li>RDS for Oracle - <code>1521</code></li>
     * <li>RDS for PostgreSQL - <code>5432</code></li>
     * </ul>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>For RDS for Microsoft SQL Server, the value can't be <code>1234</code> , <code>1434</code> , <code>3260</code> , <code>3343</code> , <code>3389</code> , <code>47001</code> , or <code>49152-49156</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-port</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
        return null;
    }

    /**
     * The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup Window</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-preferredbackupwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-preferredbackupwindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return null;
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow">Maintaining a DB instance</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <blockquote>
     * <p>
     * This property applies when AWS CloudFormation initially creates the DB instance. If you use AWS CloudFormation to update the DB instance, those updates are applied immediately.
     * <p>
     * </blockquote>
     * <p>
     * Constraints: Minimum 30-minute window.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-preferredmaintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-preferredmaintenancewindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * <p>
     * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-processorfeatures">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-processorfeatures</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProcessorFeatures() {
        return null;
    }

    /**
     * The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance">Fault Tolerance for an Aurora DB Cluster</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * <p>
     * Default: <code>1</code>
     * <p>
     * Valid Values: <code>0 - 15</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-promotiontier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-promotiontier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPromotionTier() {
        return null;
    }

    /**
     * Indicates whether the DB instance is an internet-facing instance.
     * <p>
     * If you specify true, AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address.
     * <p>
     * The default behavior value depends on your VPC setup and the database subnet group. For more information, see the <code>PubliclyAccessible</code> parameter in the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a> in the <em>Amazon RDS API Reference</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-publiclyaccessible</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return null;
    }

    /**
     * The open mode of an Oracle read replica.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting is only supported in RDS for Oracle.
     * <p>
     * Default: <code>open-read-only</code>
     * <p>
     * Valid Values: <code>open-read-only</code> or <code>mounted</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-replicamode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-replicamode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReplicaMode() {
        return null;
    }

    /**
     * The date and time to restore from.
     * <p>
     * This parameter applies to point-in-time recovery. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html">Restoring a DB instance to a specified time</a> in the in the <em>Amazon RDS User Guide</em> .
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a time in Universal Coordinated Time (UTC) format.</li>
     * <li>Must be before the latest restorable time for the DB instance.</li>
     * <li>Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled.</li>
     * </ul>
     * <p>
     * Example: <code>2009-09-07T23:45:00Z</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-restoretime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-restoretime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRestoreTime() {
        return null;
    }

    /**
     * The identifier of the Multi-AZ DB cluster that will act as the source for the read replica.
     * <p>
     * Each DB cluster can have up to 15 read replicas.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be the identifier of an existing Multi-AZ DB cluster.</li>
     * <li>Can't be specified if the <code>SourceDBInstanceIdentifier</code> parameter is also specified.</li>
     * <li>The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be greater than 0.</li>
     * <li>The source DB cluster must be in the same AWS Region as the read replica. Cross-Region replication isn't supported.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceDbClusterIdentifier() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code> .
     * <p>
     * This setting doesn't apply to RDS Custom.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbinstanceautomatedbackupsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbinstanceautomatedbackupsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceDbInstanceAutomatedBackupsArn() {
        return null;
    }

    /**
     * If you want to create a read replica DB instance, specify the ID of the source DB instance.
     * <p>
     * Each DB instance can have a limited number of read replicas. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html">Working with Read Replicas</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * The <code>SourceDBInstanceIdentifier</code> property determines whether a DB instance is a read replica. If you remove the <code>SourceDBInstanceIdentifier</code> property from your template and then update your stack, AWS CloudFormation promotes the read replica to a standalone DB instance.
     * <p>
     * If you specify the <code>UseLatestRestorableTime</code> or <code>RestoreTime</code> properties in conjunction with the <code>SourceDBInstanceIdentifier</code> property, RDS restores the DB instance to the requested point in time, thereby creating a new DB instance.
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>If you specify a source DB instance that uses VPC security groups, we recommend that you specify the <code>VPCSecurityGroups</code> property. If you don't specify the property, the read replica inherits the value of the <code>VPCSecurityGroups</code> property from the source DB when you create the replica. However, if you update the stack, AWS CloudFormation reverts the replica's <code>VPCSecurityGroups</code> property to the default value because it's not defined in the stack's template. This change might cause unexpected issues.</li>
     * <li>Read replicas don't support deletion policies. AWS CloudFormation ignores any deletion policy that's associated with a read replica.</li>
     * <li>If you specify <code>SourceDBInstanceIdentifier</code> , don't specify the <code>DBSnapshotIdentifier</code> property. You can't create a read replica from a snapshot.</li>
     * <li>Don't set the <code>BackupRetentionPeriod</code> , <code>DBName</code> , <code>MasterUsername</code> , <code>MasterUserPassword</code> , and <code>PreferredBackupWindow</code> properties. The database attributes are inherited from the source DB instance, and backups are disabled for read replicas.</li>
     * <li>If the source DB instance is in a different region than the read replica, specify the source region in <code>SourceRegion</code> , and specify an ARN for a valid DB instance in <code>SourceDBInstanceIdentifier</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN">Constructing a Amazon RDS Amazon Resource Name (ARN)</a> in the <em>Amazon RDS User Guide</em> .</li>
     * <li>For DB instances in Amazon Aurora clusters, don't specify this property. Amazon RDS automatically assigns writer and reader DB instances.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbinstanceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbinstanceidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceDbInstanceIdentifier() {
        return null;
    }

    /**
     * The resource ID of the source DB instance from which to restore.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbiresourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbiresourceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceDbiResourceId() {
        return null;
    }

    /**
     * The ID of the region that contains the source DB instance for the read replica.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourceregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourceregion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceRegion() {
        return null;
    }

    /**
     * A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBInstanceIdentifier</code> or <code>SourceDbiResourceId</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SourceDBInstanceAutomatedBackupsArn</code> property, don't specify this property. The value is inherited from the source DB instance automated backup.
     * <p>
     * If you specify <code>DBSnapshotIdentifier</code> property, don't specify this property. The value is inherited from the snapshot.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The encryption for DB instances is managed by the DB cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storageencrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storageencrypted</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return null;
    }

    /**
     * Specifies the storage throughput value, in mebibyte per second (MiBps), for the DB instance.
     * <p>
     * This setting applies only to the <code>gp3</code> storage type.
     * <p>
     * This setting doesn't apply to RDS Custom or Amazon Aurora.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storagethroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storagethroughput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStorageThroughput() {
        return null;
    }

    /**
     * The storage type to associate with the DB instance.
     * <p>
     * If you specify <code>io1</code> , <code>io2</code> , or <code>gp3</code> , you must also include a value for the <code>Iops</code> parameter.
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
     * <p>
     * Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
     * <p>
     * Default: <code>io1</code> , if the <code>Iops</code> parameter is specified. Otherwise, <code>gp3</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storagetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return null;
    }

    /**
     * Tags to assign to the DB instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tdecredentialarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tdecredentialarn</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getTdeCredentialArn() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tdecredentialpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tdecredentialpassword</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getTdeCredentialPassword() {
        return null;
    }

    /**
     * The time zone of the DB instance.
     * <p>
     * The time zone parameter is currently supported only by <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone">RDS for Db2</a> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">RDS for SQL Server</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-timezone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTimezone() {
        return null;
    }

    /**
     * Specifies whether the DB instance class of the DB instance uses its default processor features.
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseDefaultProcessorFeatures() {
        return null;
    }

    /**
     * Specifies whether the DB instance is restored from the latest backup time.
     * <p>
     * By default, the DB instance isn't restored from the latest backup time. This parameter applies to point-in-time recovery. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html">Restoring a DB instance to a specified time</a> in the in the <em>Amazon RDS User Guide</em> .
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Can't be specified if the <code>RestoreTime</code> parameter is provided.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-uselatestrestorabletime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-uselatestrestorabletime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseLatestRestorableTime() {
        return null;
    }

    /**
     * A list of the VPC security group IDs to assign to the DB instance.
     * <p>
     * The list can include both the physical IDs of existing VPC security groups and references to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html">AWS::EC2::SecurityGroup</a> resources created in the template.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     * <p>
     * If you set <code>VPCSecurityGroups</code> , you must not set <a href="https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> , and vice versa.
     * <p>
     * <blockquote>
     * <p>
     * You can migrate a DB instance in your stack from an RDS DB security group to a VPC security group, but keep the following in mind:
     * <p>
     * <ul>
     * <li>You can't revert to using an RDS security group after you establish a VPC security group membership.</li>
     * <li>When you migrate your DB instance to VPC security groups, if your stack update rolls back because the DB instance update fails or because an update fails in another AWS CloudFormation resource, the rollback fails because it can't revert to an RDS security group.</li>
     * <li>To use the properties that are available when you use a VPC security group, you must recreate the DB instance. If you don't, AWS CloudFormation submits only the property values that are listed in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> property.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * To avoid this situation, migrate your DB instance to using VPC security groups only when that is the only change in your stack template.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-vpcsecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-vpcsecuritygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDBInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDBInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDBInstanceProps> {
        java.lang.String allocatedStorage;
        java.lang.Object allowMajorVersionUpgrade;
        java.lang.Object applyImmediately;
        java.lang.Object associatedRoles;
        java.lang.String automaticBackupReplicationKmsKeyId;
        java.lang.String automaticBackupReplicationRegion;
        java.lang.Number automaticBackupReplicationRetentionPeriod;
        java.lang.Object autoMinorVersionUpgrade;
        java.lang.String availabilityZone;
        java.lang.Number backupRetentionPeriod;
        java.lang.String backupTarget;
        java.lang.String caCertificateIdentifier;
        java.lang.Object certificateRotationRestart;
        java.lang.String characterSetName;
        java.lang.Object copyTagsToSnapshot;
        java.lang.String customIamInstanceProfile;
        java.lang.String databaseInsightsMode;
        java.lang.String dbClusterIdentifier;
        java.lang.String dbClusterSnapshotIdentifier;
        java.lang.String dbInstanceClass;
        java.lang.String dbInstanceIdentifier;
        java.lang.String dbName;
        java.lang.String dbParameterGroupName;
        java.util.List<java.lang.String> dbSecurityGroups;
        java.lang.String dbSnapshotIdentifier;
        java.lang.String dbSubnetGroupName;
        java.lang.String dbSystemId;
        java.lang.Object dedicatedLogVolume;
        java.lang.Object deleteAutomatedBackups;
        java.lang.Object deletionProtection;
        java.lang.String domain;
        java.lang.String domainAuthSecretArn;
        java.util.List<java.lang.String> domainDnsIps;
        java.lang.String domainFqdn;
        java.lang.String domainIamRoleName;
        java.lang.String domainOu;
        java.util.List<java.lang.String> enableCloudwatchLogsExports;
        java.lang.Object enableIamDatabaseAuthentication;
        java.lang.Object enablePerformanceInsights;
        java.lang.String engine;
        java.lang.String engineLifecycleSupport;
        java.lang.String engineVersion;
        java.lang.Number iops;
        java.lang.String kmsKeyId;
        java.lang.String licenseModel;
        java.lang.Object manageMasterUserPassword;
        java.lang.String masterUsername;
        java.lang.String masterUserPassword;
        java.lang.Object masterUserSecret;
        java.lang.Number maxAllocatedStorage;
        java.lang.Number monitoringInterval;
        java.lang.String monitoringRoleArn;
        java.lang.Object multiAz;
        java.lang.String ncharCharacterSetName;
        java.lang.String networkType;
        java.lang.String optionGroupName;
        java.lang.String performanceInsightsKmsKeyId;
        java.lang.Number performanceInsightsRetentionPeriod;
        java.lang.String port;
        java.lang.String preferredBackupWindow;
        java.lang.String preferredMaintenanceWindow;
        java.lang.Object processorFeatures;
        java.lang.Number promotionTier;
        java.lang.Object publiclyAccessible;
        java.lang.String replicaMode;
        java.lang.String restoreTime;
        java.lang.String sourceDbClusterIdentifier;
        java.lang.String sourceDbInstanceAutomatedBackupsArn;
        java.lang.String sourceDbInstanceIdentifier;
        java.lang.String sourceDbiResourceId;
        java.lang.String sourceRegion;
        java.lang.Object storageEncrypted;
        java.lang.Number storageThroughput;
        java.lang.String storageType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String tdeCredentialArn;
        java.lang.String tdeCredentialPassword;
        java.lang.String timezone;
        java.lang.Object useDefaultProcessorFeatures;
        java.lang.Object useLatestRestorableTime;
        java.util.List<java.lang.String> vpcSecurityGroups;

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAllocatedStorage}
         * @param allocatedStorage The amount of storage in gibibytes (GiB) to be initially allocated for the database instance.
         *                         <blockquote>
         *                         <p>
         *                         If any value is set in the <code>Iops</code> parameter, <code>AllocatedStorage</code> must be at least 100 GiB, which corresponds to the minimum Iops value of 1,000. If you increase the <code>Iops</code> value (in 1,000 IOPS increments), then you must also increase the <code>AllocatedStorage</code> value (in 100-GiB increments).
         *                         <p>
         *                         </blockquote>
         *                         <p>
         *                         <em>Amazon Aurora</em>
         *                         <p>
         *                         Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.
         *                         <p>
         *                         <em>Db2</em>
         *                         <p>
         *                         Constraints to the amount of storage for each storage type are the following:
         *                         <p>
         *                         <ul>
         *                         <li>General Purpose (SSD) storage (gp3): Must be an integer from 20 to 64000.</li>
         *                         <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 64000.</li>
         *                         </ul>
         *                         <p>
         *                         <em>MySQL</em>
         *                         <p>
         *                         Constraints to the amount of storage for each storage type are the following:
         *                         <p>
         *                         <ul>
         *                         <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         *                         <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         *                         <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
         *                         </ul>
         *                         <p>
         *                         <em>MariaDB</em>
         *                         <p>
         *                         Constraints to the amount of storage for each storage type are the following:
         *                         <p>
         *                         <ul>
         *                         <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         *                         <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         *                         <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
         *                         </ul>
         *                         <p>
         *                         <em>PostgreSQL</em>
         *                         <p>
         *                         Constraints to the amount of storage for each storage type are the following:
         *                         <p>
         *                         <ul>
         *                         <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         *                         <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         *                         <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
         *                         </ul>
         *                         <p>
         *                         <em>Oracle</em>
         *                         <p>
         *                         Constraints to the amount of storage for each storage type are the following:
         *                         <p>
         *                         <ul>
         *                         <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         *                         <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         *                         <li>Magnetic storage (standard): Must be an integer from 10 to 3072.</li>
         *                         </ul>
         *                         <p>
         *                         <em>SQL Server</em>
         *                         <p>
         *                         Constraints to the amount of storage for each storage type are the following:
         *                         <p>
         *                         <ul>
         *                         <li>General Purpose (SSD) storage (gp2):</li>
         *                         <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
         *                         <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
         *                         <li>Provisioned IOPS storage (io1):</li>
         *                         <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
         *                         <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
         *                         <li>Magnetic storage (standard):</li>
         *                         <li>Enterprise and Standard editions: Must be an integer from 20 to 1024.</li>
         *                         <li>Web and Express editions: Must be an integer from 20 to 1024.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocatedStorage(java.lang.String allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAllowMajorVersionUpgrade}
         * @param allowMajorVersionUpgrade A value that indicates whether major version upgrades are allowed.
         *                                 Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         *                                 <p>
         *                                 Constraints: Major version upgrades must be allowed when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB instance's current version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowMajorVersionUpgrade(java.lang.Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAllowMajorVersionUpgrade}
         * @param allowMajorVersionUpgrade A value that indicates whether major version upgrades are allowed.
         *                                 Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         *                                 <p>
         *                                 Constraints: Major version upgrades must be allowed when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB instance's current version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowMajorVersionUpgrade(software.amazon.awscdk.IResolvable allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getApplyImmediately}
         * @param applyImmediately Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>PreferredMaintenanceWindow</code> setting.
         *                         If set to <code>false</code> , changes are applied during the next maintenance window. Until RDS applies the changes, the DB instance remains in a drift state. As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
         *                         <p>
         *                         In addition to the settings described in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB instance</a> , this property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
         *                         <p>
         *                         Default: <code>true</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyImmediately(java.lang.Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getApplyImmediately}
         * @param applyImmediately Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>PreferredMaintenanceWindow</code> setting.
         *                         If set to <code>false</code> , changes are applied during the next maintenance window. Until RDS applies the changes, the DB instance remains in a drift state. As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
         *                         <p>
         *                         In addition to the settings described in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB instance</a> , this property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
         *                         <p>
         *                         Default: <code>true</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyImmediately(software.amazon.awscdk.IResolvable applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAssociatedRoles}
         * @param associatedRoles The AWS Identity and Access Management (IAM) roles associated with the DB instance.
         *                        <em>Amazon Aurora</em>
         *                        <p>
         *                        Not applicable. The associated roles are managed by the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(software.amazon.awscdk.IResolvable associatedRoles) {
            this.associatedRoles = associatedRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAssociatedRoles}
         * @param associatedRoles The AWS Identity and Access Management (IAM) roles associated with the DB instance.
         *                        <em>Amazon Aurora</em>
         *                        <p>
         *                        Not applicable. The associated roles are managed by the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(java.util.List<? extends java.lang.Object> associatedRoles) {
            this.associatedRoles = associatedRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAutomaticBackupReplicationKmsKeyId}
         * @param automaticBackupReplicationKmsKeyId The AWS KMS key identifier for encryption of the replicated automated backups.
         *                                           The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS Region , for example, <code>arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticBackupReplicationKmsKeyId(java.lang.String automaticBackupReplicationKmsKeyId) {
            this.automaticBackupReplicationKmsKeyId = automaticBackupReplicationKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAutomaticBackupReplicationRegion}
         * @param automaticBackupReplicationRegion The AWS Region associated with the automated backup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticBackupReplicationRegion(java.lang.String automaticBackupReplicationRegion) {
            this.automaticBackupReplicationRegion = automaticBackupReplicationRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAutomaticBackupReplicationRetentionPeriod}
         * @param automaticBackupReplicationRetentionPeriod The retention period for automated backups in a different AWS Region.
         *                                                  Use this parameter to set a unique retention period that only applies to cross-Region automated backups. To enable automated backups in a different Region, specify a positive value for the <code>AutomaticBackupReplicationRegion</code> parameter.
         *                                                  <p>
         *                                                  If not specified, this parameter defaults to the value of the <code>BackupRetentionPeriod</code> parameter. The maximum allowed value is 35.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticBackupReplicationRetentionPeriod(java.lang.Number automaticBackupReplicationRetentionPeriod) {
            this.automaticBackupReplicationRetentionPeriod = automaticBackupReplicationRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         *                                By default, minor engine upgrades are applied automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(java.lang.Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         *                                By default, minor engine upgrades are applied automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(software.amazon.awscdk.IResolvable autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone (AZ) where the database will be created.
         *                         For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a> .
         *                         <p>
         *                         For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
         *                         <p>
         *                         Default: A random, system-chosen Availability Zone in the endpoint's AWS Region .
         *                         <p>
         *                         Constraints:
         *                         <p>
         *                         <ul>
         *                         <li>The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment.</li>
         *                         <li>The specified Availability Zone must be in the same AWS Region as the current endpoint.</li>
         *                         </ul>
         *                         <p>
         *                         Example: <code>us-east-1d</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getBackupRetentionPeriod}
         * @param backupRetentionPeriod The number of days for which automated backups are retained.
         *                              Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
         *                              <p>
         *                              <em>Amazon Aurora</em>
         *                              <p>
         *                              Not applicable. The retention period for automated backups is managed by the DB cluster.
         *                              <p>
         *                              Default: 1
         *                              <p>
         *                              Constraints:
         *                              <p>
         *                              <ul>
         *                              <li>Must be a value from 0 to 35</li>
         *                              <li>Can't be set to 0 if the DB instance is a source to read replicas</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionPeriod(java.lang.Number backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getBackupTarget}
         * @param backupTarget The location for storing automated backups and manual snapshots.
         *                     Valid Values:
         *                     <p>
         *                     <ul>
         *                     <li><code>local</code> (Dedicated Local Zone)</li>
         *                     <li><code>outposts</code> ( AWS Outposts)</li>
         *                     <li><code>region</code> ( AWS Region )</li>
         *                     </ul>
         *                     <p>
         *                     Default: <code>region</code>
         *                     <p>
         *                     For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on AWS Outposts</a> in the <em>Amazon RDS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupTarget(java.lang.String backupTarget) {
            this.backupTarget = backupTarget;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getCaCertificateIdentifier}
         * @param caCertificateIdentifier The identifier of the CA certificate for this DB instance.
         *                                For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <em>Amazon Aurora User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificateIdentifier(java.lang.String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getCertificateRotationRestart}
         * @param certificateRotationRestart Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
         *                                   By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
         *                                   <p>
         *                                   <blockquote>
         *                                   <p>
         *                                   Set this parameter only if you are <em>not</em> using SSL/TLS to connect to the DB instance.
         *                                   <p>
         *                                   </blockquote>
         *                                   <p>
         *                                   If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:
         *                                   <p>
         *                                   <ul>
         *                                   <li>For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate.</a> in the <em>Amazon RDS User Guide.</em></li>
         *                                   <li>For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate</a> in the <em>Amazon Aurora User Guide</em> .</li>
         *                                   </ul>
         *                                   <p>
         *                                   This setting doesn't apply to RDS Custom DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateRotationRestart(java.lang.Boolean certificateRotationRestart) {
            this.certificateRotationRestart = certificateRotationRestart;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getCertificateRotationRestart}
         * @param certificateRotationRestart Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
         *                                   By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
         *                                   <p>
         *                                   <blockquote>
         *                                   <p>
         *                                   Set this parameter only if you are <em>not</em> using SSL/TLS to connect to the DB instance.
         *                                   <p>
         *                                   </blockquote>
         *                                   <p>
         *                                   If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:
         *                                   <p>
         *                                   <ul>
         *                                   <li>For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate.</a> in the <em>Amazon RDS User Guide.</em></li>
         *                                   <li>For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate</a> in the <em>Amazon Aurora User Guide</em> .</li>
         *                                   </ul>
         *                                   <p>
         *                                   This setting doesn't apply to RDS Custom DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateRotationRestart(software.amazon.awscdk.IResolvable certificateRotationRestart) {
            this.certificateRotationRestart = certificateRotationRestart;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getCharacterSetName}
         * @param characterSetName For supported engines, indicates that the DB instance should be associated with the specified character set.
         *                         <em>Amazon Aurora</em>
         *                         <p>
         *                         Not applicable. The character set is managed by the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html">AWS::RDS::DBCluster</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder characterSetName(java.lang.String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot Specifies whether to copy tags from the DB instance to snapshots of the DB instance.
         *                           By default, tags are not copied.
         *                           <p>
         *                           This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(java.lang.Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot Specifies whether to copy tags from the DB instance to snapshots of the DB instance.
         *                           By default, tags are not copied.
         *                           <p>
         *                           This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(software.amazon.awscdk.IResolvable copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getCustomIamInstanceProfile}
         * @param customIamInstanceProfile The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
         *                                 This setting is required for RDS Custom.
         *                                 <p>
         *                                 Constraints:
         *                                 <p>
         *                                 <ul>
         *                                 <li>The profile must exist in your account.</li>
         *                                 <li>The profile must have an IAM role that Amazon EC2 has permissions to assume.</li>
         *                                 <li>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code> .</li>
         *                                 </ul>
         *                                 <p>
         *                                 For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">Configure IAM and your VPC</a> in the <em>Amazon RDS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customIamInstanceProfile(java.lang.String customIamInstanceProfile) {
            this.customIamInstanceProfile = customIamInstanceProfile;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDatabaseInsightsMode}
         * @param databaseInsightsMode The mode of Database Insights to enable for the DB instance.
         *                             <blockquote>
         *                             <p>
         *                             Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseInsightsMode(java.lang.String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbClusterIdentifier}
         * @param dbClusterIdentifier The identifier of the DB cluster that this DB instance will belong to.
         *                            This setting doesn't apply to RDS Custom DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(java.lang.String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbClusterSnapshotIdentifier}
         * @param dbClusterSnapshotIdentifier The identifier for the Multi-AZ DB cluster snapshot to restore from.
         *                                    For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">Multi-AZ DB cluster deployments</a> in the <em>Amazon RDS User Guide</em> .
         *                                    <p>
         *                                    Constraints:
         *                                    <p>
         *                                    <ul>
         *                                    <li>Must match the identifier of an existing Multi-AZ DB cluster snapshot.</li>
         *                                    <li>Can't be specified when <code>DBSnapshotIdentifier</code> is specified.</li>
         *                                    <li>Must be specified when <code>DBSnapshotIdentifier</code> isn't specified.</li>
         *                                    <li>If you are restoring from a shared manual Multi-AZ DB cluster snapshot, the <code>DBClusterSnapshotIdentifier</code> must be the ARN of the shared snapshot.</li>
         *                                    <li>Can't be the identifier of an Aurora DB cluster snapshot.</li>
         *                                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterSnapshotIdentifier(java.lang.String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbInstanceClass}
         * @param dbInstanceClass The compute and memory capacity of the DB instance, for example <code>db.m5.large</code> . Not all DB instance classes are available in all AWS Regions , or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance classes</a> in the <em>Amazon RDS User Guide</em> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html">Aurora DB instance classes</a> in the <em>Amazon Aurora User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceClass(java.lang.String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbInstanceIdentifier}
         * @param dbInstanceIdentifier A name for the DB instance.
         *                             If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         *                             <p>
         *                             For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceIdentifier(java.lang.String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbName}
         * @param dbName The meaning of this parameter differs according to the database engine you use.
         *               <blockquote>
         *               <p>
         *               If you specify the <code>[DBSnapshotIdentifier](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier)</code> property, this property only applies to RDS for Oracle.
         *               <p>
         *               </blockquote>
         *               <p>
         *               <em>Amazon Aurora</em>
         *               <p>
         *               Not applicable. The database name is managed by the DB cluster.
         *               <p>
         *               <em>Db2</em>
         *               <p>
         *               The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.
         *               <p>
         *               Constraints:
         *               <p>
         *               <ul>
         *               <li>Must contain 1 to 64 letters or numbers.</li>
         *               <li>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</li>
         *               <li>Can't be a word reserved by the specified database engine.</li>
         *               </ul>
         *               <p>
         *               <em>MySQL</em>
         *               <p>
         *               The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
         *               <p>
         *               Constraints:
         *               <p>
         *               <ul>
         *               <li>Must contain 1 to 64 letters or numbers.</li>
         *               <li>Can't be a word reserved by the specified database engine</li>
         *               </ul>
         *               <p>
         *               <em>MariaDB</em>
         *               <p>
         *               The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
         *               <p>
         *               Constraints:
         *               <p>
         *               <ul>
         *               <li>Must contain 1 to 64 letters or numbers.</li>
         *               <li>Can't be a word reserved by the specified database engine</li>
         *               </ul>
         *               <p>
         *               <em>PostgreSQL</em>
         *               <p>
         *               The name of the database to create when the DB instance is created. If this parameter is not specified, the default <code>postgres</code> database is created in the DB instance.
         *               <p>
         *               Constraints:
         *               <p>
         *               <ul>
         *               <li>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</li>
         *               <li>Must contain 1 to 63 characters.</li>
         *               <li>Can't be a word reserved by the specified database engine</li>
         *               </ul>
         *               <p>
         *               <em>Oracle</em>
         *               <p>
         *               The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code> , the default value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code> .
         *               <p>
         *               Default: <code>ORCL</code>
         *               <p>
         *               Constraints:
         *               <p>
         *               <ul>
         *               <li>Can't be longer than 8 characters</li>
         *               </ul>
         *               <p>
         *               <em>SQL Server</em>
         *               <p>
         *               Not applicable. Must be null.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbName(java.lang.String dbName) {
            this.dbName = dbName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbParameterGroupName}
         * @param dbParameterGroupName The name of an existing DB parameter group or a reference to an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html">AWS::RDS::DBParameterGroup</a> resource created in the template.
         *                             To list all of the available DB parameter group names, use the following command:
         *                             <p>
         *                             <code>aws rds describe-db-parameter-groups --query "DBParameterGroups[].DBParameterGroupName" --output text</code>
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             If any of the data members of the referenced parameter group are changed during an update, the DB instance might need to be restarted, which causes some interruption. If the parameter group contains static parameters, whether they were changed or not, an update triggers a reboot.
         *                             <p>
         *                             </blockquote>
         *                             <p>
         *                             If you don't specify a value for <code>DBParameterGroupName</code> property, the default DB parameter group for the specified engine and engine version is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbParameterGroupName(java.lang.String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbSecurityGroups}
         * @param dbSecurityGroups A list of the DB security groups to assign to the DB instance.
         *                         The list can include both the name of existing DB security groups or references to AWS::RDS::DBSecurityGroup resources created in the template.
         *                         <p>
         *                         If you set DBSecurityGroups, you must not set VPCSecurityGroups, and vice versa. Also, note that the DBSecurityGroups property exists only for backwards compatibility with older regions and is no longer recommended for providing security information to an RDS DB instance. Instead, use VPCSecurityGroups.
         *                         <p>
         *                         <blockquote>
         *                         <p>
         *                         If you specify this property, AWS CloudFormation sends only the following properties (if specified) to Amazon RDS during create operations:
         *                         <p>
         *                         <ul>
         *                         <li><code>AllocatedStorage</code></li>
         *                         <li><code>AutoMinorVersionUpgrade</code></li>
         *                         <li><code>AvailabilityZone</code></li>
         *                         <li><code>BackupRetentionPeriod</code></li>
         *                         <li><code>CharacterSetName</code></li>
         *                         <li><code>DBInstanceClass</code></li>
         *                         <li><code>DBName</code></li>
         *                         <li><code>DBParameterGroupName</code></li>
         *                         <li><code>DBSecurityGroups</code></li>
         *                         <li><code>DBSubnetGroupName</code></li>
         *                         <li><code>Engine</code></li>
         *                         <li><code>EngineVersion</code></li>
         *                         <li><code>Iops</code></li>
         *                         <li><code>LicenseModel</code></li>
         *                         <li><code>MasterUsername</code></li>
         *                         <li><code>MasterUserPassword</code></li>
         *                         <li><code>MultiAZ</code></li>
         *                         <li><code>OptionGroupName</code></li>
         *                         <li><code>PreferredBackupWindow</code></li>
         *                         <li><code>PreferredMaintenanceWindow</code></li>
         *                         </ul>
         *                         <p>
         *                         All other properties are ignored. Specify a virtual private cloud (VPC) security group if you want to submit other properties, such as <code>StorageType</code> , <code>StorageEncrypted</code> , or <code>KmsKeyId</code> . If you're already using the <code>DBSecurityGroups</code> property, you can't use these other properties by updating your DB instance to use a VPC security group. You must recreate the DB instance.
         *                         <p>
         *                         </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSecurityGroups(java.util.List<java.lang.String> dbSecurityGroups) {
            this.dbSecurityGroups = dbSecurityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbSnapshotIdentifier}
         * @param dbSnapshotIdentifier The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance.
         *                             If you're restoring from a shared manual DB snapshot, you must specify the ARN of the snapshot.
         *                             <p>
         *                             By specifying this property, you can create a DB instance from the specified DB snapshot. If the <code>DBSnapshotIdentifier</code> property is an empty string or the <code>AWS::RDS::DBInstance</code> declaration has no <code>DBSnapshotIdentifier</code> property, AWS CloudFormation creates a new database. If the property contains a value (other than an empty string), AWS CloudFormation creates a database from the specified snapshot. If a snapshot with the specified name doesn't exist, AWS CloudFormation can't create the database and it rolls back the stack.
         *                             <p>
         *                             Some DB instance properties aren't valid when you restore from a snapshot, such as the <code>MasterUsername</code> and <code>MasterUserPassword</code> properties, and the point-in-time recovery properties <code>RestoreTime</code> and <code>UseLatestRestorableTime</code> . For information about the properties that you can specify, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceFromDBSnapshot.html"><code>RestoreDBInstanceFromDBSnapshot</code></a> action in the <em>Amazon RDS API Reference</em> .
         *                             <p>
         *                             After you restore a DB instance with a <code>DBSnapshotIdentifier</code> property, you must specify the same <code>DBSnapshotIdentifier</code> property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the <code>DBSnapshotIdentifier</code> property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified <code>DBSnapshotIdentifier</code> property, and the original DB instance is deleted.
         *                             <p>
         *                             If you specify the <code>DBSnapshotIdentifier</code> property to restore a DB instance (as opposed to specifying it for DB instance updates), then don't specify the following properties:
         *                             <p>
         *                             <ul>
         *                             <li><code>CharacterSetName</code></li>
         *                             <li><code>DBClusterIdentifier</code></li>
         *                             <li><code>DBName</code></li>
         *                             <li><code>KmsKeyId</code></li>
         *                             <li><code>MasterUsername</code></li>
         *                             <li><code>MasterUserPassword</code></li>
         *                             <li><code>PromotionTier</code></li>
         *                             <li><code>SourceDBInstanceIdentifier</code></li>
         *                             <li><code>SourceRegion</code></li>
         *                             <li><code>StorageEncrypted</code> (for an unencrypted snapshot)</li>
         *                             <li><code>Timezone</code></li>
         *                             </ul>
         *                             <p>
         *                             <em>Amazon Aurora</em>
         *                             <p>
         *                             Not applicable. Snapshot restore is managed by the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSnapshotIdentifier(java.lang.String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbSubnetGroupName}
         * @param dbSubnetGroupName A DB subnet group to associate with the DB instance.
         *                          If you update this value, the new subnet group must be a subnet group in a new VPC.
         *                          <p>
         *                          If you don't specify a DB subnet group, RDS uses the default DB subnet group if one exists. If a default DB subnet group does not exist, and you don't specify a <code>DBSubnetGroupName</code> , the DB instance fails to launch.
         *                          <p>
         *                          For more information about using Amazon RDS in a VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Amazon VPC and Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         *                          <p>
         *                          This setting doesn't apply to Amazon Aurora DB instances. The DB subnet group is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSubnetGroupName(java.lang.String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbSystemId}
         * @param dbSystemId The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files.
         *                   In this context, the term "Oracle database instance" refers exclusively to the system global area (SGA) and Oracle background processes. If you don't specify a SID, the value defaults to <code>RDSCDB</code> . The Oracle SID is also the name of your CDB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSystemId(java.lang.String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDedicatedLogVolume}
         * @param dedicatedLogVolume Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dedicatedLogVolume(java.lang.Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDedicatedLogVolume}
         * @param dedicatedLogVolume Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dedicatedLogVolume(software.amazon.awscdk.IResolvable dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDeleteAutomatedBackups}
         * @param deleteAutomatedBackups A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
         *                               This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
         *                               <p>
         *                               <em>Amazon Aurora</em>
         *                               <p>
         *                               Not applicable. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the DB cluster are not deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAutomatedBackups(java.lang.Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDeleteAutomatedBackups}
         * @param deleteAutomatedBackups A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
         *                               This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
         *                               <p>
         *                               <em>Amazon Aurora</em>
         *                               <p>
         *                               Not applicable. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the DB cluster are not deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAutomatedBackups(software.amazon.awscdk.IResolvable deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDeletionProtection}
         * @param deletionProtection Specifies whether the DB instance has deletion protection enabled.
         *                           The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">Deleting a DB Instance</a> .
         *                           <p>
         *                           This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code> . DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDeletionProtection}
         * @param deletionProtection Specifies whether the DB instance has deletion protection enabled.
         *                           The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">Deleting a DB Instance</a> .
         *                           <p>
         *                           This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code> . DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(software.amazon.awscdk.IResolvable deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDomain}
         * @param domain The Active Directory directory ID to create the DB instance in.
         *               Currently, only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
         *               <p>
         *               For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <em>Amazon RDS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDomainAuthSecretArn}
         * @param domainAuthSecretArn The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
         *                            Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainAuthSecretArn(java.lang.String domainAuthSecretArn) {
            this.domainAuthSecretArn = domainAuthSecretArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDomainDnsIps}
         * @param domainDnsIps The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         *                     Constraints:
         *                     <p>
         *                     <ul>
         *                     <li>Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.</li>
         *                     </ul>
         *                     <p>
         *                     Example: <code>123.124.125.126,234.235.236.237</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainDnsIps(java.util.List<java.lang.String> domainDnsIps) {
            this.domainDnsIps = domainDnsIps;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDomainFqdn}
         * @param domainFqdn The fully qualified domain name (FQDN) of an Active Directory domain.
         *                   Constraints:
         *                   <p>
         *                   <ul>
         *                   <li>Can't be longer than 64 characters.</li>
         *                   </ul>
         *                   <p>
         *                   Example: <code>mymanagedADtest.mymanagedAD.mydomain</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainFqdn(java.lang.String domainFqdn) {
            this.domainFqdn = domainFqdn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDomainIamRoleName}
         * @param domainIamRoleName The name of the IAM role to use when making API calls to the Directory Service.
         *                          This setting doesn't apply to the following DB instances:
         *                          <p>
         *                          <ul>
         *                          <li>Amazon Aurora (The domain is managed by the DB cluster.)</li>
         *                          <li>RDS Custom</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIamRoleName(java.lang.String domainIamRoleName) {
            this.domainIamRoleName = domainIamRoleName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDomainOu}
         * @param domainOu The Active Directory organizational unit for your DB instance to join.
         *                 Constraints:
         *                 <p>
         *                 <ul>
         *                 <li>Must be in the distinguished name format.</li>
         *                 <li>Can't be longer than 64 characters.</li>
         *                 </ul>
         *                 <p>
         *                 Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainOu(java.lang.String domainOu) {
            this.domainOu = domainOu;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getEnableCloudwatchLogsExports}
         * @param enableCloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs.
         *                                    The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Relational Database Service User Guide</em> .
         *                                    <p>
         *                                    <em>Amazon Aurora</em>
         *                                    <p>
         *                                    Not applicable. CloudWatch Logs exports are managed by the DB cluster.
         *                                    <p>
         *                                    <em>Db2</em>
         *                                    <p>
         *                                    Valid values: <code>diag.log</code> , <code>notify.log</code>
         *                                    <p>
         *                                    <em>MariaDB</em>
         *                                    <p>
         *                                    Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
         *                                    <p>
         *                                    <em>Microsoft SQL Server</em>
         *                                    <p>
         *                                    Valid values: <code>agent</code> , <code>error</code>
         *                                    <p>
         *                                    <em>MySQL</em>
         *                                    <p>
         *                                    Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
         *                                    <p>
         *                                    <em>Oracle</em>
         *                                    <p>
         *                                    Valid values: <code>alert</code> , <code>audit</code> , <code>listener</code> , <code>trace</code> , <code>oemagent</code>
         *                                    <p>
         *                                    <em>PostgreSQL</em>
         *                                    <p>
         *                                    Valid values: <code>postgresql</code> , <code>upgrade</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableCloudwatchLogsExports(java.util.List<java.lang.String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = enableCloudwatchLogsExports;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getEnableIamDatabaseAuthentication}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         *                                        By default, mapping is disabled.
         *                                        <p>
         *                                        This property is supported for RDS for MariaDB, RDS for MySQL, and RDS for PostgreSQL. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication for MariaDB, MySQL, and PostgreSQL</a> in the <em>Amazon RDS User Guide.</em>
         *                                        <p>
         *                                        <em>Amazon Aurora</em>
         *                                        <p>
         *                                        Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(java.lang.Boolean enableIamDatabaseAuthentication) {
            this.enableIamDatabaseAuthentication = enableIamDatabaseAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getEnableIamDatabaseAuthentication}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         *                                        By default, mapping is disabled.
         *                                        <p>
         *                                        This property is supported for RDS for MariaDB, RDS for MySQL, and RDS for PostgreSQL. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication for MariaDB, MySQL, and PostgreSQL</a> in the <em>Amazon RDS User Guide.</em>
         *                                        <p>
         *                                        <em>Amazon Aurora</em>
         *                                        <p>
         *                                        Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(software.amazon.awscdk.IResolvable enableIamDatabaseAuthentication) {
            this.enableIamDatabaseAuthentication = enableIamDatabaseAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getEnablePerformanceInsights}
         * @param enablePerformanceInsights Specifies whether to enable Performance Insights for the DB instance.
         *                                  For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
         *                                  <p>
         *                                  This setting doesn't apply to RDS Custom DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(java.lang.Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getEnablePerformanceInsights}
         * @param enablePerformanceInsights Specifies whether to enable Performance Insights for the DB instance.
         *                                  For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
         *                                  <p>
         *                                  This setting doesn't apply to RDS Custom DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(software.amazon.awscdk.IResolvable enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getEngine}
         * @param engine The name of the database engine to use for this DB instance.
         *               Not every database engine is available in every AWS Region.
         *               <p>
         *               This property is required when creating a DB instance.
         *               <p>
         *               <blockquote>
         *               <p>
         *               You can convert an Oracle database from the non-CDB architecture to the container database (CDB) architecture by updating the <code>Engine</code> value in your templates from <code>oracle-ee</code> to <code>oracle-ee-cdb</code> or from <code>oracle-se2</code> to <code>oracle-se2-cdb</code> . Converting to the CDB architecture requires an interruption.
         *               <p>
         *               </blockquote>
         *               <p>
         *               Valid Values:
         *               <p>
         *               <ul>
         *               <li><code>aurora-mysql</code> (for Aurora MySQL DB instances)</li>
         *               <li><code>aurora-postgresql</code> (for Aurora PostgreSQL DB instances)</li>
         *               <li><code>custom-oracle-ee</code> (for RDS Custom for Oracle DB instances)</li>
         *               <li><code>custom-oracle-ee-cdb</code> (for RDS Custom for Oracle DB instances)</li>
         *               <li><code>custom-sqlserver-ee</code> (for RDS Custom for SQL Server DB instances)</li>
         *               <li><code>custom-sqlserver-se</code> (for RDS Custom for SQL Server DB instances)</li>
         *               <li><code>custom-sqlserver-web</code> (for RDS Custom for SQL Server DB instances)</li>
         *               <li><code>db2-ae</code></li>
         *               <li><code>db2-se</code></li>
         *               <li><code>mariadb</code></li>
         *               <li><code>mysql</code></li>
         *               <li><code>oracle-ee</code></li>
         *               <li><code>oracle-ee-cdb</code></li>
         *               <li><code>oracle-se2</code></li>
         *               <li><code>oracle-se2-cdb</code></li>
         *               <li><code>postgres</code></li>
         *               <li><code>sqlserver-ee</code></li>
         *               <li><code>sqlserver-se</code></li>
         *               <li><code>sqlserver-ex</code></li>
         *               <li><code>sqlserver-web</code></li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getEngineLifecycleSupport}
         * @param engineLifecycleSupport The life cycle type for this DB instance.
         *                               <blockquote>
         *                               <p>
         *                               By default, this value is set to <code>open-source-rds-extended-support</code> , which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code> . In this case, creating the DB instance will fail if the DB major version is past its end of standard support date.
         *                               <p>
         *                               </blockquote>
         *                               <p>
         *                               This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.
         *                               <p>
         *                               You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended Support with Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         *                               <p>
         *                               Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         *                               <p>
         *                               Default: <code>open-source-rds-extended-support</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineLifecycleSupport(java.lang.String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getEngineVersion}
         * @param engineVersion The version number of the database engine to use.
         *                      For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.
         *                      <p>
         *                      The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.
         *                      <p>
         *                      <em>Amazon Aurora</em>
         *                      <p>
         *                      Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.
         *                      <p>
         *                      <em>Db2</em>
         *                      <p>
         *                      See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt">Amazon RDS for Db2</a> in the <em>Amazon RDS User Guide.</em>
         *                      <p>
         *                      <em>MariaDB</em>
         *                      <p>
         *                      See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
         *                      <p>
         *                      <em>Microsoft SQL Server</em>
         *                      <p>
         *                      See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <em>Amazon RDS User Guide.</em>
         *                      <p>
         *                      <em>MySQL</em>
         *                      <p>
         *                      See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
         *                      <p>
         *                      <em>Oracle</em>
         *                      <p>
         *                      See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <em>Amazon RDS User Guide.</em>
         *                      <p>
         *                      <em>PostgreSQL</em>
         *                      <p>
         *                      See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions">Supported PostgreSQL Database Versions</a> in the <em>Amazon RDS User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getIops}
         * @param iops The number of I/O operations per second (IOPS) that the database provisions.
         *             The value must be equal to or greater than 1000.
         *             <p>
         *             If you specify this property, you must follow the range of allowed ratios of your requested IOPS rate to the amount of storage that you allocate (IOPS to allocated storage). For example, you can provision an Oracle database instance with 1000 IOPS and 200 GiB of storage (a ratio of 5:1), or specify 2000 IOPS with 200 GiB of storage (a ratio of 10:1). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <em>Amazon RDS User Guide</em> .
         *             <p>
         *             <blockquote>
         *             <p>
         *             If you specify <code>io1</code> for the <code>StorageType</code> property, then you must also specify the <code>Iops</code> property.
         *             <p>
         *             </blockquote>
         *             <p>
         *             Constraints:
         *             <p>
         *             <ul>
         *             <li>For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the storage amount for the DB instance.</li>
         *             <li>For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(java.lang.Number iops) {
            this.iops = iops;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getKmsKeyId}
         * @param kmsKeyId The ARN of the AWS KMS key that's used to encrypt the DB instance, such as <code>arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef</code> .
         *                 If you enable the StorageEncrypted property but don't specify this property, AWS CloudFormation uses the default KMS key. If you specify this property, you must set the StorageEncrypted property to true.
         *                 <p>
         *                 If you specify the <code>SourceDBInstanceIdentifier</code> or <code>SourceDbiResourceId</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used. However, if the source DB instance is in a different AWS Region, you must specify a KMS key ID.
         *                 <p>
         *                 If you specify the <code>SourceDBInstanceAutomatedBackupsArn</code> property, don't specify this property. The value is inherited from the source DB instance automated backup, and if the automated backup is encrypted, the specified <code>KmsKeyId</code> property is used.
         *                 <p>
         *                 If you create an encrypted read replica in a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the region that they're created in, and you can't use encryption keys from one region in another region.
         *                 <p>
         *                 If you specify the <code>DBSnapshotIdentifier</code> property, don't specify this property. The <code>StorageEncrypted</code> property value is inherited from the snapshot. If the DB instance is encrypted, the specified <code>KmsKeyId</code> property is also inherited from the snapshot.
         *                 <p>
         *                 If you specify <code>DBSecurityGroups</code> , AWS CloudFormation ignores this property. To specify both a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Using Amazon RDS with Amazon VPC</a> in the <em>Amazon RDS User Guide</em> .
         *                 <p>
         *                 <em>Amazon Aurora</em>
         *                 <p>
         *                 Not applicable. The KMS key identifier is managed by the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getLicenseModel}
         * @param licenseModel License model information for this DB instance.
         *                     Valid Values:
         *                     <p>
         *                     <ul>
         *                     <li>Aurora MySQL - <code>general-public-license</code></li>
         *                     <li>Aurora PostgreSQL - <code>postgresql-license</code></li>
         *                     <li>RDS for Db2 - <code>bring-your-own-license</code> . For more information about RDS for Db2 licensing, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html"></a> in the <em>Amazon RDS User Guide.</em></li>
         *                     <li>RDS for MariaDB - <code>general-public-license</code></li>
         *                     <li>RDS for Microsoft SQL Server - <code>license-included</code></li>
         *                     <li>RDS for MySQL - <code>general-public-license</code></li>
         *                     <li>RDS for Oracle - <code>bring-your-own-license</code> or <code>license-included</code></li>
         *                     <li>RDS for PostgreSQL - <code>postgresql-license</code></li>
         *                     </ul>
         *                     <p>
         *                     <blockquote>
         *                     <p>
         *                     If you've specified <code>DBSecurityGroups</code> and then you update the license model, AWS CloudFormation replaces the underlying DB instance. This will incur some interruptions to database availability.
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseModel(java.lang.String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getManageMasterUserPassword}
         * @param manageMasterUserPassword Specifies whether to manage the master user password with AWS Secrets Manager.
         *                                 For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide.</em>
         *                                 <p>
         *                                 Constraints:
         *                                 <p>
         *                                 <ul>
         *                                 <li>Can't manage the master user password with AWS Secrets Manager if <code>MasterUserPassword</code> is specified.</li>
         *                                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageMasterUserPassword(java.lang.Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getManageMasterUserPassword}
         * @param manageMasterUserPassword Specifies whether to manage the master user password with AWS Secrets Manager.
         *                                 For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide.</em>
         *                                 <p>
         *                                 Constraints:
         *                                 <p>
         *                                 <ul>
         *                                 <li>Can't manage the master user password with AWS Secrets Manager if <code>MasterUserPassword</code> is specified.</li>
         *                                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageMasterUserPassword(software.amazon.awscdk.IResolvable manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getMasterUsername}
         * @param masterUsername The master user name for the DB instance.
         *                       <blockquote>
         *                       <p>
         *                       If you specify the <code>SourceDBInstanceIdentifier</code> or <code>DBSnapshotIdentifier</code> property, don't specify this property. The value is inherited from the source DB instance or snapshot.
         *                       <p>
         *                       When migrating a self-managed Db2 database, we recommend that you use the same master username as your self-managed Db2 instance name.
         *                       <p>
         *                       </blockquote>
         *                       <p>
         *                       <em>Amazon Aurora</em>
         *                       <p>
         *                       Not applicable. The name for the master user is managed by the DB cluster.
         *                       <p>
         *                       <em>RDS for Db2</em>
         *                       <p>
         *                       Constraints:
         *                       <p>
         *                       <ul>
         *                       <li>Must be 1 to 16 letters or numbers.</li>
         *                       <li>First character must be a letter.</li>
         *                       <li>Can't be a reserved word for the chosen database engine.</li>
         *                       </ul>
         *                       <p>
         *                       <em>RDS for MariaDB</em>
         *                       <p>
         *                       Constraints:
         *                       <p>
         *                       <ul>
         *                       <li>Must be 1 to 16 letters or numbers.</li>
         *                       <li>Can't be a reserved word for the chosen database engine.</li>
         *                       </ul>
         *                       <p>
         *                       <em>RDS for Microsoft SQL Server</em>
         *                       <p>
         *                       Constraints:
         *                       <p>
         *                       <ul>
         *                       <li>Must be 1 to 128 letters or numbers.</li>
         *                       <li>First character must be a letter.</li>
         *                       <li>Can't be a reserved word for the chosen database engine.</li>
         *                       </ul>
         *                       <p>
         *                       <em>RDS for MySQL</em>
         *                       <p>
         *                       Constraints:
         *                       <p>
         *                       <ul>
         *                       <li>Must be 1 to 16 letters or numbers.</li>
         *                       <li>First character must be a letter.</li>
         *                       <li>Can't be a reserved word for the chosen database engine.</li>
         *                       </ul>
         *                       <p>
         *                       <em>RDS for Oracle</em>
         *                       <p>
         *                       Constraints:
         *                       <p>
         *                       <ul>
         *                       <li>Must be 1 to 30 letters or numbers.</li>
         *                       <li>First character must be a letter.</li>
         *                       <li>Can't be a reserved word for the chosen database engine.</li>
         *                       </ul>
         *                       <p>
         *                       <em>RDS for PostgreSQL</em>
         *                       <p>
         *                       Constraints:
         *                       <p>
         *                       <ul>
         *                       <li>Must be 1 to 63 letters or numbers.</li>
         *                       <li>First character must be a letter.</li>
         *                       <li>Can't be a reserved word for the chosen database engine.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(java.lang.String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getMasterUserPassword}
         * @param masterUserPassword The password for the master user. The password can include any printable ASCII character except "/", """, or "&#64;".
         *                           <em>Amazon Aurora</em>
         *                           <p>
         *                           Not applicable. The password for the master user is managed by the DB cluster.
         *                           <p>
         *                           <em>RDS for Db2</em>
         *                           <p>
         *                           Must contain from 8 to 255 characters.
         *                           <p>
         *                           <em>RDS for MariaDB</em>
         *                           <p>
         *                           Constraints: Must contain from 8 to 41 characters.
         *                           <p>
         *                           <em>RDS for Microsoft SQL Server</em>
         *                           <p>
         *                           Constraints: Must contain from 8 to 128 characters.
         *                           <p>
         *                           <em>RDS for MySQL</em>
         *                           <p>
         *                           Constraints: Must contain from 8 to 41 characters.
         *                           <p>
         *                           <em>RDS for Oracle</em>
         *                           <p>
         *                           Constraints: Must contain from 8 to 30 characters.
         *                           <p>
         *                           <em>RDS for PostgreSQL</em>
         *                           <p>
         *                           Constraints: Must contain from 8 to 128 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(java.lang.String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getMasterUserSecret}
         * @param masterUserSecret The secret managed by RDS in AWS Secrets Manager for the master user password.
         *                         For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserSecret(software.amazon.awscdk.IResolvable masterUserSecret) {
            this.masterUserSecret = masterUserSecret;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getMasterUserSecret}
         * @param masterUserSecret The secret managed by RDS in AWS Secrets Manager for the master user password.
         *                         For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserSecret(software.amazon.awscdk.services.rds.CfnDBInstance.MasterUserSecretProperty masterUserSecret) {
            this.masterUserSecret = masterUserSecret;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getMaxAllocatedStorage}
         * @param maxAllocatedStorage The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         *                            For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <em>Amazon RDS User Guide</em> .
         *                            <p>
         *                            This setting doesn't apply to the following DB instances:
         *                            <p>
         *                            <ul>
         *                            <li>Amazon Aurora (Storage is managed by the DB cluster.)</li>
         *                            <li>RDS Custom</li>
         *                            </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAllocatedStorage(java.lang.Number maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getMonitoringInterval}
         * @param monitoringInterval The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
         *                           To disable collection of Enhanced Monitoring metrics, specify <code>0</code> .
         *                           <p>
         *                           If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value other than <code>0</code> .
         *                           <p>
         *                           This setting doesn't apply to RDS Custom DB instances.
         *                           <p>
         *                           Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
         *                           <p>
         *                           Default: <code>0</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringInterval(java.lang.Number monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getMonitoringRoleArn}
         * @param monitoringRoleArn The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
         *                          For example, <code>arn:aws:iam:123456789012:role/emaccess</code> . For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <em>Amazon RDS User Guide</em> .
         *                          <p>
         *                          If <code>MonitoringInterval</code> is set to a value other than <code>0</code> , then you must supply a <code>MonitoringRoleArn</code> value.
         *                          <p>
         *                          This setting doesn't apply to RDS Custom DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringRoleArn(java.lang.String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getMultiAz}
         * @param multiAz Specifies whether the DB instance is a Multi-AZ deployment.
         *                You can't set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.
         *                <p>
         *                This setting doesn't apply to Amazon Aurora because the DB instance Availability Zones (AZs) are managed by the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAz(java.lang.Boolean multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getMultiAz}
         * @param multiAz Specifies whether the DB instance is a Multi-AZ deployment.
         *                You can't set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.
         *                <p>
         *                This setting doesn't apply to Amazon Aurora because the DB instance Availability Zones (AZs) are managed by the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAz(software.amazon.awscdk.IResolvable multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getNcharCharacterSetName}
         * @param ncharCharacterSetName The name of the NCHAR character set for the Oracle DB instance.
         *                              This setting doesn't apply to RDS Custom DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ncharCharacterSetName(java.lang.String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getNetworkType}
         * @param networkType The network type of the DB instance.
         *                    Valid values:
         *                    <p>
         *                    <ul>
         *                    <li><code>IPV4</code></li>
         *                    <li><code>DUAL</code></li>
         *                    </ul>
         *                    <p>
         *                    The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and IPv6 protocols ( <code>DUAL</code> ).
         *                    <p>
         *                    For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">Working with a DB instance in a VPC</a> in the <em>Amazon RDS User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkType(java.lang.String networkType) {
            this.networkType = networkType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getOptionGroupName}
         * @param optionGroupName Indicates that the DB instance should be associated with the specified option group.
         *                        Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionGroupName(java.lang.String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getPerformanceInsightsKmsKeyId}
         * @param performanceInsightsKmsKeyId The AWS KMS key identifier for encryption of Performance Insights data.
         *                                    The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *                                    <p>
         *                                    If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code> , then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account. Your AWS account has a different default KMS key for each AWS Region.
         *                                    <p>
         *                                    For information about enabling Performance Insights, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights">EnablePerformanceInsights</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsKmsKeyId(java.lang.String performanceInsightsKmsKeyId) {
            this.performanceInsightsKmsKeyId = performanceInsightsKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getPerformanceInsightsRetentionPeriod}
         * @param performanceInsightsRetentionPeriod The number of days to retain Performance Insights data.
         *                                           When creating a DB instance without enabling Performance Insights, you can't specify the parameter <code>PerformanceInsightsRetentionPeriod</code> .
         *                                           <p>
         *                                           This setting doesn't apply to RDS Custom DB instances.
         *                                           <p>
         *                                           Valid Values:
         *                                           <p>
         *                                           <ul>
         *                                           <li><code>7</code></li>
         *                                           <li><em>month</em> * 31, where <em>month</em> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</li>
         *                                           <li><code>731</code></li>
         *                                           </ul>
         *                                           <p>
         *                                           Default: <code>7</code> days
         *                                           <p>
         *                                           If you specify a retention period that isn't valid, such as <code>94</code> , Amazon RDS returns an error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsRetentionPeriod(java.lang.Number performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getPort}
         * @param port The port number on which the database accepts connections.
         *             This setting doesn't apply to Aurora DB instances. The port number is managed by the cluster.
         *             <p>
         *             Valid Values: <code>1150-65535</code>
         *             <p>
         *             Default:
         *             <p>
         *             <ul>
         *             <li>RDS for Db2 - <code>50000</code></li>
         *             <li>RDS for MariaDB - <code>3306</code></li>
         *             <li>RDS for Microsoft SQL Server - <code>1433</code></li>
         *             <li>RDS for MySQL - <code>3306</code></li>
         *             <li>RDS for Oracle - <code>1521</code></li>
         *             <li>RDS for PostgreSQL - <code>5432</code></li>
         *             </ul>
         *             <p>
         *             Constraints:
         *             <p>
         *             <ul>
         *             <li>For RDS for Microsoft SQL Server, the value can't be <code>1234</code> , <code>1434</code> , <code>3260</code> , <code>3343</code> , <code>3389</code> , <code>47001</code> , or <code>49152-49156</code> .</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.String port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getPreferredBackupWindow}
         * @param preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.
         *                              For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup Window</a> in the <em>Amazon RDS User Guide.</em>
         *                              <p>
         *                              Constraints:
         *                              <p>
         *                              <ul>
         *                              <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
         *                              <li>Must be in Universal Coordinated Time (UTC).</li>
         *                              <li>Must not conflict with the preferred maintenance window.</li>
         *                              <li>Must be at least 30 minutes.</li>
         *                              </ul>
         *                              <p>
         *                              <em>Amazon Aurora</em>
         *                              <p>
         *                              Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(java.lang.String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *                                   Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *                                   <p>
         *                                   The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow">Maintaining a DB instance</a> in the <em>Amazon RDS User Guide.</em>
         *                                   <p>
         *                                   <blockquote>
         *                                   <p>
         *                                   This property applies when AWS CloudFormation initially creates the DB instance. If you use AWS CloudFormation to update the DB instance, those updates are applied immediately.
         *                                   <p>
         *                                   </blockquote>
         *                                   <p>
         *                                   Constraints: Minimum 30-minute window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getProcessorFeatures}
         * @param processorFeatures The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         *                          This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processorFeatures(software.amazon.awscdk.IResolvable processorFeatures) {
            this.processorFeatures = processorFeatures;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getProcessorFeatures}
         * @param processorFeatures The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         *                          This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processorFeatures(java.util.List<? extends java.lang.Object> processorFeatures) {
            this.processorFeatures = processorFeatures;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getPromotionTier}
         * @param promotionTier The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance.
         *                      For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance">Fault Tolerance for an Aurora DB Cluster</a> in the <em>Amazon Aurora User Guide</em> .
         *                      <p>
         *                      This setting doesn't apply to RDS Custom DB instances.
         *                      <p>
         *                      Default: <code>1</code>
         *                      <p>
         *                      Valid Values: <code>0 - 15</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder promotionTier(java.lang.Number promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getPubliclyAccessible}
         * @param publiclyAccessible Indicates whether the DB instance is an internet-facing instance.
         *                           If you specify true, AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address.
         *                           <p>
         *                           The default behavior value depends on your VPC setup and the database subnet group. For more information, see the <code>PubliclyAccessible</code> parameter in the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a> in the <em>Amazon RDS API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getPubliclyAccessible}
         * @param publiclyAccessible Indicates whether the DB instance is an internet-facing instance.
         *                           If you specify true, AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address.
         *                           <p>
         *                           The default behavior value depends on your VPC setup and the database subnet group. For more information, see the <code>PubliclyAccessible</code> parameter in the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a> in the <em>Amazon RDS API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getReplicaMode}
         * @param replicaMode The open mode of an Oracle read replica.
         *                    For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         *                    <p>
         *                    This setting is only supported in RDS for Oracle.
         *                    <p>
         *                    Default: <code>open-read-only</code>
         *                    <p>
         *                    Valid Values: <code>open-read-only</code> or <code>mounted</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaMode(java.lang.String replicaMode) {
            this.replicaMode = replicaMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getRestoreTime}
         * @param restoreTime The date and time to restore from.
         *                    This parameter applies to point-in-time recovery. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html">Restoring a DB instance to a specified time</a> in the in the <em>Amazon RDS User Guide</em> .
         *                    <p>
         *                    Constraints:
         *                    <p>
         *                    <ul>
         *                    <li>Must be a time in Universal Coordinated Time (UTC) format.</li>
         *                    <li>Must be before the latest restorable time for the DB instance.</li>
         *                    <li>Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled.</li>
         *                    </ul>
         *                    <p>
         *                    Example: <code>2009-09-07T23:45:00Z</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTime(java.lang.String restoreTime) {
            this.restoreTime = restoreTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getSourceDbClusterIdentifier}
         * @param sourceDbClusterIdentifier The identifier of the Multi-AZ DB cluster that will act as the source for the read replica.
         *                                  Each DB cluster can have up to 15 read replicas.
         *                                  <p>
         *                                  Constraints:
         *                                  <p>
         *                                  <ul>
         *                                  <li>Must be the identifier of an existing Multi-AZ DB cluster.</li>
         *                                  <li>Can't be specified if the <code>SourceDBInstanceIdentifier</code> parameter is also specified.</li>
         *                                  <li>The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be greater than 0.</li>
         *                                  <li>The source DB cluster must be in the same AWS Region as the read replica. Cross-Region replication isn't supported.</li>
         *                                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbClusterIdentifier(java.lang.String sourceDbClusterIdentifier) {
            this.sourceDbClusterIdentifier = sourceDbClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getSourceDbInstanceAutomatedBackupsArn}
         * @param sourceDbInstanceAutomatedBackupsArn The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code> .
         *                                            This setting doesn't apply to RDS Custom.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbInstanceAutomatedBackupsArn(java.lang.String sourceDbInstanceAutomatedBackupsArn) {
            this.sourceDbInstanceAutomatedBackupsArn = sourceDbInstanceAutomatedBackupsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getSourceDbInstanceIdentifier}
         * @param sourceDbInstanceIdentifier If you want to create a read replica DB instance, specify the ID of the source DB instance.
         *                                   Each DB instance can have a limited number of read replicas. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html">Working with Read Replicas</a> in the <em>Amazon RDS User Guide</em> .
         *                                   <p>
         *                                   For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         *                                   <p>
         *                                   The <code>SourceDBInstanceIdentifier</code> property determines whether a DB instance is a read replica. If you remove the <code>SourceDBInstanceIdentifier</code> property from your template and then update your stack, AWS CloudFormation promotes the read replica to a standalone DB instance.
         *                                   <p>
         *                                   If you specify the <code>UseLatestRestorableTime</code> or <code>RestoreTime</code> properties in conjunction with the <code>SourceDBInstanceIdentifier</code> property, RDS restores the DB instance to the requested point in time, thereby creating a new DB instance.
         *                                   <p>
         *                                   <blockquote>
         *                                   <p>
         *                                   <ul>
         *                                   <li>If you specify a source DB instance that uses VPC security groups, we recommend that you specify the <code>VPCSecurityGroups</code> property. If you don't specify the property, the read replica inherits the value of the <code>VPCSecurityGroups</code> property from the source DB when you create the replica. However, if you update the stack, AWS CloudFormation reverts the replica's <code>VPCSecurityGroups</code> property to the default value because it's not defined in the stack's template. This change might cause unexpected issues.</li>
         *                                   <li>Read replicas don't support deletion policies. AWS CloudFormation ignores any deletion policy that's associated with a read replica.</li>
         *                                   <li>If you specify <code>SourceDBInstanceIdentifier</code> , don't specify the <code>DBSnapshotIdentifier</code> property. You can't create a read replica from a snapshot.</li>
         *                                   <li>Don't set the <code>BackupRetentionPeriod</code> , <code>DBName</code> , <code>MasterUsername</code> , <code>MasterUserPassword</code> , and <code>PreferredBackupWindow</code> properties. The database attributes are inherited from the source DB instance, and backups are disabled for read replicas.</li>
         *                                   <li>If the source DB instance is in a different region than the read replica, specify the source region in <code>SourceRegion</code> , and specify an ARN for a valid DB instance in <code>SourceDBInstanceIdentifier</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN">Constructing a Amazon RDS Amazon Resource Name (ARN)</a> in the <em>Amazon RDS User Guide</em> .</li>
         *                                   <li>For DB instances in Amazon Aurora clusters, don't specify this property. Amazon RDS automatically assigns writer and reader DB instances.</li>
         *                                   </ul>
         *                                   <p>
         *                                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbInstanceIdentifier(java.lang.String sourceDbInstanceIdentifier) {
            this.sourceDbInstanceIdentifier = sourceDbInstanceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getSourceDbiResourceId}
         * @param sourceDbiResourceId The resource ID of the source DB instance from which to restore.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbiResourceId(java.lang.String sourceDbiResourceId) {
            this.sourceDbiResourceId = sourceDbiResourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getSourceRegion}
         * @param sourceRegion The ID of the region that contains the source DB instance for the read replica.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceRegion(java.lang.String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getStorageEncrypted}
         * @param storageEncrypted A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
         *                         If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         *                         <p>
         *                         If you specify the <code>SourceDBInstanceIdentifier</code> or <code>SourceDbiResourceId</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
         *                         <p>
         *                         If you specify the <code>SourceDBInstanceAutomatedBackupsArn</code> property, don't specify this property. The value is inherited from the source DB instance automated backup.
         *                         <p>
         *                         If you specify <code>DBSnapshotIdentifier</code> property, don't specify this property. The value is inherited from the snapshot.
         *                         <p>
         *                         <em>Amazon Aurora</em>
         *                         <p>
         *                         Not applicable. The encryption for DB instances is managed by the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(java.lang.Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getStorageEncrypted}
         * @param storageEncrypted A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
         *                         If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         *                         <p>
         *                         If you specify the <code>SourceDBInstanceIdentifier</code> or <code>SourceDbiResourceId</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
         *                         <p>
         *                         If you specify the <code>SourceDBInstanceAutomatedBackupsArn</code> property, don't specify this property. The value is inherited from the source DB instance automated backup.
         *                         <p>
         *                         If you specify <code>DBSnapshotIdentifier</code> property, don't specify this property. The value is inherited from the snapshot.
         *                         <p>
         *                         <em>Amazon Aurora</em>
         *                         <p>
         *                         Not applicable. The encryption for DB instances is managed by the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(software.amazon.awscdk.IResolvable storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getStorageThroughput}
         * @param storageThroughput Specifies the storage throughput value, in mebibyte per second (MiBps), for the DB instance.
         *                          This setting applies only to the <code>gp3</code> storage type.
         *                          <p>
         *                          This setting doesn't apply to RDS Custom or Amazon Aurora.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageThroughput(java.lang.Number storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getStorageType}
         * @param storageType The storage type to associate with the DB instance.
         *                    If you specify <code>io1</code> , <code>io2</code> , or <code>gp3</code> , you must also include a value for the <code>Iops</code> parameter.
         *                    <p>
         *                    This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
         *                    <p>
         *                    Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
         *                    <p>
         *                    Default: <code>io1</code> , if the <code>Iops</code> parameter is specified. Otherwise, <code>gp3</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(java.lang.String storageType) {
            this.storageType = storageType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getTags}
         * @param tags Tags to assign to the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getTdeCredentialArn}
         * @param tdeCredentialArn the value to be set.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder tdeCredentialArn(java.lang.String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getTdeCredentialPassword}
         * @param tdeCredentialPassword the value to be set.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder tdeCredentialPassword(java.lang.String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getTimezone}
         * @param timezone The time zone of the DB instance.
         *                 The time zone parameter is currently supported only by <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone">RDS for Db2</a> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">RDS for SQL Server</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timezone(java.lang.String timezone) {
            this.timezone = timezone;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getUseDefaultProcessorFeatures}
         * @param useDefaultProcessorFeatures Specifies whether the DB instance class of the DB instance uses its default processor features.
         *                                    This setting doesn't apply to RDS Custom DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useDefaultProcessorFeatures(java.lang.Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getUseDefaultProcessorFeatures}
         * @param useDefaultProcessorFeatures Specifies whether the DB instance class of the DB instance uses its default processor features.
         *                                    This setting doesn't apply to RDS Custom DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useDefaultProcessorFeatures(software.amazon.awscdk.IResolvable useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getUseLatestRestorableTime}
         * @param useLatestRestorableTime Specifies whether the DB instance is restored from the latest backup time.
         *                                By default, the DB instance isn't restored from the latest backup time. This parameter applies to point-in-time recovery. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html">Restoring a DB instance to a specified time</a> in the in the <em>Amazon RDS User Guide</em> .
         *                                <p>
         *                                Constraints:
         *                                <p>
         *                                <ul>
         *                                <li>Can't be specified if the <code>RestoreTime</code> parameter is provided.</li>
         *                                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(java.lang.Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getUseLatestRestorableTime}
         * @param useLatestRestorableTime Specifies whether the DB instance is restored from the latest backup time.
         *                                By default, the DB instance isn't restored from the latest backup time. This parameter applies to point-in-time recovery. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html">Restoring a DB instance to a specified time</a> in the in the <em>Amazon RDS User Guide</em> .
         *                                <p>
         *                                Constraints:
         *                                <p>
         *                                <ul>
         *                                <li>Can't be specified if the <code>RestoreTime</code> parameter is provided.</li>
         *                                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(software.amazon.awscdk.IResolvable useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getVpcSecurityGroups}
         * @param vpcSecurityGroups A list of the VPC security group IDs to assign to the DB instance.
         *                          The list can include both the physical IDs of existing VPC security groups and references to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html">AWS::EC2::SecurityGroup</a> resources created in the template.
         *                          <p>
         *                          If you plan to update the resource, don't specify VPC security groups in a shared VPC.
         *                          <p>
         *                          If you set <code>VPCSecurityGroups</code> , you must not set <a href="https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> , and vice versa.
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          You can migrate a DB instance in your stack from an RDS DB security group to a VPC security group, but keep the following in mind:
         *                          <p>
         *                          <ul>
         *                          <li>You can't revert to using an RDS security group after you establish a VPC security group membership.</li>
         *                          <li>When you migrate your DB instance to VPC security groups, if your stack update rolls back because the DB instance update fails or because an update fails in another AWS CloudFormation resource, the rollback fails because it can't revert to an RDS security group.</li>
         *                          <li>To use the properties that are available when you use a VPC security group, you must recreate the DB instance. If you don't, AWS CloudFormation submits only the property values that are listed in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> property.</li>
         *                          </ul>
         *                          <p>
         *                          </blockquote>
         *                          <p>
         *                          To avoid this situation, migrate your DB instance to using VPC security groups only when that is the only change in your stack template.
         *                          <p>
         *                          <em>Amazon Aurora</em>
         *                          <p>
         *                          Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroups(java.util.List<java.lang.String> vpcSecurityGroups) {
            this.vpcSecurityGroups = vpcSecurityGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDBInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDBInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDBInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDBInstanceProps {
        private final java.lang.String allocatedStorage;
        private final java.lang.Object allowMajorVersionUpgrade;
        private final java.lang.Object applyImmediately;
        private final java.lang.Object associatedRoles;
        private final java.lang.String automaticBackupReplicationKmsKeyId;
        private final java.lang.String automaticBackupReplicationRegion;
        private final java.lang.Number automaticBackupReplicationRetentionPeriod;
        private final java.lang.Object autoMinorVersionUpgrade;
        private final java.lang.String availabilityZone;
        private final java.lang.Number backupRetentionPeriod;
        private final java.lang.String backupTarget;
        private final java.lang.String caCertificateIdentifier;
        private final java.lang.Object certificateRotationRestart;
        private final java.lang.String characterSetName;
        private final java.lang.Object copyTagsToSnapshot;
        private final java.lang.String customIamInstanceProfile;
        private final java.lang.String databaseInsightsMode;
        private final java.lang.String dbClusterIdentifier;
        private final java.lang.String dbClusterSnapshotIdentifier;
        private final java.lang.String dbInstanceClass;
        private final java.lang.String dbInstanceIdentifier;
        private final java.lang.String dbName;
        private final java.lang.String dbParameterGroupName;
        private final java.util.List<java.lang.String> dbSecurityGroups;
        private final java.lang.String dbSnapshotIdentifier;
        private final java.lang.String dbSubnetGroupName;
        private final java.lang.String dbSystemId;
        private final java.lang.Object dedicatedLogVolume;
        private final java.lang.Object deleteAutomatedBackups;
        private final java.lang.Object deletionProtection;
        private final java.lang.String domain;
        private final java.lang.String domainAuthSecretArn;
        private final java.util.List<java.lang.String> domainDnsIps;
        private final java.lang.String domainFqdn;
        private final java.lang.String domainIamRoleName;
        private final java.lang.String domainOu;
        private final java.util.List<java.lang.String> enableCloudwatchLogsExports;
        private final java.lang.Object enableIamDatabaseAuthentication;
        private final java.lang.Object enablePerformanceInsights;
        private final java.lang.String engine;
        private final java.lang.String engineLifecycleSupport;
        private final java.lang.String engineVersion;
        private final java.lang.Number iops;
        private final java.lang.String kmsKeyId;
        private final java.lang.String licenseModel;
        private final java.lang.Object manageMasterUserPassword;
        private final java.lang.String masterUsername;
        private final java.lang.String masterUserPassword;
        private final java.lang.Object masterUserSecret;
        private final java.lang.Number maxAllocatedStorage;
        private final java.lang.Number monitoringInterval;
        private final java.lang.String monitoringRoleArn;
        private final java.lang.Object multiAz;
        private final java.lang.String ncharCharacterSetName;
        private final java.lang.String networkType;
        private final java.lang.String optionGroupName;
        private final java.lang.String performanceInsightsKmsKeyId;
        private final java.lang.Number performanceInsightsRetentionPeriod;
        private final java.lang.String port;
        private final java.lang.String preferredBackupWindow;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.lang.Object processorFeatures;
        private final java.lang.Number promotionTier;
        private final java.lang.Object publiclyAccessible;
        private final java.lang.String replicaMode;
        private final java.lang.String restoreTime;
        private final java.lang.String sourceDbClusterIdentifier;
        private final java.lang.String sourceDbInstanceAutomatedBackupsArn;
        private final java.lang.String sourceDbInstanceIdentifier;
        private final java.lang.String sourceDbiResourceId;
        private final java.lang.String sourceRegion;
        private final java.lang.Object storageEncrypted;
        private final java.lang.Number storageThroughput;
        private final java.lang.String storageType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String tdeCredentialArn;
        private final java.lang.String tdeCredentialPassword;
        private final java.lang.String timezone;
        private final java.lang.Object useDefaultProcessorFeatures;
        private final java.lang.Object useLatestRestorableTime;
        private final java.util.List<java.lang.String> vpcSecurityGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allocatedStorage = software.amazon.jsii.Kernel.get(this, "allocatedStorage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowMajorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "allowMajorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.applyImmediately = software.amazon.jsii.Kernel.get(this, "applyImmediately", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.associatedRoles = software.amazon.jsii.Kernel.get(this, "associatedRoles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.automaticBackupReplicationKmsKeyId = software.amazon.jsii.Kernel.get(this, "automaticBackupReplicationKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.automaticBackupReplicationRegion = software.amazon.jsii.Kernel.get(this, "automaticBackupReplicationRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.automaticBackupReplicationRetentionPeriod = software.amazon.jsii.Kernel.get(this, "automaticBackupReplicationRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.autoMinorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backupRetentionPeriod = software.amazon.jsii.Kernel.get(this, "backupRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.backupTarget = software.amazon.jsii.Kernel.get(this, "backupTarget", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.caCertificateIdentifier = software.amazon.jsii.Kernel.get(this, "caCertificateIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateRotationRestart = software.amazon.jsii.Kernel.get(this, "certificateRotationRestart", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.characterSetName = software.amazon.jsii.Kernel.get(this, "characterSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.copyTagsToSnapshot = software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customIamInstanceProfile = software.amazon.jsii.Kernel.get(this, "customIamInstanceProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseInsightsMode = software.amazon.jsii.Kernel.get(this, "databaseInsightsMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbClusterSnapshotIdentifier = software.amazon.jsii.Kernel.get(this, "dbClusterSnapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbInstanceClass = software.amazon.jsii.Kernel.get(this, "dbInstanceClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbInstanceIdentifier = software.amazon.jsii.Kernel.get(this, "dbInstanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbName = software.amazon.jsii.Kernel.get(this, "dbName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbParameterGroupName = software.amazon.jsii.Kernel.get(this, "dbParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbSecurityGroups = software.amazon.jsii.Kernel.get(this, "dbSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dbSnapshotIdentifier = software.amazon.jsii.Kernel.get(this, "dbSnapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbSubnetGroupName = software.amazon.jsii.Kernel.get(this, "dbSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbSystemId = software.amazon.jsii.Kernel.get(this, "dbSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dedicatedLogVolume = software.amazon.jsii.Kernel.get(this, "dedicatedLogVolume", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deleteAutomatedBackups = software.amazon.jsii.Kernel.get(this, "deleteAutomatedBackups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainAuthSecretArn = software.amazon.jsii.Kernel.get(this, "domainAuthSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainDnsIps = software.amazon.jsii.Kernel.get(this, "domainDnsIps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.domainFqdn = software.amazon.jsii.Kernel.get(this, "domainFqdn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainIamRoleName = software.amazon.jsii.Kernel.get(this, "domainIamRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainOu = software.amazon.jsii.Kernel.get(this, "domainOu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableCloudwatchLogsExports = software.amazon.jsii.Kernel.get(this, "enableCloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.enableIamDatabaseAuthentication = software.amazon.jsii.Kernel.get(this, "enableIamDatabaseAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enablePerformanceInsights = software.amazon.jsii.Kernel.get(this, "enablePerformanceInsights", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineLifecycleSupport = software.amazon.jsii.Kernel.get(this, "engineLifecycleSupport", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.licenseModel = software.amazon.jsii.Kernel.get(this, "licenseModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.manageMasterUserPassword = software.amazon.jsii.Kernel.get(this, "manageMasterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.masterUsername = software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUserPassword = software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUserSecret = software.amazon.jsii.Kernel.get(this, "masterUserSecret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maxAllocatedStorage = software.amazon.jsii.Kernel.get(this, "maxAllocatedStorage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.monitoringInterval = software.amazon.jsii.Kernel.get(this, "monitoringInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.monitoringRoleArn = software.amazon.jsii.Kernel.get(this, "monitoringRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiAz = software.amazon.jsii.Kernel.get(this, "multiAz", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ncharCharacterSetName = software.amazon.jsii.Kernel.get(this, "ncharCharacterSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkType = software.amazon.jsii.Kernel.get(this, "networkType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.optionGroupName = software.amazon.jsii.Kernel.get(this, "optionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.performanceInsightsKmsKeyId = software.amazon.jsii.Kernel.get(this, "performanceInsightsKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.performanceInsightsRetentionPeriod = software.amazon.jsii.Kernel.get(this, "performanceInsightsRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredBackupWindow = software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.processorFeatures = software.amazon.jsii.Kernel.get(this, "processorFeatures", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.promotionTier = software.amazon.jsii.Kernel.get(this, "promotionTier", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.replicaMode = software.amazon.jsii.Kernel.get(this, "replicaMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restoreTime = software.amazon.jsii.Kernel.get(this, "restoreTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceDbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "sourceDbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceDbInstanceAutomatedBackupsArn = software.amazon.jsii.Kernel.get(this, "sourceDbInstanceAutomatedBackupsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceDbInstanceIdentifier = software.amazon.jsii.Kernel.get(this, "sourceDbInstanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceDbiResourceId = software.amazon.jsii.Kernel.get(this, "sourceDbiResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceRegion = software.amazon.jsii.Kernel.get(this, "sourceRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageEncrypted = software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.storageThroughput = software.amazon.jsii.Kernel.get(this, "storageThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.storageType = software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.tdeCredentialArn = software.amazon.jsii.Kernel.get(this, "tdeCredentialArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tdeCredentialPassword = software.amazon.jsii.Kernel.get(this, "tdeCredentialPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timezone = software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.useDefaultProcessorFeatures = software.amazon.jsii.Kernel.get(this, "useDefaultProcessorFeatures", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.useLatestRestorableTime = software.amazon.jsii.Kernel.get(this, "useLatestRestorableTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcSecurityGroups = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allocatedStorage = builder.allocatedStorage;
            this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
            this.applyImmediately = builder.applyImmediately;
            this.associatedRoles = builder.associatedRoles;
            this.automaticBackupReplicationKmsKeyId = builder.automaticBackupReplicationKmsKeyId;
            this.automaticBackupReplicationRegion = builder.automaticBackupReplicationRegion;
            this.automaticBackupReplicationRetentionPeriod = builder.automaticBackupReplicationRetentionPeriod;
            this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
            this.availabilityZone = builder.availabilityZone;
            this.backupRetentionPeriod = builder.backupRetentionPeriod;
            this.backupTarget = builder.backupTarget;
            this.caCertificateIdentifier = builder.caCertificateIdentifier;
            this.certificateRotationRestart = builder.certificateRotationRestart;
            this.characterSetName = builder.characterSetName;
            this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
            this.customIamInstanceProfile = builder.customIamInstanceProfile;
            this.databaseInsightsMode = builder.databaseInsightsMode;
            this.dbClusterIdentifier = builder.dbClusterIdentifier;
            this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
            this.dbInstanceClass = builder.dbInstanceClass;
            this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
            this.dbName = builder.dbName;
            this.dbParameterGroupName = builder.dbParameterGroupName;
            this.dbSecurityGroups = builder.dbSecurityGroups;
            this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
            this.dbSubnetGroupName = builder.dbSubnetGroupName;
            this.dbSystemId = builder.dbSystemId;
            this.dedicatedLogVolume = builder.dedicatedLogVolume;
            this.deleteAutomatedBackups = builder.deleteAutomatedBackups;
            this.deletionProtection = builder.deletionProtection;
            this.domain = builder.domain;
            this.domainAuthSecretArn = builder.domainAuthSecretArn;
            this.domainDnsIps = builder.domainDnsIps;
            this.domainFqdn = builder.domainFqdn;
            this.domainIamRoleName = builder.domainIamRoleName;
            this.domainOu = builder.domainOu;
            this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
            this.enableIamDatabaseAuthentication = builder.enableIamDatabaseAuthentication;
            this.enablePerformanceInsights = builder.enablePerformanceInsights;
            this.engine = builder.engine;
            this.engineLifecycleSupport = builder.engineLifecycleSupport;
            this.engineVersion = builder.engineVersion;
            this.iops = builder.iops;
            this.kmsKeyId = builder.kmsKeyId;
            this.licenseModel = builder.licenseModel;
            this.manageMasterUserPassword = builder.manageMasterUserPassword;
            this.masterUsername = builder.masterUsername;
            this.masterUserPassword = builder.masterUserPassword;
            this.masterUserSecret = builder.masterUserSecret;
            this.maxAllocatedStorage = builder.maxAllocatedStorage;
            this.monitoringInterval = builder.monitoringInterval;
            this.monitoringRoleArn = builder.monitoringRoleArn;
            this.multiAz = builder.multiAz;
            this.ncharCharacterSetName = builder.ncharCharacterSetName;
            this.networkType = builder.networkType;
            this.optionGroupName = builder.optionGroupName;
            this.performanceInsightsKmsKeyId = builder.performanceInsightsKmsKeyId;
            this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
            this.port = builder.port;
            this.preferredBackupWindow = builder.preferredBackupWindow;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.processorFeatures = builder.processorFeatures;
            this.promotionTier = builder.promotionTier;
            this.publiclyAccessible = builder.publiclyAccessible;
            this.replicaMode = builder.replicaMode;
            this.restoreTime = builder.restoreTime;
            this.sourceDbClusterIdentifier = builder.sourceDbClusterIdentifier;
            this.sourceDbInstanceAutomatedBackupsArn = builder.sourceDbInstanceAutomatedBackupsArn;
            this.sourceDbInstanceIdentifier = builder.sourceDbInstanceIdentifier;
            this.sourceDbiResourceId = builder.sourceDbiResourceId;
            this.sourceRegion = builder.sourceRegion;
            this.storageEncrypted = builder.storageEncrypted;
            this.storageThroughput = builder.storageThroughput;
            this.storageType = builder.storageType;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.tdeCredentialArn = builder.tdeCredentialArn;
            this.tdeCredentialPassword = builder.tdeCredentialPassword;
            this.timezone = builder.timezone;
            this.useDefaultProcessorFeatures = builder.useDefaultProcessorFeatures;
            this.useLatestRestorableTime = builder.useLatestRestorableTime;
            this.vpcSecurityGroups = builder.vpcSecurityGroups;
        }

        @Override
        public final java.lang.String getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final java.lang.Object getAllowMajorVersionUpgrade() {
            return this.allowMajorVersionUpgrade;
        }

        @Override
        public final java.lang.Object getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final java.lang.Object getAssociatedRoles() {
            return this.associatedRoles;
        }

        @Override
        public final java.lang.String getAutomaticBackupReplicationKmsKeyId() {
            return this.automaticBackupReplicationKmsKeyId;
        }

        @Override
        public final java.lang.String getAutomaticBackupReplicationRegion() {
            return this.automaticBackupReplicationRegion;
        }

        @Override
        public final java.lang.Number getAutomaticBackupReplicationRetentionPeriod() {
            return this.automaticBackupReplicationRetentionPeriod;
        }

        @Override
        public final java.lang.Object getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Number getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final java.lang.String getBackupTarget() {
            return this.backupTarget;
        }

        @Override
        public final java.lang.String getCaCertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        @Override
        public final java.lang.Object getCertificateRotationRestart() {
            return this.certificateRotationRestart;
        }

        @Override
        public final java.lang.String getCharacterSetName() {
            return this.characterSetName;
        }

        @Override
        public final java.lang.Object getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final java.lang.String getCustomIamInstanceProfile() {
            return this.customIamInstanceProfile;
        }

        @Override
        public final java.lang.String getDatabaseInsightsMode() {
            return this.databaseInsightsMode;
        }

        @Override
        public final java.lang.String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final java.lang.String getDbClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        @Override
        public final java.lang.String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final java.lang.String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final java.lang.String getDbName() {
            return this.dbName;
        }

        @Override
        public final java.lang.String getDbParameterGroupName() {
            return this.dbParameterGroupName;
        }

        @Override
        public final java.util.List<java.lang.String> getDbSecurityGroups() {
            return this.dbSecurityGroups;
        }

        @Override
        public final java.lang.String getDbSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final java.lang.String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final java.lang.String getDbSystemId() {
            return this.dbSystemId;
        }

        @Override
        public final java.lang.Object getDedicatedLogVolume() {
            return this.dedicatedLogVolume;
        }

        @Override
        public final java.lang.Object getDeleteAutomatedBackups() {
            return this.deleteAutomatedBackups;
        }

        @Override
        public final java.lang.Object getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.String getDomainAuthSecretArn() {
            return this.domainAuthSecretArn;
        }

        @Override
        public final java.util.List<java.lang.String> getDomainDnsIps() {
            return this.domainDnsIps;
        }

        @Override
        public final java.lang.String getDomainFqdn() {
            return this.domainFqdn;
        }

        @Override
        public final java.lang.String getDomainIamRoleName() {
            return this.domainIamRoleName;
        }

        @Override
        public final java.lang.String getDomainOu() {
            return this.domainOu;
        }

        @Override
        public final java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
            return this.enableCloudwatchLogsExports;
        }

        @Override
        public final java.lang.Object getEnableIamDatabaseAuthentication() {
            return this.enableIamDatabaseAuthentication;
        }

        @Override
        public final java.lang.Object getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getEngineLifecycleSupport() {
            return this.engineLifecycleSupport;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.Number getIops() {
            return this.iops;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final java.lang.Object getManageMasterUserPassword() {
            return this.manageMasterUserPassword;
        }

        @Override
        public final java.lang.String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final java.lang.String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final java.lang.Object getMasterUserSecret() {
            return this.masterUserSecret;
        }

        @Override
        public final java.lang.Number getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        @Override
        public final java.lang.Number getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final java.lang.String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        @Override
        public final java.lang.Object getMultiAz() {
            return this.multiAz;
        }

        @Override
        public final java.lang.String getNcharCharacterSetName() {
            return this.ncharCharacterSetName;
        }

        @Override
        public final java.lang.String getNetworkType() {
            return this.networkType;
        }

        @Override
        public final java.lang.String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final java.lang.String getPerformanceInsightsKmsKeyId() {
            return this.performanceInsightsKmsKeyId;
        }

        @Override
        public final java.lang.Number getPerformanceInsightsRetentionPeriod() {
            return this.performanceInsightsRetentionPeriod;
        }

        @Override
        public final java.lang.String getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.lang.Object getProcessorFeatures() {
            return this.processorFeatures;
        }

        @Override
        public final java.lang.Number getPromotionTier() {
            return this.promotionTier;
        }

        @Override
        public final java.lang.Object getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final java.lang.String getReplicaMode() {
            return this.replicaMode;
        }

        @Override
        public final java.lang.String getRestoreTime() {
            return this.restoreTime;
        }

        @Override
        public final java.lang.String getSourceDbClusterIdentifier() {
            return this.sourceDbClusterIdentifier;
        }

        @Override
        public final java.lang.String getSourceDbInstanceAutomatedBackupsArn() {
            return this.sourceDbInstanceAutomatedBackupsArn;
        }

        @Override
        public final java.lang.String getSourceDbInstanceIdentifier() {
            return this.sourceDbInstanceIdentifier;
        }

        @Override
        public final java.lang.String getSourceDbiResourceId() {
            return this.sourceDbiResourceId;
        }

        @Override
        public final java.lang.String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final java.lang.Object getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final java.lang.Number getStorageThroughput() {
            return this.storageThroughput;
        }

        @Override
        public final java.lang.String getStorageType() {
            return this.storageType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        @Override
        public final java.lang.String getTdeCredentialPassword() {
            return this.tdeCredentialPassword;
        }

        @Override
        public final java.lang.String getTimezone() {
            return this.timezone;
        }

        @Override
        public final java.lang.Object getUseDefaultProcessorFeatures() {
            return this.useDefaultProcessorFeatures;
        }

        @Override
        public final java.lang.Object getUseLatestRestorableTime() {
            return this.useLatestRestorableTime;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSecurityGroups() {
            return this.vpcSecurityGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllocatedStorage() != null) {
                data.set("allocatedStorage", om.valueToTree(this.getAllocatedStorage()));
            }
            if (this.getAllowMajorVersionUpgrade() != null) {
                data.set("allowMajorVersionUpgrade", om.valueToTree(this.getAllowMajorVersionUpgrade()));
            }
            if (this.getApplyImmediately() != null) {
                data.set("applyImmediately", om.valueToTree(this.getApplyImmediately()));
            }
            if (this.getAssociatedRoles() != null) {
                data.set("associatedRoles", om.valueToTree(this.getAssociatedRoles()));
            }
            if (this.getAutomaticBackupReplicationKmsKeyId() != null) {
                data.set("automaticBackupReplicationKmsKeyId", om.valueToTree(this.getAutomaticBackupReplicationKmsKeyId()));
            }
            if (this.getAutomaticBackupReplicationRegion() != null) {
                data.set("automaticBackupReplicationRegion", om.valueToTree(this.getAutomaticBackupReplicationRegion()));
            }
            if (this.getAutomaticBackupReplicationRetentionPeriod() != null) {
                data.set("automaticBackupReplicationRetentionPeriod", om.valueToTree(this.getAutomaticBackupReplicationRetentionPeriod()));
            }
            if (this.getAutoMinorVersionUpgrade() != null) {
                data.set("autoMinorVersionUpgrade", om.valueToTree(this.getAutoMinorVersionUpgrade()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getBackupRetentionPeriod() != null) {
                data.set("backupRetentionPeriod", om.valueToTree(this.getBackupRetentionPeriod()));
            }
            if (this.getBackupTarget() != null) {
                data.set("backupTarget", om.valueToTree(this.getBackupTarget()));
            }
            if (this.getCaCertificateIdentifier() != null) {
                data.set("caCertificateIdentifier", om.valueToTree(this.getCaCertificateIdentifier()));
            }
            if (this.getCertificateRotationRestart() != null) {
                data.set("certificateRotationRestart", om.valueToTree(this.getCertificateRotationRestart()));
            }
            if (this.getCharacterSetName() != null) {
                data.set("characterSetName", om.valueToTree(this.getCharacterSetName()));
            }
            if (this.getCopyTagsToSnapshot() != null) {
                data.set("copyTagsToSnapshot", om.valueToTree(this.getCopyTagsToSnapshot()));
            }
            if (this.getCustomIamInstanceProfile() != null) {
                data.set("customIamInstanceProfile", om.valueToTree(this.getCustomIamInstanceProfile()));
            }
            if (this.getDatabaseInsightsMode() != null) {
                data.set("databaseInsightsMode", om.valueToTree(this.getDatabaseInsightsMode()));
            }
            if (this.getDbClusterIdentifier() != null) {
                data.set("dbClusterIdentifier", om.valueToTree(this.getDbClusterIdentifier()));
            }
            if (this.getDbClusterSnapshotIdentifier() != null) {
                data.set("dbClusterSnapshotIdentifier", om.valueToTree(this.getDbClusterSnapshotIdentifier()));
            }
            if (this.getDbInstanceClass() != null) {
                data.set("dbInstanceClass", om.valueToTree(this.getDbInstanceClass()));
            }
            if (this.getDbInstanceIdentifier() != null) {
                data.set("dbInstanceIdentifier", om.valueToTree(this.getDbInstanceIdentifier()));
            }
            if (this.getDbName() != null) {
                data.set("dbName", om.valueToTree(this.getDbName()));
            }
            if (this.getDbParameterGroupName() != null) {
                data.set("dbParameterGroupName", om.valueToTree(this.getDbParameterGroupName()));
            }
            if (this.getDbSecurityGroups() != null) {
                data.set("dbSecurityGroups", om.valueToTree(this.getDbSecurityGroups()));
            }
            if (this.getDbSnapshotIdentifier() != null) {
                data.set("dbSnapshotIdentifier", om.valueToTree(this.getDbSnapshotIdentifier()));
            }
            if (this.getDbSubnetGroupName() != null) {
                data.set("dbSubnetGroupName", om.valueToTree(this.getDbSubnetGroupName()));
            }
            if (this.getDbSystemId() != null) {
                data.set("dbSystemId", om.valueToTree(this.getDbSystemId()));
            }
            if (this.getDedicatedLogVolume() != null) {
                data.set("dedicatedLogVolume", om.valueToTree(this.getDedicatedLogVolume()));
            }
            if (this.getDeleteAutomatedBackups() != null) {
                data.set("deleteAutomatedBackups", om.valueToTree(this.getDeleteAutomatedBackups()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getDomainAuthSecretArn() != null) {
                data.set("domainAuthSecretArn", om.valueToTree(this.getDomainAuthSecretArn()));
            }
            if (this.getDomainDnsIps() != null) {
                data.set("domainDnsIps", om.valueToTree(this.getDomainDnsIps()));
            }
            if (this.getDomainFqdn() != null) {
                data.set("domainFqdn", om.valueToTree(this.getDomainFqdn()));
            }
            if (this.getDomainIamRoleName() != null) {
                data.set("domainIamRoleName", om.valueToTree(this.getDomainIamRoleName()));
            }
            if (this.getDomainOu() != null) {
                data.set("domainOu", om.valueToTree(this.getDomainOu()));
            }
            if (this.getEnableCloudwatchLogsExports() != null) {
                data.set("enableCloudwatchLogsExports", om.valueToTree(this.getEnableCloudwatchLogsExports()));
            }
            if (this.getEnableIamDatabaseAuthentication() != null) {
                data.set("enableIamDatabaseAuthentication", om.valueToTree(this.getEnableIamDatabaseAuthentication()));
            }
            if (this.getEnablePerformanceInsights() != null) {
                data.set("enablePerformanceInsights", om.valueToTree(this.getEnablePerformanceInsights()));
            }
            if (this.getEngine() != null) {
                data.set("engine", om.valueToTree(this.getEngine()));
            }
            if (this.getEngineLifecycleSupport() != null) {
                data.set("engineLifecycleSupport", om.valueToTree(this.getEngineLifecycleSupport()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getIops() != null) {
                data.set("iops", om.valueToTree(this.getIops()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLicenseModel() != null) {
                data.set("licenseModel", om.valueToTree(this.getLicenseModel()));
            }
            if (this.getManageMasterUserPassword() != null) {
                data.set("manageMasterUserPassword", om.valueToTree(this.getManageMasterUserPassword()));
            }
            if (this.getMasterUsername() != null) {
                data.set("masterUsername", om.valueToTree(this.getMasterUsername()));
            }
            if (this.getMasterUserPassword() != null) {
                data.set("masterUserPassword", om.valueToTree(this.getMasterUserPassword()));
            }
            if (this.getMasterUserSecret() != null) {
                data.set("masterUserSecret", om.valueToTree(this.getMasterUserSecret()));
            }
            if (this.getMaxAllocatedStorage() != null) {
                data.set("maxAllocatedStorage", om.valueToTree(this.getMaxAllocatedStorage()));
            }
            if (this.getMonitoringInterval() != null) {
                data.set("monitoringInterval", om.valueToTree(this.getMonitoringInterval()));
            }
            if (this.getMonitoringRoleArn() != null) {
                data.set("monitoringRoleArn", om.valueToTree(this.getMonitoringRoleArn()));
            }
            if (this.getMultiAz() != null) {
                data.set("multiAz", om.valueToTree(this.getMultiAz()));
            }
            if (this.getNcharCharacterSetName() != null) {
                data.set("ncharCharacterSetName", om.valueToTree(this.getNcharCharacterSetName()));
            }
            if (this.getNetworkType() != null) {
                data.set("networkType", om.valueToTree(this.getNetworkType()));
            }
            if (this.getOptionGroupName() != null) {
                data.set("optionGroupName", om.valueToTree(this.getOptionGroupName()));
            }
            if (this.getPerformanceInsightsKmsKeyId() != null) {
                data.set("performanceInsightsKmsKeyId", om.valueToTree(this.getPerformanceInsightsKmsKeyId()));
            }
            if (this.getPerformanceInsightsRetentionPeriod() != null) {
                data.set("performanceInsightsRetentionPeriod", om.valueToTree(this.getPerformanceInsightsRetentionPeriod()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredBackupWindow() != null) {
                data.set("preferredBackupWindow", om.valueToTree(this.getPreferredBackupWindow()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getProcessorFeatures() != null) {
                data.set("processorFeatures", om.valueToTree(this.getProcessorFeatures()));
            }
            if (this.getPromotionTier() != null) {
                data.set("promotionTier", om.valueToTree(this.getPromotionTier()));
            }
            if (this.getPubliclyAccessible() != null) {
                data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            }
            if (this.getReplicaMode() != null) {
                data.set("replicaMode", om.valueToTree(this.getReplicaMode()));
            }
            if (this.getRestoreTime() != null) {
                data.set("restoreTime", om.valueToTree(this.getRestoreTime()));
            }
            if (this.getSourceDbClusterIdentifier() != null) {
                data.set("sourceDbClusterIdentifier", om.valueToTree(this.getSourceDbClusterIdentifier()));
            }
            if (this.getSourceDbInstanceAutomatedBackupsArn() != null) {
                data.set("sourceDbInstanceAutomatedBackupsArn", om.valueToTree(this.getSourceDbInstanceAutomatedBackupsArn()));
            }
            if (this.getSourceDbInstanceIdentifier() != null) {
                data.set("sourceDbInstanceIdentifier", om.valueToTree(this.getSourceDbInstanceIdentifier()));
            }
            if (this.getSourceDbiResourceId() != null) {
                data.set("sourceDbiResourceId", om.valueToTree(this.getSourceDbiResourceId()));
            }
            if (this.getSourceRegion() != null) {
                data.set("sourceRegion", om.valueToTree(this.getSourceRegion()));
            }
            if (this.getStorageEncrypted() != null) {
                data.set("storageEncrypted", om.valueToTree(this.getStorageEncrypted()));
            }
            if (this.getStorageThroughput() != null) {
                data.set("storageThroughput", om.valueToTree(this.getStorageThroughput()));
            }
            if (this.getStorageType() != null) {
                data.set("storageType", om.valueToTree(this.getStorageType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTdeCredentialArn() != null) {
                data.set("tdeCredentialArn", om.valueToTree(this.getTdeCredentialArn()));
            }
            if (this.getTdeCredentialPassword() != null) {
                data.set("tdeCredentialPassword", om.valueToTree(this.getTdeCredentialPassword()));
            }
            if (this.getTimezone() != null) {
                data.set("timezone", om.valueToTree(this.getTimezone()));
            }
            if (this.getUseDefaultProcessorFeatures() != null) {
                data.set("useDefaultProcessorFeatures", om.valueToTree(this.getUseDefaultProcessorFeatures()));
            }
            if (this.getUseLatestRestorableTime() != null) {
                data.set("useLatestRestorableTime", om.valueToTree(this.getUseLatestRestorableTime()));
            }
            if (this.getVpcSecurityGroups() != null) {
                data.set("vpcSecurityGroups", om.valueToTree(this.getVpcSecurityGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDBInstanceProps.Jsii$Proxy that = (CfnDBInstanceProps.Jsii$Proxy) o;

            if (this.allocatedStorage != null ? !this.allocatedStorage.equals(that.allocatedStorage) : that.allocatedStorage != null) return false;
            if (this.allowMajorVersionUpgrade != null ? !this.allowMajorVersionUpgrade.equals(that.allowMajorVersionUpgrade) : that.allowMajorVersionUpgrade != null) return false;
            if (this.applyImmediately != null ? !this.applyImmediately.equals(that.applyImmediately) : that.applyImmediately != null) return false;
            if (this.associatedRoles != null ? !this.associatedRoles.equals(that.associatedRoles) : that.associatedRoles != null) return false;
            if (this.automaticBackupReplicationKmsKeyId != null ? !this.automaticBackupReplicationKmsKeyId.equals(that.automaticBackupReplicationKmsKeyId) : that.automaticBackupReplicationKmsKeyId != null) return false;
            if (this.automaticBackupReplicationRegion != null ? !this.automaticBackupReplicationRegion.equals(that.automaticBackupReplicationRegion) : that.automaticBackupReplicationRegion != null) return false;
            if (this.automaticBackupReplicationRetentionPeriod != null ? !this.automaticBackupReplicationRetentionPeriod.equals(that.automaticBackupReplicationRetentionPeriod) : that.automaticBackupReplicationRetentionPeriod != null) return false;
            if (this.autoMinorVersionUpgrade != null ? !this.autoMinorVersionUpgrade.equals(that.autoMinorVersionUpgrade) : that.autoMinorVersionUpgrade != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.backupRetentionPeriod != null ? !this.backupRetentionPeriod.equals(that.backupRetentionPeriod) : that.backupRetentionPeriod != null) return false;
            if (this.backupTarget != null ? !this.backupTarget.equals(that.backupTarget) : that.backupTarget != null) return false;
            if (this.caCertificateIdentifier != null ? !this.caCertificateIdentifier.equals(that.caCertificateIdentifier) : that.caCertificateIdentifier != null) return false;
            if (this.certificateRotationRestart != null ? !this.certificateRotationRestart.equals(that.certificateRotationRestart) : that.certificateRotationRestart != null) return false;
            if (this.characterSetName != null ? !this.characterSetName.equals(that.characterSetName) : that.characterSetName != null) return false;
            if (this.copyTagsToSnapshot != null ? !this.copyTagsToSnapshot.equals(that.copyTagsToSnapshot) : that.copyTagsToSnapshot != null) return false;
            if (this.customIamInstanceProfile != null ? !this.customIamInstanceProfile.equals(that.customIamInstanceProfile) : that.customIamInstanceProfile != null) return false;
            if (this.databaseInsightsMode != null ? !this.databaseInsightsMode.equals(that.databaseInsightsMode) : that.databaseInsightsMode != null) return false;
            if (this.dbClusterIdentifier != null ? !this.dbClusterIdentifier.equals(that.dbClusterIdentifier) : that.dbClusterIdentifier != null) return false;
            if (this.dbClusterSnapshotIdentifier != null ? !this.dbClusterSnapshotIdentifier.equals(that.dbClusterSnapshotIdentifier) : that.dbClusterSnapshotIdentifier != null) return false;
            if (this.dbInstanceClass != null ? !this.dbInstanceClass.equals(that.dbInstanceClass) : that.dbInstanceClass != null) return false;
            if (this.dbInstanceIdentifier != null ? !this.dbInstanceIdentifier.equals(that.dbInstanceIdentifier) : that.dbInstanceIdentifier != null) return false;
            if (this.dbName != null ? !this.dbName.equals(that.dbName) : that.dbName != null) return false;
            if (this.dbParameterGroupName != null ? !this.dbParameterGroupName.equals(that.dbParameterGroupName) : that.dbParameterGroupName != null) return false;
            if (this.dbSecurityGroups != null ? !this.dbSecurityGroups.equals(that.dbSecurityGroups) : that.dbSecurityGroups != null) return false;
            if (this.dbSnapshotIdentifier != null ? !this.dbSnapshotIdentifier.equals(that.dbSnapshotIdentifier) : that.dbSnapshotIdentifier != null) return false;
            if (this.dbSubnetGroupName != null ? !this.dbSubnetGroupName.equals(that.dbSubnetGroupName) : that.dbSubnetGroupName != null) return false;
            if (this.dbSystemId != null ? !this.dbSystemId.equals(that.dbSystemId) : that.dbSystemId != null) return false;
            if (this.dedicatedLogVolume != null ? !this.dedicatedLogVolume.equals(that.dedicatedLogVolume) : that.dedicatedLogVolume != null) return false;
            if (this.deleteAutomatedBackups != null ? !this.deleteAutomatedBackups.equals(that.deleteAutomatedBackups) : that.deleteAutomatedBackups != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.domainAuthSecretArn != null ? !this.domainAuthSecretArn.equals(that.domainAuthSecretArn) : that.domainAuthSecretArn != null) return false;
            if (this.domainDnsIps != null ? !this.domainDnsIps.equals(that.domainDnsIps) : that.domainDnsIps != null) return false;
            if (this.domainFqdn != null ? !this.domainFqdn.equals(that.domainFqdn) : that.domainFqdn != null) return false;
            if (this.domainIamRoleName != null ? !this.domainIamRoleName.equals(that.domainIamRoleName) : that.domainIamRoleName != null) return false;
            if (this.domainOu != null ? !this.domainOu.equals(that.domainOu) : that.domainOu != null) return false;
            if (this.enableCloudwatchLogsExports != null ? !this.enableCloudwatchLogsExports.equals(that.enableCloudwatchLogsExports) : that.enableCloudwatchLogsExports != null) return false;
            if (this.enableIamDatabaseAuthentication != null ? !this.enableIamDatabaseAuthentication.equals(that.enableIamDatabaseAuthentication) : that.enableIamDatabaseAuthentication != null) return false;
            if (this.enablePerformanceInsights != null ? !this.enablePerformanceInsights.equals(that.enablePerformanceInsights) : that.enablePerformanceInsights != null) return false;
            if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) return false;
            if (this.engineLifecycleSupport != null ? !this.engineLifecycleSupport.equals(that.engineLifecycleSupport) : that.engineLifecycleSupport != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.licenseModel != null ? !this.licenseModel.equals(that.licenseModel) : that.licenseModel != null) return false;
            if (this.manageMasterUserPassword != null ? !this.manageMasterUserPassword.equals(that.manageMasterUserPassword) : that.manageMasterUserPassword != null) return false;
            if (this.masterUsername != null ? !this.masterUsername.equals(that.masterUsername) : that.masterUsername != null) return false;
            if (this.masterUserPassword != null ? !this.masterUserPassword.equals(that.masterUserPassword) : that.masterUserPassword != null) return false;
            if (this.masterUserSecret != null ? !this.masterUserSecret.equals(that.masterUserSecret) : that.masterUserSecret != null) return false;
            if (this.maxAllocatedStorage != null ? !this.maxAllocatedStorage.equals(that.maxAllocatedStorage) : that.maxAllocatedStorage != null) return false;
            if (this.monitoringInterval != null ? !this.monitoringInterval.equals(that.monitoringInterval) : that.monitoringInterval != null) return false;
            if (this.monitoringRoleArn != null ? !this.monitoringRoleArn.equals(that.monitoringRoleArn) : that.monitoringRoleArn != null) return false;
            if (this.multiAz != null ? !this.multiAz.equals(that.multiAz) : that.multiAz != null) return false;
            if (this.ncharCharacterSetName != null ? !this.ncharCharacterSetName.equals(that.ncharCharacterSetName) : that.ncharCharacterSetName != null) return false;
            if (this.networkType != null ? !this.networkType.equals(that.networkType) : that.networkType != null) return false;
            if (this.optionGroupName != null ? !this.optionGroupName.equals(that.optionGroupName) : that.optionGroupName != null) return false;
            if (this.performanceInsightsKmsKeyId != null ? !this.performanceInsightsKmsKeyId.equals(that.performanceInsightsKmsKeyId) : that.performanceInsightsKmsKeyId != null) return false;
            if (this.performanceInsightsRetentionPeriod != null ? !this.performanceInsightsRetentionPeriod.equals(that.performanceInsightsRetentionPeriod) : that.performanceInsightsRetentionPeriod != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredBackupWindow != null ? !this.preferredBackupWindow.equals(that.preferredBackupWindow) : that.preferredBackupWindow != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.processorFeatures != null ? !this.processorFeatures.equals(that.processorFeatures) : that.processorFeatures != null) return false;
            if (this.promotionTier != null ? !this.promotionTier.equals(that.promotionTier) : that.promotionTier != null) return false;
            if (this.publiclyAccessible != null ? !this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible != null) return false;
            if (this.replicaMode != null ? !this.replicaMode.equals(that.replicaMode) : that.replicaMode != null) return false;
            if (this.restoreTime != null ? !this.restoreTime.equals(that.restoreTime) : that.restoreTime != null) return false;
            if (this.sourceDbClusterIdentifier != null ? !this.sourceDbClusterIdentifier.equals(that.sourceDbClusterIdentifier) : that.sourceDbClusterIdentifier != null) return false;
            if (this.sourceDbInstanceAutomatedBackupsArn != null ? !this.sourceDbInstanceAutomatedBackupsArn.equals(that.sourceDbInstanceAutomatedBackupsArn) : that.sourceDbInstanceAutomatedBackupsArn != null) return false;
            if (this.sourceDbInstanceIdentifier != null ? !this.sourceDbInstanceIdentifier.equals(that.sourceDbInstanceIdentifier) : that.sourceDbInstanceIdentifier != null) return false;
            if (this.sourceDbiResourceId != null ? !this.sourceDbiResourceId.equals(that.sourceDbiResourceId) : that.sourceDbiResourceId != null) return false;
            if (this.sourceRegion != null ? !this.sourceRegion.equals(that.sourceRegion) : that.sourceRegion != null) return false;
            if (this.storageEncrypted != null ? !this.storageEncrypted.equals(that.storageEncrypted) : that.storageEncrypted != null) return false;
            if (this.storageThroughput != null ? !this.storageThroughput.equals(that.storageThroughput) : that.storageThroughput != null) return false;
            if (this.storageType != null ? !this.storageType.equals(that.storageType) : that.storageType != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.tdeCredentialArn != null ? !this.tdeCredentialArn.equals(that.tdeCredentialArn) : that.tdeCredentialArn != null) return false;
            if (this.tdeCredentialPassword != null ? !this.tdeCredentialPassword.equals(that.tdeCredentialPassword) : that.tdeCredentialPassword != null) return false;
            if (this.timezone != null ? !this.timezone.equals(that.timezone) : that.timezone != null) return false;
            if (this.useDefaultProcessorFeatures != null ? !this.useDefaultProcessorFeatures.equals(that.useDefaultProcessorFeatures) : that.useDefaultProcessorFeatures != null) return false;
            if (this.useLatestRestorableTime != null ? !this.useLatestRestorableTime.equals(that.useLatestRestorableTime) : that.useLatestRestorableTime != null) return false;
            return this.vpcSecurityGroups != null ? this.vpcSecurityGroups.equals(that.vpcSecurityGroups) : that.vpcSecurityGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allocatedStorage != null ? this.allocatedStorage.hashCode() : 0;
            result = 31 * result + (this.allowMajorVersionUpgrade != null ? this.allowMajorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.applyImmediately != null ? this.applyImmediately.hashCode() : 0);
            result = 31 * result + (this.associatedRoles != null ? this.associatedRoles.hashCode() : 0);
            result = 31 * result + (this.automaticBackupReplicationKmsKeyId != null ? this.automaticBackupReplicationKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.automaticBackupReplicationRegion != null ? this.automaticBackupReplicationRegion.hashCode() : 0);
            result = 31 * result + (this.automaticBackupReplicationRetentionPeriod != null ? this.automaticBackupReplicationRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.autoMinorVersionUpgrade != null ? this.autoMinorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.backupRetentionPeriod != null ? this.backupRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.backupTarget != null ? this.backupTarget.hashCode() : 0);
            result = 31 * result + (this.caCertificateIdentifier != null ? this.caCertificateIdentifier.hashCode() : 0);
            result = 31 * result + (this.certificateRotationRestart != null ? this.certificateRotationRestart.hashCode() : 0);
            result = 31 * result + (this.characterSetName != null ? this.characterSetName.hashCode() : 0);
            result = 31 * result + (this.copyTagsToSnapshot != null ? this.copyTagsToSnapshot.hashCode() : 0);
            result = 31 * result + (this.customIamInstanceProfile != null ? this.customIamInstanceProfile.hashCode() : 0);
            result = 31 * result + (this.databaseInsightsMode != null ? this.databaseInsightsMode.hashCode() : 0);
            result = 31 * result + (this.dbClusterIdentifier != null ? this.dbClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.dbClusterSnapshotIdentifier != null ? this.dbClusterSnapshotIdentifier.hashCode() : 0);
            result = 31 * result + (this.dbInstanceClass != null ? this.dbInstanceClass.hashCode() : 0);
            result = 31 * result + (this.dbInstanceIdentifier != null ? this.dbInstanceIdentifier.hashCode() : 0);
            result = 31 * result + (this.dbName != null ? this.dbName.hashCode() : 0);
            result = 31 * result + (this.dbParameterGroupName != null ? this.dbParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.dbSecurityGroups != null ? this.dbSecurityGroups.hashCode() : 0);
            result = 31 * result + (this.dbSnapshotIdentifier != null ? this.dbSnapshotIdentifier.hashCode() : 0);
            result = 31 * result + (this.dbSubnetGroupName != null ? this.dbSubnetGroupName.hashCode() : 0);
            result = 31 * result + (this.dbSystemId != null ? this.dbSystemId.hashCode() : 0);
            result = 31 * result + (this.dedicatedLogVolume != null ? this.dedicatedLogVolume.hashCode() : 0);
            result = 31 * result + (this.deleteAutomatedBackups != null ? this.deleteAutomatedBackups.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.domainAuthSecretArn != null ? this.domainAuthSecretArn.hashCode() : 0);
            result = 31 * result + (this.domainDnsIps != null ? this.domainDnsIps.hashCode() : 0);
            result = 31 * result + (this.domainFqdn != null ? this.domainFqdn.hashCode() : 0);
            result = 31 * result + (this.domainIamRoleName != null ? this.domainIamRoleName.hashCode() : 0);
            result = 31 * result + (this.domainOu != null ? this.domainOu.hashCode() : 0);
            result = 31 * result + (this.enableCloudwatchLogsExports != null ? this.enableCloudwatchLogsExports.hashCode() : 0);
            result = 31 * result + (this.enableIamDatabaseAuthentication != null ? this.enableIamDatabaseAuthentication.hashCode() : 0);
            result = 31 * result + (this.enablePerformanceInsights != null ? this.enablePerformanceInsights.hashCode() : 0);
            result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
            result = 31 * result + (this.engineLifecycleSupport != null ? this.engineLifecycleSupport.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.licenseModel != null ? this.licenseModel.hashCode() : 0);
            result = 31 * result + (this.manageMasterUserPassword != null ? this.manageMasterUserPassword.hashCode() : 0);
            result = 31 * result + (this.masterUsername != null ? this.masterUsername.hashCode() : 0);
            result = 31 * result + (this.masterUserPassword != null ? this.masterUserPassword.hashCode() : 0);
            result = 31 * result + (this.masterUserSecret != null ? this.masterUserSecret.hashCode() : 0);
            result = 31 * result + (this.maxAllocatedStorage != null ? this.maxAllocatedStorage.hashCode() : 0);
            result = 31 * result + (this.monitoringInterval != null ? this.monitoringInterval.hashCode() : 0);
            result = 31 * result + (this.monitoringRoleArn != null ? this.monitoringRoleArn.hashCode() : 0);
            result = 31 * result + (this.multiAz != null ? this.multiAz.hashCode() : 0);
            result = 31 * result + (this.ncharCharacterSetName != null ? this.ncharCharacterSetName.hashCode() : 0);
            result = 31 * result + (this.networkType != null ? this.networkType.hashCode() : 0);
            result = 31 * result + (this.optionGroupName != null ? this.optionGroupName.hashCode() : 0);
            result = 31 * result + (this.performanceInsightsKmsKeyId != null ? this.performanceInsightsKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.performanceInsightsRetentionPeriod != null ? this.performanceInsightsRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredBackupWindow != null ? this.preferredBackupWindow.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.processorFeatures != null ? this.processorFeatures.hashCode() : 0);
            result = 31 * result + (this.promotionTier != null ? this.promotionTier.hashCode() : 0);
            result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
            result = 31 * result + (this.replicaMode != null ? this.replicaMode.hashCode() : 0);
            result = 31 * result + (this.restoreTime != null ? this.restoreTime.hashCode() : 0);
            result = 31 * result + (this.sourceDbClusterIdentifier != null ? this.sourceDbClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.sourceDbInstanceAutomatedBackupsArn != null ? this.sourceDbInstanceAutomatedBackupsArn.hashCode() : 0);
            result = 31 * result + (this.sourceDbInstanceIdentifier != null ? this.sourceDbInstanceIdentifier.hashCode() : 0);
            result = 31 * result + (this.sourceDbiResourceId != null ? this.sourceDbiResourceId.hashCode() : 0);
            result = 31 * result + (this.sourceRegion != null ? this.sourceRegion.hashCode() : 0);
            result = 31 * result + (this.storageEncrypted != null ? this.storageEncrypted.hashCode() : 0);
            result = 31 * result + (this.storageThroughput != null ? this.storageThroughput.hashCode() : 0);
            result = 31 * result + (this.storageType != null ? this.storageType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tdeCredentialArn != null ? this.tdeCredentialArn.hashCode() : 0);
            result = 31 * result + (this.tdeCredentialPassword != null ? this.tdeCredentialPassword.hashCode() : 0);
            result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
            result = 31 * result + (this.useDefaultProcessorFeatures != null ? this.useDefaultProcessorFeatures.hashCode() : 0);
            result = 31 * result + (this.useLatestRestorableTime != null ? this.useLatestRestorableTime.hashCode() : 0);
            result = 31 * result + (this.vpcSecurityGroups != null ? this.vpcSecurityGroups.hashCode() : 0);
            return result;
        }
    }
}
