package software.amazon.awscdk.services.rds;

/**
 * Engine lifecycle support for Amazon RDS and Amazon Aurora.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * DatabaseCluster.Builder.create(this, "DatabaseCluster")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder().version(AuroraMysqlEngineVersion.VER_3_07_0).build()))
 *         .writer(ClusterInstance.serverlessV2("writerInstance"))
 *         .vpc(vpc)
 *         .engineLifecycleSupport(EngineLifecycleSupport.OPEN_SOURCE_RDS_EXTENDED_SUPPORT)
 *         .build();
 * DatabaseInstance.Builder.create(this, "DatabaseInstance")
 *         .engine(DatabaseInstanceEngine.mysql(MySqlInstanceEngineProps.builder().version(MysqlEngineVersion.VER_8_0_39).build()))
 *         .instanceType(InstanceType.of(InstanceClass.R7G, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .engineLifecycleSupport(EngineLifecycleSupport.OPEN_SOURCE_RDS_EXTENDED_SUPPORT_DISABLED)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:21.705Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.EngineLifecycleSupport")
public enum EngineLifecycleSupport {
    /**
     * Using Amazon RDS extended support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPEN_SOURCE_RDS_EXTENDED_SUPPORT,
    /**
     * Not using Amazon RDS extended support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPEN_SOURCE_RDS_EXTENDED_SUPPORT_DISABLED,
}
