package software.amazon.awscdk.services.rds;

/**
 * Options for creating a serverless v2 instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder().version(AuroraMysqlEngineVersion.VER_3_01_0).build()))
 *         .writer(ClusterInstance.provisioned("writer", ProvisionedClusterInstanceProps.builder()
 *                 .caCertificate(CaCertificate.RDS_CA_RSA2048_G1)
 *                 .build()))
 *         .readers(List.of(ClusterInstance.serverlessV2("reader", ServerlessV2ClusterInstanceProps.builder()
 *                 .caCertificate(CaCertificate.of("custom-ca"))
 *                 .build())))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:21.773Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ServerlessV2ClusterInstanceProps")
@software.amazon.jsii.Jsii.Proxy(ServerlessV2ClusterInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServerlessV2ClusterInstanceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.rds.ClusterInstanceOptions {

    /**
     * Only applicable to reader instances.
     * <p>
     * If this is true then the instance will be placed in promotion tier 1, otherwise
     * it will be placed in promotion tier 2.
     * <p>
     * For serverless v2 instances this means:
     * <p>
     * <ul>
     * <li>true: The serverless v2 reader will scale to match the writer instance (provisioned or serverless)</li>
     * <li>false: The serverless v2 reader will scale with the read workload on the instance</li>
     * </ul>
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getScaleWithWriter() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServerlessV2ClusterInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServerlessV2ClusterInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServerlessV2ClusterInstanceProps> {
        java.lang.Boolean scaleWithWriter;
        java.lang.Boolean allowMajorVersionUpgrade;
        java.lang.Boolean applyImmediately;
        java.lang.Boolean autoMinorVersionUpgrade;
        java.lang.String availabilityZone;
        software.amazon.awscdk.services.rds.CaCertificate caCertificate;
        java.lang.Boolean enablePerformanceInsights;
        java.lang.String instanceIdentifier;
        java.lang.Boolean isFromLegacyInstanceProps;
        software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        java.util.Map<java.lang.String, java.lang.String> parameters;
        software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey;
        software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention;
        java.lang.String preferredMaintenanceWindow;
        java.lang.Boolean publiclyAccessible;

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getScaleWithWriter}
         * @param scaleWithWriter Only applicable to reader instances.
         *                        If this is true then the instance will be placed in promotion tier 1, otherwise
         *                        it will be placed in promotion tier 2.
         *                        <p>
         *                        For serverless v2 instances this means:
         *                        <p>
         *                        <ul>
         *                        <li>true: The serverless v2 reader will scale to match the writer instance (provisioned or serverless)</li>
         *                        <li>false: The serverless v2 reader will scale with the read workload on the instance</li>
         *                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleWithWriter(java.lang.Boolean scaleWithWriter) {
            this.scaleWithWriter = scaleWithWriter;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getAllowMajorVersionUpgrade}
         * @param allowMajorVersionUpgrade Whether to allow upgrade of major version for the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowMajorVersionUpgrade(java.lang.Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getApplyImmediately}
         * @param applyImmediately Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>preferredMaintenanceWindow</code> setting.
         *                         If set to <code>false</code>, changes are applied during the next maintenance window.
         *                         <p>
         *                         Until RDS applies the changes, the DB instance remains in a drift state.
         *                         As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
         *                         <p>
         *                         This property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyImmediately(java.lang.Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade Whether to enable automatic upgrade of minor version for the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(java.lang.Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone (AZ) where the database will be created.
         *                         For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones.
         *                         Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getCaCertificate}
         * @param caCertificate The identifier of the CA certificate for this DB cluster's instances.
         *                      Specifying or updating this property triggers a reboot.
         *                      <p>
         *                      For RDS DB engines:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificate(software.amazon.awscdk.services.rds.CaCertificate caCertificate) {
            this.caCertificate = caCertificate;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getEnablePerformanceInsights}
         * @param enablePerformanceInsights Whether to enable Performance Insights for the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(java.lang.Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getInstanceIdentifier}
         * @param instanceIdentifier The identifier for the database instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifier(java.lang.String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getIsFromLegacyInstanceProps}
         * @param isFromLegacyInstanceProps Only used for migrating existing clusters from using <code>instanceProps</code> to <code>writer</code> and <code>readers</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isFromLegacyInstanceProps(java.lang.Boolean isFromLegacyInstanceProps) {
            this.isFromLegacyInstanceProps = isFromLegacyInstanceProps;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getParameterGroup}
         * @param parameterGroup The DB parameter group to associate with the instance.
         *                       This is only needed if you need to configure different parameter
         *                       groups for each individual instance, otherwise you should not
         *                       provide this and just use the cluster parameter group
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterGroup(software.amazon.awscdk.services.rds.IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getParameters}
         * @param parameters The parameters in the DBParameterGroup to create automatically.
         *                   You can only specify parameterGroup or parameters but not both.
         *                   You need to use a versioned engine to auto-generate a DBParameterGroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getPerformanceInsightEncryptionKey}
         * @param performanceInsightEncryptionKey The AWS KMS key for encryption of Performance Insights data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightEncryptionKey(software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey) {
            this.performanceInsightEncryptionKey = performanceInsightEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getPerformanceInsightRetention}
         * @param performanceInsightRetention The amount of time, in days, to retain Performance Insights data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightRetention(software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention) {
            this.performanceInsightRetention = performanceInsightRetention;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC).
         *                                   Example: 'Sun:23:45-Mon:00:15'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessV2ClusterInstanceProps#getPubliclyAccessible}
         * @param publiclyAccessible Indicates whether the DB instance is an internet-facing instance.
         *                           If not specified,
         *                           the cluster's vpcSubnets will be used to determine if the instance is internet-facing
         *                           or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerlessV2ClusterInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServerlessV2ClusterInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServerlessV2ClusterInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerlessV2ClusterInstanceProps {
        private final java.lang.Boolean scaleWithWriter;
        private final java.lang.Boolean allowMajorVersionUpgrade;
        private final java.lang.Boolean applyImmediately;
        private final java.lang.Boolean autoMinorVersionUpgrade;
        private final java.lang.String availabilityZone;
        private final software.amazon.awscdk.services.rds.CaCertificate caCertificate;
        private final java.lang.Boolean enablePerformanceInsights;
        private final java.lang.String instanceIdentifier;
        private final java.lang.Boolean isFromLegacyInstanceProps;
        private final software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey;
        private final software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.lang.Boolean publiclyAccessible;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scaleWithWriter = software.amazon.jsii.Kernel.get(this, "scaleWithWriter", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.allowMajorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "allowMajorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.applyImmediately = software.amazon.jsii.Kernel.get(this, "applyImmediately", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.autoMinorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.caCertificate = software.amazon.jsii.Kernel.get(this, "caCertificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CaCertificate.class));
            this.enablePerformanceInsights = software.amazon.jsii.Kernel.get(this, "enablePerformanceInsights", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceIdentifier = software.amazon.jsii.Kernel.get(this, "instanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.isFromLegacyInstanceProps = software.amazon.jsii.Kernel.get(this, "isFromLegacyInstanceProps", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.parameterGroup = software.amazon.jsii.Kernel.get(this, "parameterGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IParameterGroup.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.performanceInsightEncryptionKey = software.amazon.jsii.Kernel.get(this, "performanceInsightEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.performanceInsightRetention = software.amazon.jsii.Kernel.get(this, "performanceInsightRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PerformanceInsightRetention.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scaleWithWriter = builder.scaleWithWriter;
            this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
            this.applyImmediately = builder.applyImmediately;
            this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
            this.availabilityZone = builder.availabilityZone;
            this.caCertificate = builder.caCertificate;
            this.enablePerformanceInsights = builder.enablePerformanceInsights;
            this.instanceIdentifier = builder.instanceIdentifier;
            this.isFromLegacyInstanceProps = builder.isFromLegacyInstanceProps;
            this.parameterGroup = builder.parameterGroup;
            this.parameters = builder.parameters;
            this.performanceInsightEncryptionKey = builder.performanceInsightEncryptionKey;
            this.performanceInsightRetention = builder.performanceInsightRetention;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.publiclyAccessible = builder.publiclyAccessible;
        }

        @Override
        public final java.lang.Boolean getScaleWithWriter() {
            return this.scaleWithWriter;
        }

        @Override
        public final java.lang.Boolean getAllowMajorVersionUpgrade() {
            return this.allowMajorVersionUpgrade;
        }

        @Override
        public final java.lang.Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final java.lang.Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final software.amazon.awscdk.services.rds.CaCertificate getCaCertificate() {
            return this.caCertificate;
        }

        @Override
        public final java.lang.Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        @Override
        public final java.lang.String getInstanceIdentifier() {
            return this.instanceIdentifier;
        }

        @Override
        public final java.lang.Boolean getIsFromLegacyInstanceProps() {
            return this.isFromLegacyInstanceProps;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IParameterGroup getParameterGroup() {
            return this.parameterGroup;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getPerformanceInsightEncryptionKey() {
            return this.performanceInsightEncryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.rds.PerformanceInsightRetention getPerformanceInsightRetention() {
            return this.performanceInsightRetention;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.lang.Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getScaleWithWriter() != null) {
                data.set("scaleWithWriter", om.valueToTree(this.getScaleWithWriter()));
            }
            if (this.getAllowMajorVersionUpgrade() != null) {
                data.set("allowMajorVersionUpgrade", om.valueToTree(this.getAllowMajorVersionUpgrade()));
            }
            if (this.getApplyImmediately() != null) {
                data.set("applyImmediately", om.valueToTree(this.getApplyImmediately()));
            }
            if (this.getAutoMinorVersionUpgrade() != null) {
                data.set("autoMinorVersionUpgrade", om.valueToTree(this.getAutoMinorVersionUpgrade()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getCaCertificate() != null) {
                data.set("caCertificate", om.valueToTree(this.getCaCertificate()));
            }
            if (this.getEnablePerformanceInsights() != null) {
                data.set("enablePerformanceInsights", om.valueToTree(this.getEnablePerformanceInsights()));
            }
            if (this.getInstanceIdentifier() != null) {
                data.set("instanceIdentifier", om.valueToTree(this.getInstanceIdentifier()));
            }
            if (this.getIsFromLegacyInstanceProps() != null) {
                data.set("isFromLegacyInstanceProps", om.valueToTree(this.getIsFromLegacyInstanceProps()));
            }
            if (this.getParameterGroup() != null) {
                data.set("parameterGroup", om.valueToTree(this.getParameterGroup()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPerformanceInsightEncryptionKey() != null) {
                data.set("performanceInsightEncryptionKey", om.valueToTree(this.getPerformanceInsightEncryptionKey()));
            }
            if (this.getPerformanceInsightRetention() != null) {
                data.set("performanceInsightRetention", om.valueToTree(this.getPerformanceInsightRetention()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getPubliclyAccessible() != null) {
                data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.ServerlessV2ClusterInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerlessV2ClusterInstanceProps.Jsii$Proxy that = (ServerlessV2ClusterInstanceProps.Jsii$Proxy) o;

            if (this.scaleWithWriter != null ? !this.scaleWithWriter.equals(that.scaleWithWriter) : that.scaleWithWriter != null) return false;
            if (this.allowMajorVersionUpgrade != null ? !this.allowMajorVersionUpgrade.equals(that.allowMajorVersionUpgrade) : that.allowMajorVersionUpgrade != null) return false;
            if (this.applyImmediately != null ? !this.applyImmediately.equals(that.applyImmediately) : that.applyImmediately != null) return false;
            if (this.autoMinorVersionUpgrade != null ? !this.autoMinorVersionUpgrade.equals(that.autoMinorVersionUpgrade) : that.autoMinorVersionUpgrade != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.caCertificate != null ? !this.caCertificate.equals(that.caCertificate) : that.caCertificate != null) return false;
            if (this.enablePerformanceInsights != null ? !this.enablePerformanceInsights.equals(that.enablePerformanceInsights) : that.enablePerformanceInsights != null) return false;
            if (this.instanceIdentifier != null ? !this.instanceIdentifier.equals(that.instanceIdentifier) : that.instanceIdentifier != null) return false;
            if (this.isFromLegacyInstanceProps != null ? !this.isFromLegacyInstanceProps.equals(that.isFromLegacyInstanceProps) : that.isFromLegacyInstanceProps != null) return false;
            if (this.parameterGroup != null ? !this.parameterGroup.equals(that.parameterGroup) : that.parameterGroup != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.performanceInsightEncryptionKey != null ? !this.performanceInsightEncryptionKey.equals(that.performanceInsightEncryptionKey) : that.performanceInsightEncryptionKey != null) return false;
            if (this.performanceInsightRetention != null ? !this.performanceInsightRetention.equals(that.performanceInsightRetention) : that.performanceInsightRetention != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            return this.publiclyAccessible != null ? this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible == null;
        }

        @Override
        public final int hashCode() {
            int result = this.scaleWithWriter != null ? this.scaleWithWriter.hashCode() : 0;
            result = 31 * result + (this.allowMajorVersionUpgrade != null ? this.allowMajorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.applyImmediately != null ? this.applyImmediately.hashCode() : 0);
            result = 31 * result + (this.autoMinorVersionUpgrade != null ? this.autoMinorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.caCertificate != null ? this.caCertificate.hashCode() : 0);
            result = 31 * result + (this.enablePerformanceInsights != null ? this.enablePerformanceInsights.hashCode() : 0);
            result = 31 * result + (this.instanceIdentifier != null ? this.instanceIdentifier.hashCode() : 0);
            result = 31 * result + (this.isFromLegacyInstanceProps != null ? this.isFromLegacyInstanceProps.hashCode() : 0);
            result = 31 * result + (this.parameterGroup != null ? this.parameterGroup.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.performanceInsightEncryptionKey != null ? this.performanceInsightEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.performanceInsightRetention != null ? this.performanceInsightRetention.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
            return result;
        }
    }
}
