package software.amazon.awscdk.services.redshiftserverless;

/**
 * Properties for defining a <code>CfnNamespace</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshiftserverless.*;
 * Object namespaceResourcePolicy;
 * CfnNamespaceProps cfnNamespaceProps = CfnNamespaceProps.builder()
 *         .namespaceName("namespaceName")
 *         // the properties below are optional
 *         .adminPasswordSecretKmsKeyId("adminPasswordSecretKmsKeyId")
 *         .adminUsername("adminUsername")
 *         .adminUserPassword("adminUserPassword")
 *         .dbName("dbName")
 *         .defaultIamRoleArn("defaultIamRoleArn")
 *         .finalSnapshotName("finalSnapshotName")
 *         .finalSnapshotRetentionPeriod(123)
 *         .iamRoles(List.of("iamRoles"))
 *         .kmsKeyId("kmsKeyId")
 *         .logExports(List.of("logExports"))
 *         .manageAdminPassword(false)
 *         .namespaceResourcePolicy(namespaceResourcePolicy)
 *         .redshiftIdcApplicationArn("redshiftIdcApplicationArn")
 *         .snapshotCopyConfigurations(List.of(SnapshotCopyConfigurationProperty.builder()
 *                 .destinationRegion("destinationRegion")
 *                 // the properties below are optional
 *                 .destinationKmsKeyId("destinationKmsKeyId")
 *                 .snapshotRetentionPeriod(123)
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:21.839Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnNamespaceProps")
@software.amazon.jsii.Jsii.Proxy(CfnNamespaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNamespaceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the namespace.
     * <p>
     * Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com//redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-namespacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-namespacename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNamespaceName();

    /**
     * The ID of the AWS Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret.
     * <p>
     * You can only use this parameter if <code>ManageAdminPassword</code> is <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminpasswordsecretkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminpasswordsecretkmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdminPasswordSecretKmsKeyId() {
        return null;
    }

    /**
     * The username of the administrator for the primary database created in the namespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminusername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdminUsername() {
        return null;
    }

    /**
     * The password of the administrator for the primary database created in the namespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminuserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminuserpassword</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdminUserPassword() {
        return null;
    }

    /**
     * The name of the primary database created in the namespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-dbname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-dbname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbName() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-defaultiamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-defaultiamrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultIamRoleArn() {
        return null;
    }

    /**
     * The name of the snapshot to be created before the namespace is deleted.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-finalsnapshotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-finalsnapshotname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFinalSnapshotName() {
        return null;
    }

    /**
     * How long to retain the final snapshot.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-finalsnapshotretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-finalsnapshotretentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getFinalSnapshotRetentionPeriod() {
        return null;
    }

    /**
     * A list of IAM roles to associate with the namespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-iamroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-iamroles</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIamRoles() {
        return null;
    }

    /**
     * The ID of the AWS Key Management Service key used to encrypt your data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The types of logs the namespace can export.
     * <p>
     * Available export types are <code>userlog</code> , <code>connectionlog</code> , and <code>useractivitylog</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-logexports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-logexports</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogExports() {
        return null;
    }

    /**
     * If true, Amazon Redshift uses AWS Secrets Manager to manage the namespace's admin credentials.
     * <p>
     * You can't use <code>AdminUserPassword</code> if <code>ManageAdminPassword</code> is true. If <code>ManageAdminPassword</code> is <code>false</code> or not set, Amazon Redshift uses <code>AdminUserPassword</code> for the admin user account's password.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-manageadminpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-manageadminpassword</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getManageAdminPassword() {
        return null;
    }

    /**
     * The resource policy that will be attached to the namespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-namespaceresourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-namespaceresourcepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNamespaceResourcePolicy() {
        return null;
    }

    /**
     * The ARN for the Redshift application that integrates with IAM Identity Center.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-redshiftidcapplicationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-redshiftidcapplicationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRedshiftIdcApplicationArn() {
        return null;
    }

    /**
     * The snapshot copy configurations for the namespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-snapshotcopyconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-snapshotcopyconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotCopyConfigurations() {
        return null;
    }

    /**
     * The map of the key-value pairs used to tag the namespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNamespaceProps> {
        java.lang.String namespaceName;
        java.lang.String adminPasswordSecretKmsKeyId;
        java.lang.String adminUsername;
        java.lang.String adminUserPassword;
        java.lang.String dbName;
        java.lang.String defaultIamRoleArn;
        java.lang.String finalSnapshotName;
        java.lang.Number finalSnapshotRetentionPeriod;
        java.util.List<java.lang.String> iamRoles;
        java.lang.String kmsKeyId;
        java.util.List<java.lang.String> logExports;
        java.lang.Object manageAdminPassword;
        java.lang.Object namespaceResourcePolicy;
        java.lang.String redshiftIdcApplicationArn;
        java.lang.Object snapshotCopyConfigurations;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnNamespaceProps#getNamespaceName}
         * @param namespaceName The name of the namespace. This parameter is required.
         *                      Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com//redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaceName(java.lang.String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getAdminPasswordSecretKmsKeyId}
         * @param adminPasswordSecretKmsKeyId The ID of the AWS Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret.
         *                                    You can only use this parameter if <code>ManageAdminPassword</code> is <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminPasswordSecretKmsKeyId(java.lang.String adminPasswordSecretKmsKeyId) {
            this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getAdminUsername}
         * @param adminUsername The username of the administrator for the primary database created in the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminUsername(java.lang.String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getAdminUserPassword}
         * @param adminUserPassword The password of the administrator for the primary database created in the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminUserPassword(java.lang.String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getDbName}
         * @param dbName The name of the primary database created in the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbName(java.lang.String dbName) {
            this.dbName = dbName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getDefaultIamRoleArn}
         * @param defaultIamRoleArn The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIamRoleArn(java.lang.String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getFinalSnapshotName}
         * @param finalSnapshotName The name of the snapshot to be created before the namespace is deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder finalSnapshotName(java.lang.String finalSnapshotName) {
            this.finalSnapshotName = finalSnapshotName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getFinalSnapshotRetentionPeriod}
         * @param finalSnapshotRetentionPeriod How long to retain the final snapshot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder finalSnapshotRetentionPeriod(java.lang.Number finalSnapshotRetentionPeriod) {
            this.finalSnapshotRetentionPeriod = finalSnapshotRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getIamRoles}
         * @param iamRoles A list of IAM roles to associate with the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRoles(java.util.List<java.lang.String> iamRoles) {
            this.iamRoles = iamRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getKmsKeyId}
         * @param kmsKeyId The ID of the AWS Key Management Service key used to encrypt your data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getLogExports}
         * @param logExports The types of logs the namespace can export.
         *                   Available export types are <code>userlog</code> , <code>connectionlog</code> , and <code>useractivitylog</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logExports(java.util.List<java.lang.String> logExports) {
            this.logExports = logExports;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getManageAdminPassword}
         * @param manageAdminPassword If true, Amazon Redshift uses AWS Secrets Manager to manage the namespace's admin credentials.
         *                            You can't use <code>AdminUserPassword</code> if <code>ManageAdminPassword</code> is true. If <code>ManageAdminPassword</code> is <code>false</code> or not set, Amazon Redshift uses <code>AdminUserPassword</code> for the admin user account's password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageAdminPassword(java.lang.Boolean manageAdminPassword) {
            this.manageAdminPassword = manageAdminPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getManageAdminPassword}
         * @param manageAdminPassword If true, Amazon Redshift uses AWS Secrets Manager to manage the namespace's admin credentials.
         *                            You can't use <code>AdminUserPassword</code> if <code>ManageAdminPassword</code> is true. If <code>ManageAdminPassword</code> is <code>false</code> or not set, Amazon Redshift uses <code>AdminUserPassword</code> for the admin user account's password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageAdminPassword(software.amazon.awscdk.IResolvable manageAdminPassword) {
            this.manageAdminPassword = manageAdminPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getNamespaceResourcePolicy}
         * @param namespaceResourcePolicy The resource policy that will be attached to the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaceResourcePolicy(java.lang.Object namespaceResourcePolicy) {
            this.namespaceResourcePolicy = namespaceResourcePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getRedshiftIdcApplicationArn}
         * @param redshiftIdcApplicationArn The ARN for the Redshift application that integrates with IAM Identity Center.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftIdcApplicationArn(java.lang.String redshiftIdcApplicationArn) {
            this.redshiftIdcApplicationArn = redshiftIdcApplicationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getSnapshotCopyConfigurations}
         * @param snapshotCopyConfigurations The snapshot copy configurations for the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyConfigurations(software.amazon.awscdk.IResolvable snapshotCopyConfigurations) {
            this.snapshotCopyConfigurations = snapshotCopyConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getSnapshotCopyConfigurations}
         * @param snapshotCopyConfigurations The snapshot copy configurations for the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyConfigurations(java.util.List<? extends java.lang.Object> snapshotCopyConfigurations) {
            this.snapshotCopyConfigurations = snapshotCopyConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getTags}
         * @param tags The map of the key-value pairs used to tag the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNamespaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNamespaceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNamespaceProps {
        private final java.lang.String namespaceName;
        private final java.lang.String adminPasswordSecretKmsKeyId;
        private final java.lang.String adminUsername;
        private final java.lang.String adminUserPassword;
        private final java.lang.String dbName;
        private final java.lang.String defaultIamRoleArn;
        private final java.lang.String finalSnapshotName;
        private final java.lang.Number finalSnapshotRetentionPeriod;
        private final java.util.List<java.lang.String> iamRoles;
        private final java.lang.String kmsKeyId;
        private final java.util.List<java.lang.String> logExports;
        private final java.lang.Object manageAdminPassword;
        private final java.lang.Object namespaceResourcePolicy;
        private final java.lang.String redshiftIdcApplicationArn;
        private final java.lang.Object snapshotCopyConfigurations;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.namespaceName = software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.adminPasswordSecretKmsKeyId = software.amazon.jsii.Kernel.get(this, "adminPasswordSecretKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.adminUsername = software.amazon.jsii.Kernel.get(this, "adminUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.adminUserPassword = software.amazon.jsii.Kernel.get(this, "adminUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbName = software.amazon.jsii.Kernel.get(this, "dbName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultIamRoleArn = software.amazon.jsii.Kernel.get(this, "defaultIamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.finalSnapshotName = software.amazon.jsii.Kernel.get(this, "finalSnapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.finalSnapshotRetentionPeriod = software.amazon.jsii.Kernel.get(this, "finalSnapshotRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.iamRoles = software.amazon.jsii.Kernel.get(this, "iamRoles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logExports = software.amazon.jsii.Kernel.get(this, "logExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.manageAdminPassword = software.amazon.jsii.Kernel.get(this, "manageAdminPassword", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.namespaceResourcePolicy = software.amazon.jsii.Kernel.get(this, "namespaceResourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.redshiftIdcApplicationArn = software.amazon.jsii.Kernel.get(this, "redshiftIdcApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snapshotCopyConfigurations = software.amazon.jsii.Kernel.get(this, "snapshotCopyConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.namespaceName = java.util.Objects.requireNonNull(builder.namespaceName, "namespaceName is required");
            this.adminPasswordSecretKmsKeyId = builder.adminPasswordSecretKmsKeyId;
            this.adminUsername = builder.adminUsername;
            this.adminUserPassword = builder.adminUserPassword;
            this.dbName = builder.dbName;
            this.defaultIamRoleArn = builder.defaultIamRoleArn;
            this.finalSnapshotName = builder.finalSnapshotName;
            this.finalSnapshotRetentionPeriod = builder.finalSnapshotRetentionPeriod;
            this.iamRoles = builder.iamRoles;
            this.kmsKeyId = builder.kmsKeyId;
            this.logExports = builder.logExports;
            this.manageAdminPassword = builder.manageAdminPassword;
            this.namespaceResourcePolicy = builder.namespaceResourcePolicy;
            this.redshiftIdcApplicationArn = builder.redshiftIdcApplicationArn;
            this.snapshotCopyConfigurations = builder.snapshotCopyConfigurations;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getNamespaceName() {
            return this.namespaceName;
        }

        @Override
        public final java.lang.String getAdminPasswordSecretKmsKeyId() {
            return this.adminPasswordSecretKmsKeyId;
        }

        @Override
        public final java.lang.String getAdminUsername() {
            return this.adminUsername;
        }

        @Override
        public final java.lang.String getAdminUserPassword() {
            return this.adminUserPassword;
        }

        @Override
        public final java.lang.String getDbName() {
            return this.dbName;
        }

        @Override
        public final java.lang.String getDefaultIamRoleArn() {
            return this.defaultIamRoleArn;
        }

        @Override
        public final java.lang.String getFinalSnapshotName() {
            return this.finalSnapshotName;
        }

        @Override
        public final java.lang.Number getFinalSnapshotRetentionPeriod() {
            return this.finalSnapshotRetentionPeriod;
        }

        @Override
        public final java.util.List<java.lang.String> getIamRoles() {
            return this.iamRoles;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.util.List<java.lang.String> getLogExports() {
            return this.logExports;
        }

        @Override
        public final java.lang.Object getManageAdminPassword() {
            return this.manageAdminPassword;
        }

        @Override
        public final java.lang.Object getNamespaceResourcePolicy() {
            return this.namespaceResourcePolicy;
        }

        @Override
        public final java.lang.String getRedshiftIdcApplicationArn() {
            return this.redshiftIdcApplicationArn;
        }

        @Override
        public final java.lang.Object getSnapshotCopyConfigurations() {
            return this.snapshotCopyConfigurations;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("namespaceName", om.valueToTree(this.getNamespaceName()));
            if (this.getAdminPasswordSecretKmsKeyId() != null) {
                data.set("adminPasswordSecretKmsKeyId", om.valueToTree(this.getAdminPasswordSecretKmsKeyId()));
            }
            if (this.getAdminUsername() != null) {
                data.set("adminUsername", om.valueToTree(this.getAdminUsername()));
            }
            if (this.getAdminUserPassword() != null) {
                data.set("adminUserPassword", om.valueToTree(this.getAdminUserPassword()));
            }
            if (this.getDbName() != null) {
                data.set("dbName", om.valueToTree(this.getDbName()));
            }
            if (this.getDefaultIamRoleArn() != null) {
                data.set("defaultIamRoleArn", om.valueToTree(this.getDefaultIamRoleArn()));
            }
            if (this.getFinalSnapshotName() != null) {
                data.set("finalSnapshotName", om.valueToTree(this.getFinalSnapshotName()));
            }
            if (this.getFinalSnapshotRetentionPeriod() != null) {
                data.set("finalSnapshotRetentionPeriod", om.valueToTree(this.getFinalSnapshotRetentionPeriod()));
            }
            if (this.getIamRoles() != null) {
                data.set("iamRoles", om.valueToTree(this.getIamRoles()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLogExports() != null) {
                data.set("logExports", om.valueToTree(this.getLogExports()));
            }
            if (this.getManageAdminPassword() != null) {
                data.set("manageAdminPassword", om.valueToTree(this.getManageAdminPassword()));
            }
            if (this.getNamespaceResourcePolicy() != null) {
                data.set("namespaceResourcePolicy", om.valueToTree(this.getNamespaceResourcePolicy()));
            }
            if (this.getRedshiftIdcApplicationArn() != null) {
                data.set("redshiftIdcApplicationArn", om.valueToTree(this.getRedshiftIdcApplicationArn()));
            }
            if (this.getSnapshotCopyConfigurations() != null) {
                data.set("snapshotCopyConfigurations", om.valueToTree(this.getSnapshotCopyConfigurations()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnNamespaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNamespaceProps.Jsii$Proxy that = (CfnNamespaceProps.Jsii$Proxy) o;

            if (!namespaceName.equals(that.namespaceName)) return false;
            if (this.adminPasswordSecretKmsKeyId != null ? !this.adminPasswordSecretKmsKeyId.equals(that.adminPasswordSecretKmsKeyId) : that.adminPasswordSecretKmsKeyId != null) return false;
            if (this.adminUsername != null ? !this.adminUsername.equals(that.adminUsername) : that.adminUsername != null) return false;
            if (this.adminUserPassword != null ? !this.adminUserPassword.equals(that.adminUserPassword) : that.adminUserPassword != null) return false;
            if (this.dbName != null ? !this.dbName.equals(that.dbName) : that.dbName != null) return false;
            if (this.defaultIamRoleArn != null ? !this.defaultIamRoleArn.equals(that.defaultIamRoleArn) : that.defaultIamRoleArn != null) return false;
            if (this.finalSnapshotName != null ? !this.finalSnapshotName.equals(that.finalSnapshotName) : that.finalSnapshotName != null) return false;
            if (this.finalSnapshotRetentionPeriod != null ? !this.finalSnapshotRetentionPeriod.equals(that.finalSnapshotRetentionPeriod) : that.finalSnapshotRetentionPeriod != null) return false;
            if (this.iamRoles != null ? !this.iamRoles.equals(that.iamRoles) : that.iamRoles != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.logExports != null ? !this.logExports.equals(that.logExports) : that.logExports != null) return false;
            if (this.manageAdminPassword != null ? !this.manageAdminPassword.equals(that.manageAdminPassword) : that.manageAdminPassword != null) return false;
            if (this.namespaceResourcePolicy != null ? !this.namespaceResourcePolicy.equals(that.namespaceResourcePolicy) : that.namespaceResourcePolicy != null) return false;
            if (this.redshiftIdcApplicationArn != null ? !this.redshiftIdcApplicationArn.equals(that.redshiftIdcApplicationArn) : that.redshiftIdcApplicationArn != null) return false;
            if (this.snapshotCopyConfigurations != null ? !this.snapshotCopyConfigurations.equals(that.snapshotCopyConfigurations) : that.snapshotCopyConfigurations != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.namespaceName.hashCode();
            result = 31 * result + (this.adminPasswordSecretKmsKeyId != null ? this.adminPasswordSecretKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.adminUsername != null ? this.adminUsername.hashCode() : 0);
            result = 31 * result + (this.adminUserPassword != null ? this.adminUserPassword.hashCode() : 0);
            result = 31 * result + (this.dbName != null ? this.dbName.hashCode() : 0);
            result = 31 * result + (this.defaultIamRoleArn != null ? this.defaultIamRoleArn.hashCode() : 0);
            result = 31 * result + (this.finalSnapshotName != null ? this.finalSnapshotName.hashCode() : 0);
            result = 31 * result + (this.finalSnapshotRetentionPeriod != null ? this.finalSnapshotRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.iamRoles != null ? this.iamRoles.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.logExports != null ? this.logExports.hashCode() : 0);
            result = 31 * result + (this.manageAdminPassword != null ? this.manageAdminPassword.hashCode() : 0);
            result = 31 * result + (this.namespaceResourcePolicy != null ? this.namespaceResourcePolicy.hashCode() : 0);
            result = 31 * result + (this.redshiftIdcApplicationArn != null ? this.redshiftIdcApplicationArn.hashCode() : 0);
            result = 31 * result + (this.snapshotCopyConfigurations != null ? this.snapshotCopyConfigurations.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
