package software.amazon.awscdk.services.route53;

/**
 * A Cross Account Zone Delegation record.
 * <p>
 * This construct uses custom resource lambda that calls Route53
 * ChangeResourceRecordSets API to upsert a NS record into the <code>parentHostedZone</code>.
 * <p>
 * WARNING: The default removal policy of this resource is DESTROY, therefore, if this resource's logical ID changes or
 * if this resource is removed from the stack, the existing NS record will be removed.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * PublicHostedZone subZone = PublicHostedZone.Builder.create(this, "SubZone")
 *         .zoneName("sub.someexample.com")
 *         .build();
 * // import the delegation role by constructing the roleArn
 * String delegationRoleArn = Stack.of(this).formatArn(ArnComponents.builder()
 *         .region("") // IAM is global in each partition
 *         .service("iam")
 *         .account("parent-account-id")
 *         .resource("role")
 *         .resourceName("MyDelegationRole")
 *         .build());
 * IRole delegationRole = Role.fromRoleArn(this, "DelegationRole", delegationRoleArn);
 * // create the record
 * // create the record
 * CrossAccountZoneDelegationRecord.Builder.create(this, "delegate")
 *         .delegatedZone(subZone)
 *         .parentHostedZoneName("someexample.com") // or you can use parentHostedZoneId
 *         .delegationRole(delegationRole)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:22.046Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CrossAccountZoneDelegationRecord")
public class CrossAccountZoneDelegationRecord extends software.constructs.Construct {

    protected CrossAccountZoneDelegationRecord(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CrossAccountZoneDelegationRecord(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CrossAccountZoneDelegationRecord(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.CrossAccountZoneDelegationRecordProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.CrossAccountZoneDelegationRecord}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.CrossAccountZoneDelegationRecord> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.CrossAccountZoneDelegationRecordProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.CrossAccountZoneDelegationRecordProps.Builder();
        }

        /**
         * The zone to be delegated.
         * <p>
         * @return {@code this}
         * @param delegatedZone The zone to be delegated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delegatedZone(final software.amazon.awscdk.services.route53.IHostedZone delegatedZone) {
            this.props.delegatedZone(delegatedZone);
            return this;
        }

        /**
         * The delegation role in the parent account.
         * <p>
         * @return {@code this}
         * @param delegationRole The delegation role in the parent account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delegationRole(final software.amazon.awscdk.services.iam.IRole delegationRole) {
            this.props.delegationRole(delegationRole);
            return this;
        }

        /**
         * Region from which to obtain temporary credentials.
         * <p>
         * Default: - the Route53 signing region in the current partition
         * <p>
         * @return {@code this}
         * @param assumeRoleRegion Region from which to obtain temporary credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleRegion(final java.lang.String assumeRoleRegion) {
            this.props.assumeRoleRegion(assumeRoleRegion);
            return this;
        }

        /**
         * The hosted zone id in the parent account.
         * <p>
         * Default: - no zone id
         * <p>
         * @return {@code this}
         * @param parentHostedZoneId The hosted zone id in the parent account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentHostedZoneId(final java.lang.String parentHostedZoneId) {
            this.props.parentHostedZoneId(parentHostedZoneId);
            return this;
        }

        /**
         * The hosted zone name in the parent account.
         * <p>
         * Default: - no zone name
         * <p>
         * @return {@code this}
         * @param parentHostedZoneName The hosted zone name in the parent account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentHostedZoneName(final java.lang.String parentHostedZoneName) {
            this.props.parentHostedZoneName(parentHostedZoneName);
            return this;
        }

        /**
         * The removal policy to apply to the record set.
         * <p>
         * Default: RemovalPolicy.DESTROY
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply to the record set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * The resource record cache time to live (TTL).
         * <p>
         * Default: Duration.days(2)
         * <p>
         * @return {@code this}
         * @param ttl The resource record cache time to live (TTL). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(final software.amazon.awscdk.Duration ttl) {
            this.props.ttl(ttl);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.route53.CrossAccountZoneDelegationRecord}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.CrossAccountZoneDelegationRecord build() {
            return new software.amazon.awscdk.services.route53.CrossAccountZoneDelegationRecord(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
