package software.amazon.awscdk.services.route53resolver;

/**
 * High-level information for a firewall rule group.
 * <p>
 * A firewall rule group is a collection of rules that DNS Firewall uses to filter DNS network traffic for a VPC. To retrieve the rules for the rule group, call <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListFirewallRules.html">ListFirewallRules</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53resolver.*;
 * CfnFirewallRuleGroup cfnFirewallRuleGroup = CfnFirewallRuleGroup.Builder.create(this, "MyCfnFirewallRuleGroup")
 *         .firewallRules(List.of(FirewallRuleProperty.builder()
 *                 .action("action")
 *                 .priority(123)
 *                 // the properties below are optional
 *                 .blockOverrideDnsType("blockOverrideDnsType")
 *                 .blockOverrideDomain("blockOverrideDomain")
 *                 .blockOverrideTtl(123)
 *                 .blockResponse("blockResponse")
 *                 .confidenceThreshold("confidenceThreshold")
 *                 .dnsThreatProtection("dnsThreatProtection")
 *                 .firewallDomainListId("firewallDomainListId")
 *                 .firewallDomainRedirectionAction("firewallDomainRedirectionAction")
 *                 .firewallThreatProtectionId("firewallThreatProtectionId")
 *                 .qtype("qtype")
 *                 .build()))
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-firewallrulegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-firewallrulegroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:22.148Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53resolver.CfnFirewallRuleGroup")
public class CfnFirewallRuleGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnFirewallRuleGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFirewallRuleGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFirewallRuleGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFirewallRuleGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN (Amazon Resource Name) of the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time that the rule group was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique string defined by you to identify the request.
     * <p>
     * This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatorRequestId() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatorRequestId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time that the rule group was last modified, in Unix time format and Coordinated Universal Time (UTC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrModificationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrModificationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS account ID for the account that created the rule group.
     * <p>
     * When a rule group is shared with your account, this is the account that has shared the rule group with you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOwnerId() {
        return software.amazon.jsii.Kernel.get(this, "attrOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of rules in the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrRuleCount() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Whether the rule group is shared with other AWS accounts , or was shared with the current account by another AWS account .
     * <p>
     * Sharing is configured through AWS Resource Access Manager ( AWS RAM ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrShareStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrShareStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the domain list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Additional information about the status of the rule group, if available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A list of the rules that you have defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFirewallRules() {
        return software.amazon.jsii.Kernel.get(this, "firewallRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of the rules that you have defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFirewallRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "firewallRules", value);
    }

    /**
     * A list of the rules that you have defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFirewallRules(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroup.FirewallRuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroup.FirewallRuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "firewallRules", value);
    }

    /**
     * The name of the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * A list of the tag keys and values that you want to associate with the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of the tag keys and values that you want to associate with the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A single firewall rule in a rule group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53resolver.*;
     * FirewallRuleProperty firewallRuleProperty = FirewallRuleProperty.builder()
     *         .action("action")
     *         .priority(123)
     *         // the properties below are optional
     *         .blockOverrideDnsType("blockOverrideDnsType")
     *         .blockOverrideDomain("blockOverrideDomain")
     *         .blockOverrideTtl(123)
     *         .blockResponse("blockResponse")
     *         .confidenceThreshold("confidenceThreshold")
     *         .dnsThreatProtection("dnsThreatProtection")
     *         .firewallDomainListId("firewallDomainListId")
     *         .firewallDomainRedirectionAction("firewallDomainRedirectionAction")
     *         .firewallThreatProtectionId("firewallThreatProtectionId")
     *         .qtype("qtype")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53resolver.CfnFirewallRuleGroup.FirewallRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(FirewallRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FirewallRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list, or a threat in a DNS Firewall Advvanced rule:  - <code>ALLOW</code> - Permit the request to go through.
         * <p>
         * Not available for DNS Firewall Advanced rules.
         * <p>
         * <ul>
         * <li><code>ALERT</code> - Permit the request to go through but send an alert to the logs.</li>
         * <li><code>BLOCK</code> - Disallow the request. If this is specified,then <code>BlockResponse</code> must also be specified.</li>
         * </ul>
         * <p>
         * if <code>BlockResponse</code> is <code>OVERRIDE</code> , then all of the following <code>OVERRIDE</code> attributes must be specified:
         * <p>
         * <ul>
         * <li><code>BlockOverrideDnsType</code></li>
         * <li><code>BlockOverrideDomain</code></li>
         * <li><code>BlockOverrideTtl</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * The priority of the rule in the rule group.
         * <p>
         * This value must be unique within the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-priority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

        /**
         * The DNS record's type.
         * <p>
         * This determines the format of the record value that you provided in <code>BlockOverrideDomain</code> . Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-blockoverridednstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-blockoverridednstype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBlockOverrideDnsType() {
            return null;
        }

        /**
         * The custom DNS record to send back in response to the query.
         * <p>
         * Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-blockoverridedomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-blockoverridedomain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBlockOverrideDomain() {
            return null;
        }

        /**
         * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record.
         * <p>
         * Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-blockoverridettl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-blockoverridettl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBlockOverrideTtl() {
            return null;
        }

        /**
         * The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code> .
         * <p>
         * <ul>
         * <li><code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</li>
         * <li><code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</li>
         * <li><code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-blockresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-blockresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBlockResponse() {
            return null;
        }

        /**
         * The confidence threshold for DNS Firewall Advanced.
         * <p>
         * You must provide this value when you create a DNS Firewall Advanced rule. The confidence level values mean:
         * <p>
         * <ul>
         * <li><code>LOW</code> : Provides the highest detection rate for threats, but also increases false positives.</li>
         * <li><code>MEDIUM</code> : Provides a balance between detecting threats and false positives.</li>
         * <li><code>HIGH</code> : Detects only the most well corroborated threats with a low rate of false positives.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-confidencethreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-confidencethreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConfidenceThreshold() {
            return null;
        }

        /**
         * The type of the DNS Firewall Advanced rule. Valid values are:.
         * <p>
         * <ul>
         * <li><code>DGA</code> : Domain generation algorithms detection. DGAs are used by attackers to generate a large number of domains to to launch malware attacks.</li>
         * <li><code>DNS_TUNNELING</code> : DNS tunneling detection. DNS tunneling is used by attackers to exfiltrate data from the client by using the DNS tunnel without making a network connection to the client.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-dnsthreatprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-dnsthreatprotection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDnsThreatProtection() {
            return null;
        }

        /**
         * The ID of the domain list that's used in the rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-firewalldomainlistid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-firewalldomainlistid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFirewallDomainListId() {
            return null;
        }

        /**
         * How you want the the rule to evaluate DNS redirection in the DNS redirection chain, such as CNAME, or DNAME.
         * <p>
         * <code>Inspect_Redirection_Domain</code> (Default) inspects all domains in the redirection chain. The individual domains in the redirection chain must be added to the domain list.
         * <p>
         * <code>Trust_Redirection_Domain</code> inspects only the first domain in the redirection chain. You don't need to add the subsequent domains in the domain in the redirection list to the domain list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-firewalldomainredirectionaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-firewalldomainredirectionaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFirewallDomainRedirectionAction() {
            return null;
        }

        /**
         * ID of the DNS Firewall Advanced rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-firewallthreatprotectionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-firewallthreatprotectionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFirewallThreatProtectionId() {
            return null;
        }

        /**
         * The DNS query type you want the rule to evaluate. Allowed values are;
         * <p>
         * <ul>
         * <li>A: Returns an IPv4 address.</li>
         * <li>AAAA: Returns an Ipv6 address.</li>
         * <li>CAA: Restricts CAs that can create SSL/TLS certifications for the domain.</li>
         * <li>CNAME: Returns another domain name.</li>
         * <li>DS: Record that identifies the DNSSEC signing key of a delegated zone.</li>
         * <li>MX: Specifies mail servers.</li>
         * <li>NAPTR: Regular-expression-based rewriting of domain names.</li>
         * <li>NS: Authoritative name servers.</li>
         * <li>PTR: Maps an IP address to a domain name.</li>
         * <li>SOA: Start of authority record for the zone.</li>
         * <li>SPF: Lists the servers authorized to send emails from a domain.</li>
         * <li>SRV: Application specific values that identify servers.</li>
         * <li>TXT: Verifies email senders and application-specific values.</li>
         * <li>A query type you define by using the DNS type ID, for example 28 for AAAA. The values must be defined as TYPE NUMBER , where the NUMBER can be 1-65334, for example, TYPE28. For more information, see <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/List_of_DNS_record_types">List of DNS record types</a> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-qtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53resolver-firewallrulegroup-firewallrule.html#cfn-route53resolver-firewallrulegroup-firewallrule-qtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQtype() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FirewallRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FirewallRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FirewallRuleProperty> {
            java.lang.String action;
            java.lang.Number priority;
            java.lang.String blockOverrideDnsType;
            java.lang.String blockOverrideDomain;
            java.lang.Number blockOverrideTtl;
            java.lang.String blockResponse;
            java.lang.String confidenceThreshold;
            java.lang.String dnsThreatProtection;
            java.lang.String firewallDomainListId;
            java.lang.String firewallDomainRedirectionAction;
            java.lang.String firewallThreatProtectionId;
            java.lang.String qtype;

            /**
             * Sets the value of {@link FirewallRuleProperty#getAction}
             * @param action The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list, or a threat in a DNS Firewall Advvanced rule:  - <code>ALLOW</code> - Permit the request to go through. This parameter is required.
             *               Not available for DNS Firewall Advanced rules.
             *               <p>
             *               <ul>
             *               <li><code>ALERT</code> - Permit the request to go through but send an alert to the logs.</li>
             *               <li><code>BLOCK</code> - Disallow the request. If this is specified,then <code>BlockResponse</code> must also be specified.</li>
             *               </ul>
             *               <p>
             *               if <code>BlockResponse</code> is <code>OVERRIDE</code> , then all of the following <code>OVERRIDE</code> attributes must be specified:
             *               <p>
             *               <ul>
             *               <li><code>BlockOverrideDnsType</code></li>
             *               <li><code>BlockOverrideDomain</code></li>
             *               <li><code>BlockOverrideTtl</code></li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link FirewallRuleProperty#getPriority}
             * @param priority The priority of the rule in the rule group. This parameter is required.
             *                 This value must be unique within the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link FirewallRuleProperty#getBlockOverrideDnsType}
             * @param blockOverrideDnsType The DNS record's type.
             *                             This determines the format of the record value that you provided in <code>BlockOverrideDomain</code> . Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockOverrideDnsType(java.lang.String blockOverrideDnsType) {
                this.blockOverrideDnsType = blockOverrideDnsType;
                return this;
            }

            /**
             * Sets the value of {@link FirewallRuleProperty#getBlockOverrideDomain}
             * @param blockOverrideDomain The custom DNS record to send back in response to the query.
             *                            Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockOverrideDomain(java.lang.String blockOverrideDomain) {
                this.blockOverrideDomain = blockOverrideDomain;
                return this;
            }

            /**
             * Sets the value of {@link FirewallRuleProperty#getBlockOverrideTtl}
             * @param blockOverrideTtl The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record.
             *                         Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockOverrideTtl(java.lang.Number blockOverrideTtl) {
                this.blockOverrideTtl = blockOverrideTtl;
                return this;
            }

            /**
             * Sets the value of {@link FirewallRuleProperty#getBlockResponse}
             * @param blockResponse The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code> .
             *                      <ul>
             *                      <li><code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</li>
             *                      <li><code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</li>
             *                      <li><code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockResponse(java.lang.String blockResponse) {
                this.blockResponse = blockResponse;
                return this;
            }

            /**
             * Sets the value of {@link FirewallRuleProperty#getConfidenceThreshold}
             * @param confidenceThreshold The confidence threshold for DNS Firewall Advanced.
             *                            You must provide this value when you create a DNS Firewall Advanced rule. The confidence level values mean:
             *                            <p>
             *                            <ul>
             *                            <li><code>LOW</code> : Provides the highest detection rate for threats, but also increases false positives.</li>
             *                            <li><code>MEDIUM</code> : Provides a balance between detecting threats and false positives.</li>
             *                            <li><code>HIGH</code> : Detects only the most well corroborated threats with a low rate of false positives.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confidenceThreshold(java.lang.String confidenceThreshold) {
                this.confidenceThreshold = confidenceThreshold;
                return this;
            }

            /**
             * Sets the value of {@link FirewallRuleProperty#getDnsThreatProtection}
             * @param dnsThreatProtection The type of the DNS Firewall Advanced rule. Valid values are:.
             *                            <ul>
             *                            <li><code>DGA</code> : Domain generation algorithms detection. DGAs are used by attackers to generate a large number of domains to to launch malware attacks.</li>
             *                            <li><code>DNS_TUNNELING</code> : DNS tunneling detection. DNS tunneling is used by attackers to exfiltrate data from the client by using the DNS tunnel without making a network connection to the client.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsThreatProtection(java.lang.String dnsThreatProtection) {
                this.dnsThreatProtection = dnsThreatProtection;
                return this;
            }

            /**
             * Sets the value of {@link FirewallRuleProperty#getFirewallDomainListId}
             * @param firewallDomainListId The ID of the domain list that's used in the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firewallDomainListId(java.lang.String firewallDomainListId) {
                this.firewallDomainListId = firewallDomainListId;
                return this;
            }

            /**
             * Sets the value of {@link FirewallRuleProperty#getFirewallDomainRedirectionAction}
             * @param firewallDomainRedirectionAction How you want the the rule to evaluate DNS redirection in the DNS redirection chain, such as CNAME, or DNAME.
             *                                        <code>Inspect_Redirection_Domain</code> (Default) inspects all domains in the redirection chain. The individual domains in the redirection chain must be added to the domain list.
             *                                        <p>
             *                                        <code>Trust_Redirection_Domain</code> inspects only the first domain in the redirection chain. You don't need to add the subsequent domains in the domain in the redirection list to the domain list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firewallDomainRedirectionAction(java.lang.String firewallDomainRedirectionAction) {
                this.firewallDomainRedirectionAction = firewallDomainRedirectionAction;
                return this;
            }

            /**
             * Sets the value of {@link FirewallRuleProperty#getFirewallThreatProtectionId}
             * @param firewallThreatProtectionId ID of the DNS Firewall Advanced rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firewallThreatProtectionId(java.lang.String firewallThreatProtectionId) {
                this.firewallThreatProtectionId = firewallThreatProtectionId;
                return this;
            }

            /**
             * Sets the value of {@link FirewallRuleProperty#getQtype}
             * @param qtype The DNS query type you want the rule to evaluate. Allowed values are;.
             *              <ul>
             *              <li>A: Returns an IPv4 address.</li>
             *              <li>AAAA: Returns an Ipv6 address.</li>
             *              <li>CAA: Restricts CAs that can create SSL/TLS certifications for the domain.</li>
             *              <li>CNAME: Returns another domain name.</li>
             *              <li>DS: Record that identifies the DNSSEC signing key of a delegated zone.</li>
             *              <li>MX: Specifies mail servers.</li>
             *              <li>NAPTR: Regular-expression-based rewriting of domain names.</li>
             *              <li>NS: Authoritative name servers.</li>
             *              <li>PTR: Maps an IP address to a domain name.</li>
             *              <li>SOA: Start of authority record for the zone.</li>
             *              <li>SPF: Lists the servers authorized to send emails from a domain.</li>
             *              <li>SRV: Application specific values that identify servers.</li>
             *              <li>TXT: Verifies email senders and application-specific values.</li>
             *              <li>A query type you define by using the DNS type ID, for example 28 for AAAA. The values must be defined as TYPE NUMBER , where the NUMBER can be 1-65334, for example, TYPE28. For more information, see <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/List_of_DNS_record_types">List of DNS record types</a> .</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder qtype(java.lang.String qtype) {
                this.qtype = qtype;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FirewallRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FirewallRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FirewallRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirewallRuleProperty {
            private final java.lang.String action;
            private final java.lang.Number priority;
            private final java.lang.String blockOverrideDnsType;
            private final java.lang.String blockOverrideDomain;
            private final java.lang.Number blockOverrideTtl;
            private final java.lang.String blockResponse;
            private final java.lang.String confidenceThreshold;
            private final java.lang.String dnsThreatProtection;
            private final java.lang.String firewallDomainListId;
            private final java.lang.String firewallDomainRedirectionAction;
            private final java.lang.String firewallThreatProtectionId;
            private final java.lang.String qtype;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.blockOverrideDnsType = software.amazon.jsii.Kernel.get(this, "blockOverrideDnsType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.blockOverrideDomain = software.amazon.jsii.Kernel.get(this, "blockOverrideDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.blockOverrideTtl = software.amazon.jsii.Kernel.get(this, "blockOverrideTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.blockResponse = software.amazon.jsii.Kernel.get(this, "blockResponse", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.confidenceThreshold = software.amazon.jsii.Kernel.get(this, "confidenceThreshold", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dnsThreatProtection = software.amazon.jsii.Kernel.get(this, "dnsThreatProtection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.firewallDomainListId = software.amazon.jsii.Kernel.get(this, "firewallDomainListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.firewallDomainRedirectionAction = software.amazon.jsii.Kernel.get(this, "firewallDomainRedirectionAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.firewallThreatProtectionId = software.amazon.jsii.Kernel.get(this, "firewallThreatProtectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.qtype = software.amazon.jsii.Kernel.get(this, "qtype", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
                this.blockOverrideDnsType = builder.blockOverrideDnsType;
                this.blockOverrideDomain = builder.blockOverrideDomain;
                this.blockOverrideTtl = builder.blockOverrideTtl;
                this.blockResponse = builder.blockResponse;
                this.confidenceThreshold = builder.confidenceThreshold;
                this.dnsThreatProtection = builder.dnsThreatProtection;
                this.firewallDomainListId = builder.firewallDomainListId;
                this.firewallDomainRedirectionAction = builder.firewallDomainRedirectionAction;
                this.firewallThreatProtectionId = builder.firewallThreatProtectionId;
                this.qtype = builder.qtype;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.String getBlockOverrideDnsType() {
                return this.blockOverrideDnsType;
            }

            @Override
            public final java.lang.String getBlockOverrideDomain() {
                return this.blockOverrideDomain;
            }

            @Override
            public final java.lang.Number getBlockOverrideTtl() {
                return this.blockOverrideTtl;
            }

            @Override
            public final java.lang.String getBlockResponse() {
                return this.blockResponse;
            }

            @Override
            public final java.lang.String getConfidenceThreshold() {
                return this.confidenceThreshold;
            }

            @Override
            public final java.lang.String getDnsThreatProtection() {
                return this.dnsThreatProtection;
            }

            @Override
            public final java.lang.String getFirewallDomainListId() {
                return this.firewallDomainListId;
            }

            @Override
            public final java.lang.String getFirewallDomainRedirectionAction() {
                return this.firewallDomainRedirectionAction;
            }

            @Override
            public final java.lang.String getFirewallThreatProtectionId() {
                return this.firewallThreatProtectionId;
            }

            @Override
            public final java.lang.String getQtype() {
                return this.qtype;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("priority", om.valueToTree(this.getPriority()));
                if (this.getBlockOverrideDnsType() != null) {
                    data.set("blockOverrideDnsType", om.valueToTree(this.getBlockOverrideDnsType()));
                }
                if (this.getBlockOverrideDomain() != null) {
                    data.set("blockOverrideDomain", om.valueToTree(this.getBlockOverrideDomain()));
                }
                if (this.getBlockOverrideTtl() != null) {
                    data.set("blockOverrideTtl", om.valueToTree(this.getBlockOverrideTtl()));
                }
                if (this.getBlockResponse() != null) {
                    data.set("blockResponse", om.valueToTree(this.getBlockResponse()));
                }
                if (this.getConfidenceThreshold() != null) {
                    data.set("confidenceThreshold", om.valueToTree(this.getConfidenceThreshold()));
                }
                if (this.getDnsThreatProtection() != null) {
                    data.set("dnsThreatProtection", om.valueToTree(this.getDnsThreatProtection()));
                }
                if (this.getFirewallDomainListId() != null) {
                    data.set("firewallDomainListId", om.valueToTree(this.getFirewallDomainListId()));
                }
                if (this.getFirewallDomainRedirectionAction() != null) {
                    data.set("firewallDomainRedirectionAction", om.valueToTree(this.getFirewallDomainRedirectionAction()));
                }
                if (this.getFirewallThreatProtectionId() != null) {
                    data.set("firewallThreatProtectionId", om.valueToTree(this.getFirewallThreatProtectionId()));
                }
                if (this.getQtype() != null) {
                    data.set("qtype", om.valueToTree(this.getQtype()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53resolver.CfnFirewallRuleGroup.FirewallRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FirewallRuleProperty.Jsii$Proxy that = (FirewallRuleProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!priority.equals(that.priority)) return false;
                if (this.blockOverrideDnsType != null ? !this.blockOverrideDnsType.equals(that.blockOverrideDnsType) : that.blockOverrideDnsType != null) return false;
                if (this.blockOverrideDomain != null ? !this.blockOverrideDomain.equals(that.blockOverrideDomain) : that.blockOverrideDomain != null) return false;
                if (this.blockOverrideTtl != null ? !this.blockOverrideTtl.equals(that.blockOverrideTtl) : that.blockOverrideTtl != null) return false;
                if (this.blockResponse != null ? !this.blockResponse.equals(that.blockResponse) : that.blockResponse != null) return false;
                if (this.confidenceThreshold != null ? !this.confidenceThreshold.equals(that.confidenceThreshold) : that.confidenceThreshold != null) return false;
                if (this.dnsThreatProtection != null ? !this.dnsThreatProtection.equals(that.dnsThreatProtection) : that.dnsThreatProtection != null) return false;
                if (this.firewallDomainListId != null ? !this.firewallDomainListId.equals(that.firewallDomainListId) : that.firewallDomainListId != null) return false;
                if (this.firewallDomainRedirectionAction != null ? !this.firewallDomainRedirectionAction.equals(that.firewallDomainRedirectionAction) : that.firewallDomainRedirectionAction != null) return false;
                if (this.firewallThreatProtectionId != null ? !this.firewallThreatProtectionId.equals(that.firewallThreatProtectionId) : that.firewallThreatProtectionId != null) return false;
                return this.qtype != null ? this.qtype.equals(that.qtype) : that.qtype == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.priority.hashCode());
                result = 31 * result + (this.blockOverrideDnsType != null ? this.blockOverrideDnsType.hashCode() : 0);
                result = 31 * result + (this.blockOverrideDomain != null ? this.blockOverrideDomain.hashCode() : 0);
                result = 31 * result + (this.blockOverrideTtl != null ? this.blockOverrideTtl.hashCode() : 0);
                result = 31 * result + (this.blockResponse != null ? this.blockResponse.hashCode() : 0);
                result = 31 * result + (this.confidenceThreshold != null ? this.confidenceThreshold.hashCode() : 0);
                result = 31 * result + (this.dnsThreatProtection != null ? this.dnsThreatProtection.hashCode() : 0);
                result = 31 * result + (this.firewallDomainListId != null ? this.firewallDomainListId.hashCode() : 0);
                result = 31 * result + (this.firewallDomainRedirectionAction != null ? this.firewallDomainRedirectionAction.hashCode() : 0);
                result = 31 * result + (this.firewallThreatProtectionId != null ? this.firewallThreatProtectionId.hashCode() : 0);
                result = 31 * result + (this.qtype != null ? this.qtype.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A list of the rules that you have defined.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-firewallrulegroup.html#cfn-route53resolver-firewallrulegroup-firewallrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-firewallrulegroup.html#cfn-route53resolver-firewallrulegroup-firewallrules</a>
         * @param firewallRules A list of the rules that you have defined. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallRules(final software.amazon.awscdk.IResolvable firewallRules) {
            this.props().firewallRules(firewallRules);
            return this;
        }
        /**
         * A list of the rules that you have defined.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-firewallrulegroup.html#cfn-route53resolver-firewallrulegroup-firewallrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-firewallrulegroup.html#cfn-route53resolver-firewallrulegroup-firewallrules</a>
         * @param firewallRules A list of the rules that you have defined. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallRules(final java.util.List<? extends java.lang.Object> firewallRules) {
            this.props().firewallRules(firewallRules);
            return this;
        }

        /**
         * The name of the rule group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-firewallrulegroup.html#cfn-route53resolver-firewallrulegroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-firewallrulegroup.html#cfn-route53resolver-firewallrulegroup-name</a>
         * @param name The name of the rule group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * A list of the tag keys and values that you want to associate with the rule group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-firewallrulegroup.html#cfn-route53resolver-firewallrulegroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-firewallrulegroup.html#cfn-route53resolver-firewallrulegroup-tags</a>
         * @param tags A list of the tag keys and values that you want to associate with the rule group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroup build() {
            return new software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroup(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroupProps.Builder();
            }
            return this.props;
        }
    }
}
