package software.amazon.awscdk.services.s3;

/**
 * The key format for the log object.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket accessLogsBucket = new Bucket(this, "AccessLogsBucket");
 * Bucket bucket = Bucket.Builder.create(this, "MyBucket")
 *         .serverAccessLogsBucket(accessLogsBucket)
 *         .serverAccessLogsPrefix("logs")
 *         // You can use a simple prefix with `TargetObjectKeyFormat.simplePrefix()`, but it is the same even if you do not specify `targetObjectKeyFormat` property.
 *         .targetObjectKeyFormat(TargetObjectKeyFormat.simplePrefix())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:22.355Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.TargetObjectKeyFormat")
public abstract class TargetObjectKeyFormat extends software.amazon.jsii.JsiiObject {

    protected TargetObjectKeyFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TargetObjectKeyFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected TargetObjectKeyFormat() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Use partitioned prefix for log objects. If you do not specify the dateSource argument, the default is EventTime.
     * <p>
     * The partitioned prefix format as follow:
     * [DestinationPrefix][SourceAccountId]/​[SourceRegion]/​[SourceBucket]/​[YYYY]/​[MM]/​[DD]/​[YYYY]-[MM]-[DD]-[hh]-[mm]-[ss]-[UniqueString]
     * <p>
     * @param dateSource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.TargetObjectKeyFormat partitionedPrefix(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.PartitionDateSource dateSource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.TargetObjectKeyFormat.class, "partitionedPrefix", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.TargetObjectKeyFormat.class), new Object[] { dateSource });
    }

    /**
     * Use partitioned prefix for log objects. If you do not specify the dateSource argument, the default is EventTime.
     * <p>
     * The partitioned prefix format as follow:
     * [DestinationPrefix][SourceAccountId]/​[SourceRegion]/​[SourceBucket]/​[YYYY]/​[MM]/​[DD]/​[YYYY]-[MM]-[DD]-[hh]-[mm]-[ss]-[UniqueString]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.TargetObjectKeyFormat partitionedPrefix() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.TargetObjectKeyFormat.class, "partitionedPrefix", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.TargetObjectKeyFormat.class));
    }

    /**
     * Use the simple prefix for log objects.
     * <p>
     * The simple prefix format as follow:
     * [DestinationPrefix][YYYY]-[MM]-[DD]-[hh]-[mm]-[ss]-[UniqueString]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.TargetObjectKeyFormat simplePrefix() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.TargetObjectKeyFormat.class, "simplePrefix", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.TargetObjectKeyFormat.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.s3.TargetObjectKeyFormat {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
