package software.amazon.awscdk.services.scheduler.targets;

/**
 * Properties for scheduling an ECS Fargate Task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecs.*;
 * ICluster cluster;
 * FargateTaskDefinition taskDefinition;
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.minutes(60)))
 *         .target(EcsRunFargateTask.Builder.create(cluster)
 *                 .taskDefinition(taskDefinition)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:22.966Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler_targets.FargateTaskProps")
@software.amazon.jsii.Jsii.Proxy(FargateTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FargateTaskProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.scheduler.targets.EcsRunTaskBaseProps {

    /**
     * Specifies whether the task's elastic network interface receives a public IP address.
     * <p>
     * If true, the task will receive a public IP address and be accessible from the internet.
     * Should only be set to true when using public subnets.
     * <p>
     * Default: - true if the subnet type is PUBLIC, otherwise false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssignPublicIp() {
        return null;
    }

    /**
     * Specifies the platform version for the task.
     * <p>
     * Specify only the numeric portion of the platform version, such as 1.1.0.
     * Platform versions determine the underlying runtime environment for the task.
     * <p>
     * Default: - LATEST
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FargateTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FargateTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FargateTaskProps> {
        java.lang.Boolean assignPublicIp;
        software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies;
        java.lang.Boolean enableEcsManagedTags;
        java.lang.Boolean enableExecuteCommand;
        java.lang.String group;
        java.lang.Boolean propagateTags;
        java.lang.String referenceId;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        java.util.List<software.amazon.awscdk.services.scheduler.targets.Tag> tags;
        java.lang.Number taskCount;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        software.amazon.awscdk.services.scheduler.ScheduleTargetInput input;
        software.amazon.awscdk.Duration maxEventAge;
        java.lang.Number retryAttempts;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link FargateTaskProps#getAssignPublicIp}
         * @param assignPublicIp Specifies whether the task's elastic network interface receives a public IP address.
         *                       If true, the task will receive a public IP address and be accessible from the internet.
         *                       Should only be set to true when using public subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignPublicIp(java.lang.Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getPlatformVersion}
         * @param platformVersion Specifies the platform version for the task.
         *                        Specify only the numeric portion of the platform version, such as 1.1.0.
         *                        Platform versions determine the underlying runtime environment for the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getTaskDefinition}
         * @param taskDefinition The task definition to use for scheduled tasks. This parameter is required.
         *                       Note: this must be TaskDefinition, and not ITaskDefinition,
         *                       as it requires properties that are not known for imported task definitions
         *                       If you want to run a RunTask with an imported task definition,
         *                       consider using a Universal target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getCapacityProviderStrategies}
         * @param capacityProviderStrategies The capacity provider strategy to use for the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder capacityProviderStrategies(java.util.List<? extends software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies) {
            this.capacityProviderStrategies = (java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy>)capacityProviderStrategies;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getEnableExecuteCommand}
         * @param enableExecuteCommand Whether to enable execute command functionality for the containers in this task.
         *                             If true, this enables execute command functionality on all containers in the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(java.lang.Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getGroup}
         * @param group Specifies an ECS task group for the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder group(java.lang.String group) {
            this.group = group;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition to the task.
         *                      If no value is specified, the tags are not propagated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(java.lang.Boolean propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getReferenceId}
         * @param referenceId The reference ID to use for the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder referenceId(java.lang.String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getSecurityGroups}
         * @param securityGroups The security groups associated with the task.
         *                       These security groups must all be in the same VPC.
         *                       Controls inbound and outbound network access for the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getTags}
         * @param tags The metadata that you apply to the task to help you categorize and organize them.
         *             Each tag consists of a key and an optional value, both of which you define.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.scheduler.targets.Tag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.scheduler.targets.Tag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getTaskCount}
         * @param taskCount The number of tasks to create based on TaskDefinition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskCount(java.lang.Number taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getVpcSubnets}
         * @param vpcSubnets The subnets associated with the task.
         *                   These subnets must all be in the same VPC.
         *                   The task will be launched in these subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getDeadLetterQueue}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue.
         *                        The events not successfully delivered are automatically retried for a specified period of time,
         *                        depending on the retry policy of the target.
         *                        If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getInput}
         * @param input Input passed to the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.services.scheduler.ScheduleTargetInput input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Scheduler sends to a target for processing.
         *                    Minimum value of 60.
         *                    Maximum value of 86400.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the target returns an error.
         *                      Minimum value of 0.
         *                      Maximum value of 185.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link FargateTaskProps#getRole}
         * @param role An execution role is an IAM role that EventBridge Scheduler assumes in order to interact with other AWS services on your behalf.
         *             If none provided templates target will automatically create an IAM role with all the minimum necessary
         *             permissions to interact with the templated target. If you wish you may specify your own IAM role, then the templated targets
         *             will grant minimal required permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FargateTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FargateTaskProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FargateTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FargateTaskProps {
        private final java.lang.Boolean assignPublicIp;
        private final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        private final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        private final java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies;
        private final java.lang.Boolean enableEcsManagedTags;
        private final java.lang.Boolean enableExecuteCommand;
        private final java.lang.String group;
        private final java.lang.Boolean propagateTags;
        private final java.lang.String referenceId;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.util.List<software.amazon.awscdk.services.scheduler.targets.Tag> tags;
        private final java.lang.Number taskCount;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final software.amazon.awscdk.services.scheduler.ScheduleTargetInput input;
        private final software.amazon.awscdk.Duration maxEventAge;
        private final java.lang.Number retryAttempts;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargatePlatformVersion.class));
            this.taskDefinition = software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.TaskDefinition.class));
            this.capacityProviderStrategies = software.amazon.jsii.Kernel.get(this, "capacityProviderStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CapacityProviderStrategy.class)));
            this.enableEcsManagedTags = software.amazon.jsii.Kernel.get(this, "enableEcsManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableExecuteCommand = software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.group = software.amazon.jsii.Kernel.get(this, "group", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.referenceId = software.amazon.jsii.Kernel.get(this, "referenceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.targets.Tag.class)));
            this.taskCount = software.amazon.jsii.Kernel.get(this, "taskCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleTargetInput.class));
            this.maxEventAge = software.amazon.jsii.Kernel.get(this, "maxEventAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assignPublicIp = builder.assignPublicIp;
            this.platformVersion = builder.platformVersion;
            this.taskDefinition = java.util.Objects.requireNonNull(builder.taskDefinition, "taskDefinition is required");
            this.capacityProviderStrategies = (java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy>)builder.capacityProviderStrategies;
            this.enableEcsManagedTags = builder.enableEcsManagedTags;
            this.enableExecuteCommand = builder.enableExecuteCommand;
            this.group = builder.group;
            this.propagateTags = builder.propagateTags;
            this.referenceId = builder.referenceId;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.tags = (java.util.List<software.amazon.awscdk.services.scheduler.targets.Tag>)builder.tags;
            this.taskCount = builder.taskCount;
            this.vpcSubnets = builder.vpcSubnets;
            this.deadLetterQueue = builder.deadLetterQueue;
            this.input = builder.input;
            this.maxEventAge = builder.maxEventAge;
            this.retryAttempts = builder.retryAttempts;
            this.role = builder.role;
        }

        @Override
        public final java.lang.Boolean getAssignPublicIp() {
            return this.assignPublicIp;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> getCapacityProviderStrategies() {
            return this.capacityProviderStrategies;
        }

        @Override
        public final java.lang.Boolean getEnableEcsManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public final java.lang.Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        @Override
        public final java.lang.String getGroup() {
            return this.group;
        }

        @Override
        public final java.lang.Boolean getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final java.lang.String getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.scheduler.targets.Tag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getTaskCount() {
            return this.taskCount;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.ScheduleTargetInput getInput() {
            return this.input;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssignPublicIp() != null) {
                data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
            }
            if (this.getPlatformVersion() != null) {
                data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
            }
            data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            if (this.getCapacityProviderStrategies() != null) {
                data.set("capacityProviderStrategies", om.valueToTree(this.getCapacityProviderStrategies()));
            }
            if (this.getEnableEcsManagedTags() != null) {
                data.set("enableEcsManagedTags", om.valueToTree(this.getEnableEcsManagedTags()));
            }
            if (this.getEnableExecuteCommand() != null) {
                data.set("enableExecuteCommand", om.valueToTree(this.getEnableExecuteCommand()));
            }
            if (this.getGroup() != null) {
                data.set("group", om.valueToTree(this.getGroup()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getReferenceId() != null) {
                data.set("referenceId", om.valueToTree(this.getReferenceId()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTaskCount() != null) {
                data.set("taskCount", om.valueToTree(this.getTaskCount()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler_targets.FargateTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FargateTaskProps.Jsii$Proxy that = (FargateTaskProps.Jsii$Proxy) o;

            if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
            if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) return false;
            if (!taskDefinition.equals(that.taskDefinition)) return false;
            if (this.capacityProviderStrategies != null ? !this.capacityProviderStrategies.equals(that.capacityProviderStrategies) : that.capacityProviderStrategies != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.enableExecuteCommand != null ? !this.enableExecuteCommand.equals(that.enableExecuteCommand) : that.enableExecuteCommand != null) return false;
            if (this.group != null ? !this.group.equals(that.group) : that.group != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.referenceId != null ? !this.referenceId.equals(that.referenceId) : that.referenceId != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.taskCount != null ? !this.taskCount.equals(that.taskCount) : that.taskCount != null) return false;
            if (this.vpcSubnets != null ? !this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            if (this.retryAttempts != null ? !this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0;
            result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
            result = 31 * result + (this.taskDefinition.hashCode());
            result = 31 * result + (this.capacityProviderStrategies != null ? this.capacityProviderStrategies.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.enableExecuteCommand != null ? this.enableExecuteCommand.hashCode() : 0);
            result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.referenceId != null ? this.referenceId.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.taskCount != null ? this.taskCount.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
