package software.amazon.awscdk.services.secretsmanager;

/**
 * Construction properties for a SecretRotation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Secret myUserSecret;
 * Secret myMasterSecret;
 * IConnectable myDatabase;
 * Vpc myVpc;
 * SecretRotation.Builder.create(this, "SecretRotation")
 *         .application(SecretRotationApplication.MYSQL_ROTATION_MULTI_USER)
 *         .secret(myUserSecret) // The secret that will be rotated
 *         .masterSecret(myMasterSecret) // The secret used for the rotation
 *         .target(myDatabase)
 *         .vpc(myVpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:23.025Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.SecretRotationProps")
@software.amazon.jsii.Jsii.Proxy(SecretRotationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecretRotationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The serverless application for the rotation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getApplication();

    /**
     * The secret to rotate. It must be a JSON string with the following format:.
     * <p>
     * <blockquote><pre>
     * {
     *   "engine": &lt;required: database engine&gt;,
     *   "host": &lt;required: instance host name&gt;,
     *   "username": &lt;required: username&gt;,
     *   "password": &lt;required: password&gt;,
     *   "dbname": &lt;optional: database name&gt;,
     *   "port": &lt;optional: if not specified, default port will be used&gt;,
     *   "masterarn": &lt;required for multi user rotation: the arn of the master secret which will be used to create users/change passwords&gt;
     * }
     * </pre></blockquote>
     * <p>
     * This is typically the case for a secret referenced from an <code>AWS::SecretsManager::SecretTargetAttachment</code>
     * or an <code>ISecret</code> returned by the <code>attach()</code> method of <code>Secret</code>.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secrettargetattachment.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secrettargetattachment.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret getSecret();

    /**
     * The target service or database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable getTarget();

    /**
     * The VPC where the Lambda rotation function will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     * <p>
     * Default: Duration.days(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getAutomaticallyAfter() {
        return null;
    }

    /**
     * The VPC interface endpoint to use for the Secrets Manager API.
     * <p>
     * If you enable private DNS hostnames for your VPC private endpoint (the default), you don't
     * need to specify an endpoint. The standard Secrets Manager DNS hostname the Secrets Manager
     * CLI and SDKs use by default (https://secretsmanager.<region>.amazonaws.com) automatically
     * resolves to your VPC endpoint.
     * <p>
     * Default: https://secretsmanager.<region>.amazonaws.com
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint getEndpoint() {
        return null;
    }

    /**
     * Characters which should not appear in the generated password.
     * <p>
     * Default: - no additional characters are explicitly excluded
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters() {
        return null;
    }

    /**
     * The master secret for a multi user rotation scheme.
     * <p>
     * Default: - single user rotation scheme
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getMasterSecret() {
        return null;
    }

    /**
     * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRotateImmediatelyOnUpdate() {
        return null;
    }

    /**
     * The security group for the Lambda rotation function.
     * <p>
     * Default: - a new security group is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * The type of subnets in the VPC where the Lambda rotation function will run.
     * <p>
     * Default: - the Vpc default strategy if not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecretRotationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecretRotationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecretRotationProps> {
        software.amazon.awscdk.services.secretsmanager.SecretRotationApplication application;
        software.amazon.awscdk.services.secretsmanager.ISecret secret;
        software.amazon.awscdk.services.ec2.IConnectable target;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.Duration automaticallyAfter;
        software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint endpoint;
        java.lang.String excludeCharacters;
        software.amazon.awscdk.services.secretsmanager.ISecret masterSecret;
        java.lang.Boolean rotateImmediatelyOnUpdate;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link SecretRotationProps#getApplication}
         * @param application The serverless application for the rotation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication application) {
            this.application = application;
            return this;
        }

        /**
         * Sets the value of {@link SecretRotationProps#getSecret}
         * @param secret The secret to rotate. It must be a JSON string with the following format:. This parameter is required.
         *               <blockquote><pre>
         *               {
         *                 "engine": &lt;required: database engine&gt;,
         *                 "host": &lt;required: instance host name&gt;,
         *                 "username": &lt;required: username&gt;,
         *                 "password": &lt;required: password&gt;,
         *                 "dbname": &lt;optional: database name&gt;,
         *                 "port": &lt;optional: if not specified, default port will be used&gt;,
         *                 "masterarn": &lt;required for multi user rotation: the arn of the master secret which will be used to create users/change passwords&gt;
         *               }
         *               </pre></blockquote>
         *               <p>
         *               This is typically the case for a secret referenced from an <code>AWS::SecretsManager::SecretTargetAttachment</code>
         *               or an <code>ISecret</code> returned by the <code>attach()</code> method of <code>Secret</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.secret = secret;
            return this;
        }

        /**
         * Sets the value of {@link SecretRotationProps#getTarget}
         * @param target The target service or database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.services.ec2.IConnectable target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link SecretRotationProps#getVpc}
         * @param vpc The VPC where the Lambda rotation function will run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link SecretRotationProps#getAutomaticallyAfter}
         * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticallyAfter(software.amazon.awscdk.Duration automaticallyAfter) {
            this.automaticallyAfter = automaticallyAfter;
            return this;
        }

        /**
         * Sets the value of {@link SecretRotationProps#getEndpoint}
         * @param endpoint The VPC interface endpoint to use for the Secrets Manager API.
         *                 If you enable private DNS hostnames for your VPC private endpoint (the default), you don't
         *                 need to specify an endpoint. The standard Secrets Manager DNS hostname the Secrets Manager
         *                 CLI and SDKs use by default (https://secretsmanager.<region>.amazonaws.com) automatically
         *                 resolves to your VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link SecretRotationProps#getExcludeCharacters}
         * @param excludeCharacters Characters which should not appear in the generated password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeCharacters(java.lang.String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
            return this;
        }

        /**
         * Sets the value of {@link SecretRotationProps#getMasterSecret}
         * @param masterSecret The master secret for a multi user rotation scheme.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterSecret(software.amazon.awscdk.services.secretsmanager.ISecret masterSecret) {
            this.masterSecret = masterSecret;
            return this;
        }

        /**
         * Sets the value of {@link SecretRotationProps#getRotateImmediatelyOnUpdate}
         * @param rotateImmediatelyOnUpdate Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateImmediatelyOnUpdate(java.lang.Boolean rotateImmediatelyOnUpdate) {
            this.rotateImmediatelyOnUpdate = rotateImmediatelyOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link SecretRotationProps#getSecurityGroup}
         * @param securityGroup The security group for the Lambda rotation function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link SecretRotationProps#getVpcSubnets}
         * @param vpcSubnets The type of subnets in the VPC where the Lambda rotation function will run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecretRotationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecretRotationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecretRotationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretRotationProps {
        private final software.amazon.awscdk.services.secretsmanager.SecretRotationApplication application;
        private final software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private final software.amazon.awscdk.services.ec2.IConnectable target;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.Duration automaticallyAfter;
        private final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint endpoint;
        private final java.lang.String excludeCharacters;
        private final software.amazon.awscdk.services.secretsmanager.ISecret masterSecret;
        private final java.lang.Boolean rotateImmediatelyOnUpdate;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.application = software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
            this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IConnectable.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.automaticallyAfter = software.amazon.jsii.Kernel.get(this, "automaticallyAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint.class));
            this.excludeCharacters = software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterSecret = software.amazon.jsii.Kernel.get(this, "masterSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.rotateImmediatelyOnUpdate = software.amazon.jsii.Kernel.get(this, "rotateImmediatelyOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.application = java.util.Objects.requireNonNull(builder.application, "application is required");
            this.secret = java.util.Objects.requireNonNull(builder.secret, "secret is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.automaticallyAfter = builder.automaticallyAfter;
            this.endpoint = builder.endpoint;
            this.excludeCharacters = builder.excludeCharacters;
            this.masterSecret = builder.masterSecret;
            this.rotateImmediatelyOnUpdate = builder.rotateImmediatelyOnUpdate;
            this.securityGroup = builder.securityGroup;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getApplication() {
            return this.application;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return this.secret;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IConnectable getTarget() {
            return this.target;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.Duration getAutomaticallyAfter() {
            return this.automaticallyAfter;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final java.lang.String getExcludeCharacters() {
            return this.excludeCharacters;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getMasterSecret() {
            return this.masterSecret;
        }

        @Override
        public final java.lang.Boolean getRotateImmediatelyOnUpdate() {
            return this.rotateImmediatelyOnUpdate;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("application", om.valueToTree(this.getApplication()));
            data.set("secret", om.valueToTree(this.getSecret()));
            data.set("target", om.valueToTree(this.getTarget()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAutomaticallyAfter() != null) {
                data.set("automaticallyAfter", om.valueToTree(this.getAutomaticallyAfter()));
            }
            if (this.getEndpoint() != null) {
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
            }
            if (this.getExcludeCharacters() != null) {
                data.set("excludeCharacters", om.valueToTree(this.getExcludeCharacters()));
            }
            if (this.getMasterSecret() != null) {
                data.set("masterSecret", om.valueToTree(this.getMasterSecret()));
            }
            if (this.getRotateImmediatelyOnUpdate() != null) {
                data.set("rotateImmediatelyOnUpdate", om.valueToTree(this.getRotateImmediatelyOnUpdate()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.SecretRotationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecretRotationProps.Jsii$Proxy that = (SecretRotationProps.Jsii$Proxy) o;

            if (!application.equals(that.application)) return false;
            if (!secret.equals(that.secret)) return false;
            if (!target.equals(that.target)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.automaticallyAfter != null ? !this.automaticallyAfter.equals(that.automaticallyAfter) : that.automaticallyAfter != null) return false;
            if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) return false;
            if (this.excludeCharacters != null ? !this.excludeCharacters.equals(that.excludeCharacters) : that.excludeCharacters != null) return false;
            if (this.masterSecret != null ? !this.masterSecret.equals(that.masterSecret) : that.masterSecret != null) return false;
            if (this.rotateImmediatelyOnUpdate != null ? !this.rotateImmediatelyOnUpdate.equals(that.rotateImmediatelyOnUpdate) : that.rotateImmediatelyOnUpdate != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.application.hashCode();
            result = 31 * result + (this.secret.hashCode());
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.automaticallyAfter != null ? this.automaticallyAfter.hashCode() : 0);
            result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
            result = 31 * result + (this.excludeCharacters != null ? this.excludeCharacters.hashCode() : 0);
            result = 31 * result + (this.masterSecret != null ? this.masterSecret.hashCode() : 0);
            result = 31 * result + (this.rotateImmediatelyOnUpdate != null ? this.rotateImmediatelyOnUpdate.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
