package software.amazon.awscdk.services.servicecatalog;

/**
 * Defines the provisioning template constraints.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * Portfolio portfolio;
 * CloudFormationProduct product;
 * portfolio.constrainCloudFormationParameters(product, CloudFormationRuleConstraintOptions.builder()
 *         .rule(TemplateRule.builder()
 *                 .ruleName("testInstanceType")
 *                 .condition(Fn.conditionEquals(Fn.ref("Environment"), "test"))
 *                 .assertions(List.of(TemplateRuleAssertion.builder()
 *                         .assert(Fn.conditionContains(List.of("t2.micro", "t2.small"), Fn.ref("InstanceType")))
 *                         .description("For test environment, the instance type should be small")
 *                         .build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:23.236Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.TemplateRule")
@software.amazon.jsii.Jsii.Proxy(TemplateRule.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TemplateRule extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of assertions that make up the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.servicecatalog.TemplateRuleAssertion> getAssertions();

    /**
     * Name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleName();

    /**
     * Specify when to apply rule with a rule-specific intrinsic function.
     * <p>
     * Default: - no rule condition provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.ICfnRuleConditionExpression getCondition() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TemplateRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TemplateRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TemplateRule> {
        java.util.List<software.amazon.awscdk.services.servicecatalog.TemplateRuleAssertion> assertions;
        java.lang.String ruleName;
        software.amazon.awscdk.ICfnRuleConditionExpression condition;

        /**
         * Sets the value of {@link TemplateRule#getAssertions}
         * @param assertions A list of assertions that make up the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assertions(java.util.List<? extends software.amazon.awscdk.services.servicecatalog.TemplateRuleAssertion> assertions) {
            this.assertions = (java.util.List<software.amazon.awscdk.services.servicecatalog.TemplateRuleAssertion>)assertions;
            return this;
        }

        /**
         * Sets the value of {@link TemplateRule#getRuleName}
         * @param ruleName Name of the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Sets the value of {@link TemplateRule#getCondition}
         * @param condition Specify when to apply rule with a rule-specific intrinsic function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder condition(software.amazon.awscdk.ICfnRuleConditionExpression condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TemplateRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TemplateRule build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TemplateRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateRule {
        private final java.util.List<software.amazon.awscdk.services.servicecatalog.TemplateRuleAssertion> assertions;
        private final java.lang.String ruleName;
        private final software.amazon.awscdk.ICfnRuleConditionExpression condition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assertions = software.amazon.jsii.Kernel.get(this, "assertions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.TemplateRuleAssertion.class)));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ICfnRuleConditionExpression.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assertions = (java.util.List<software.amazon.awscdk.services.servicecatalog.TemplateRuleAssertion>)java.util.Objects.requireNonNull(builder.assertions, "assertions is required");
            this.ruleName = java.util.Objects.requireNonNull(builder.ruleName, "ruleName is required");
            this.condition = builder.condition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.servicecatalog.TemplateRuleAssertion> getAssertions() {
            return this.assertions;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final software.amazon.awscdk.ICfnRuleConditionExpression getCondition() {
            return this.condition;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assertions", om.valueToTree(this.getAssertions()));
            data.set("ruleName", om.valueToTree(this.getRuleName()));
            if (this.getCondition() != null) {
                data.set("condition", om.valueToTree(this.getCondition()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicecatalog.TemplateRule"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TemplateRule.Jsii$Proxy that = (TemplateRule.Jsii$Proxy) o;

            if (!assertions.equals(that.assertions)) return false;
            if (!ruleName.equals(that.ruleName)) return false;
            return this.condition != null ? this.condition.equals(that.condition) : that.condition == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assertions.hashCode();
            result = 31 * result + (this.ruleName.hashCode());
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            return result;
        }
    }
}
