package software.amazon.awscdk.services.servicediscovery;

/**
 * Define a CloudMap Service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * PublicDnsNamespace namespace = PublicDnsNamespace.Builder.create(stack, "Namespace")
 *         .name("foobar.com")
 *         .build();
 * Service service = namespace.createService("Service", DnsServiceProps.builder()
 *         .name("foo")
 *         .dnsRecordType(DnsRecordType.A)
 *         .dnsTtl(Duration.seconds(30))
 *         .healthCheck(HealthCheckConfig.builder()
 *                 .type(HealthCheckType.HTTPS)
 *                 .resourcePath("/healthcheck")
 *                 .failureThreshold(2)
 *                 .build())
 *         .build());
 * service.registerIpInstance("IpInstance", IpInstanceBaseProps.builder()
 *         .ipv4("54.239.25.192")
 *         .port(443)
 *         .build());
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:23.291Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.Service")
public class Service extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.servicediscovery.IService {

    protected Service(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Service(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.servicediscovery.Service.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Service(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.ServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService fromServiceAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.ServiceAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.servicediscovery.Service.class, "fromServiceAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IService.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Registers a resource that is accessible using a CNAME.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IInstance registerCnameInstance(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.CnameInstanceBaseProps props) {
        return software.amazon.jsii.Kernel.call(this, "registerCnameInstance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IInstance.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Registers a resource that is accessible using an IP address.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IInstance registerIpInstance(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IpInstanceBaseProps props) {
        return software.amazon.jsii.Kernel.call(this, "registerIpInstance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IInstance.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Registers an ELB as a new instance with unique name instanceId in this service.
     * <p>
     * @param id This parameter is required.
     * @param loadBalancer This parameter is required.
     * @param customAttributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IInstance registerLoadBalancer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ILoadBalancerV2 loadBalancer, final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> customAttributes) {
        return software.amazon.jsii.Kernel.call(this, "registerLoadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IInstance.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required"), customAttributes });
    }

    /**
     * Registers an ELB as a new instance with unique name instanceId in this service.
     * <p>
     * @param id This parameter is required.
     * @param loadBalancer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IInstance registerLoadBalancer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ILoadBalancerV2 loadBalancer) {
        return software.amazon.jsii.Kernel.call(this, "registerLoadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IInstance.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * Registers a resource that is accessible using values other than an IP address or a domain name (CNAME).
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IInstance registerNonIpInstance(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.NonIpInstanceBaseProps props) {
        return software.amazon.jsii.Kernel.call(this, "registerNonIpInstance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IInstance.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The discovery type used by this service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.DiscoveryType getDiscoveryType() {
        return software.amazon.jsii.Kernel.get(this, "discoveryType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.DiscoveryType.class));
    }

    /**
     * The DnsRecordType used by the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.DnsRecordType getDnsRecordType() {
        return software.amazon.jsii.Kernel.get(this, "dnsRecordType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.DnsRecordType.class));
    }

    /**
     * The namespace for the Cloudmap Service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.INamespace getNamespace() {
        return software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.INamespace.class));
    }

    /**
     * The Routing Policy used by the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.RoutingPolicy getRoutingPolicy() {
        return software.amazon.jsii.Kernel.get(this, "routingPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.RoutingPolicy.class));
    }

    /**
     * The Arn of the namespace that you want to use for DNS configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the namespace that you want to use for DNS configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceId() {
        return software.amazon.jsii.Kernel.get(this, "serviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the Cloudmap Service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceName() {
        return software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicediscovery.Service}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicediscovery.Service> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicediscovery.ServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicediscovery.ServiceProps.Builder();
        }

        /**
         * Structure containing failure threshold for a custom health checker.
         * <p>
         * Only one of healthCheckConfig or healthCheckCustomConfig can be specified.
         * See: https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param customHealthCheck Structure containing failure threshold for a custom health checker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHealthCheck(final software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck) {
            this.props.customHealthCheck(customHealthCheck);
            return this;
        }

        /**
         * A description of the service.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param description A description of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Settings for an optional health check.
         * <p>
         * If you specify health check settings, AWS Cloud Map associates the health
         * check with the records that you specify in DnsConfig. Only one of healthCheckConfig or healthCheckCustomConfig can
         * be specified. Not valid for PrivateDnsNamespaces. If you use healthCheck, you can only register IP instances to
         * this service.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param healthCheck Settings for an optional health check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * A name for the Service.
         * <p>
         * Default: CloudFormation-generated name
         * <p>
         * @return {@code this}
         * @param name A name for the Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Controls how instances within this service can be discovered.
         * <p>
         * Default: DNS_AND_API
         * <p>
         * @return {@code this}
         * @param discoveryType Controls how instances within this service can be discovered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder discoveryType(final software.amazon.awscdk.services.servicediscovery.DiscoveryType discoveryType) {
            this.props.discoveryType(discoveryType);
            return this;
        }

        /**
         * The DNS type of the record that you want AWS Cloud Map to create.
         * <p>
         * Supported record types
         * include A, AAAA, A and AAAA (A_AAAA), CNAME, and SRV.
         * <p>
         * Default: A
         * <p>
         * @return {@code this}
         * @param dnsRecordType The DNS type of the record that you want AWS Cloud Map to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsRecordType(final software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType) {
            this.props.dnsRecordType(dnsRecordType);
            return this;
        }

        /**
         * The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.
         * <p>
         * Default: Duration.minutes(1)
         * <p>
         * @return {@code this}
         * @param dnsTtl The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsTtl(final software.amazon.awscdk.Duration dnsTtl) {
            this.props.dnsTtl(dnsTtl);
            return this;
        }

        /**
         * Whether or not this service will have an Elastic LoadBalancer registered to it as an AliasTargetInstance.
         * <p>
         * Setting this to <code>true</code> correctly configures the <code>routingPolicy</code>
         * and performs some additional validation.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param loadBalancer Whether or not this service will have an Elastic LoadBalancer registered to it as an AliasTargetInstance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(final java.lang.Boolean loadBalancer) {
            this.props.loadBalancer(loadBalancer);
            return this;
        }

        /**
         * The routing policy that you want to apply to all DNS records that AWS Cloud Map creates when you register an instance and specify this service.
         * <p>
         * Default: WEIGHTED for CNAME records and when loadBalancer is true, MULTIVALUE otherwise
         * <p>
         * @return {@code this}
         * @param routingPolicy The routing policy that you want to apply to all DNS records that AWS Cloud Map creates when you register an instance and specify this service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingPolicy(final software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy) {
            this.props.routingPolicy(routingPolicy);
            return this;
        }

        /**
         * The namespace that you want to use for DNS configuration.
         * <p>
         * @return {@code this}
         * @param namespace The namespace that you want to use for DNS configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(final software.amazon.awscdk.services.servicediscovery.INamespace namespace) {
            this.props.namespace(namespace);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.servicediscovery.Service}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicediscovery.Service build() {
            return new software.amazon.awscdk.services.servicediscovery.Service(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
