package software.amazon.awscdk.services.ssm;

/**
 * The <code>AWS::SSM::PatchBaseline</code> resource defines the basic information for an AWS Systems Manager patch baseline.
 * <p>
 * A patch baseline defines which patches are approved for installation on your instances.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreatePatchBaseline.html">CreatePatchBaseline</a> in the <em>AWS Systems Manager API Reference</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssm.*;
 * CfnPatchBaseline cfnPatchBaseline = CfnPatchBaseline.Builder.create(this, "MyCfnPatchBaseline")
 *         .name("name")
 *         // the properties below are optional
 *         .approvalRules(RuleGroupProperty.builder()
 *                 .patchRules(List.of(RuleProperty.builder()
 *                         .approveAfterDays(123)
 *                         .approveUntilDate("approveUntilDate")
 *                         .complianceLevel("complianceLevel")
 *                         .enableNonSecurity(false)
 *                         .patchFilterGroup(PatchFilterGroupProperty.builder()
 *                                 .patchFilters(List.of(PatchFilterProperty.builder()
 *                                         .key("key")
 *                                         .values(List.of("values"))
 *                                         .build()))
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .approvedPatches(List.of("approvedPatches"))
 *         .approvedPatchesComplianceLevel("approvedPatchesComplianceLevel")
 *         .approvedPatchesEnableNonSecurity(false)
 *         .defaultBaseline(false)
 *         .description("description")
 *         .globalFilters(PatchFilterGroupProperty.builder()
 *                 .patchFilters(List.of(PatchFilterProperty.builder()
 *                         .key("key")
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .build())
 *         .operatingSystem("operatingSystem")
 *         .patchGroups(List.of("patchGroups"))
 *         .rejectedPatches(List.of("rejectedPatches"))
 *         .rejectedPatchesAction("rejectedPatchesAction")
 *         .sources(List.of(PatchSourceProperty.builder()
 *                 .configuration("configuration")
 *                 .name("name")
 *                 .products(List.of("products"))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:23.618Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnPatchBaseline")
public class CfnPatchBaseline extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnPatchBaseline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPatchBaseline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ssm.CfnPatchBaseline.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPatchBaseline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.CfnPatchBaselineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the patch baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the patch baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the patch baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A set of rules used to include patches in the baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApprovalRules() {
        return software.amazon.jsii.Kernel.get(this, "approvalRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of rules used to include patches in the baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovalRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "approvalRules", value);
    }

    /**
     * A set of rules used to include patches in the baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovalRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.CfnPatchBaseline.RuleGroupProperty value) {
        software.amazon.jsii.Kernel.set(this, "approvalRules", value);
    }

    /**
     * A list of explicitly approved patches for the baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getApprovedPatches() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "approvedPatches", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of explicitly approved patches for the baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovedPatches(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "approvedPatches", value);
    }

    /**
     * Defines the compliance level for approved patches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApprovedPatchesComplianceLevel() {
        return software.amazon.jsii.Kernel.get(this, "approvedPatchesComplianceLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Defines the compliance level for approved patches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovedPatchesComplianceLevel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "approvedPatchesComplianceLevel", value);
    }

    /**
     * Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApprovedPatchesEnableNonSecurity() {
        return software.amazon.jsii.Kernel.get(this, "approvedPatchesEnableNonSecurity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovedPatchesEnableNonSecurity(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "approvedPatchesEnableNonSecurity", value);
    }

    /**
     * Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovedPatchesEnableNonSecurity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "approvedPatchesEnableNonSecurity", value);
    }

    /**
     * Indicates whether this is the default baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultBaseline() {
        return software.amazon.jsii.Kernel.get(this, "defaultBaseline", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether this is the default baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultBaseline(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "defaultBaseline", value);
    }

    /**
     * Indicates whether this is the default baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultBaseline(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultBaseline", value);
    }

    /**
     * A description of the patch baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the patch baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * A set of global filters used to include patches in the baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGlobalFilters() {
        return software.amazon.jsii.Kernel.get(this, "globalFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of global filters used to include patches in the baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalFilters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "globalFilters", value);
    }

    /**
     * A set of global filters used to include patches in the baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalFilters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.CfnPatchBaseline.PatchFilterGroupProperty value) {
        software.amazon.jsii.Kernel.set(this, "globalFilters", value);
    }

    /**
     * Defines the operating system the patch baseline applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOperatingSystem() {
        return software.amazon.jsii.Kernel.get(this, "operatingSystem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Defines the operating system the patch baseline applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOperatingSystem(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "operatingSystem", value);
    }

    /**
     * The name of the patch group to be registered with the patch baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPatchGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "patchGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The name of the patch group to be registered with the patch baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPatchGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "patchGroups", value);
    }

    /**
     * A list of explicitly rejected patches for the baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRejectedPatches() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "rejectedPatches", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of explicitly rejected patches for the baseline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRejectedPatches(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "rejectedPatches", value);
    }

    /**
     * The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRejectedPatchesAction() {
        return software.amazon.jsii.Kernel.get(this, "rejectedPatchesAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRejectedPatchesAction(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "rejectedPatchesAction", value);
    }

    /**
     * Information about the patches to use to update the managed nodes, including target operating systems and source repositories.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSources() {
        return software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the patches to use to update the managed nodes, including target operating systems and source repositories.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sources", value);
    }

    /**
     * Information about the patches to use to update the managed nodes, including target operating systems and source repositories.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSources(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ssm.CfnPatchBaseline.PatchSourceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ssm.CfnPatchBaseline.PatchSourceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "sources", value);
    }

    /**
     * Optional metadata that you assign to a resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Optional metadata that you assign to a resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The <code>PatchFilterGroup</code> property type specifies a set of patch filters for an AWS Systems Manager patch baseline, typically used for approval rules for a Systems Manager patch baseline.
     * <p>
     * <code>PatchFilterGroup</code> is the property type for the <code>GlobalFilters</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html">AWS::SSM::PatchBaseline</a> resource and the <code>PatchFilterGroup</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html">Rule</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * PatchFilterGroupProperty patchFilterGroupProperty = PatchFilterGroupProperty.builder()
     *         .patchFilters(List.of(PatchFilterProperty.builder()
     *                 .key("key")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfiltergroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfiltergroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnPatchBaseline.PatchFilterGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(PatchFilterGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PatchFilterGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The set of patch filters that make up the group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfiltergroup.html#cfn-ssm-patchbaseline-patchfiltergroup-patchfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfiltergroup.html#cfn-ssm-patchbaseline-patchfiltergroup-patchfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPatchFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PatchFilterGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PatchFilterGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PatchFilterGroupProperty> {
            java.lang.Object patchFilters;

            /**
             * Sets the value of {@link PatchFilterGroupProperty#getPatchFilters}
             * @param patchFilters The set of patch filters that make up the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patchFilters(software.amazon.awscdk.IResolvable patchFilters) {
                this.patchFilters = patchFilters;
                return this;
            }

            /**
             * Sets the value of {@link PatchFilterGroupProperty#getPatchFilters}
             * @param patchFilters The set of patch filters that make up the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patchFilters(java.util.List<? extends java.lang.Object> patchFilters) {
                this.patchFilters = patchFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PatchFilterGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PatchFilterGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PatchFilterGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PatchFilterGroupProperty {
            private final java.lang.Object patchFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.patchFilters = software.amazon.jsii.Kernel.get(this, "patchFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.patchFilters = builder.patchFilters;
            }

            @Override
            public final java.lang.Object getPatchFilters() {
                return this.patchFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPatchFilters() != null) {
                    data.set("patchFilters", om.valueToTree(this.getPatchFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnPatchBaseline.PatchFilterGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PatchFilterGroupProperty.Jsii$Proxy that = (PatchFilterGroupProperty.Jsii$Proxy) o;

                return this.patchFilters != null ? this.patchFilters.equals(that.patchFilters) : that.patchFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.patchFilters != null ? this.patchFilters.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The <code>PatchFilter</code> property type defines a patch filter for an AWS Systems Manager patch baseline.
     * <p>
     * The <code>PatchFilters</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfiltergroup.html">PatchFilterGroup</a> property type contains a list of <code>PatchFilter</code> property types.
     * <p>
     * You can view lists of valid values for the patch properties by running the <code>DescribePatchProperties</code> command. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html">DescribePatchProperties</a> in the <em>AWS Systems Manager API Reference</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * PatchFilterProperty patchFilterProperty = PatchFilterProperty.builder()
     *         .key("key")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnPatchBaseline.PatchFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(PatchFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PatchFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key for the filter.
         * <p>
         * For information about valid keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a> in the <em>AWS Systems Manager API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html#cfn-ssm-patchbaseline-patchfilter-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html#cfn-ssm-patchbaseline-patchfilter-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The value for the filter key.
         * <p>
         * For information about valid values for each key based on operating system type, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a> in the <em>AWS Systems Manager API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html#cfn-ssm-patchbaseline-patchfilter-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html#cfn-ssm-patchbaseline-patchfilter-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PatchFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PatchFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PatchFilterProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link PatchFilterProperty#getKey}
             * @param key The key for the filter.
             *            For information about valid keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a> in the <em>AWS Systems Manager API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link PatchFilterProperty#getValues}
             * @param values The value for the filter key.
             *               For information about valid values for each key based on operating system type, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a> in the <em>AWS Systems Manager API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PatchFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PatchFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PatchFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PatchFilterProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnPatchBaseline.PatchFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PatchFilterProperty.Jsii$Proxy that = (PatchFilterProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>PatchSource</code> is the property type for the <code>Sources</code> resource of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html">AWS::SSM::PatchBaseline</a> resource.
     * <p>
     * The AWS CloudFormation <code>AWS::SSM::PatchSource</code> resource is used to provide information about the patches to use to update target instances, including target operating systems and source repository. Applies to Linux managed nodes only.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * PatchSourceProperty patchSourceProperty = PatchSourceProperty.builder()
     *         .configuration("configuration")
     *         .name("name")
     *         .products(List.of("products"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnPatchBaseline.PatchSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(PatchSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PatchSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value of the repo configuration.
         * <p>
         * <em>Example for yum repositories</em>
         * <p>
         * <code>[main]</code>
         * <p>
         * <code>name=MyCustomRepository</code>
         * <p>
         * <code>baseurl=https://my-custom-repository</code>
         * <p>
         * <code>enabled=1</code>
         * <p>
         * For information about other options available for your yum repository configuration, see <a href="https://docs.aws.amazon.com/https://man7.org/linux/man-pages/man5/dnf.conf.5.html">dnf.conf(5)</a> on the <em>man7.org</em> website.
         * <p>
         * <em>Examples for Ubuntu Server and Debian Server</em>
         * <p>
         * <code>deb http://security.ubuntu.com/ubuntu jammy main</code>
         * <p>
         * <code>deb https://site.example.com/debian distribution component1 component2 component3</code>
         * <p>
         * Repo information for Ubuntu Server repositories must be specifed in a single line. For more examples and information, see <a href="https://docs.aws.amazon.com/https://manpages.ubuntu.com/manpages/jammy/man5/sources.list.5.html">jammy (5) sources.list.5.gz</a> on the <em>Ubuntu Server Manuals</em> website and <a href="https://docs.aws.amazon.com/https://wiki.debian.org/SourcesList#sources.list_format">sources.list format</a> on the <em>Debian Wiki</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConfiguration() {
            return null;
        }

        /**
         * The name specified to identify the patch source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The specific operating system versions a patch repository applies to, such as "Ubuntu16.04", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product values, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a> in the <em>AWS Systems Manager API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-products">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-products</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProducts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PatchSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PatchSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PatchSourceProperty> {
            java.lang.String configuration;
            java.lang.String name;
            java.util.List<java.lang.String> products;

            /**
             * Sets the value of {@link PatchSourceProperty#getConfiguration}
             * @param configuration The value of the repo configuration.
             *                      <em>Example for yum repositories</em>
             *                      <p>
             *                      <code>[main]</code>
             *                      <p>
             *                      <code>name=MyCustomRepository</code>
             *                      <p>
             *                      <code>baseurl=https://my-custom-repository</code>
             *                      <p>
             *                      <code>enabled=1</code>
             *                      <p>
             *                      For information about other options available for your yum repository configuration, see <a href="https://docs.aws.amazon.com/https://man7.org/linux/man-pages/man5/dnf.conf.5.html">dnf.conf(5)</a> on the <em>man7.org</em> website.
             *                      <p>
             *                      <em>Examples for Ubuntu Server and Debian Server</em>
             *                      <p>
             *                      <code>deb http://security.ubuntu.com/ubuntu jammy main</code>
             *                      <p>
             *                      <code>deb https://site.example.com/debian distribution component1 component2 component3</code>
             *                      <p>
             *                      Repo information for Ubuntu Server repositories must be specifed in a single line. For more examples and information, see <a href="https://docs.aws.amazon.com/https://manpages.ubuntu.com/manpages/jammy/man5/sources.list.5.html">jammy (5) sources.list.5.gz</a> on the <em>Ubuntu Server Manuals</em> website and <a href="https://docs.aws.amazon.com/https://wiki.debian.org/SourcesList#sources.list_format">sources.list format</a> on the <em>Debian Wiki</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(java.lang.String configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link PatchSourceProperty#getName}
             * @param name The name specified to identify the patch source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link PatchSourceProperty#getProducts}
             * @param products The specific operating system versions a patch repository applies to, such as "Ubuntu16.04", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product values, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a> in the <em>AWS Systems Manager API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder products(java.util.List<java.lang.String> products) {
                this.products = products;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PatchSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PatchSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PatchSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PatchSourceProperty {
            private final java.lang.String configuration;
            private final java.lang.String name;
            private final java.util.List<java.lang.String> products;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.products = software.amazon.jsii.Kernel.get(this, "products", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configuration = builder.configuration;
                this.name = builder.name;
                this.products = builder.products;
            }

            @Override
            public final java.lang.String getConfiguration() {
                return this.configuration;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getProducts() {
                return this.products;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfiguration() != null) {
                    data.set("configuration", om.valueToTree(this.getConfiguration()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getProducts() != null) {
                    data.set("products", om.valueToTree(this.getProducts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnPatchBaseline.PatchSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PatchSourceProperty.Jsii$Proxy that = (PatchSourceProperty.Jsii$Proxy) o;

                if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.products != null ? this.products.equals(that.products) : that.products == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configuration != null ? this.configuration.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.products != null ? this.products.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>RuleGroup</code> property type specifies a set of rules that define the approval rules for an AWS Systems Manager patch baseline.
     * <p>
     * <code>RuleGroup</code> is the property type for the <code>ApprovalRules</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html">AWS::SSM::PatchBaseline</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * RuleGroupProperty ruleGroupProperty = RuleGroupProperty.builder()
     *         .patchRules(List.of(RuleProperty.builder()
     *                 .approveAfterDays(123)
     *                 .approveUntilDate("approveUntilDate")
     *                 .complianceLevel("complianceLevel")
     *                 .enableNonSecurity(false)
     *                 .patchFilterGroup(PatchFilterGroupProperty.builder()
     *                         .patchFilters(List.of(PatchFilterProperty.builder()
     *                                 .key("key")
     *                                 .values(List.of("values"))
     *                                 .build()))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rulegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rulegroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnPatchBaseline.RuleGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The rules that make up the rule group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rulegroup.html#cfn-ssm-patchbaseline-rulegroup-patchrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rulegroup.html#cfn-ssm-patchbaseline-rulegroup-patchrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPatchRules() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleGroupProperty> {
            java.lang.Object patchRules;

            /**
             * Sets the value of {@link RuleGroupProperty#getPatchRules}
             * @param patchRules The rules that make up the rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patchRules(software.amazon.awscdk.IResolvable patchRules) {
                this.patchRules = patchRules;
                return this;
            }

            /**
             * Sets the value of {@link RuleGroupProperty#getPatchRules}
             * @param patchRules The rules that make up the rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patchRules(java.util.List<? extends java.lang.Object> patchRules) {
                this.patchRules = patchRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleGroupProperty {
            private final java.lang.Object patchRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.patchRules = software.amazon.jsii.Kernel.get(this, "patchRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.patchRules = builder.patchRules;
            }

            @Override
            public final java.lang.Object getPatchRules() {
                return this.patchRules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPatchRules() != null) {
                    data.set("patchRules", om.valueToTree(this.getPatchRules()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnPatchBaseline.RuleGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleGroupProperty.Jsii$Proxy that = (RuleGroupProperty.Jsii$Proxy) o;

                return this.patchRules != null ? this.patchRules.equals(that.patchRules) : that.patchRules == null;
            }

            @Override
            public final int hashCode() {
                int result = this.patchRules != null ? this.patchRules.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The <code>Rule</code> property type specifies an approval rule for a Systems Manager patch baseline.
     * <p>
     * The <code>PatchRules</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rulegroup.html">RuleGroup</a> property type contains a list of <code>Rule</code> property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * RuleProperty ruleProperty = RuleProperty.builder()
     *         .approveAfterDays(123)
     *         .approveUntilDate("approveUntilDate")
     *         .complianceLevel("complianceLevel")
     *         .enableNonSecurity(false)
     *         .patchFilterGroup(PatchFilterGroupProperty.builder()
     *                 .patchFilters(List.of(PatchFilterProperty.builder()
     *                         .key("key")
     *                         .values(List.of("values"))
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnPatchBaseline.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of days after the release date of each patch matched by the rule that the patch is marked as approved in the patch baseline.
         * <p>
         * For example, a value of <code>7</code> means that patches are approved seven days after they are released.
         * <p>
         * This parameter is marked as <code>Required: No</code> , but your request must include a value for either <code>ApproveAfterDays</code> or <code>ApproveUntilDate</code> .
         * <p>
         * Not supported for Debian Server or Ubuntu Server.
         * <p>
         * <blockquote>
         * <p>
         * Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the <em>Windows Server</em> tab in the topic <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html">How security patches are selected</a> in the <em>AWS Systems Manager User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-approveafterdays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-approveafterdays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getApproveAfterDays() {
            return null;
        }

        /**
         * The cutoff date for auto approval of released patches.
         * <p>
         * Any patches released on or before this date are installed automatically.
         * <p>
         * Enter dates in the format <code>YYYY-MM-DD</code> . For example, <code>2024-12-31</code> .
         * <p>
         * This parameter is marked as <code>Required: No</code> , but your request must include a value for either <code>ApproveUntilDate</code> or <code>ApproveAfterDays</code> .
         * <p>
         * Not supported for Debian Server or Ubuntu Server.
         * <p>
         * <blockquote>
         * <p>
         * Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the <em>Windows Server</em> tab in the topic <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html">How security patches are selected</a> in the <em>AWS Systems Manager User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-approveuntildate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-approveuntildate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApproveUntilDate() {
            return null;
        }

        /**
         * A compliance severity level for all approved patches in a patch baseline.
         * <p>
         * Valid compliance severity levels include the following: <code>UNSPECIFIED</code> , <code>CRITICAL</code> , <code>HIGH</code> , <code>MEDIUM</code> , <code>LOW</code> , and <code>INFORMATIONAL</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-compliancelevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-compliancelevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComplianceLevel() {
            return null;
        }

        /**
         * For managed nodes identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository.
         * <p>
         * The default value is <code>false</code> . Applies to Linux managed nodes only.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-enablenonsecurity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-enablenonsecurity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableNonSecurity() {
            return null;
        }

        /**
         * The patch filter group that defines the criteria for the rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-patchfiltergroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-patchfiltergroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPatchFilterGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            java.lang.Number approveAfterDays;
            java.lang.String approveUntilDate;
            java.lang.String complianceLevel;
            java.lang.Object enableNonSecurity;
            java.lang.Object patchFilterGroup;

            /**
             * Sets the value of {@link RuleProperty#getApproveAfterDays}
             * @param approveAfterDays The number of days after the release date of each patch matched by the rule that the patch is marked as approved in the patch baseline.
             *                         For example, a value of <code>7</code> means that patches are approved seven days after they are released.
             *                         <p>
             *                         This parameter is marked as <code>Required: No</code> , but your request must include a value for either <code>ApproveAfterDays</code> or <code>ApproveUntilDate</code> .
             *                         <p>
             *                         Not supported for Debian Server or Ubuntu Server.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the <em>Windows Server</em> tab in the topic <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html">How security patches are selected</a> in the <em>AWS Systems Manager User Guide</em> .
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder approveAfterDays(java.lang.Number approveAfterDays) {
                this.approveAfterDays = approveAfterDays;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getApproveUntilDate}
             * @param approveUntilDate The cutoff date for auto approval of released patches.
             *                         Any patches released on or before this date are installed automatically.
             *                         <p>
             *                         Enter dates in the format <code>YYYY-MM-DD</code> . For example, <code>2024-12-31</code> .
             *                         <p>
             *                         This parameter is marked as <code>Required: No</code> , but your request must include a value for either <code>ApproveUntilDate</code> or <code>ApproveAfterDays</code> .
             *                         <p>
             *                         Not supported for Debian Server or Ubuntu Server.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the <em>Windows Server</em> tab in the topic <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html">How security patches are selected</a> in the <em>AWS Systems Manager User Guide</em> .
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder approveUntilDate(java.lang.String approveUntilDate) {
                this.approveUntilDate = approveUntilDate;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getComplianceLevel}
             * @param complianceLevel A compliance severity level for all approved patches in a patch baseline.
             *                        Valid compliance severity levels include the following: <code>UNSPECIFIED</code> , <code>CRITICAL</code> , <code>HIGH</code> , <code>MEDIUM</code> , <code>LOW</code> , and <code>INFORMATIONAL</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceLevel(java.lang.String complianceLevel) {
                this.complianceLevel = complianceLevel;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getEnableNonSecurity}
             * @param enableNonSecurity For managed nodes identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository.
             *                          The default value is <code>false</code> . Applies to Linux managed nodes only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNonSecurity(java.lang.Boolean enableNonSecurity) {
                this.enableNonSecurity = enableNonSecurity;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getEnableNonSecurity}
             * @param enableNonSecurity For managed nodes identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository.
             *                          The default value is <code>false</code> . Applies to Linux managed nodes only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNonSecurity(software.amazon.awscdk.IResolvable enableNonSecurity) {
                this.enableNonSecurity = enableNonSecurity;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getPatchFilterGroup}
             * @param patchFilterGroup The patch filter group that defines the criteria for the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patchFilterGroup(software.amazon.awscdk.IResolvable patchFilterGroup) {
                this.patchFilterGroup = patchFilterGroup;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getPatchFilterGroup}
             * @param patchFilterGroup The patch filter group that defines the criteria for the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patchFilterGroup(software.amazon.awscdk.services.ssm.CfnPatchBaseline.PatchFilterGroupProperty patchFilterGroup) {
                this.patchFilterGroup = patchFilterGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.lang.Number approveAfterDays;
            private final java.lang.String approveUntilDate;
            private final java.lang.String complianceLevel;
            private final java.lang.Object enableNonSecurity;
            private final java.lang.Object patchFilterGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.approveAfterDays = software.amazon.jsii.Kernel.get(this, "approveAfterDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.approveUntilDate = software.amazon.jsii.Kernel.get(this, "approveUntilDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.complianceLevel = software.amazon.jsii.Kernel.get(this, "complianceLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enableNonSecurity = software.amazon.jsii.Kernel.get(this, "enableNonSecurity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.patchFilterGroup = software.amazon.jsii.Kernel.get(this, "patchFilterGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.approveAfterDays = builder.approveAfterDays;
                this.approveUntilDate = builder.approveUntilDate;
                this.complianceLevel = builder.complianceLevel;
                this.enableNonSecurity = builder.enableNonSecurity;
                this.patchFilterGroup = builder.patchFilterGroup;
            }

            @Override
            public final java.lang.Number getApproveAfterDays() {
                return this.approveAfterDays;
            }

            @Override
            public final java.lang.String getApproveUntilDate() {
                return this.approveUntilDate;
            }

            @Override
            public final java.lang.String getComplianceLevel() {
                return this.complianceLevel;
            }

            @Override
            public final java.lang.Object getEnableNonSecurity() {
                return this.enableNonSecurity;
            }

            @Override
            public final java.lang.Object getPatchFilterGroup() {
                return this.patchFilterGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApproveAfterDays() != null) {
                    data.set("approveAfterDays", om.valueToTree(this.getApproveAfterDays()));
                }
                if (this.getApproveUntilDate() != null) {
                    data.set("approveUntilDate", om.valueToTree(this.getApproveUntilDate()));
                }
                if (this.getComplianceLevel() != null) {
                    data.set("complianceLevel", om.valueToTree(this.getComplianceLevel()));
                }
                if (this.getEnableNonSecurity() != null) {
                    data.set("enableNonSecurity", om.valueToTree(this.getEnableNonSecurity()));
                }
                if (this.getPatchFilterGroup() != null) {
                    data.set("patchFilterGroup", om.valueToTree(this.getPatchFilterGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnPatchBaseline.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (this.approveAfterDays != null ? !this.approveAfterDays.equals(that.approveAfterDays) : that.approveAfterDays != null) return false;
                if (this.approveUntilDate != null ? !this.approveUntilDate.equals(that.approveUntilDate) : that.approveUntilDate != null) return false;
                if (this.complianceLevel != null ? !this.complianceLevel.equals(that.complianceLevel) : that.complianceLevel != null) return false;
                if (this.enableNonSecurity != null ? !this.enableNonSecurity.equals(that.enableNonSecurity) : that.enableNonSecurity != null) return false;
                return this.patchFilterGroup != null ? this.patchFilterGroup.equals(that.patchFilterGroup) : that.patchFilterGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.approveAfterDays != null ? this.approveAfterDays.hashCode() : 0;
                result = 31 * result + (this.approveUntilDate != null ? this.approveUntilDate.hashCode() : 0);
                result = 31 * result + (this.complianceLevel != null ? this.complianceLevel.hashCode() : 0);
                result = 31 * result + (this.enableNonSecurity != null ? this.enableNonSecurity.hashCode() : 0);
                result = 31 * result + (this.patchFilterGroup != null ? this.patchFilterGroup.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ssm.CfnPatchBaseline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ssm.CfnPatchBaseline> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ssm.CfnPatchBaselineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ssm.CfnPatchBaselineProps.Builder();
        }

        /**
         * The name of the patch baseline.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-name</a>
         * @param name The name of the patch baseline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A set of rules used to include patches in the baseline.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvalrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvalrules</a>
         * @param approvalRules A set of rules used to include patches in the baseline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvalRules(final software.amazon.awscdk.IResolvable approvalRules) {
            this.props.approvalRules(approvalRules);
            return this;
        }
        /**
         * A set of rules used to include patches in the baseline.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvalrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvalrules</a>
         * @param approvalRules A set of rules used to include patches in the baseline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvalRules(final software.amazon.awscdk.services.ssm.CfnPatchBaseline.RuleGroupProperty approvalRules) {
            this.props.approvalRules(approvalRules);
            return this;
        }

        /**
         * A list of explicitly approved patches for the baseline.
         * <p>
         * For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">Package name formats for approved and rejected patch lists</a> in the <em>AWS Systems Manager User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatches">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatches</a>
         * @param approvedPatches A list of explicitly approved patches for the baseline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvedPatches(final java.util.List<java.lang.String> approvedPatches) {
            this.props.approvedPatches(approvedPatches);
            return this;
        }

        /**
         * Defines the compliance level for approved patches.
         * <p>
         * When an approved patch is reported as missing, this value describes the severity of the compliance violation. The default value is <code>UNSPECIFIED</code> .
         * <p>
         * Default: - "UNSPECIFIED"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchescompliancelevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchescompliancelevel</a>
         * @param approvedPatchesComplianceLevel Defines the compliance level for approved patches. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvedPatchesComplianceLevel(final java.lang.String approvedPatchesComplianceLevel) {
            this.props.approvedPatchesComplianceLevel(approvedPatchesComplianceLevel);
            return this;
        }

        /**
         * Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes.
         * <p>
         * The default value is <code>false</code> . Applies to Linux managed nodes only.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchesenablenonsecurity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchesenablenonsecurity</a>
         * @param approvedPatchesEnableNonSecurity Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvedPatchesEnableNonSecurity(final java.lang.Boolean approvedPatchesEnableNonSecurity) {
            this.props.approvedPatchesEnableNonSecurity(approvedPatchesEnableNonSecurity);
            return this;
        }
        /**
         * Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes.
         * <p>
         * The default value is <code>false</code> . Applies to Linux managed nodes only.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchesenablenonsecurity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchesenablenonsecurity</a>
         * @param approvedPatchesEnableNonSecurity Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvedPatchesEnableNonSecurity(final software.amazon.awscdk.IResolvable approvedPatchesEnableNonSecurity) {
            this.props.approvedPatchesEnableNonSecurity(approvedPatchesEnableNonSecurity);
            return this;
        }

        /**
         * Indicates whether this is the default baseline.
         * <p>
         * AWS Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-defaultbaseline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-defaultbaseline</a>
         * @param defaultBaseline Indicates whether this is the default baseline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultBaseline(final java.lang.Boolean defaultBaseline) {
            this.props.defaultBaseline(defaultBaseline);
            return this;
        }
        /**
         * Indicates whether this is the default baseline.
         * <p>
         * AWS Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-defaultbaseline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-defaultbaseline</a>
         * @param defaultBaseline Indicates whether this is the default baseline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultBaseline(final software.amazon.awscdk.IResolvable defaultBaseline) {
            this.props.defaultBaseline(defaultBaseline);
            return this;
        }

        /**
         * A description of the patch baseline.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-description</a>
         * @param description A description of the patch baseline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A set of global filters used to include patches in the baseline.
         * <p>
         * <blockquote>
         * <p>
         * The <code>GlobalFilters</code> parameter can be configured only by using the AWS CLI or an AWS SDK. It can't be configured from the Patch Manager console, and its value isn't displayed in the console.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-globalfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-globalfilters</a>
         * @param globalFilters A set of global filters used to include patches in the baseline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalFilters(final software.amazon.awscdk.IResolvable globalFilters) {
            this.props.globalFilters(globalFilters);
            return this;
        }
        /**
         * A set of global filters used to include patches in the baseline.
         * <p>
         * <blockquote>
         * <p>
         * The <code>GlobalFilters</code> parameter can be configured only by using the AWS CLI or an AWS SDK. It can't be configured from the Patch Manager console, and its value isn't displayed in the console.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-globalfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-globalfilters</a>
         * @param globalFilters A set of global filters used to include patches in the baseline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalFilters(final software.amazon.awscdk.services.ssm.CfnPatchBaseline.PatchFilterGroupProperty globalFilters) {
            this.props.globalFilters(globalFilters);
            return this;
        }

        /**
         * Defines the operating system the patch baseline applies to.
         * <p>
         * The default value is <code>WINDOWS</code> .
         * <p>
         * Default: - "WINDOWS"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-operatingsystem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-operatingsystem</a>
         * @param operatingSystem Defines the operating system the patch baseline applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatingSystem(final java.lang.String operatingSystem) {
            this.props.operatingSystem(operatingSystem);
            return this;
        }

        /**
         * The name of the patch group to be registered with the patch baseline.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-patchgroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-patchgroups</a>
         * @param patchGroups The name of the patch group to be registered with the patch baseline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder patchGroups(final java.util.List<java.lang.String> patchGroups) {
            this.props.patchGroups(patchGroups);
            return this;
        }

        /**
         * A list of explicitly rejected patches for the baseline.
         * <p>
         * For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">Package name formats for approved and rejected patch lists</a> in the <em>AWS Systems Manager User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatches">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatches</a>
         * @param rejectedPatches A list of explicitly rejected patches for the baseline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rejectedPatches(final java.util.List<java.lang.String> rejectedPatches) {
            this.props.rejectedPatches(rejectedPatches);
            return this;
        }

        /**
         * The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.
         * <p>
         * <ul>
         * <li><strong>ALLOW_AS_DEPENDENCY</strong> - <em>Linux and macOS</em> : A package in the rejected patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as <code>INSTALLED_OTHER</code> . This is the default action if no option is specified.</li>
         * </ul>
         * <p>
         * <em>Windows Server</em> : Windows Server doesn't support the concept of package dependencies. If a package in the rejected patches list and already installed on the node, its status is reported as <code>INSTALLED_OTHER</code> . Any package not already installed on the node is skipped. This is the default action if no option is specified.
         * <p>
         * <ul>
         * <li><strong>BLOCK</strong> - <em>All OSs</em> : Packages in the rejected patches list, and packages that include them as dependencies, aren't installed by Patch Manager under any circumstances. If a package was installed before it was added to the rejected patches list, or is installed outside of Patch Manager afterward, it's considered noncompliant with the patch baseline and its status is reported as <code>INSTALLED_REJECTED</code> .</li>
         * </ul>
         * <p>
         * Default: - "ALLOW_AS_DEPENDENCY"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatchesaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatchesaction</a>
         * @param rejectedPatchesAction The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rejectedPatchesAction(final java.lang.String rejectedPatchesAction) {
            this.props.rejectedPatchesAction(rejectedPatchesAction);
            return this;
        }

        /**
         * Information about the patches to use to update the managed nodes, including target operating systems and source repositories.
         * <p>
         * Applies to Linux managed nodes only.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-sources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-sources</a>
         * @param sources Information about the patches to use to update the managed nodes, including target operating systems and source repositories. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(final software.amazon.awscdk.IResolvable sources) {
            this.props.sources(sources);
            return this;
        }
        /**
         * Information about the patches to use to update the managed nodes, including target operating systems and source repositories.
         * <p>
         * Applies to Linux managed nodes only.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-sources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-sources</a>
         * @param sources Information about the patches to use to update the managed nodes, including target operating systems and source repositories. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(final java.util.List<? extends java.lang.Object> sources) {
            this.props.sources(sources);
            return this;
        }

        /**
         * Optional metadata that you assign to a resource.
         * <p>
         * Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a patch baseline to identify the severity level of patches it specifies and the operating system family it applies to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-tags</a>
         * @param tags Optional metadata that you assign to a resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ssm.CfnPatchBaseline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ssm.CfnPatchBaseline build() {
            return new software.amazon.awscdk.services.ssm.CfnPatchBaseline(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
