package software.amazon.awscdk.services.ssm;

/**
 * Additional properties for looking up an existing StringParameter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String stringValue = StringParameter.valueFromLookup(this, "/My/Public/Parameter", undefined, StringParameterLookupOptions.builder().additionalCacheKey(this.node.getPath()).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:23.650Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.StringParameterLookupOptions")
@software.amazon.jsii.Jsii.Proxy(StringParameterLookupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StringParameterLookupOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Adds an additional discriminator to the <code>cdk.context.json</code> cache key.
     * <p>
     * Default: - no additional cache key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalCacheKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StringParameterLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StringParameterLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StringParameterLookupOptions> {
        java.lang.String additionalCacheKey;

        /**
         * Sets the value of {@link StringParameterLookupOptions#getAdditionalCacheKey}
         * @param additionalCacheKey Adds an additional discriminator to the <code>cdk.context.json</code> cache key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalCacheKey(java.lang.String additionalCacheKey) {
            this.additionalCacheKey = additionalCacheKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StringParameterLookupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StringParameterLookupOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StringParameterLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringParameterLookupOptions {
        private final java.lang.String additionalCacheKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalCacheKey = software.amazon.jsii.Kernel.get(this, "additionalCacheKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalCacheKey = builder.additionalCacheKey;
        }

        @Override
        public final java.lang.String getAdditionalCacheKey() {
            return this.additionalCacheKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalCacheKey() != null) {
                data.set("additionalCacheKey", om.valueToTree(this.getAdditionalCacheKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.StringParameterLookupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StringParameterLookupOptions.Jsii$Proxy that = (StringParameterLookupOptions.Jsii$Proxy) o;

            return this.additionalCacheKey != null ? this.additionalCacheKey.equals(that.additionalCacheKey) : that.additionalCacheKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalCacheKey != null ? this.additionalCacheKey.hashCode() : 0;
            return result;
        }
    }
}
